/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsMAC;
import org.bouncycastle.tls.crypto.impl.ArrayUtil;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class TlsSuiteHMac
implements TlsSuiteMac {
    private static final long SEQUENCE_NUMBER_PLACEHOLDER = -1L;
    private final TlsCryptoParameters cryptoParams;
    private final TlsHMAC mac;
    private final int digestBlockSize;
    private final int digestOverhead;
    private final int macSize;

    private static int getMacSize(TlsCryptoParameters cryptoParams, TlsMAC mac) {
        int macSize = mac.getMacLength();
        if (cryptoParams.getSecurityParametersHandshake().isTruncatedHMac()) {
            macSize = Math.min(macSize, 10);
        }
        return macSize;
    }

    public TlsSuiteHMac(TlsCryptoParameters cryptoParams, TlsHMAC mac) {
        this.cryptoParams = cryptoParams;
        this.mac = mac;
        this.macSize = TlsSuiteHMac.getMacSize(cryptoParams, mac);
        this.digestBlockSize = mac.getInternalBlockSize();
        this.digestOverhead = TlsImplUtils.isSSL(cryptoParams) && mac.getMacLength() == 20 ? 4 : this.digestBlockSize / 8;
    }

    public int getSize() {
        return this.macSize;
    }

    public byte[] calculateMac(long seqNo, short type, byte[] connectionID, byte[] msg, int msgOff, int msgLen) {
        ProtocolVersion serverVersion = this.cryptoParams.getServerVersion();
        if (!ArrayUtil.isNullOrEmpty(connectionID)) {
            int cidLength = connectionID.length;
            byte[] macHeader = new byte[23 + cidLength];
            TlsUtils.writeUint64(-1L, macHeader, 0);
            TlsUtils.writeUint8((short)25, macHeader, 8);
            TlsUtils.writeUint8(cidLength, macHeader, 9);
            TlsUtils.writeUint8((short)25, macHeader, 10);
            TlsUtils.writeVersion(serverVersion, macHeader, 11);
            TlsUtils.writeUint64(seqNo, macHeader, 13);
            System.arraycopy(connectionID, 0, macHeader, 21, cidLength);
            TlsUtils.writeUint16(msgLen, macHeader, 21 + cidLength);
            this.mac.update(macHeader, 0, macHeader.length);
        } else {
            byte[] macHeader = new byte[13];
            TlsUtils.writeUint64(seqNo, macHeader, 0);
            TlsUtils.writeUint8(type, macHeader, 8);
            TlsUtils.writeVersion(serverVersion, macHeader, 9);
            TlsUtils.writeUint16(msgLen, macHeader, 11);
            this.mac.update(macHeader, 0, macHeader.length);
        }
        this.mac.update(msg, msgOff, msgLen);
        return this.truncate(this.mac.calculateMAC());
    }

    public byte[] calculateMacConstantTime(long seqNo, short type, byte[] connectionID, byte[] msg, int msgOff, int msgLen, int fullLength, byte[] dummyData) {
        byte[] result = this.calculateMac(seqNo, type, connectionID, msg, msgOff, msgLen);
        int headerLength = this.getHeaderLength(connectionID);
        int extra = this.getDigestBlockCount(headerLength + fullLength) - this.getDigestBlockCount(headerLength + msgLen);
        while (--extra >= 0) {
            this.mac.update(dummyData, 0, this.digestBlockSize);
        }
        this.mac.update(dummyData, 0, 1);
        this.mac.reset();
        return result;
    }

    private int getDigestBlockCount(int inputLength) {
        return (inputLength + this.digestOverhead) / this.digestBlockSize;
    }

    private int getHeaderLength(byte[] connectionID) {
        if (TlsImplUtils.isSSL(this.cryptoParams)) {
            return 11;
        }
        if (!ArrayUtil.isNullOrEmpty(connectionID)) {
            return 23 + connectionID.length;
        }
        return 13;
    }

    private byte[] truncate(byte[] bs) {
        if (bs.length <= this.macSize) {
            return bs;
        }
        return Arrays.copyOf((byte[])bs, (int)this.macSize);
    }
}

