/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.FipsUtils;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NamedGroupInfo {
    private static final Logger LOG = Logger.getLogger(NamedGroupInfo.class.getName());
    private static final String PROPERTY_NAMED_GROUPS = "jdk.tls.namedGroups";
    private static final int[] CANDIDATES_DEFAULT = new int[]{29, 30, 23, 24, 25, 256, 257, 258};
    private final All all;
    private final AlgorithmParameters algorithmParameters;
    private final boolean enabled;

    static PerConnection createPerConnection(PerContext perContext, ProvSSLParameters provSSLParameters, ProtocolVersion[] protocolVersionArray) {
        Map<Integer, NamedGroupInfo> map = NamedGroupInfo.createLocal(perContext, provSSLParameters, protocolVersionArray);
        boolean bl = NamedGroupInfo.createLocalECDSA(map);
        return new PerConnection(map, bl);
    }

    static PerContext createPerContext(boolean bl, JcaTlsCrypto jcaTlsCrypto) {
        Map<Integer, NamedGroupInfo> map = NamedGroupInfo.createIndex(bl, jcaTlsCrypto);
        int[] nArray = NamedGroupInfo.createCandidates(map);
        return new PerContext(map, nArray);
    }

    static int getMaximumBitsServerECDH(PerConnection perConnection) {
        int n = 0;
        for (NamedGroupInfo namedGroupInfo : NamedGroupInfo.getEffectivePeer(perConnection)) {
            n = Math.max(n, namedGroupInfo.getBitsECDH());
        }
        return n;
    }

    static int getMaximumBitsServerFFDHE(PerConnection perConnection) {
        int n = 0;
        for (NamedGroupInfo namedGroupInfo : NamedGroupInfo.getEffectivePeer(perConnection)) {
            n = Math.max(n, namedGroupInfo.getBitsFFDHE());
        }
        return n;
    }

    static NamedGroupInfo getNamedGroup(PerContext perContext, int n) {
        return (NamedGroupInfo)perContext.index.get(n);
    }

    static Vector<Integer> getSupportedGroupsLocal(PerConnection perConnection) {
        return new Vector<Integer>(perConnection.local.keySet());
    }

    static boolean hasAnyECDSALocal(PerConnection perConnection) {
        return perConnection.localECDSA;
    }

    static boolean hasLocal(PerConnection perConnection, int n) {
        return perConnection.local.containsKey(n);
    }

    static void notifyPeer(PerConnection perConnection, int[] nArray) {
        List<NamedGroupInfo> list = NamedGroupInfo.createPeer(perConnection, nArray);
        perConnection.setPeer(list);
    }

    static int selectServerECDH(PerConnection perConnection, int n) {
        for (NamedGroupInfo namedGroupInfo : NamedGroupInfo.getEffectivePeer(perConnection)) {
            if (namedGroupInfo.getBitsECDH() < n) continue;
            return namedGroupInfo.getNamedGroup();
        }
        return -1;
    }

    static int selectServerFFDHE(PerConnection perConnection, int n) {
        for (NamedGroupInfo namedGroupInfo : NamedGroupInfo.getEffectivePeer(perConnection)) {
            if (namedGroupInfo.getBitsFFDHE() < n) continue;
            return namedGroupInfo.getNamedGroup();
        }
        return -1;
    }

    private static void addNamedGroup(boolean bl, JcaTlsCrypto jcaTlsCrypto, boolean bl2, boolean bl3, Map<Integer, NamedGroupInfo> map, All all) {
        int n = all.namedGroup;
        if (bl && !FipsUtils.isFipsNamedGroup(n)) {
            return;
        }
        boolean bl4 = bl2 && all.char2 || bl3 && all.bitsFFDHE > 0;
        boolean bl5 = !bl4 && jcaTlsCrypto.hasNamedGroup(n);
        AlgorithmParameters algorithmParameters = null;
        if (bl5) {
            try {
                algorithmParameters = jcaTlsCrypto.getNamedGroupAlgorithmParameters(n);
            }
            catch (Exception exception) {
                bl5 = false;
            }
        }
        NamedGroupInfo namedGroupInfo = new NamedGroupInfo(all, algorithmParameters, bl5);
        if (null != map.put(n, namedGroupInfo)) {
            throw new IllegalStateException("Duplicate entries for NamedGroupInfo");
        }
    }

    private static int[] createCandidates(Map<Integer, NamedGroupInfo> map) {
        String[] stringArray = PropertyUtils.getStringArraySystemProperty(PROPERTY_NAMED_GROUPS);
        if (null == stringArray) {
            return CANDIDATES_DEFAULT;
        }
        int[] nArray = new int[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            int n2 = NamedGroupInfo.getNamedGroupByName(string);
            if (n2 < 0) {
                LOG.warning("'jdk.tls.namedGroups' contains unrecognised NamedGroup: " + string);
                continue;
            }
            NamedGroupInfo namedGroupInfo = map.get(n2);
            if (null == namedGroupInfo) {
                LOG.warning("'jdk.tls.namedGroups' contains unsupported NamedGroup: " + string);
                continue;
            }
            if (!namedGroupInfo.isEnabled()) {
                LOG.warning("'jdk.tls.namedGroups' contains disabled NamedGroup: " + string);
                continue;
            }
            nArray[n++] = n2;
        }
        if (n < nArray.length) {
            nArray = Arrays.copyOf((int[])nArray, (int)n);
        }
        if (nArray.length < 1) {
            LOG.severe("'jdk.tls.namedGroups' contained no usable NamedGroup values");
        }
        return nArray;
    }

    private static Map<Integer, NamedGroupInfo> createIndex(boolean bl, JcaTlsCrypto jcaTlsCrypto) {
        TreeMap<Integer, NamedGroupInfo> treeMap = new TreeMap<Integer, NamedGroupInfo>();
        boolean bl2 = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.ec.disableChar2", false) || PropertyUtils.getBooleanSystemProperty("org.bouncycastle.ec.disable_f2m", false);
        boolean bl3 = !PropertyUtils.getBooleanSystemProperty("jsse.enableFFDHE", true);
        for (All all : All.values()) {
            NamedGroupInfo.addNamedGroup(bl, jcaTlsCrypto, bl2, bl3, treeMap, all);
        }
        return treeMap;
    }

    private static Map<Integer, NamedGroupInfo> createLocal(PerContext perContext, ProvSSLParameters provSSLParameters, ProtocolVersion[] protocolVersionArray) {
        ProtocolVersion protocolVersion = ProtocolVersion.getLatestTLS(protocolVersionArray);
        ProtocolVersion protocolVersion2 = ProtocolVersion.getEarliestTLS(protocolVersionArray);
        BCAlgorithmConstraints bCAlgorithmConstraints = provSSLParameters.getAlgorithmConstraints();
        boolean bl = TlsUtils.isTLSv13(protocolVersion);
        boolean bl2 = !TlsUtils.isTLSv13(protocolVersion2);
        int n = perContext.candidates.length;
        LinkedHashMap<Integer, NamedGroupInfo> linkedHashMap = new LinkedHashMap<Integer, NamedGroupInfo>(n);
        for (int i = 0; i < n; ++i) {
            Integer n2 = Integers.valueOf((int)perContext.candidates[i]);
            NamedGroupInfo namedGroupInfo = (NamedGroupInfo)perContext.index.get(n2);
            if (null == namedGroupInfo || linkedHashMap.containsKey(n2) || !namedGroupInfo.isActive(bCAlgorithmConstraints, bl2, bl)) continue;
            linkedHashMap.put(n2, namedGroupInfo);
        }
        return linkedHashMap;
    }

    private static boolean createLocalECDSA(Map<Integer, NamedGroupInfo> map) {
        for (NamedGroupInfo namedGroupInfo : map.values()) {
            if (!NamedGroup.refersToAnECDSACurve(namedGroupInfo.getNamedGroup())) continue;
            return true;
        }
        return false;
    }

    private static List<NamedGroupInfo> createPeer(PerConnection perConnection, int[] nArray) {
        return NamedGroupInfo.getNamedGroupInfos(perConnection.local, nArray);
    }

    private static Collection<NamedGroupInfo> getEffectivePeer(PerConnection perConnection) {
        List<NamedGroupInfo> list = perConnection.getPeer();
        if (!list.isEmpty()) {
            return list;
        }
        return perConnection.local.values();
    }

    private static int getNamedGroupByName(String string) {
        for (All all : All.values()) {
            if (!all.name.equalsIgnoreCase(string)) continue;
            return all.namedGroup;
        }
        return -1;
    }

    private static List<NamedGroupInfo> getNamedGroupInfos(Map<Integer, NamedGroupInfo> map, int[] nArray) {
        if (null == nArray || nArray.length < 1) {
            return Collections.emptyList();
        }
        int n = nArray.length;
        ArrayList<NamedGroupInfo> arrayList = new ArrayList<NamedGroupInfo>(n);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            NamedGroupInfo namedGroupInfo = map.get(n2);
            if (null == namedGroupInfo) continue;
            arrayList.add(namedGroupInfo);
        }
        if (arrayList.isEmpty()) {
            return Collections.emptyList();
        }
        arrayList.trimToSize();
        return arrayList;
    }

    NamedGroupInfo(All all, AlgorithmParameters algorithmParameters, boolean bl) {
        this.all = all;
        this.algorithmParameters = algorithmParameters;
        this.enabled = bl;
    }

    int getBitsECDH() {
        return this.all.bitsECDH;
    }

    int getBitsFFDHE() {
        return this.all.bitsFFDHE;
    }

    String getName() {
        return this.all.name;
    }

    int getNamedGroup() {
        return this.all.namedGroup;
    }

    boolean isActive(BCAlgorithmConstraints bCAlgorithmConstraints, boolean bl, boolean bl2) {
        return this.enabled && (bl || bl2 && this.isSupported13()) && this.isPermittedBy(bCAlgorithmConstraints);
    }

    boolean isEnabled() {
        return this.enabled;
    }

    boolean isSupported13() {
        return this.all.supported13;
    }

    public String toString() {
        return this.all.text;
    }

    private boolean isPermittedBy(BCAlgorithmConstraints bCAlgorithmConstraints) {
        Set<BCCryptoPrimitive> set = JsseUtils.KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC;
        return bCAlgorithmConstraints.permits(set, this.all.name, null) && bCAlgorithmConstraints.permits(set, this.all.jcaAlgorithm, this.algorithmParameters);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum All {
        sect163k1(1, "EC"),
        sect163r1(2, "EC"),
        sect163r2(3, "EC"),
        sect193r1(4, "EC"),
        sect193r2(5, "EC"),
        sect233k1(6, "EC"),
        sect233r1(7, "EC"),
        sect239k1(8, "EC"),
        sect283k1(9, "EC"),
        sect283r1(10, "EC"),
        sect409k1(11, "EC"),
        sect409r1(12, "EC"),
        sect571k1(13, "EC"),
        sect571r1(14, "EC"),
        secp160k1(15, "EC"),
        secp160r1(16, "EC"),
        secp160r2(17, "EC"),
        secp192k1(18, "EC"),
        secp192r1(19, "EC"),
        secp224k1(20, "EC"),
        secp224r1(21, "EC"),
        secp256k1(22, "EC"),
        secp256r1(23, "EC"),
        secp384r1(24, "EC"),
        secp521r1(25, "EC"),
        brainpoolP256r1(26, "EC"),
        brainpoolP384r1(27, "EC"),
        brainpoolP512r1(28, "EC"),
        x25519(29, "XDH"),
        x448(30, "XDH"),
        ffdhe2048(256, "DiffieHellman"),
        ffdhe3072(257, "DiffieHellman"),
        ffdhe4096(258, "DiffieHellman"),
        ffdhe6144(259, "DiffieHellman"),
        ffdhe8192(260, "DiffieHellman");

        private final int namedGroup;
        private final String name;
        private final String text;
        private final String jcaAlgorithm;
        private final boolean char2;
        private final boolean supported13;
        private final int bitsECDH;
        private final int bitsFFDHE;

        private All(int n2, String string2) {
            this.namedGroup = n2;
            this.name = NamedGroup.getName(n2);
            this.text = this.name + "(" + n2 + ")";
            this.jcaAlgorithm = string2;
            this.supported13 = NamedGroup.canBeNegotiated(n2, ProtocolVersion.TLSv13);
            this.char2 = NamedGroup.isChar2Curve(n2);
            this.bitsECDH = NamedGroup.getCurveBits(n2);
            this.bitsFFDHE = NamedGroup.getFiniteFieldBits(n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PerConnection {
        private final Map<Integer, NamedGroupInfo> local;
        private final boolean localECDSA;
        private List<NamedGroupInfo> peer;

        PerConnection(Map<Integer, NamedGroupInfo> map, boolean bl) {
            this.local = map;
            this.localECDSA = bl;
            this.peer = null;
        }

        public synchronized List<NamedGroupInfo> getPeer() {
            return this.peer;
        }

        private synchronized void setPeer(List<NamedGroupInfo> list) {
            this.peer = list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PerContext {
        private final Map<Integer, NamedGroupInfo> index;
        private final int[] candidates;

        PerContext(Map<Integer, NamedGroupInfo> map, int[] nArray) {
            this.index = map;
            this.candidates = nArray;
        }
    }
}

