/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPathParameters;
import java.security.cert.Certificate;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvX509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvTrustManagerFactorySpi
extends TrustManagerFactorySpi {
    private static final Logger LOG = Logger.getLogger(ProvTrustManagerFactorySpi.class.getName());
    protected final JcaJceHelper helper;
    protected ProvX509TrustManager x509TrustManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyStore getDefaultTrustStore() throws Exception {
        Object object;
        String string;
        Object object2;
        String string2 = KeyStore.getDefaultType();
        Object object3 = null;
        char[] cArray = null;
        String string3 = PropertyUtils.getSystemProperty("javax.net.ssl.trustStore");
        if (!"NONE".equals(string3)) {
            if (null != string3) {
                if (new File(string3).exists()) {
                    object3 = string3;
                }
            } else {
                object2 = PropertyUtils.getSystemProperty("java.home");
                if (null != object2) {
                    string = (String)object2 + "/lib/security/jssecacerts".replace("/", File.separator);
                    if (new File(string).exists()) {
                        string2 = "jks";
                        object3 = string;
                    } else {
                        object = (String)object2 + "/lib/security/cacerts".replace("/", File.separator);
                        if (new File((String)object).exists()) {
                            string2 = "jks";
                            object3 = object;
                        }
                    }
                }
            }
        }
        object2 = ProvTrustManagerFactorySpi.createTrustStore(string2);
        string = PropertyUtils.getSystemProperty("javax.net.ssl.trustStorePassword");
        if (null != string) {
            cArray = string.toCharArray();
        }
        object = null;
        try {
            if (null == object3) {
                LOG.info("Initializing empty trust store");
            } else {
                LOG.info("Initializing with trust store at path: " + (String)object3);
                object = new BufferedInputStream(new FileInputStream((String)object3));
            }
            ((KeyStore)object2).load((InputStream)object, cArray);
        }
        finally {
            if (null != object) {
                ((InputStream)object).close();
            }
        }
        return object2;
    }

    ProvTrustManagerFactorySpi(JcaJceHelper jcaJceHelper) {
        this.helper = jcaJceHelper;
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        if (null == this.x509TrustManager) {
            throw new IllegalStateException("TrustManagerFactory not initialized");
        }
        return new TrustManager[]{this.x509TrustManager.getExportX509TrustManager()};
    }

    @Override
    protected void engineInit(KeyStore keyStore) throws KeyStoreException {
        if (null == keyStore) {
            try {
                keyStore = ProvTrustManagerFactorySpi.getDefaultTrustStore();
            }
            catch (SecurityException securityException) {
                LOG.log(Level.WARNING, "Skipped default trust store", securityException);
            }
            catch (Error error) {
                LOG.log(Level.WARNING, "Skipped default trust store", error);
                throw error;
            }
            catch (RuntimeException runtimeException) {
                LOG.log(Level.WARNING, "Skipped default trust store", runtimeException);
                throw runtimeException;
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Skipped default trust store", exception);
                throw new KeyStoreException("Failed to load default\u00a0trust store", exception);
            }
        }
        Set<TrustAnchor> set = ProvTrustManagerFactorySpi.getTrustAnchors(keyStore);
        try {
            this.x509TrustManager = new ProvX509TrustManager(this.helper, set);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new KeyStoreException("Failed to create trust manager", invalidAlgorithmParameterException);
        }
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        CertPathParameters certPathParameters;
        if (managerFactoryParameters instanceof CertPathTrustManagerParameters) {
            certPathParameters = ((CertPathTrustManagerParameters)managerFactoryParameters).getParameters();
            if (!(certPathParameters instanceof PKIXParameters)) {
                throw new InvalidAlgorithmParameterException("parameters must inherit from PKIXParameters");
            }
        } else {
            if (null == managerFactoryParameters) {
                throw new InvalidAlgorithmParameterException("spec cannot be null");
            }
            throw new InvalidAlgorithmParameterException("unknown spec: " + managerFactoryParameters.getClass().getName());
        }
        this.x509TrustManager = new ProvX509TrustManager(this.helper, (PKIXParameters)certPathParameters);
    }

    private static void collectTrustAnchor(Set<TrustAnchor> set, Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            set.add(new TrustAnchor((X509Certificate)certificate, null));
        }
    }

    private static KeyStore createTrustStore(String string) throws NoSuchProviderException, KeyStoreException {
        String string2 = ProvTrustManagerFactorySpi.getTrustStoreType(string);
        String string3 = PropertyUtils.getSystemProperty("javax.net.ssl.trustStoreProvider");
        return null == string3 || string3.length() < 1 ? KeyStore.getInstance(string2) : KeyStore.getInstance(string2, string3);
    }

    private static Set<TrustAnchor> getTrustAnchors(KeyStore keyStore) throws KeyStoreException {
        if (null == keyStore) {
            return Collections.emptySet();
        }
        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate[] certificateArray;
            String string = enumeration.nextElement();
            if (keyStore.isCertificateEntry(string)) {
                ProvTrustManagerFactorySpi.collectTrustAnchor(hashSet, keyStore.getCertificate(string));
                continue;
            }
            if (!keyStore.isKeyEntry(string) || null == (certificateArray = keyStore.getCertificateChain(string)) || certificateArray.length <= 0) continue;
            ProvTrustManagerFactorySpi.collectTrustAnchor(hashSet, certificateArray[0]);
        }
        return hashSet;
    }

    private static String getTrustStoreType(String string) {
        String string2 = PropertyUtils.getSystemProperty("javax.net.ssl.trustStoreType");
        return null == string2 ? string : string2;
    }
}

