/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.api;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.buni.meldware.mail.api.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchKey {
    private final KeyName partName;
    private final KeyType partType;
    private final String name;
    private final Object value;

    protected SearchKey(KeyName partName, KeyType partType, String name, Object value) {
        this.partName = partName;
        this.partType = partType;
        this.name = name;
        this.value = value;
    }

    protected SearchKey(KeyName partName, KeyType partType, Object value) {
        this(partName, partType, partName.toString(), value);
    }

    public String getName() {
        return this.name;
    }

    public KeyName getPartName() {
        return this.partName;
    }

    public Object getValue() {
        return this.value;
    }

    public KeyType getType() {
        return this.partType;
    }

    public static SearchKey create(KeyName partName, boolean value) {
        return new SearchKey(partName, KeyType.BOOLEAN, value);
    }

    public static SearchKey create(KeyName partName, int value) {
        return new SearchKey(partName, KeyType.NUMBER, value);
    }

    public static SearchKey create(KeyName partName, String value) {
        return new SearchKey(partName, KeyType.STRING, value);
    }

    public static SearchKey create(KeyName partName, Calendar value) {
        return new SearchKey(partName, KeyType.DATE, value);
    }

    public static SearchKey createHeader(String name, String value) {
        return new SearchKey(KeyName.HEADER, KeyType.STRING, name, value);
    }

    public static SearchKey createOr(List<SearchKey> parts) {
        return new SearchKey(KeyName.OR, KeyType.LIST, parts);
    }

    public static SearchKey createOr(SearchKey ... parts) {
        return new SearchKey(KeyName.OR, KeyType.LIST, Arrays.asList(parts));
    }

    public static SearchKey createAnd(List<SearchKey> parts) {
        return new SearchKey(KeyName.AND, KeyType.LIST, parts);
    }

    public static SearchKey createNot(SearchKey part) {
        return new SearchKey(KeyName.NOT, KeyType.PART, part);
    }

    public static SearchKey createUid(Range[] ranges) {
        return new SearchKey(KeyName.UID, KeyType.RANGE_SET, ranges);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeyName {
        ALL,
        ANSWERED,
        BEFORE,
        BCC,
        BODY,
        CC,
        DELETED,
        DRAFT,
        FLAGGED,
        FROM,
        KEYWORD,
        LARGER,
        NEW,
        NOT,
        OLD,
        ON,
        RECENT,
        SEEN,
        SENTBEFORE,
        SENTON,
        SENTSINCE,
        SINCE,
        SMALLER,
        SUBJECT,
        TEXT,
        TO,
        UID,
        UNANSWERED,
        UNDELETED,
        UNDRAFT,
        UNFLAGGED,
        UNKEYWORD,
        UNSEEN,
        HEADER,
        OR,
        AND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeyType {
        STRING,
        NUMBER,
        DATE,
        BOOLEAN,
        LIST,
        PART,
        RANGE_SET;

    }
}

