/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.renderkit.html_basic;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import org.butterfaces.component.base.renderer.HtmlBasicRenderer;
import org.butterfaces.component.html.HtmlPrettyPrint;

@FacesRenderer(componentFamily="org.butterfaces.component.family", rendererType="org.butterfaces.renderkit.html_basic.PrettyPrintRenderer")
public class PrettyPrintRenderer
extends HtmlBasicRenderer {
    public static final String ELEMENT_PRE = "pre";
    public static final String ATTRIBUTE_STYLE = "style";
    public static final String ATTRIBUTE_CLASS = "class";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        HtmlPrettyPrint prettyPrint = (HtmlPrettyPrint)component;
        String style = prettyPrint.getStyle();
        String styleClass = prettyPrint.getStyleClass();
        writer.startElement("div", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        if (null != style) {
            writer.writeAttribute(ATTRIBUTE_STYLE, (Object)style, ATTRIBUTE_STYLE);
        }
        if (null != styleClass) {
            writer.writeAttribute(ATTRIBUTE_CLASS, (Object)("butter-component-prettyprint " + styleClass), ATTRIBUTE_CLASS);
        } else {
            writer.writeAttribute(ATTRIBUTE_CLASS, (Object)"butter-component-prettyprint", ATTRIBUTE_CLASS);
        }
        writer.startElement(ELEMENT_PRE, component);
        writer.writeAttribute(ATTRIBUTE_CLASS, (Object)("prettyprint " + prettyPrint.getLanguage()), ATTRIBUTE_CLASS);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement(ELEMENT_PRE);
        writer.endElement("div");
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", "type");
        writer.writeText((Object)"jQuery(function () { butter.prettyprint.cleanup(); });", null);
        writer.endElement("script");
    }
}

