///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-overlay.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var WaitingPanel = /** @class */ (function () {
        function WaitingPanel(overlay) {
            this.overlay = overlay;
        }
        WaitingPanel.prototype.processAjaxUpdate = function () {
            var _this = this;
            var ajaxRequestsRunning = 0;
            return function (_a) {
                var status = _a.status;
                console.log("ButterFaces.WaitingPanel.onEvent - processEvent: " + status);
                if (status === "begin") {
                    ajaxRequestsRunning++;
                }
                else if (status === "success") {
                    ajaxRequestsRunning--;
                }
                if (ajaxRequestsRunning > 0) {
                    console.log("ButterFaces.WaitingPanel.onEvent  - show " + ajaxRequestsRunning);
                    _this.overlay.show();
                }
                else {
                    console.log("ButterFaces.WaitingPanel.onEvent  - hide " + ajaxRequestsRunning);
                    _this.overlay.hide();
                }
            };
        };
        WaitingPanel.prototype.processOnError = function (data) {
            if (data) {
                console.error("ButterFaces.WaitingPanel.onError  - An error occured, closing waiting panel. errorType: " + data.status + ", description: " + data.description);
                ButterFaces.Overlay.hideAll();
            }
        };
        return WaitingPanel;
    }());
    ButterFaces.WaitingPanel = WaitingPanel;
})(ButterFaces || (ButterFaces = {}));
(function ($) {
    // extend jQuery --------------------------------------------------------------------
    var eventRegistered = false;
    var overlay;
    $.fn.waitingPanel = function (_a) {
        var waitingPanelDelay = _a.waitingPanelDelay, blockpage = _a.blockpage;
        return this.each(function () {
            // I found no way to remove event listener from jsf js.
            // I tried to register a callback once and change it on render waiting panel but after this
            // no waiting panel appears anymore.
            // Actually on each rendering of this component a new callback is put on event listener collection.
            if (!eventRegistered) {
                // console.log("waitingPanel - register: " + _elementId);
                overlay = new ButterFaces.Overlay(waitingPanelDelay, blockpage);
                var waitingPanel = new ButterFaces.WaitingPanel(overlay);
                jsf.ajax.addOnEvent(waitingPanel.processAjaxUpdate());
                jsf.ajax.addOnError(waitingPanel.processOnError);
                eventRegistered = true;
            }
            overlay.delay = waitingPanelDelay;
            overlay.isTransparentBlockingOverlayActive = blockpage;
        });
    };
}(jQuery));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
