// Targeted by JavaCPP version 1.3: DO NOT EDIT THIS FILE

package org.bytedeco.javacpp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

public class RealSense extends org.bytedeco.javacpp.presets.RealSense {
    static { Loader.load(); }

// Parsed from <librealsense/rs.h>

/* License: Apache 2.0. See LICENSE file in root directory.
   Copyright(c) 2015 Intel Corporation. All Rights Reserved. */

// #ifndef LIBREALSENSE_RS_H
// #define LIBREALSENSE_RS_H

// #ifdef __cplusplus
// #endif

public static final int RS_API_MAJOR_VERSION =    1;
public static final int RS_API_MINOR_VERSION =    9;
public static final int RS_API_PATCH_VERSION =    6;

// #define STRINGIFY(arg) #arg
// #define VAR_ARG_STRING(arg) STRINGIFY(arg)

/* Version in encoded integer format (1,9,x) -> 1090x note that each component is limited into [0-99] range by design*/
public static final int RS_API_VERSION =  (((RS_API_MAJOR_VERSION) * 10000) + ((RS_API_MINOR_VERSION) * 100) + (RS_API_PATCH_VERSION));
/*// Return version in "X.Y.Z" format */
/* #define RS_API_VERSION_STR (VAR_ARG_STRING(RS_API_MAJOR_VERSION.RS_API_MINOR_VERSION.RS_API_PATCH_VERSION))*/
public static final String RS_API_VERSION_STR = "1.9.6";

/* rs_capabilities defines the full set of functionality that a RealSense device might provide
   to check what functionality is supported by a particular device at runtime call dev->supports(capability) */
/** enum rs_capabilities */
public static final int
    /** provides depth stream */
    RS_CAPABILITIES_DEPTH                   = 0,
    /** provides color stream */
    RS_CAPABILITIES_COLOR                   = 1,
    /** provides infrared stream */
    RS_CAPABILITIES_INFRARED                = 2,
    /** provides second infrared stream */
    RS_CAPABILITIES_INFRARED2               = 3,
    /** provides wide field of view (fish-eye) stream */
    RS_CAPABILITIES_FISH_EYE                = 4,
    /** provides gyro and accelorometer events */
    RS_CAPABILITIES_MOTION_EVENTS           = 5,
    /** provides method for upgrading motion module firmware */
    RS_CAPABILITIES_MOTION_MODULE_FW_UPDATE = 6,
    /** interanlly includes MIPI to USB adapter */
    RS_CAPABILITIES_ADAPTER_BOARD           = 7,
    /** provides enough basic functionality to be considered supported. this to catch at runtime various outdated engineering samples */
    RS_CAPABILITIES_ENUMERATION             = 8,
    RS_CAPABILITIES_COUNT                   = 9,
    RS_CAPABILITIES_MAX_ENUM =  0x7FFFFFFF;

/** enum rs_stream */
public static final int
    /** Native stream of depth data produced by RealSense device */
    RS_STREAM_DEPTH                            = 0,
    /** Native stream of color data captured by RealSense device */
    RS_STREAM_COLOR                            = 1,
    /** Native stream of infrared data captured by RealSense device */
    RS_STREAM_INFRARED                         = 2,
    /** Native stream of infrared data captured from a second viewpoint by RealSense device */
    RS_STREAM_INFRARED2                        = 3,
    RS_STREAM_FISHEYE                          = 4,
    /** Synthetic stream containing point cloud data generated by deprojecting the depth image */
    RS_STREAM_POINTS                           = 5,
    /** Synthetic stream containing undistorted color data with no extrinsic rotation from the depth stream */
    RS_STREAM_RECTIFIED_COLOR                  = 6,
    /** Synthetic stream containing color data but sharing intrinsics of depth stream */
    RS_STREAM_COLOR_ALIGNED_TO_DEPTH           = 7,
    /** Synthetic stream containing second viewpoint infrared data but sharing intrinsics of depth stream */
    RS_STREAM_INFRARED2_ALIGNED_TO_DEPTH       = 8,
    /** Synthetic stream containing depth data but sharing intrinsics of color stream */
    RS_STREAM_DEPTH_ALIGNED_TO_COLOR           = 9,
    /** Synthetic stream containing depth data but sharing intrinsics of rectified color stream */
    RS_STREAM_DEPTH_ALIGNED_TO_RECTIFIED_COLOR = 10,
    /** Synthetic stream containing depth data but sharing intrinsics of second viewpoint infrared stream */
    RS_STREAM_DEPTH_ALIGNED_TO_INFRARED2       = 11,
    RS_STREAM_COUNT                            = 12,
    RS_STREAM_MAX_ENUM =  0x7FFFFFFF;

/** enum rs_format */
public static final int
    RS_FORMAT_ANY         = 0,
    /** 16 bit linear depth values. The depth is meters is equal to depth scale * pixel value */
    RS_FORMAT_Z16         = 1,
    /** 16 bit linear disparity values. The depth in meters is equal to depth scale / pixel value */
    RS_FORMAT_DISPARITY16 = 2,
    /** 32 bit floating point 3D coordinates. */
    RS_FORMAT_XYZ32F      = 3,
    RS_FORMAT_YUYV        = 4,
    RS_FORMAT_RGB8        = 5,
    RS_FORMAT_BGR8        = 6,
    RS_FORMAT_RGBA8       = 7,
    RS_FORMAT_BGRA8       = 8,
    RS_FORMAT_Y8          = 9,
    RS_FORMAT_Y16         = 10,
    /** Four 10-bit luminance values encoded into a 5-byte macropixel */
    RS_FORMAT_RAW10       = 11,
    RS_FORMAT_RAW16       = 12,
    RS_FORMAT_RAW8        = 13,
    RS_FORMAT_COUNT       = 14,
    RS_FORMAT_MAX_ENUM =  0x7FFFFFFF;

/** enum rs_output_buffer_format */
public static final int
    /** Makes sure that the output frame is exposed as a single continuous buffer */
    RS_OUTPUT_BUFFER_FORMAT_CONTINOUS   = 0,
    /** Don't convert buffer to continuous, the user has to handle pitch manually */
    RS_OUTPUT_BUFFER_FORMAT_NATIVE      = 1,
    RS_OUTPUT_BUFFER_FORMAT_COUNT       = 2,
    RS_OUTPUT_BUFFER_FORMAT_ENUM        =  0x7FFFFFFF;

/** enum rs_preset */
public static final int
    RS_PRESET_BEST_QUALITY              = 0,
    RS_PRESET_LARGEST_IMAGE             = 1,
    RS_PRESET_HIGHEST_FRAMERATE         = 2,
    RS_PRESET_COUNT                     = 3,
    RS_PRESET_MAX_ENUM =  0x7FFFFFFF;

/** enum rs_source */
public static final int
    RS_SOURCE_VIDEO                     = 1,
    RS_SOURCE_MOTION_TRACKING           = 2,
    RS_SOURCE_ALL                       = 3,
    RS_SOURCE_COUNT                     = 4,
    RS_SOURCE_MAX_ENUM                  =  0x7FFFFFFF;

/** enum rs_distortion */
public static final int
    /** Rectilinear images, no distortion compensation required */
    RS_DISTORTION_NONE                   = 0,
    /** Equivalent to Brown-Conrady distortion, except that tangential distortion is applied to radially distorted points */
    RS_DISTORTION_MODIFIED_BROWN_CONRADY = 1,
    /** Equivalent to Brown-Conrady distortion, except undistorts image instead of distorting it */
    RS_DISTORTION_INVERSE_BROWN_CONRADY  = 2,
    RS_DISTORTION_FTHETA                 = 3,
    RS_DISTORTION_COUNT                  = 4,
    RS_DISTORTION_MAX_ENUM =  0x7FFFFFFF;

/** enum rs_ivcam_preset */
public static final int
    RS_IVCAM_PRESET_SHORT_RANGE             = 0,
    RS_IVCAM_PRESET_LONG_RANGE              = 1,
    RS_IVCAM_PRESET_BACKGROUND_SEGMENTATION = 2,
    RS_IVCAM_PRESET_GESTURE_RECOGNITION     = 3,
    RS_IVCAM_PRESET_OBJECT_SCANNING         = 4,
    RS_IVCAM_PRESET_FACE_ANALYTICS          = 5,
    RS_IVCAM_PRESET_FACE_LOGIN              = 6,
    RS_IVCAM_PRESET_GR_CURSOR               = 7,
    RS_IVCAM_PRESET_DEFAULT                 = 8,
    RS_IVCAM_PRESET_MID_RANGE               = 9,
    RS_IVCAM_PRESET_IR_ONLY                 = 10,
    RS_IVCAM_PRESET_MAX_ENUM =  0x7FFFFFFF;

/** enum rs_option */
public static final int
    /** Enable / disable color backlight compensation*/
    RS_OPTION_COLOR_BACKLIGHT_COMPENSATION                    = 0,
    /** Color image brightness*/
    RS_OPTION_COLOR_BRIGHTNESS                                = 1,
    /** Color image contrast*/
    RS_OPTION_COLOR_CONTRAST                                  = 2,
    /** Controls exposure time of color camera. Setting any value will disable auto exposure*/
    RS_OPTION_COLOR_EXPOSURE                                  = 3,
    /** Color image gain*/
    RS_OPTION_COLOR_GAIN                                      = 4,
    /** Color image gamma setting*/
    RS_OPTION_COLOR_GAMMA                                     = 5,
    /** Color image hue*/
    RS_OPTION_COLOR_HUE                                       = 6,
    /** Color image saturation setting*/
    RS_OPTION_COLOR_SATURATION                                = 7,
    /** Color image sharpness setting*/
    RS_OPTION_COLOR_SHARPNESS                                 = 8,
    /** Controls white balance of color image. Setting any value will disable auto white balance*/
    RS_OPTION_COLOR_WHITE_BALANCE                             = 9,
    /** Enable / disable color image auto-exposure*/
    RS_OPTION_COLOR_ENABLE_AUTO_EXPOSURE                      = 10,
    /** Enable / disable color image auto-white-balance*/
    RS_OPTION_COLOR_ENABLE_AUTO_WHITE_BALANCE                 = 11,
    /** Power of the F200 / SR300 projector, with 0 meaning projector off*/
    RS_OPTION_F200_LASER_POWER                                = 12,
    /** Set the number of patterns projected per frame. The higher the accuracy value the more patterns projected. Increasing the number of patterns help to achieve better accuracy. Note that this control is affecting the Depth FPS */
    RS_OPTION_F200_ACCURACY                                   = 13,
    /** Motion vs. Range trade-off, with lower values allowing for better motion sensitivity and higher values allowing for better depth range*/
    RS_OPTION_F200_MOTION_RANGE                               = 14,
    /** Set the filter to apply to each depth frame. Each one of the filter is optimized per the application requirements*/
    RS_OPTION_F200_FILTER_OPTION                              = 15,
    /** The confidence level threshold used by the Depth algorithm pipe to set whether a pixel will get a valid range or will be marked with invalid range*/
    RS_OPTION_F200_CONFIDENCE_THRESHOLD                       = 16,
    /** (F200-only) Allows to reduce FPS without restarting streaming. Valid values are {2, 5, 15, 30, 60}*/
    RS_OPTION_F200_DYNAMIC_FPS                                = 17,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_ENABLE_MOTION_VERSUS_RANGE     = 18,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_ENABLE_LASER                   = 19,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_MIN_MOTION_VERSUS_RANGE        = 20,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_MAX_MOTION_VERSUS_RANGE        = 21,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_START_MOTION_VERSUS_RANGE      = 22,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_MIN_LASER                      = 23,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_MAX_LASER                      = 24,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_START_LASER                    = 25,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_UPPER_THRESHOLD                = 26,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_LOWER_THRESHOLD                = 27,
    /** Enables / disables R200 auto-exposure. This will affect both IR and depth image.*/
    RS_OPTION_R200_LR_AUTO_EXPOSURE_ENABLED                   = 28,
    /** IR image gain*/
    RS_OPTION_R200_LR_GAIN                                    = 29,
    /** This control allows manual adjustment of the exposure time value for the L/R imagers*/
    RS_OPTION_R200_LR_EXPOSURE                                = 30,
    /** Enables / disables R200 emitter*/
    RS_OPTION_R200_EMITTER_ENABLED                            = 31,
    /** Micrometers per increment in integer depth values, 1000 is default (mm scale). Set before streaming*/
    RS_OPTION_R200_DEPTH_UNITS                                = 32,
    /** Minimum depth in current depth units that will be output. Any values less than ?Min Depth? will be mapped to 0 during the conversion between disparity and depth. Set before streaming*/
    RS_OPTION_R200_DEPTH_CLAMP_MIN                            = 33,
    /** Maximum depth in current depth units that will be output. Any values greater than ?Max Depth? will be mapped to 0 during the conversion between disparity and depth. Set before streaming*/
    RS_OPTION_R200_DEPTH_CLAMP_MAX                            = 34,
    /** The disparity scale factor used when in disparity output mode. Can only be set before streaming*/
    RS_OPTION_R200_DISPARITY_MULTIPLIER                       = 35,
    /** {0 - 512}. Can only be set before streaming starts*/
    RS_OPTION_R200_DISPARITY_SHIFT                            = 36,
    /** (Requires LR-Auto-Exposure ON) Mean intensity set point*/
    RS_OPTION_R200_AUTO_EXPOSURE_MEAN_INTENSITY_SET_POINT     = 37,
    /** (Requires LR-Auto-Exposure ON) Bright ratio set point*/
    RS_OPTION_R200_AUTO_EXPOSURE_BRIGHT_RATIO_SET_POINT       = 38,
    /** (Requires LR-Auto-Exposure ON) Kp Gain*/
    RS_OPTION_R200_AUTO_EXPOSURE_KP_GAIN                      = 39,
    /** (Requires LR-Auto-Exposure ON) Kp Exposure*/
    RS_OPTION_R200_AUTO_EXPOSURE_KP_EXPOSURE                  = 40,
    /** (Requires LR-Auto-Exposure ON) Kp Dark Threshold*/
    RS_OPTION_R200_AUTO_EXPOSURE_KP_DARK_THRESHOLD            = 41,
    /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest top edge (in pixels)*/
    RS_OPTION_R200_AUTO_EXPOSURE_TOP_EDGE                     = 42,
    /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest bottom edge (in pixels)*/
    RS_OPTION_R200_AUTO_EXPOSURE_BOTTOM_EDGE                  = 43,
    /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest left edge (in pixels)*/
    RS_OPTION_R200_AUTO_EXPOSURE_LEFT_EDGE                    = 44,
    /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest right edge (in pixels)*/
    RS_OPTION_R200_AUTO_EXPOSURE_RIGHT_EDGE                   = 45,
    /** Value to subtract when estimating the median of the correlation surface*/
    RS_OPTION_R200_DEPTH_CONTROL_ESTIMATE_MEDIAN_DECREMENT    = 46,
    /** Value to add when estimating the median of the correlation surface*/
    RS_OPTION_R200_DEPTH_CONTROL_ESTIMATE_MEDIAN_INCREMENT    = 47,
    /** A threshold by how much the winning score must beat the median*/
    RS_OPTION_R200_DEPTH_CONTROL_MEDIAN_THRESHOLD             = 48,
    /** The minimum correlation score that is considered acceptable*/
    RS_OPTION_R200_DEPTH_CONTROL_SCORE_MINIMUM_THRESHOLD      = 49,
    /** The maximum correlation score that is considered acceptable*/
    RS_OPTION_R200_DEPTH_CONTROL_SCORE_MAXIMUM_THRESHOLD      = 50,
    /** A parameter for determining whether the texture in the region is sufficient to justify a depth result*/
    RS_OPTION_R200_DEPTH_CONTROL_TEXTURE_COUNT_THRESHOLD      = 51,
    /** A parameter for determining whether the texture in the region is sufficient to justify a depth result*/
    RS_OPTION_R200_DEPTH_CONTROL_TEXTURE_DIFFERENCE_THRESHOLD = 52,
    /** A threshold on how much the minimum correlation score must differ from the next best score*/
    RS_OPTION_R200_DEPTH_CONTROL_SECOND_PEAK_THRESHOLD        = 53,
    /** Neighbor threshold value for depth calculation*/
    RS_OPTION_R200_DEPTH_CONTROL_NEIGHBOR_THRESHOLD           = 54,
    /** Left-Right threshold value for depth calculation*/
    RS_OPTION_R200_DEPTH_CONTROL_LR_THRESHOLD                 = 55,
    /** Fisheye image exposure time in msec*/
    RS_OPTION_FISHEYE_EXPOSURE                                = 56,
    /** Fisheye image gain*/
    RS_OPTION_FISHEYE_GAIN                                    = 57,
    /** Enables / disables fisheye strobe. When enabled this will align timestamps to common clock-domain with the motion events*/
    RS_OPTION_FISHEYE_STROBE                                  = 58,
    /** Enables / disables fisheye external trigger mode. When enabled fisheye image will be aquired in-sync with the depth image*/
    RS_OPTION_FISHEYE_EXTERNAL_TRIGGER                        = 59,
    /** Enable / disable fisheye auto-exposure */
    RS_OPTION_FISHEYE_ENABLE_AUTO_EXPOSURE                    = 60,
    /** 0 - static auto-exposure, 1 - anti-flicker auto-exposure, 2 - hybrid */
    RS_OPTION_FISHEYE_AUTO_EXPOSURE_MODE                      = 61,
    /** Fisheye auto-exposure anti-flicker rate, can be 50 or 60 Hz */
    RS_OPTION_FISHEYE_AUTO_EXPOSURE_ANTIFLICKER_RATE          = 62,
    /** In Fisheye auto-exposure sample frame every given number of pixels */
    RS_OPTION_FISHEYE_AUTO_EXPOSURE_PIXEL_SAMPLE_RATE         = 63,
    /** In Fisheye auto-exposure sample every given number of frames */
    RS_OPTION_FISHEYE_AUTO_EXPOSURE_SKIP_FRAMES               = 64,
    /** Number of frames the user is allowed to keep per stream. Trying to hold-on to more frames will cause frame-drops.*/
    RS_OPTION_FRAMES_QUEUE_SIZE                               = 65,
    /** Enable / disable fetching log data from the device */
    RS_OPTION_HARDWARE_LOGGER_ENABLED                         = 66,
    RS_OPTION_COUNT                                           = 67,
    RS_OPTION_MAX_ENUM =  0x7FFFFFFF;

/** enum rs_blob_type */
public static final int
    RS_BLOB_TYPE_MOTION_MODULE_FIRMWARE_UPDATE                = 0,
    RS_BLOB_TYPE_COUNT                                        = 1,
    RS_BLOB_TYPE_MAX_ENUM =  0x7FFFFFFF;

/** enum rs_camera_info */
public static final int
    RS_CAMERA_INFO_DEVICE_NAME                                = 0,
    RS_CAMERA_INFO_DEVICE_SERIAL_NUMBER                       = 1,
    RS_CAMERA_INFO_CAMERA_FIRMWARE_VERSION                    = 2,
    RS_CAMERA_INFO_ADAPTER_BOARD_FIRMWARE_VERSION             = 3,
    RS_CAMERA_INFO_MOTION_MODULE_FIRMWARE_VERSION             = 4,
    RS_CAMERA_INFO_COUNT                                      = 5,
    RS_CAMERA_INFO_MAX_ENUM =  0x7FFFFFFF;

public static class rs_intrinsics extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public rs_intrinsics() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public rs_intrinsics(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_intrinsics(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public rs_intrinsics position(long position) {
        return (rs_intrinsics)super.position(position);
    }

    public native int width(); public native rs_intrinsics width(int width);     /* width of the image in pixels */
    public native int height(); public native rs_intrinsics height(int height);    /* height of the image in pixels */
    public native float ppx(); public native rs_intrinsics ppx(float ppx);       /* horizontal coordinate of the principal point of the image, as a pixel offset from the left edge */
    public native float ppy(); public native rs_intrinsics ppy(float ppy);       /* vertical coordinate of the principal point of the image, as a pixel offset from the top edge */
    public native float fx(); public native rs_intrinsics fx(float fx);        /* focal length of the image plane, as a multiple of pixel width */
    public native float fy(); public native rs_intrinsics fy(float fy);        /* focal length of the image plane, as a multiple of pixel height */
    public native @Cast("rs_distortion") int model(); public native rs_intrinsics model(int model);     /* distortion model of the image */
    public native float coeffs(int i); public native rs_intrinsics coeffs(int i, float coeffs);
    @MemberGetter public native FloatPointer coeffs(); /* distortion coefficients */
}

/* represents motion device intrinsics - scale, bias and variances */
public static class rs_motion_device_intrinsic extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public rs_motion_device_intrinsic() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public rs_motion_device_intrinsic(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_motion_device_intrinsic(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public rs_motion_device_intrinsic position(long position) {
        return (rs_motion_device_intrinsic)super.position(position);
    }

    /* Scale X        cross axis        cross axis      Bias X */
    /* cross axis     Scale Y           cross axis      Bias Y */
    /* cross axis     cross axis        Scale Z         Bias Z */
    public native float data(int i, int j); public native rs_motion_device_intrinsic data(int i, int j, float data);
    @MemberGetter public native @Cast("float(* /*[3]*/ )[4]") FloatPointer data();

    public native float noise_variances(int i); public native rs_motion_device_intrinsic noise_variances(int i, float noise_variances);
    @MemberGetter public native FloatPointer noise_variances();
    public native float bias_variances(int i); public native rs_motion_device_intrinsic bias_variances(int i, float bias_variances);
    @MemberGetter public native FloatPointer bias_variances();
}

/* represents motion module intrinsics including accelerometer and gyro intrinsics */
public static class rs_motion_intrinsics extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public rs_motion_intrinsics() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public rs_motion_intrinsics(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_motion_intrinsics(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public rs_motion_intrinsics position(long position) {
        return (rs_motion_intrinsics)super.position(position);
    }

    public native @ByRef rs_motion_device_intrinsic acc(); public native rs_motion_intrinsics acc(rs_motion_device_intrinsic acc);
    public native @ByRef rs_motion_device_intrinsic gyro(); public native rs_motion_intrinsics gyro(rs_motion_device_intrinsic gyro);
}

public static class rs_extrinsics extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public rs_extrinsics() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public rs_extrinsics(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_extrinsics(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public rs_extrinsics position(long position) {
        return (rs_extrinsics)super.position(position);
    }

    public native float rotation(int i); public native rs_extrinsics rotation(int i, float rotation);
    @MemberGetter public native FloatPointer rotation();    /* column-major 3x3 rotation matrix */
    public native float translation(int i); public native rs_extrinsics translation(int i, float translation);
    @MemberGetter public native FloatPointer translation(); /* 3 element translation vector, in meters */
}

/** enum rs_event_source */
public static final int
    RS_EVENT_IMU_ACCEL        = 0,
    RS_EVENT_IMU_GYRO         = 1,
    RS_EVENT_IMU_DEPTH_CAM    = 2,
    RS_EVENT_IMU_MOTION_CAM   = 3,
    RS_EVENT_G0_SYNC          = 4,
    RS_EVENT_G1_SYNC          = 5,
    RS_EVENT_G2_SYNC          = 6,
    RS_EVENT_SOURCE_COUNT     = 7,
    RS_EVENT_SOURCE_MAX_ENUM  =  0x7FFFFFFF;


/** enum rs_timestamp_domain */
public static final int
    RS_TIMESTAMP_DOMAIN_CAMERA                   = 0,
    RS_TIMESTAMP_DOMAIN_MICROCONTROLLER          = 1,
    RS_TIMESTAMP_DOMAIN_COUNT   = 3,
    RS_TIMESTAMP_DOMAIN_MAX_ENUM =  0x7FFFFFFF;


public static class rs_timestamp_data extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public rs_timestamp_data() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public rs_timestamp_data(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_timestamp_data(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public rs_timestamp_data position(long position) {
        return (rs_timestamp_data)super.position(position);
    }

    public native double timestamp(); public native rs_timestamp_data timestamp(double timestamp);     /* timestamp in milliseconds */
    public native @Cast("rs_event_source") int source_id(); public native rs_timestamp_data source_id(int source_id);
    public native @Cast("unsigned long long") long frame_number(); public native rs_timestamp_data frame_number(long frame_number);
}

public static class rs_motion_data extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public rs_motion_data() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public rs_motion_data(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_motion_data(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public rs_motion_data position(long position) {
        return (rs_motion_data)super.position(position);
    }

    public native @ByRef rs_timestamp_data timestamp_data(); public native rs_motion_data timestamp_data(rs_timestamp_data timestamp_data);
    public native @Cast("unsigned int") int is_valid(); public native rs_motion_data is_valid(int is_valid);   /* boolean */
    public native float axes(int i); public native rs_motion_data axes(int i, float axes);
    @MemberGetter public native FloatPointer axes();    /* Three [x,y,z] axes; 16 bit data for Gyro [rad/sec], 12 bit for Accelerometer; 2's complement [m/sec^2]*/
}
@Opaque public static class rs_error extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public rs_error() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_error(Pointer p) { super(p); }
}
@Opaque public static class rs_frameset extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public rs_frameset() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_frameset(Pointer p) { super(p); }
}

public static native rs_context rs_create_context(int api_version, @Cast("rs_error**") PointerPointer error);
public static native rs_context rs_create_context(int api_version, @ByPtrPtr rs_error error);
public static native void rs_delete_context(rs_context context, @Cast("rs_error**") PointerPointer error);
public static native void rs_delete_context(rs_context context, @ByPtrPtr rs_error error);

/**
 * determine number of connected devices
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the count of devices
 */
public static native int rs_get_device_count(@Const rs_context context, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_device_count(@Const rs_context context, @ByPtrPtr rs_error error);

/**
 * retrieve connected device by index
 * @param [in] index   the zero based index of device to retrieve
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the requested device
 */
public static native rs_device rs_get_device(rs_context context, int index, @Cast("rs_error**") PointerPointer error);
public static native rs_device rs_get_device(rs_context context, int index, @ByPtrPtr rs_error error);

/**
 * retrieve a human readable device model string
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the model string, such as "Intel RealSense F200" or "Intel RealSense R200"
 */
public static native @Cast("const char*") BytePointer rs_get_device_name(@Const rs_device device, @Cast("rs_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs_get_device_name(@Const rs_device device, @ByPtrPtr rs_error error);

/**
 * retrieve the unique serial number of the device
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the serial number, in a format specific to the device model
 */
public static native @Cast("const char*") BytePointer rs_get_device_serial(@Const rs_device device, @Cast("rs_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs_get_device_serial(@Const rs_device device, @ByPtrPtr rs_error error);

/**
* retrieve camera specific information, like versions of various internal componnents
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the requested camera info string, in a format specific to the device model
*/
public static native @Cast("const char*") BytePointer rs_get_device_info(@Const rs_device device, @Cast("rs_camera_info") int info, @Cast("rs_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs_get_device_info(@Const rs_device device, @Cast("rs_camera_info") int info, @ByPtrPtr rs_error error);

/**
 * retrieve the USB port number of the device
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the USB port number in a string form "##-##"
 */
public static native @Cast("const char*") BytePointer rs_get_device_usb_port_id(@Const rs_device device, @Cast("rs_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs_get_device_usb_port_id(@Const rs_device device, @ByPtrPtr rs_error error);

/**
 * retrieve the version of the firmware currently installed on the device
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            firmware version string, in a format is specific to device model
 */
public static native @Cast("const char*") BytePointer rs_get_device_firmware_version(@Const rs_device device, @Cast("rs_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs_get_device_firmware_version(@Const rs_device device, @ByPtrPtr rs_error error);

/**
 * retrieve extrinsic transformation between the viewpoints of two different streams
 * @param [in] from_stream  stream whose coordinate space we will transform from
 * @param [in] to_stream    stream whose coordinate space we will transform to
 * @param [out] extrin      the transformation between the two streams
 * @param [out] error       if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_get_device_extrinsics(@Const rs_device device, @Cast("rs_stream") int from_stream, @Cast("rs_stream") int to_stream, rs_extrinsics extrin, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_device_extrinsics(@Const rs_device device, @Cast("rs_stream") int from_stream, @Cast("rs_stream") int to_stream, rs_extrinsics extrin, @ByPtrPtr rs_error error);

/**
* retrieve extrinsic transformation between specific stream and the motion module
* @param [in] from_stream  stream whose coordinate space we will transform from
* @param [out] extrin      the transformation between the specific stream and motion module
* @param [out] error       if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_get_motion_extrinsics_from(@Const rs_device device, @Cast("rs_stream") int from, rs_extrinsics extrin, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_motion_extrinsics_from(@Const rs_device device, @Cast("rs_stream") int from, rs_extrinsics extrin, @ByPtrPtr rs_error error);

/**
 * retrieve mapping between the units of the depth image and meters
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            depth in meters corresponding to a depth value of 1
 */
public static native float rs_get_device_depth_scale(@Const rs_device device, @Cast("rs_error**") PointerPointer error);
public static native float rs_get_device_depth_scale(@Const rs_device device, @ByPtrPtr rs_error error);

/**
 * determine if the device allows a specific option to be queried and set
 * @param [in] option  the option to check for support
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            true if the option can be queried and set
 */
public static native int rs_device_supports_option(@Const rs_device device, @Cast("rs_option") int option, @Cast("rs_error**") PointerPointer error);
public static native int rs_device_supports_option(@Const rs_device device, @Cast("rs_option") int option, @ByPtrPtr rs_error error);

/**
 * determine the number of streaming modes available for a given stream
 * @param [in] stream  the stream whose modes will be enumerated
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the count of available modes
 */
public static native int rs_get_stream_mode_count(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_stream_mode_count(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * determine the properties of a specific streaming mode
 * @param [in] stream      the stream whose mode will be queried
 * @param [in] index       the zero based index of the streaming mode
 * @param [out] width      the width of a frame image in pixels
 * @param [out] height     the height of a frame image in pixels
 * @param [out] format     the pixel format of a frame image
 * @param [out] framerate  the number of frames which will be streamed per second
 * @param [out] error      if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_get_stream_mode(@Const rs_device device, @Cast("rs_stream") int stream, int index, IntPointer width, IntPointer height, @Cast("rs_format*") IntPointer format, IntPointer framerate, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_stream_mode(@Const rs_device device, @Cast("rs_stream") int stream, int index, IntPointer width, IntPointer height, @Cast("rs_format*") IntPointer format, IntPointer framerate, @ByPtrPtr rs_error error);
public static native void rs_get_stream_mode(@Const rs_device device, @Cast("rs_stream") int stream, int index, IntBuffer width, IntBuffer height, @Cast("rs_format*") IntBuffer format, IntBuffer framerate, @ByPtrPtr rs_error error);
public static native void rs_get_stream_mode(@Const rs_device device, @Cast("rs_stream") int stream, int index, int[] width, int[] height, @Cast("rs_format*") int[] format, int[] framerate, @ByPtrPtr rs_error error);

/**
 * enable a specific stream and request specific properties
 * @param [in] stream         the stream to enable
 * @param [in] width          the desired width of a frame image in pixels, or 0 if any width is acceptable
 * @param [in] height         the desired height of a frame image in pixels, or 0 if any height is acceptable
 * @param [in] format         the pixel format of a frame image, or ANY if any format is acceptable
 * @param [in] framerate      the number of frames which will be streamed per second, or 0 if any framerate is acceptable
 * @param [in] output_format  output buffer format (contious in memory / native with pitch)
 * @param [out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_enable_stream_ex(rs_device device, @Cast("rs_stream") int stream, int width, int height, @Cast("rs_format") int format, int framerate, @Cast("rs_output_buffer_format") int output_format, @Cast("rs_error**") PointerPointer error);
public static native void rs_enable_stream_ex(rs_device device, @Cast("rs_stream") int stream, int width, int height, @Cast("rs_format") int format, int framerate, @Cast("rs_output_buffer_format") int output_format, @ByPtrPtr rs_error error);

/**
* enable a specific stream and request specific properties
* @param [in] stream         the stream to enable
* @param [in] width          the desired width of a frame image in pixels, or 0 if any width is acceptable
* @param [in] height         the desired height of a frame image in pixels, or 0 if any height is acceptable
* @param [in] format         the pixel format of a frame image, or ANY if any format is acceptable
* @param [in] framerate      the number of frames which will be streamed per second, or 0 if any framerate is acceptable
* @param [out] error     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_enable_stream(rs_device device, @Cast("rs_stream") int stream, int width, int height, @Cast("rs_format") int format, int framerate, @Cast("rs_error**") PointerPointer error);
public static native void rs_enable_stream(rs_device device, @Cast("rs_stream") int stream, int width, int height, @Cast("rs_format") int format, int framerate, @ByPtrPtr rs_error error);

/**
 * enable a specific stream and request properties using a preset
 * @param [in] stream  the stream to enable
 * @param [in] preset  the preset to use to enable the stream
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_enable_stream_preset(rs_device device, @Cast("rs_stream") int stream, @Cast("rs_preset") int preset, @Cast("rs_error**") PointerPointer error);
public static native void rs_enable_stream_preset(rs_device device, @Cast("rs_stream") int stream, @Cast("rs_preset") int preset, @ByPtrPtr rs_error error);

/**
 * disable a specific stream
 * @param [in] stream  the stream to disable
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_disable_stream(rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native void rs_disable_stream(rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * determine if a specific stream is enabled
 * @param [in] stream  the stream to check
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            true if the stream is currently enabled
 */
public static native int rs_is_stream_enabled(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native int rs_is_stream_enabled(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * retrieve the width in pixels of a specific stream, equivalent to the width field from the stream's intrinsics
 * @param [in] stream  the stream whose width to retrieve
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the width in pixels of images from this stream
 */
public static native int rs_get_stream_width(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_stream_width(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * retrieve the height in pixels of a specific stream, equivalent to the height field from the stream's intrinsics
 * @param [in] stream  the stream whose height to retrieve
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the height in pixels of images from this stream
 */
public static native int rs_get_stream_height(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_stream_height(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * retrieve the pixel format for a specific stream
 * @param [in] stream  the stream whose format to retrieve
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the pixel format of the stream
 */
public static native @Cast("rs_format") int rs_get_stream_format(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native @Cast("rs_format") int rs_get_stream_format(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * retrieve the framerate for a specific stream
 * @param [in] stream  the stream whose framerate to retrieve
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the framerate of the stream, in frames per second
 */
public static native int rs_get_stream_framerate(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_stream_framerate(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * retrieve intrinsic camera parameters for a specific stream
 * @param [in] stream   the stream whose parameters to retrieve
 * @param [out] intrin  the intrinsic parameters of the stream
 * @param [out] error   if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_get_stream_intrinsics(@Const rs_device device, @Cast("rs_stream") int stream, rs_intrinsics intrin, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_stream_intrinsics(@Const rs_device device, @Cast("rs_stream") int stream, rs_intrinsics intrin, @ByPtrPtr rs_error error);

/**
* retrieve intrinsic camera parameters for a motion module
* @param [out] intrinsic  the intrinsic parameters
* @param [out] error   if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_get_motion_intrinsics(@Const rs_device device, rs_motion_intrinsics intrinsic, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_motion_intrinsics(@Const rs_device device, rs_motion_intrinsics intrinsic, @ByPtrPtr rs_error error);

/**
* set up a frame callback that will be called immediately when an image is available, with no synchronization logic applied
* @param [in] stream    the stream for whose images the callback should be registered
* @param [in] on_frame  the callback which will receive the frame data and timestamp
* @param [in] user      a user data point to be passed to the callback
* @param [out] error    if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static class On_frame_rs_device_rs_frame_ref_Pointer extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    On_frame_rs_device_rs_frame_ref_Pointer(Pointer p) { super(p); }
    protected On_frame_rs_device_rs_frame_ref_Pointer() { allocate(); }
    private native void allocate();
    public native void call(rs_device dev, rs_frame_ref frame, Pointer user);
}
public static native void rs_set_frame_callback(rs_device device, @Cast("rs_stream") int stream, On_frame_rs_device_rs_frame_ref_Pointer on_frame, Pointer user, @Cast("rs_error**") PointerPointer error);
public static native void rs_set_frame_callback(rs_device device, @Cast("rs_stream") int stream, On_frame_rs_device_rs_frame_ref_Pointer on_frame, Pointer user, @ByPtrPtr rs_error error);

/**
* enable and configure motion-tracking data handlers
* @param [in] on_motion_event    user-defined routine to be invoked when a motion data arrives
* @param [in] motion_handler     a user data point to be passed to the motion event callback
* @param [in] on_timestamp_event user-defined routine to be invoked on timestamp
* @param [in] timestamp_handler  a user data point to be passed to the motion event callback
* @param [out] error             if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static class On_motion_event_rs_device_rs_motion_data_Pointer extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    On_motion_event_rs_device_rs_motion_data_Pointer(Pointer p) { super(p); }
    protected On_motion_event_rs_device_rs_motion_data_Pointer() { allocate(); }
    private native void allocate();
    public native void call(rs_device arg0, @ByVal rs_motion_data arg1, Pointer arg2 );
}
public static class On_timestamp_event_rs_device_rs_timestamp_data_Pointer extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    On_timestamp_event_rs_device_rs_timestamp_data_Pointer(Pointer p) { super(p); }
    protected On_timestamp_event_rs_device_rs_timestamp_data_Pointer() { allocate(); }
    private native void allocate();
    public native void call(rs_device arg0, @ByVal rs_timestamp_data arg1, Pointer arg2 );
}
public static native void rs_enable_motion_tracking(rs_device device,
    On_motion_event_rs_device_rs_motion_data_Pointer on_motion_event, Pointer motion_handler,
    On_timestamp_event_rs_device_rs_timestamp_data_Pointer on_timestamp_event, Pointer timestamp_handler,
    @Cast("rs_error**") PointerPointer error);
public static native void rs_enable_motion_tracking(rs_device device,
    On_motion_event_rs_device_rs_motion_data_Pointer on_motion_event, Pointer motion_handler,
    On_timestamp_event_rs_device_rs_timestamp_data_Pointer on_timestamp_event, Pointer timestamp_handler,
    @ByPtrPtr rs_error error);

/**
* enable and configure motion-tracking data handlers
* (This variant is provided specifically to enable passing lambdas with capture lists safely into the library)
* @param [in] motion_callback    user-defined routine to be invoked when a motion data arrives
* @param [in] timestamp_callback user-defined routine to be invoked on timestamp
* @param [out] error             if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_enable_motion_tracking_cpp(rs_device device,
    rs_motion_callback motion_callback,
    rs_timestamp_callback timestamp_callback,
    @Cast("rs_error**") PointerPointer error);
public static native void rs_enable_motion_tracking_cpp(rs_device device,
    rs_motion_callback motion_callback,
    rs_timestamp_callback timestamp_callback,
    @ByPtrPtr rs_error error);

/**
 * set up a frame callback that will be called immediately when an image is available, with no synchronization logic applied
 * (This variant is provided specificly to enable passing lambdas with capture lists safely into the library)
 * @param [in] stream    the stream for whose images the callback should be registered
 * @param [in] callback  the callback which will receive the frame data and timestamp
 * @param [out] error    if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_set_frame_callback_cpp(rs_device device, @Cast("rs_stream") int stream, rs_frame_callback callback, @Cast("rs_error**") PointerPointer error);
public static native void rs_set_frame_callback_cpp(rs_device device, @Cast("rs_stream") int stream, rs_frame_callback callback, @ByPtrPtr rs_error error);

/**
* disable motion-tracking handlers
*/
public static native void rs_disable_motion_tracking(rs_device device, @Cast("rs_error**") PointerPointer error);
public static native void rs_disable_motion_tracking(rs_device device, @ByPtrPtr rs_error error);

/**
* check if data acquisition is active
*/
public static native int rs_is_motion_tracking_active(rs_device device, @Cast("rs_error**") PointerPointer error);
public static native int rs_is_motion_tracking_active(rs_device device, @ByPtrPtr rs_error error);


/**
 * begin streaming on all enabled streams for this device
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_start_device(rs_device device, @Cast("rs_error**") PointerPointer error);
public static native void rs_start_device(rs_device device, @ByPtrPtr rs_error error);

/**
 * end data acquisition for the specified source providers
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_stop_device(rs_device device, @Cast("rs_error**") PointerPointer error);
public static native void rs_stop_device(rs_device device, @ByPtrPtr rs_error error);

/**
 * begin streaming on all enabled streams for this device
 * @param [in] source  the data source to be activated
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_start_source(rs_device device, @Cast("rs_source") int source, @Cast("rs_error**") PointerPointer error);
public static native void rs_start_source(rs_device device, @Cast("rs_source") int source, @ByPtrPtr rs_error error);

/**
 * end data acquisition for the specified source providers
 * @param [in] source  the data source to be terminated
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_stop_source(rs_device device, @Cast("rs_source") int source, @Cast("rs_error**") PointerPointer error);
public static native void rs_stop_source(rs_device device, @Cast("rs_source") int source, @ByPtrPtr rs_error error);

/**
 * determine if the device is currently streaming
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            true if the device is currently streaming
 */
public static native int rs_is_device_streaming(@Const rs_device device, @Cast("rs_error**") PointerPointer error);
public static native int rs_is_device_streaming(@Const rs_device device, @ByPtrPtr rs_error error);

/**
 * retrieve the available range of values of a supported option
 * @param [in] option  the option whose range should be queried
 * @param [out] min    the minimum value which will be accepted for this option
 * @param [out] max    the maximum value which will be accepted for this option
 * @param [out] step   the granularity of options which accept discrete values, or zero if the option accepts continuous values
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_get_device_option_range(rs_device device, @Cast("rs_option") int option, DoublePointer min, DoublePointer max, DoublePointer step, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_device_option_range(rs_device device, @Cast("rs_option") int option, DoublePointer min, DoublePointer max, DoublePointer step, @ByPtrPtr rs_error error);
public static native void rs_get_device_option_range(rs_device device, @Cast("rs_option") int option, DoubleBuffer min, DoubleBuffer max, DoubleBuffer step, @ByPtrPtr rs_error error);
public static native void rs_get_device_option_range(rs_device device, @Cast("rs_option") int option, double[] min, double[] max, double[] step, @ByPtrPtr rs_error error);

/**
 * retrieve the available range of values of a supported option
 * @param [in] option  the option whose range should be queried
 * @param [out] min    the minimum value which will be accepted for this option
 * @param [out] max    the maximum value which will be accepted for this option
 * @param [out] step   the granularity of options which accept discrete values, or zero if the option accepts continuous values
 * @param [out] def    the default value of the option
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_get_device_option_range_ex(rs_device device, @Cast("rs_option") int option, DoublePointer min, DoublePointer max, DoublePointer step, DoublePointer def, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_device_option_range_ex(rs_device device, @Cast("rs_option") int option, DoublePointer min, DoublePointer max, DoublePointer step, DoublePointer def, @ByPtrPtr rs_error error);
public static native void rs_get_device_option_range_ex(rs_device device, @Cast("rs_option") int option, DoubleBuffer min, DoubleBuffer max, DoubleBuffer step, DoubleBuffer def, @ByPtrPtr rs_error error);
public static native void rs_get_device_option_range_ex(rs_device device, @Cast("rs_option") int option, double[] min, double[] max, double[] step, double[] def, @ByPtrPtr rs_error error);

/**
 * efficiently retrieve the value of an arbitrary number of options, using minimal hardware IO
 * @param [in] options  the array of options which should be queried
 * @param [in] count    the length of the options and values arrays
 * @param [out] values  the array which will receive the values of the queried options
 * @param [out] error   if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_get_device_options(rs_device device, @Cast("const rs_option*") IntPointer options, @Cast("unsigned int") int count, DoublePointer values, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_device_options(rs_device device, @Cast("const rs_option*") IntPointer options, @Cast("unsigned int") int count, DoublePointer values, @ByPtrPtr rs_error error);
public static native void rs_get_device_options(rs_device device, @Cast("const rs_option*") IntBuffer options, @Cast("unsigned int") int count, DoubleBuffer values, @ByPtrPtr rs_error error);
public static native void rs_get_device_options(rs_device device, @Cast("const rs_option*") int[] options, @Cast("unsigned int") int count, double[] values, @ByPtrPtr rs_error error);

/**
 * efficiently set the value of an arbitrary number of options, using minimal hardware IO
 * @param [in] options  the array of options which should be set
 * @param [in] count    the length of the options and values arrays
 * @param [in] values   the array of values to which the options should be set
 * @param [out] error   if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_set_device_options(rs_device device, @Cast("const rs_option*") IntPointer options, @Cast("unsigned int") int count, @Const DoublePointer values, @Cast("rs_error**") PointerPointer error);
public static native void rs_set_device_options(rs_device device, @Cast("const rs_option*") IntPointer options, @Cast("unsigned int") int count, @Const DoublePointer values, @ByPtrPtr rs_error error);
public static native void rs_set_device_options(rs_device device, @Cast("const rs_option*") IntBuffer options, @Cast("unsigned int") int count, @Const DoubleBuffer values, @ByPtrPtr rs_error error);
public static native void rs_set_device_options(rs_device device, @Cast("const rs_option*") int[] options, @Cast("unsigned int") int count, @Const double[] values, @ByPtrPtr rs_error error);

/**
* efficiently reset the value of an arbitrary number of options to default
* @param [in] options  the array of options which should be set to default
* @param [in] count    the length of the options array
* @param [out] error   if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_reset_device_options_to_default(rs_device device, @Cast("const rs_option*") IntPointer options, int count, @Cast("rs_error**") PointerPointer error);
public static native void rs_reset_device_options_to_default(rs_device device, @Cast("const rs_option*") IntPointer options, int count, @ByPtrPtr rs_error error);
public static native void rs_reset_device_options_to_default(rs_device device, @Cast("const rs_option*") IntBuffer options, int count, @ByPtrPtr rs_error error);
public static native void rs_reset_device_options_to_default(rs_device device, @Cast("const rs_option*") int[] options, int count, @ByPtrPtr rs_error error);

/**
 * retrieve the current value of a single option
 * @param [in] option  the option whose value should be retrieved
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the value of the option
 */
public static native double rs_get_device_option(rs_device device, @Cast("rs_option") int option, @Cast("rs_error**") PointerPointer error);
public static native double rs_get_device_option(rs_device device, @Cast("rs_option") int option, @ByPtrPtr rs_error error);


/**
 * retrieve a static description of what a particular option does on given device
 * @param [in] option  the option whose description should be retrieved
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the value of the option
 */
public static native @Cast("const char*") BytePointer rs_get_device_option_description(rs_device device, @Cast("rs_option") int option, @Cast("rs_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs_get_device_option_description(rs_device device, @Cast("rs_option") int option, @ByPtrPtr rs_error error);


/**
 * set the current value of a single option
 * @param [in] option  the option whose value should be set
 * @param [in] value   the value of the option
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_set_device_option(rs_device device, @Cast("rs_option") int option, double value, @Cast("rs_error**") PointerPointer error);
public static native void rs_set_device_option(rs_device device, @Cast("rs_option") int option, double value, @ByPtrPtr rs_error error);

/**
 * block until new frames are available
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_wait_for_frames(rs_device device, @Cast("rs_error**") PointerPointer error);
public static native void rs_wait_for_frames(rs_device device, @ByPtrPtr rs_error error);

/**
 * check if new frames are available, without blocking
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            1 if new frames are available, 0 if no new frames have arrived
 */
public static native int rs_poll_for_frames(rs_device device, @Cast("rs_error**") PointerPointer error);
public static native int rs_poll_for_frames(rs_device device, @ByPtrPtr rs_error error);

/**
 * determine device capabilities
 * @param [in] capability  the capability to check for support
 * @return                true if device has this capability
 */
public static native int rs_supports(rs_device device, @Cast("rs_capabilities") int capability, @Cast("rs_error**") PointerPointer error);
public static native int rs_supports(rs_device device, @Cast("rs_capabilities") int capability, @ByPtrPtr rs_error error);

/**
 * retrieve the time at which the latest frame on a stream was captured
 * @param [in] stream  the stream whose latest frame we are interested in
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the timestamp of the frame, in milliseconds since the device was started
 */
public static native double rs_get_frame_timestamp(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native double rs_get_frame_timestamp(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
* retrieve the frame number
* @param [in] stream  the stream whose latest frame we are interested in
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the frame number
*/
public static native @Cast("unsigned long long") long rs_get_frame_number(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native @Cast("unsigned long long") long rs_get_frame_number(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * retrieve the contents of the latest frame on a stream
 * @param [in] stream  the stream whose latest frame we are interested in
 * @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the pointer to the start of the frame data
 */
public static native @Const Pointer rs_get_frame_data(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native @Const Pointer rs_get_frame_data(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
* relases the frame handle
* @param [in] frame handle returned either detach, clone_ref or from frame callback
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the pointer to the start of the frame data
*/
public static native void rs_release_frame(rs_device device, rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native void rs_release_frame(rs_device device, rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive timestamp from safe frame handle, returned from detach, clone_ref or from frame callback
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the timestamp of the frame, in milliseconds since the device was started
*/
public static native double rs_get_detached_frame_timestamp(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native double rs_get_detached_frame_timestamp(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive timestamp domain from safe frame handle, returned from detach, clone_ref or from frame callback
* this method is used to check if two timestamp values are comparable (generated from the same clock)
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the timestamp domain of the frame (camera/ microcontroller)
*/
public static native @Cast("rs_timestamp_domain") int rs_get_detached_frame_timestamp_domain(@Const rs_frame_ref frameset, @Cast("rs_error**") PointerPointer error);
public static native @Cast("rs_timestamp_domain") int rs_get_detached_frame_timestamp_domain(@Const rs_frame_ref frameset, @ByPtrPtr rs_error error);

/**
* retrive frame number from safe frame handle, returned from detach, clone_ref or from frame callback
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the frame nubmer of the frame, in milliseconds since the device was started
*/
public static native @Cast("unsigned long long") long rs_get_detached_frame_number(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native @Cast("unsigned long long") long rs_get_detached_frame_number(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive data from safe frame handle, returned from detach, clone_ref or from frame callback
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the pointer to the start of the frame data
*/
public static native @Const Pointer rs_get_detached_frame_data(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native @Const Pointer rs_get_detached_frame_data(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive frame intrinsic width
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            intrinsic width
*/
public static native int rs_get_detached_frame_width(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_detached_frame_width(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive frame intrinsic height
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            intrinsic height
*/
public static native int rs_get_detached_frame_height(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_detached_frame_height(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive frame intrinsic framerate
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            intrinsic framerate
*/
public static native int rs_get_detached_framerate(@Const rs_frame_ref frameset, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_detached_framerate(@Const rs_frame_ref frameset, @ByPtrPtr rs_error error);

/**
* retrive frame stride, meaning the actual line width in memory (not the logical image width)
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            frame pad crop
*/
public static native int rs_get_detached_frame_stride(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_detached_frame_stride(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive frame **bits** per pixel
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            frame pad crop
*/
public static native int rs_get_detached_frame_bpp(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_detached_frame_bpp(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive frame format
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            frame format
*/
public static native @Cast("rs_format") int rs_get_detached_frame_format(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native @Cast("rs_format") int rs_get_detached_frame_format(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive frame stream type
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            stream type
*/
public static native @Cast("rs_stream") int rs_get_detached_frame_stream_type(@Const rs_frame_ref frameset, @Cast("rs_error**") PointerPointer error);
public static native @Cast("rs_stream") int rs_get_detached_frame_stream_type(@Const rs_frame_ref frameset, @ByPtrPtr rs_error error);

/**
* send a blob of data to the device. at the moment only RS_BLOB_TYPE_MOTION_MODULE_FIRMWARE_UPDATE is support
* of the motiohn module.
* @param [in] firmware data.
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_send_blob_to_device(rs_device device, @Cast("rs_blob_type") int type, Pointer data, int size, @Cast("rs_error**") PointerPointer error);
public static native void rs_send_blob_to_device(rs_device device, @Cast("rs_blob_type") int type, Pointer data, int size, @ByPtrPtr rs_error error);

/**
* retrieve the API version from the source code. Evaluate that the value is conformant to the established policies
* @param [out] error  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the version API encoded into integer value "1.9.3" -> 10903
*/
public static native int rs_get_api_version(@Cast("rs_error**") PointerPointer error);
public static native int rs_get_api_version(@ByPtrPtr rs_error error);

public static native @Cast("const char*") BytePointer rs_get_failed_function(@Const rs_error error);
public static native @Cast("const char*") BytePointer rs_get_failed_args(@Const rs_error error);
public static native @Cast("const char*") BytePointer rs_get_error_message(@Const rs_error error);
public static native void rs_free_error(rs_error error);


public static native @Cast("const char*") BytePointer rs_stream_to_string(@Cast("rs_stream") int stream);
public static native @Cast("const char*") BytePointer rs_format_to_string(@Cast("rs_format") int format);
public static native @Cast("const char*") BytePointer rs_preset_to_string(@Cast("rs_preset") int preset);
public static native @Cast("const char*") BytePointer rs_distortion_to_string(@Cast("rs_distortion") int distortion);
public static native @Cast("const char*") BytePointer rs_option_to_string(@Cast("rs_option") int option);
public static native @Cast("const char*") BytePointer rs_capabilities_to_string(@Cast("rs_capabilities") int capability);
public static native @Cast("const char*") BytePointer rs_source_to_string(@Cast("rs_source") int source);
public static native @Cast("const char*") BytePointer rs_event_to_string(@Cast("rs_event_source") int event);
public static native @Cast("const char*") BytePointer rs_blob_type_to_string(@Cast("rs_blob_type") int type);
public static native @Cast("const char*") BytePointer rs_camera_info_to_string(@Cast("rs_camera_info") int info);
public static native @Cast("const char*") BytePointer rs_timestamp_domain_to_string(@Cast("rs_timestamp_domain") int info);

/** enum rs_log_severity */
public static final int
    RS_LOG_SEVERITY_DEBUG = 0, /* Detailed information about ordinary operations */
    RS_LOG_SEVERITY_INFO  = 1, /* Terse information about ordinary operations */
    RS_LOG_SEVERITY_WARN  = 2, /* Indication of possible failure */
    RS_LOG_SEVERITY_ERROR = 3, /* Indication of definite failure */
    RS_LOG_SEVERITY_FATAL = 4, /* Indication of unrecoverable failure */
    RS_LOG_SEVERITY_NONE  = 5, /* No logging will occur */
    RS_LOG_SEVERITY_MAX_ENUM =  0x7FFFFFFF;
public static native void rs_log_to_console(@Cast("rs_log_severity") int min_severity, @Cast("rs_error**") PointerPointer error);
public static native void rs_log_to_console(@Cast("rs_log_severity") int min_severity, @ByPtrPtr rs_error error);
public static native void rs_log_to_file(@Cast("rs_log_severity") int min_severity, @Cast("const char*") BytePointer file_path, @Cast("rs_error**") PointerPointer error);
public static native void rs_log_to_file(@Cast("rs_log_severity") int min_severity, @Cast("const char*") BytePointer file_path, @ByPtrPtr rs_error error);
public static native void rs_log_to_file(@Cast("rs_log_severity") int min_severity, String file_path, @ByPtrPtr rs_error error);
public static native void rs_log_to_callback_cpp(@Cast("rs_log_severity") int min_severity, rs_log_callback callback, @Cast("rs_error**") PointerPointer error);
public static native void rs_log_to_callback_cpp(@Cast("rs_log_severity") int min_severity, rs_log_callback callback, @ByPtrPtr rs_error error);
public static class On_log_int_BytePointer_Pointer extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    On_log_int_BytePointer_Pointer(Pointer p) { super(p); }
    protected On_log_int_BytePointer_Pointer() { allocate(); }
    private native void allocate();
    public native void call(@Cast("rs_log_severity") int min_severity, @Cast("const char*") BytePointer message, Pointer user);
}
public static native void rs_log_to_callback(@Cast("rs_log_severity") int min_severity, On_log_int_BytePointer_Pointer on_log, Pointer user, @Cast("rs_error**") PointerPointer error);
public static native void rs_log_to_callback(@Cast("rs_log_severity") int min_severity, On_log_int_BytePointer_Pointer on_log, Pointer user, @ByPtrPtr rs_error error);
public static class On_log_int_String_Pointer extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    On_log_int_String_Pointer(Pointer p) { super(p); }
    protected On_log_int_String_Pointer() { allocate(); }
    private native void allocate();
    public native void call(@Cast("rs_log_severity") int min_severity, String message, Pointer user);
}
public static native void rs_log_to_callback(@Cast("rs_log_severity") int min_severity, On_log_int_String_Pointer on_log, Pointer user, @ByPtrPtr rs_error error);

// #ifdef __cplusplus
// #endif
// #endif


// Parsed from <librealsense/rs.hpp>

// License: Apache 2.0. See LICENSE file in root directory.
// Copyright(c) 2015 Intel Corporation. All Rights Reserved.

// #ifndef LIBREALSENSE_RS_HPP
// #define LIBREALSENSE_RS_HPP

// #include "rsutil.h"
// #include "rscore.hpp"
// #include <cmath>
// #include <cstdint>
// #include <cstring>
// #include <sstream>
// #include <stdexcept>
// #include <functional>
// #include <vector>
    /** enum class rs::capabilities */
    public static final int
        // depth                   = 0,
        // color                   = 1,
        // infrared                = 2,
        // infrared2               = 3,
        fish_eye                = 4,
        motion_events           = 5,
        motion_module_fw_update = 6,
        adapter_board           = 7,
        enumeration             = 8;

    /** enum class rs::stream */
    public static final int
        /** Native stream of depth data produced by RealSense device */
        depth                            = 0,
        /** Native stream of color data captured by RealSense device */
        color                            = 1,
        /** Native stream of infrared data captured by RealSense device */
        infrared                         = 2,
        /** Native stream of infrared data captured from a second viewpoint by RealSense device */
        infrared2                        = 3,
        fisheye                          = 4,
        /** Synthetic stream containing point cloud data generated by deprojecting the depth image */
        points                           = 5,
        /** Synthetic stream containing undistorted color data with no extrinsic rotation from the depth stream */
        rectified_color                  = 6,
        /** Synthetic stream containing color data but sharing intrinsics of depth stream */
        color_aligned_to_depth           = 7,
        /** Synthetic stream containing second viewpoint infrared data but sharing intrinsics of depth stream */
        infrared2_aligned_to_depth       = 8,
        /** Synthetic stream containing depth data but sharing intrinsics of color stream */
        depth_aligned_to_color           = 9,
        /** Synthetic stream containing depth data but sharing intrinsics of rectified color stream */
        depth_aligned_to_rectified_color = 10,
        /** Synthetic stream containing depth data but sharing intrinsics of second viewpoint infrared stream */
        depth_aligned_to_infrared2       = 11;

    /** enum class rs::format */
    public static final int
        any         = 0,
        /** 16 bit linear depth values. The depth is meters is equal to depth scale * pixel value */
        z16         = 1,
        /** 16 bit linear disparity values. The depth in meters is equal to depth scale / pixel value */
        disparity16 = 2,
        /** 32 bit floating point 3D coordinates. */
        xyz32f      = 3,
        yuyv        = 4,
        rgb8        = 5,
        bgr8        = 6,
        rgba8       = 7,
        bgra8       = 8,
        y8          = 9,
        y16         = 10,
        /** Four 10-bit luminance values encoded into a 5-byte macropixel */
        raw10       = 11,
        /** Four 10-bit luminance filled in 16 bit pixel (6 bit unused) */
        raw16       = 12,
        raw8        = 13;

    /** enum class rs::output_buffer_format */
    public static final int
         output_buffer_continous      = 0,
         output_buffer_native         = 1;

    /** enum class rs::preset */
    public static final int
        best_quality      = 0,
        largest_image     = 1,
        highest_framerate = 2;

    /** enum class rs::distortion */
    public static final int
        /** Rectilinear images, no distortion compensation required */
        none                   = 0,
        /** Equivalent to Brown-Conrady distortion, except that tangential distortion is applied to radially distorted points */
        modified_brown_conrady = 1,
        /** Equivalent to Brown-Conrady distortion, except undistorts image instead of distorting it */
        inverse_brown_conrady  = 2,
        distortion_ftheta      = 3;

    // reflection of rs_option
    /** enum class rs::option */
    public static final int
        /** Enable / disable color backlight compensation*/
        color_backlight_compensation                    = 0,
        /** Color image brightness*/
        color_brightness                                = 1,
        /** Color image contrast*/
        color_contrast                                  = 2,
        /** Controls exposure time of color camera. Setting any value will disable auto exposure*/
        color_exposure                                  = 3,
        /** Color image gain*/
        color_gain                                      = 4,
        /** Color image gamma setting*/
        color_gamma                                     = 5,
        /** Color image hue*/
        color_hue                                       = 6,
        /** Color image saturation setting*/
        color_saturation                                = 7,
        /** Color image sharpness setting*/
        color_sharpness                                 = 8,
        /** Controls white balance of color image. Setting any value will disable auto white balance*/
        color_white_balance                             = 9,
        /** Enable / disable color image auto-exposure*/
        color_enable_auto_exposure                      = 10,
        /** Enable / disable color image auto-white-balance*/
        color_enable_auto_white_balance                 = 11,
        /** Power of the F200 / SR300 projector, with 0 meaning projector off*/
        f200_laser_power                                = 12,
        /** Set the number of patterns projected per frame. The higher the accuracy value the more patterns projected. Increasing the number of patterns help to achieve better accuracy. Note that this control is affecting the Depth FPS */
        f200_accuracy                                   = 13,
        /** Motion vs. Range trade-off, with lower values allowing for better motion sensitivity and higher values allowing for better depth range*/
        f200_motion_range                               = 14,
        /** Set the filter to apply to each depth frame. Each one of the filter is optimized per the application requirements*/
        f200_filter_option                              = 15,
        /** The confidence level threshold used by the Depth algorithm pipe to set whether a pixel will get a valid range or will be marked with invalid range*/
        f200_confidence_threshold                       = 16,
        /** (F200-only) Allows to reduce FPS without restarting streaming. Valid values are {2, 5, 15, 30, 60}*/
        f200_dynamic_fps                                = 17,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_enable_motion_versus_range     = 18,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_enable_laser                   = 19,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_min_motion_versus_range        = 20,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_max_motion_versus_range        = 21,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_start_motion_versus_range      = 22,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_min_laser                      = 23,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_max_laser                      = 24,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_start_laser                    = 25,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_upper_threshold                = 26,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_lower_threshold                = 27,
        /** Enables / disables R200 auto-exposure. This will affect both IR and depth image.*/
        r200_lr_auto_exposure_enabled                   = 28,
        /** IR image gain*/
        r200_lr_gain                                    = 29,
        /** This control allows manual adjustment of the exposure time value for the L/R imagers*/
        r200_lr_exposure                                = 30,
        /** Enables / disables R200 emitter*/
        r200_emitter_enabled                            = 31,
        /** Micrometers per increment in integer depth values, 1000 is default (mm scale). Set before streaming*/
        r200_depth_units                                = 32,
        /** Minimum depth in current depth units that will be output. Any values less than ?Min Depth? will be mapped to 0 during the conversion between disparity and depth. Set before streaming*/
        r200_depth_clamp_min                            = 33,
        /** Maximum depth in current depth units that will be output. Any values greater than ?Max Depth? will be mapped to 0 during the conversion between disparity and depth. Set before streaming*/
        r200_depth_clamp_max                            = 34,
        /** The disparity scale factor used when in disparity output mode. Can only be set before streaming*/
        r200_disparity_multiplier                       = 35,
        /** {0 - 512}. Can only be set before streaming starts*/
        r200_disparity_shift                            = 36,
        /** (Requires LR-Auto-Exposure ON) Mean intensity set point*/
        r200_auto_exposure_mean_intensity_set_point     = 37,
        /** (Requires LR-Auto-Exposure ON) Bright ratio set point*/
        r200_auto_exposure_bright_ratio_set_point       = 38,
        /** (Requires LR-Auto-Exposure ON) Kp Gain*/
        r200_auto_exposure_kp_gain                      = 39,
        /** (Requires LR-Auto-Exposure ON) Kp Exposure*/
        r200_auto_exposure_kp_exposure                  = 40,
        /** (Requires LR-Auto-Exposure ON) Kp Dark Threshold*/
        r200_auto_exposure_kp_dark_threshold            = 41,
        /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest top edge (in pixels)*/
        r200_auto_exposure_top_edge                     = 42,
        /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest bottom edge (in pixels)*/
        r200_auto_exposure_bottom_edge                  = 43,
        /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest left edge (in pixels)*/
        r200_auto_exposure_left_edge                    = 44,
        /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest right edge (in pixels)*/
        r200_auto_exposure_right_edge                   = 45,
        /** Value to subtract when estimating the median of the correlation surface*/
        r200_depth_control_estimate_median_decrement    = 46,
        /** Value to add when estimating the median of the correlation surface*/
        r200_depth_control_estimate_median_increment    = 47,
        /** A threshold by how much the winning score must beat the median*/
        r200_depth_control_median_threshold             = 48,
        /** The minimum correlation score that is considered acceptable*/
        r200_depth_control_score_minimum_threshold      = 49,
        /** The maximum correlation score that is considered acceptable*/
        r200_depth_control_score_maximum_threshold      = 50,
        /** A parameter for determining whether the texture in the region is sufficient to justify a depth result*/
        r200_depth_control_texture_count_threshold      = 51,
        /** A parameter for determining whether the texture in the region is sufficient to justify a depth result*/
        r200_depth_control_texture_difference_threshold = 52,
        /** A threshold on how much the minimum correlation score must differ from the next best score*/
        r200_depth_control_second_peak_threshold        = 53,
        /** Neighbor threshold value for depth calculation*/
        r200_depth_control_neighbor_threshold           = 54,
        /** Left-Right threshold value for depth calculation*/
        r200_depth_control_lr_threshold                 = 55,
        /** Fisheye image exposure time in msec*/
        fisheye_exposure                                = 56,
        /** Fisheye image gain*/
        fisheye_gain                                    = 57,
        /** Enables / disables fisheye strobe. When enabled this will align timestamps to common clock-domain with the motion events*/
        fisheye_strobe                                  = 58,
        /** Enables / disables fisheye external trigger mode. When enabled fisheye image will be aquired in-sync with the depth image*/
        fisheye_external_trigger                        = 59,
        /** Enable / disable fisheye auto-exposure */
        fisheye_color_auto_exposure                     = 60,
        /** 0 - static auto-exposure, 1 - anti-flicker auto-exposure, 2 - hybrid */
        fisheye_color_auto_exposure_mode                = 61,
        /** Fisheye auto-exposure anti-flicker rate, can be 50 or 60 Hz */
        fisheye_color_auto_exposure_rate                = 62,
        /** In Fisheye auto-exposure sample frame every given number of pixels */
        fisheye_color_auto_exposure_sample_rate         = 63,
        /** In Fisheye auto-exposure sample every given number of frames */
        fisheye_color_auto_exposure_skip_frames         = 64,
        /** Number of frames the user is allowed to keep per stream. Trying to hold-on to more frames will cause frame-drops.*/
        frames_queue_size                               = 65,
        /** Enable / disable fetching log data from the device */
        hardware_logger_enabled                         = 66;

    /** enum class rs::blob_type */
    public static final int
        motion_module_firmware_update                   = 0;

    /** enum class rs::camera_info */
    public static final int
        device_name                                     = 0,
        serial_number                                   = 1,
        camera_firmware_version                         = 2,
        adapter_board_firmware_version                  = 3,
        motion_module_firmware_version                  = 4;

    /** enum class rs::source */
    public static final byte
        video           = 1,
        motion_data     = 2,
        all_sources     = 3;

    /** enum class rs::event */
    public static final byte
        event_imu_accel         = 0,
        event_imu_gyro          = 1,
        event_imu_depth_cam     = 2,
        event_imu_motion_cam    = 3,
        event_imu_g0_sync       = 4,
        event_imu_g1_sync       = 5,
        event_imu_g2_sync       = 6;

    /** enum class rs::timestamp_domain */
    public static final int
        camera = 0,
        microcontroller = 1;

    @Namespace("rs") public static class float2 extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public float2() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public float2(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public float2(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public float2 position(long position) {
            return (float2)super.position(position);
        }
     public native float x(); public native float2 x(float x);
public native float y(); public native float2 y(float y); }
    @Namespace("rs") public static class float3 extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public float3() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public float3(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public float3(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public float3 position(long position) {
            return (float3)super.position(position);
        }
     public native float x(); public native float3 x(float x);
public native float y(); public native float3 y(float y);
public native float z(); public native float3 z(float z); }

    @Namespace("rs") public static class intrinsics extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public intrinsics() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public intrinsics(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public intrinsics(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public intrinsics position(long position) {
            return (intrinsics)super.position(position);
        }
    
        public native float hfov();
        public native float vfov();
        public native @Cast("rs::distortion") int model();

                    // Helpers for mapping between pixel coordinates and texture coordinates
        public native @ByVal float2 pixel_to_texcoord(@Const @ByRef float2 pixel);
        public native @ByVal float2 texcoord_to_pixel(@Const @ByRef float2 coord);

                    // Helpers for mapping from image coordinates into 3D space
        public native @ByVal float3 deproject(@Const @ByRef float2 pixel, float depth);
        public native @ByVal float3 deproject_from_texcoord(@Const @ByRef float2 coord, float depth);

                    // Helpers for mapping from 3D space into image coordinates
        public native @ByVal float2 project(@Const @ByRef float3 point);
        public native @ByVal float2 project_to_texcoord(@Const @ByRef float3 point);

        public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef intrinsics r);

    }

    @Namespace("rs") public static class motion_intrinsics extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public motion_intrinsics(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public motion_intrinsics(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public motion_intrinsics position(long position) {
            return (motion_intrinsics)super.position(position);
        }
    
        public motion_intrinsics() { super((Pointer)null); allocate(); }
        private native void allocate();
    }

    @Namespace("rs") public static class extrinsics extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public extrinsics() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public extrinsics(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public extrinsics(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public extrinsics position(long position) {
            return (extrinsics)super.position(position);
        }
    
        public native @Cast("bool") boolean is_identity();
        public native @ByVal float3 transform(@Const @ByRef float3 point);
    }

    @Namespace("rs") public static class timestamp_data extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public timestamp_data(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public timestamp_data(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public timestamp_data position(long position) {
            return (timestamp_data)super.position(position);
        }
    
        public timestamp_data(@ByVal rs_timestamp_data orig) { super((Pointer)null); allocate(orig); }
        private native void allocate(@ByVal rs_timestamp_data orig);
        public timestamp_data() { super((Pointer)null); allocate(); }
        private native void allocate();
    }

    @Namespace("rs") public static class motion_data extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public motion_data(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public motion_data(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public motion_data position(long position) {
            return (motion_data)super.position(position);
        }
    
        public motion_data(@ByVal rs_motion_data orig) { super((Pointer)null); allocate(orig); }
        private native void allocate(@ByVal rs_motion_data orig);
        public motion_data() { super((Pointer)null); allocate(); }
        private native void allocate();
    }

    @Namespace("rs") @NoOffset public static class error extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public error(Pointer p) { super(p); }
    
        public error(rs_error err) { super((Pointer)null); allocate(err); }
        private native void allocate(rs_error err);
        public native @StdString BytePointer get_failed_function();
        public native @StdString BytePointer get_failed_args();
        public static native void handle(rs_error e);
    }

    @Namespace("rs") @NoOffset public static class context extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public context(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public context(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public context position(long position) {
            return (context)super.position(position);
        }
    
        public context() { super((Pointer)null); allocate(); }
        private native void allocate();

        public context(rs_context handle) { super((Pointer)null); allocate(handle); }
        private native void allocate(rs_context handle);

        /** determine number of connected devices
         *  @return  the count of devices */
        public native int get_device_count();

        /** retrieve connected device by index
         *  @param [in] index  the zero based index of device to retrieve
         *  @return           the requested device */
        public native device get_device(int index);
    }

    @Namespace("rs") @NoOffset public static class motion_callback extends rs_motion_callback {
        static { Loader.load(); }
    
        public motion_callback(@ByVal @Cast("std::function<void(rs::motion_data)>*") Pointer on_event) { super((Pointer)null); allocate(on_event); }
        private native void allocate(@ByVal @Cast("std::function<void(rs::motion_data)>*") Pointer on_event);

        public native void on_event(@ByVal rs_motion_data e);

        public native void release();
    }

    @Namespace("rs") @NoOffset public static class timestamp_callback extends rs_timestamp_callback {
        static { Loader.load(); }
    
        public timestamp_callback(@ByVal @Cast("std::function<void(rs::timestamp_data)>*") Pointer on_event) { super((Pointer)null); allocate(on_event); }
        private native void allocate(@ByVal @Cast("std::function<void(rs::timestamp_data)>*") Pointer on_event);

        public native void on_event(@ByVal rs_timestamp_data data);

        public native void release();
    }

    @Namespace("rs") @NoOffset public static class frame extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public frame(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public frame(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public frame position(long position) {
            return (frame)super.position(position);
        }
    

        public frame(@Const @ByRef frame arg0) { super((Pointer)null); allocate(arg0); }
        private native void allocate(@Const @ByRef frame arg0);

        public frame() { super((Pointer)null); allocate(); }
        private native void allocate();
        public frame(rs_device device, rs_frame_ref frame_ref) { super((Pointer)null); allocate(device, frame_ref); }
        private native void allocate(rs_device device, rs_frame_ref frame_ref);
        public native @ByRef @Name("operator =") frame put(@ByVal frame other);
        public native void swap(@ByRef frame other);

        /** retrieve the time at which the frame was captured
         *  @return            the timestamp of the frame, in milliseconds since the device was started */
        public native double get_timestamp();

        /** retrieve the timestamp domain
         *  @return            timestamp domain (clock name) for timestamp values */
        public native @Cast("rs::timestamp_domain") int get_frame_timestamp_domain();

        public native @Cast("unsigned long long") long get_frame_number();

        public native @Const Pointer get_data();

        public native int get_width();

        public native int get_height();

        public native int get_framerate();

        public native int get_stride();

        /** retrieve bits per pixel
         *  @return            number of bits per one pixel */
        public native int get_bpp();

        public native @Cast("rs::format") int get_format();

        public native @Cast("rs::stream") int get_stream_type();
    }

    @Namespace("rs") @NoOffset public static class frame_callback extends rs_frame_callback {
        static { Loader.load(); }
    
        public frame_callback(@ByVal @Cast("std::function<void(rs::frame)>*") Pointer on_frame) { super((Pointer)null); allocate(on_frame); }
        private native void allocate(@ByVal @Cast("std::function<void(rs::frame)>*") Pointer on_frame);

        public native void on_frame(rs_device device, rs_frame_ref fref);

        public native void release();
    }

    @Namespace("rs") public static class device extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public device() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public device(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public device(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public device position(long position) {
            return (device)super.position(position);
        }
    


        /** retrieve a human readable device model string
         *  @return  the model string, such as "Intel RealSense F200" or "Intel RealSense R200" */
        public native @Cast("const char*") BytePointer get_name();

        /** retrieve the unique serial number of the device
         *  @return  the serial number, in a format specific to the device model */
        public native @Cast("const char*") BytePointer get_serial();

        /** retrieve the USB port number of the device
         *  @return  the USB port number, in a format specific to the device model */
        public native @Cast("const char*") BytePointer get_usb_port_id();

        /** retrieve the version of the firmware currently installed on the device
         *  @return  firmware version string, in a format is specific to device model */
        public native @Cast("const char*") BytePointer get_firmware_version();

        /** retrieve camera specific information like the versions of the various componnents
         *  @return  camera info string, in a format specific to the device model */
        public native @Cast("const char*") BytePointer get_info(@Cast("rs::camera_info") int info);

        /** retrieve extrinsic transformation between the viewpoints of two different streams
         *  @param [in] from_stream  stream whose coordinate space we will transform from
         *  @param [in] to_stream    stream whose coordinate space we will transform to
         *  @return                 the transformation between the two streams */
        public native @ByVal extrinsics get_extrinsics(@Cast("rs::stream") int from_stream, @Cast("rs::stream") int to_stream);

        /** retrieve extrinsic transformation between the viewpoints of specific stream and the motion module
         *  @param [in] from_stream  stream whose coordinate space we will transform from
         *  @return                 the transformation between the  specific stream and motion module */
        public native @ByVal extrinsics get_motion_extrinsics_from(@Cast("rs::stream") int from_stream);

        /** retrieve mapping between the units of the depth image and meters
         *  @return  depth in meters corresponding to a depth value of 1 */
        public native float get_depth_scale();

        /** determine if the device allows a specific option to be queried and set
         *  @param [in] option  the option to check for support
         *  @return            true if the option can be queried and set */
        public native @Cast("bool") boolean supports_option(@Cast("rs::option") int option);

        /** determine the number of streaming modes available for a given stream
         *  @param [in] stream  the stream whose modes will be enumerated
         *  @return            the count of available modes */
        public native int get_stream_mode_count(@Cast("rs::stream") int stream);

        /** determine the properties of a specific streaming mode
         *  @param [in] stream      the stream whose mode will be queried
         *  @param [in] index       the zero based index of the streaming mode
         *  @param [out] width      the width of a frame image in pixels
         *  @param [out] height     the height of a frame image in pixels
         *  @param [out] format     the pixel format of a frame image
         *  @param [out] framerate  the number of frames which will be streamed per second */
        public native void get_stream_mode(@Cast("rs::stream") int stream, int index, @ByRef IntPointer width, @ByRef IntPointer height, @Cast("rs::format*") @ByRef IntPointer format, @ByRef IntPointer framerate);
        public native void get_stream_mode(@Cast("rs::stream") int stream, int index, @ByRef IntBuffer width, @ByRef IntBuffer height, @Cast("rs::format*") @ByRef IntBuffer format, @ByRef IntBuffer framerate);
        public native void get_stream_mode(@Cast("rs::stream") int stream, int index, @ByRef int[] width, @ByRef int[] height, @Cast("rs::format*") @ByRef int[] format, @ByRef int[] framerate);

        /** enable a specific stream and request specific properties
         *  @param [in] stream                   the stream to enable
         *  @param [in] width                    the desired width of a frame image in pixels, or 0 if any width is acceptable
         *  @param [in] height                   the desired height of a frame image in pixels, or 0 if any height is acceptable
         *  @param [in] format                   the pixel format of a frame image, or ANY if any format is acceptable
         *  @param [in] framerate                the number of frames which will be streamed per second, or 0 if any framerate is acceptable
         *  @param [in] output_buffer_type       output buffer format (continous in memory / native with pitch) */
        public native void enable_stream(@Cast("rs::stream") int stream, int width, int height, @Cast("rs::format") int format, int framerate, @Cast("rs::output_buffer_format") int output_buffer_type/*=rs::output_buffer_format::output_buffer_continous*/);
        public native void enable_stream(@Cast("rs::stream") int stream, int width, int height, @Cast("rs::format") int format, int framerate);

        /** enable a specific stream and request properties using a preset
         *  @param [in] stream  the stream to enable
         *  @param [in] preset  the preset to use to enable the stream */
        public native void enable_stream(@Cast("rs::stream") int stream, @Cast("rs::preset") int preset);

        /** disable a specific stream
         *  @param [in] stream  the stream to disable */
        public native void disable_stream(@Cast("rs::stream") int stream);

        /** determine if a specific stream is enabled
         *  @param [in] stream  the stream to check
         *  @return            true if the stream is currently enabled */
        public native @Cast("bool") boolean is_stream_enabled(@Cast("rs::stream") int stream);

        /** retrieve the width in pixels of a specific stream, equivalent to the width field from the stream's intrinsics
         *  @param [in] stream  the stream whose width to retrieve
         *  @return            the width in pixels of images from this stream */
        public native int get_stream_width(@Cast("rs::stream") int stream);

        /** retrieve the height in pixels of a specific stream, equivalent to the height field from the stream's intrinsics
         *  @param [in] stream  the stream whose height to retrieve
         *  @return            the height in pixels of images from this stream */
        public native int get_stream_height(@Cast("rs::stream") int stream);

        /** retrieve the pixel format for a specific stream
         *  @param [in] stream  the stream whose format to retrieve
         *  @return            the pixel format of the stream */
        public native @Cast("rs::format") int get_stream_format(@Cast("rs::stream") int stream);

        /** retrieve the framerate for a specific stream
         *  @param [in] stream  the stream whose framerate to retrieve
         *  @return            the framerate of the stream, in frames per second */
        public native int get_stream_framerate(@Cast("rs::stream") int stream);

        /** retrieve intrinsic camera parameters for a specific stream
         *  @param [in] stream  the stream whose parameters to retrieve
         *  @return            the intrinsic parameters of the stream */
        public native @ByVal intrinsics get_stream_intrinsics(@Cast("rs::stream") int stream);

        /** retrieve intrinsic camera parameters for the motion module
         *  @return            the intrinsic parameters of the stream */
        public native @ByVal motion_intrinsics get_motion_intrinsics();

        /** sets the callback for frame arrival event. provided callback will be called the instant new frame of given stream becomes available
         *  once callback is set on certain stream type, frames of this type will no longer be available throuhg wait/poll methods (those two approaches are mutually exclusive)
         *  while wait/poll methods provide consistent set of syncronized frames at the expense of extra latency,
         *  set frame callbacks provides low latency solution with no syncronization
         *  @param [in] stream    the stream
         *  @param [in] on_frame  frame callback to be invoke on every new frame
         *  @return            the framerate of the stream, in frames per second */
        public native void set_frame_callback(@Cast("rs::stream") int stream, @ByVal @Cast("std::function<void(rs::frame)>*") Pointer frame_handler);

        ///// sets the callback for motion module event. provided callback will be called the instant new motion or timestamp event is available.
        ///// \param[in] stream             the stream
        ///// \param[in] motion_handler     frame callback to be invoke on every new motion event
        ///// \param[in] timestamp_handler  frame callback to be invoke on every new timestamp event
        ///// \return                       the framerate of the stream, in frames per second
        public native void enable_motion_tracking(@ByVal @Cast("std::function<void(rs::motion_data)>*") Pointer motion_handler, @ByVal @Cast("std::function<void(rs::timestamp_data)>*") Pointer timestamp_handler);

        ///// sets the callback for motion module event. provided callback will be called the instant new motion event is available.
        ///// \param[in] stream             the stream
        ///// \param[in] motion_handler     frame callback to be invoke on every new motion event
        ///// \return                       the framerate of the stream, in frames per second
        public native void enable_motion_tracking(@ByVal @Cast("std::function<void(rs::motion_data)>*") Pointer motion_handler);

        /** disable events polling */
        public native void disable_motion_tracking();

        /** check if data acquisition is active */
        
        ///
        public native int is_motion_tracking_active();


        /** begin streaming on all enabled streams for this device
         *  */
        
        ///
        public native void start(@Cast("rs::source") byte source/*=rs::source::video*/);
        public native void start();

        /** end streaming on all streams for this device
         *  */
        public native void stop(@Cast("rs::source") byte source/*=rs::source::video*/);
        public native void stop();

        /** determine if the device is currently streaming
         *  @return  true if the device is currently streaming */
        public native @Cast("bool") boolean is_streaming();

        /** retrieve the available range of values of a supported option
         *  @param [in] option  the option whose range should be queried
         *  @param [out] min    the minimum value which will be accepted for this option
         *  @param [out] max    the maximum value which will be accepted for this option
         *  @param [out] step   the granularity of options which accept discrete values, or zero if the option accepts continuous values */
        public native void get_option_range(@Cast("rs::option") int option, @ByRef DoublePointer min, @ByRef DoublePointer max, @ByRef DoublePointer step);
        public native void get_option_range(@Cast("rs::option") int option, @ByRef DoubleBuffer min, @ByRef DoubleBuffer max, @ByRef DoubleBuffer step);
        public native void get_option_range(@Cast("rs::option") int option, @ByRef double[] min, @ByRef double[] max, @ByRef double[] step);

        /** retrieve the available range of values of a supported option
         *  @param [in] option  the option whose range should be queried
         *  @param [out] min    the minimum value which will be accepted for this option
         *  @param [out] max    the maximum value which will be accepted for this option
         *  @param [out] step   the granularity of options which accept discrete values, or zero if the option accepts continuous values
         *  @param [out] def    the default value of the option */
        public native void get_option_range(@Cast("rs::option") int option, @ByRef DoublePointer min, @ByRef DoublePointer max, @ByRef DoublePointer step, @ByRef DoublePointer def);
        public native void get_option_range(@Cast("rs::option") int option, @ByRef DoubleBuffer min, @ByRef DoubleBuffer max, @ByRef DoubleBuffer step, @ByRef DoubleBuffer def);
        public native void get_option_range(@Cast("rs::option") int option, @ByRef double[] min, @ByRef double[] max, @ByRef double[] step, @ByRef double[] def);

        /** efficiently retrieve the value of an arbitrary number of options, using minimal hardware IO
         *  @param [in] options  the array of options which should be queried
         *  @param [in] count    the length of the options and values arrays
         *  @param [out] values  the array which will receive the values of the queried options */
        public native void get_options(@Cast("const rs::option*") IntPointer options, @Cast("size_t") long count, DoublePointer values);
        public native void get_options(@Cast("const rs::option*") IntBuffer options, @Cast("size_t") long count, DoubleBuffer values);
        public native void get_options(@Cast("const rs::option*") int[] options, @Cast("size_t") long count, double[] values);

        /** efficiently set the value of an arbitrary number of options, using minimal hardware IO
         *  @param [in] options  the array of options which should be set
         *  @param [in] count    the length of the options and values arrays
         *  @param [in] values   the array of values to which the options should be set */
        public native void set_options(@Cast("const rs::option*") IntPointer options, @Cast("size_t") long count, @Const DoublePointer values);
        public native void set_options(@Cast("const rs::option*") IntBuffer options, @Cast("size_t") long count, @Const DoubleBuffer values);
        public native void set_options(@Cast("const rs::option*") int[] options, @Cast("size_t") long count, @Const double[] values);

        /** retrieve the current value of a single option
         *  @param [in] option  the option whose value should be retrieved
         *  @return            the value of the option */
        public native double get_option(@Cast("rs::option") int option);

        /** retrieve the device specific option description
         *  @param [in] option  the option whose description should be retrieved
         *  @return            the value of the option */
        public native @Cast("const char*") BytePointer get_option_description(@Cast("rs::option") int option);

        /** set the current value of a single option
         *  @param [in] option  the option whose value should be set
         *  @param [in] value   the value of the option */
        
        ///
        public native void set_option(@Cast("rs::option") int option, double value);

        /** block until new frames are available
         *  */
        public native void wait_for_frames();

        /** check if new frames are available, without blocking
         *  @return  true if new frames are available, false if no new frames have arrived */
        public native @Cast("bool") boolean poll_for_frames();

        /** determine device capabilities
         *  @param [in] capability  the capability to check for support
         *  @return                true if device has this capability */
        public native @Cast("bool") boolean supports(@Cast("rs::capabilities") int capability);

        /** retrieve the time at which the latest frame on a stream was captured
         *  @param [in] stream  the stream whose latest frame we are interested in
         *  @return            the timestamp of the frame, in milliseconds since the device was started */
        public native double get_frame_timestamp(@Cast("rs::stream") int stream);

        /** retrieve the frame number
         *  @param [in] stream  the stream whose latest frame we are interested in
         *  @return            the number of the frame, since the device was started */
        public native @Cast("unsigned long long") long get_frame_number(@Cast("rs::stream") int stream);

        /** retrieve the contents of the latest frame on a stream
         *  @param [in] stream  the stream whose latest frame we are interested in
         *  @return            the pointer to the start of the frame data */
        public native @Const Pointer get_frame_data(@Cast("rs::stream") int stream);

        /** send device specific data to the device
         *  @param [in] type  describes the content of the memory buffer, how it will be interpreted by the device
         *  @param [in] data  raw data buffer to be sent to the device
         *  @param [in] size  size in bytes of the buffer */
        public native void send_blob_to_device(@Cast("rs::blob_type") int type, Pointer data, int size);
    }

    @Namespace("rs") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer o, @Cast("rs::stream") int stream);
    @Namespace("rs") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer o, @Cast("rs::source") byte src);


    /** enum class rs::log_severity */
    public static final int
        debug = 0, // Detailed information about ordinary operations
        info  = 1, // Terse information about ordinary operations
        warn  = 2, // Indication of possible failure
        error = 3, // Indication of definite failure
        fatal = 4; // Indication of unrecoverable failure
        //        none  = 5, // No logging will occur

    // class log_callback : public rs_log_callback
    // {
    //     std::function<void(log_severity, const char *)> on_event_function;
    // public:
    //     explicit log_callback(std::function<void(log_severity, const char *)> on_event) : on_event_function(on_event) {}

    //     void on_event(rs_log_severity severity, const char * message) override
    //     {
    //         on_event_function((log_severity)severity, message);
    //     }

    //     void release() override { delete this; }
    // };

    @Namespace("rs") public static native void log_to_console(@Cast("rs::log_severity") int min_severity);

    @Namespace("rs") public static native void log_to_file(@Cast("rs::log_severity") int min_severity, @Cast("const char*") BytePointer file_path);
    @Namespace("rs") public static native void log_to_file(@Cast("rs::log_severity") int min_severity, String file_path);

    // inline void log_to_callback(log_severity min_severity, std::function<void(log_severity, const char *)> callback)
    // {
    //     rs_error * e = nullptr;
    //     rs_log_to_callback_cpp((rs_log_severity)min_severity, new log_callback(callback), &e);
    //     error::handle(e);
    // }

    // Additional utilities
    @Namespace("rs") public static native void apply_depth_control_preset(device device, int preset);
    @Namespace("rs") public static native void apply_ivcam_preset(device device, @Cast("rs_ivcam_preset") int preset); // duplicate for better backward compatibility with existing applications

// #endif


// Parsed from <librealsense/rscore.hpp>

// License: Apache 2.0. See LICENSE file in root directory.
// Copyright(c) 2015 Intel Corporation. All Rights Reserved.

// #ifndef LIBREALSENSE_RSCORE_HPP
// #define LIBREALSENSE_RSCORE_HPP

// #include "rs.h"
// #include <cstdint>
// #include <cstddef>
// #include <mutex>

// this interface is an entry point for extending librealsense with custom devices while keeping librealsense public API
// the interfaces in this file are expected to be inherited from, never used directly, rs.hpp provides safer and simpler wrapper
// an example usage would be playback and record. this API allows to integrate custom playback&record implementation while keeping librealsense API

public static class rs_stream_interface extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_stream_interface(Pointer p) { super(p); }


    public native @ByVal rs_extrinsics get_extrinsics_to(@Const @ByRef rs_stream_interface r);
    public native float get_depth_scale();

    public native @ByVal rs_intrinsics get_intrinsics();
    public native @ByVal rs_intrinsics get_rectified_intrinsics();
    public native @Cast("rs_format") int get_format();
    public native int get_framerate();

    public native int get_frame_stride();
    public native int get_frame_bpp();
    public native @Cast("unsigned long long") long get_frame_number();
    public native double get_frame_timestamp();
    public native long get_frame_system_time();
    public native @Cast("const uint8_t*") BytePointer get_frame_data();

    public native int get_mode_count();
    public native void get_mode(int mode, IntPointer w, IntPointer h, @Cast("rs_format*") IntPointer f, IntPointer fps);
    public native void get_mode(int mode, IntBuffer w, IntBuffer h, @Cast("rs_format*") IntBuffer f, IntBuffer fps);
    public native void get_mode(int mode, int[] w, int[] h, @Cast("rs_format*") int[] f, int[] fps);

    public native @Cast("bool") boolean is_enabled();
    public native @Cast("rs_stream") int get_stream_type();
}

public static class rs_frame_ref extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_frame_ref(Pointer p) { super(p); }

    public native @Cast("const uint8_t*") BytePointer get_frame_data();
    public native double get_frame_timestamp();
    public native @Cast("rs_timestamp_domain") int get_frame_timestamp_domain();
    public native @Cast("unsigned long long") long get_frame_number();
    public native long get_frame_system_time();
    public native int get_frame_width();
    public native int get_frame_height();
    public native int get_frame_framerate();
    public native int get_frame_stride();
    public native int get_frame_bpp();
    public native @Cast("rs_format") int get_frame_format();
    public native @Cast("rs_stream") int get_stream_type();
}

// realsense device public interface
public static class rs_device extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_device(Pointer p) { super(p); }

    public native @Const @ByRef rs_stream_interface get_stream_interface(@Cast("rs_stream") int stream);

    public native @Cast("const char*") BytePointer get_name();
    public native @Cast("const char*") BytePointer get_serial();
    public native @Cast("const char*") BytePointer get_firmware_version();
    public native @Cast("const char*") BytePointer get_camera_info(@Cast("rs_camera_info") int arg0);
    public native float get_depth_scale();

    public native void enable_stream(@Cast("rs_stream") int stream, int width, int height, @Cast("rs_format") int format, int fps, @Cast("rs_output_buffer_format") int output);
    public native void enable_stream_preset(@Cast("rs_stream") int stream, @Cast("rs_preset") int preset);
    public native void disable_stream(@Cast("rs_stream") int stream);

    public native void enable_motion_tracking();
    public static class On_frame_rs_device_rs_frame_ref_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    On_frame_rs_device_rs_frame_ref_Pointer(Pointer p) { super(p); }
        protected On_frame_rs_device_rs_frame_ref_Pointer() { allocate(); }
        private native void allocate();
        public native void call(rs_device device, rs_frame_ref frame, Pointer user);
    }
    public native void set_stream_callback(@Cast("rs_stream") int stream, On_frame_rs_device_rs_frame_ref_Pointer on_frame, Pointer user);
    public native void set_stream_callback(@Cast("rs_stream") int stream, rs_frame_callback callback);
    public native void disable_motion_tracking();

    public native @ByVal rs_motion_intrinsics get_motion_intrinsics();
    public native @ByVal rs_extrinsics get_motion_extrinsics_from(@Cast("rs_stream") int from);
    public static class On_event_rs_device_rs_motion_data_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    On_event_rs_device_rs_motion_data_Pointer(Pointer p) { super(p); }
        protected On_event_rs_device_rs_motion_data_Pointer() { allocate(); }
        private native void allocate();
        public native void call(rs_device device, @ByVal rs_motion_data data, Pointer user);
    }
    public native void set_motion_callback(On_event_rs_device_rs_motion_data_Pointer on_event, Pointer user);
    public native void set_motion_callback(rs_motion_callback callback);
    public static class On_event_rs_device_rs_timestamp_data_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    On_event_rs_device_rs_timestamp_data_Pointer(Pointer p) { super(p); }
        protected On_event_rs_device_rs_timestamp_data_Pointer() { allocate(); }
        private native void allocate();
        public native void call(rs_device device, @ByVal rs_timestamp_data data, Pointer user);
    }
    public native void set_timestamp_callback(On_event_rs_device_rs_timestamp_data_Pointer on_event, Pointer user);
    public native void set_timestamp_callback(rs_timestamp_callback callback);

    public native void start(@Cast("rs_source") int source);
    public native void stop(@Cast("rs_source") int source);

    public native void start_fw_logger(@Cast("char") byte fw_log_op_code, int grab_rate_in_ms, @Cast("std::timed_mutex*") @ByRef Pointer mutex);
    public native void stop_fw_logger();

    public native @Cast("bool") boolean is_capturing();
    public native int is_motion_tracking_active();

    public native void wait_all_streams();
    public native @Cast("bool") boolean poll_all_streams();

    public native @Cast("bool") boolean supports(@Cast("rs_capabilities") int capability);

    public native @Cast("bool") boolean supports_option(@Cast("rs_option") int option);
    public native void get_option_range(@Cast("rs_option") int option, @ByRef DoublePointer min, @ByRef DoublePointer max, @ByRef DoublePointer step, @ByRef DoublePointer def);
    public native void get_option_range(@Cast("rs_option") int option, @ByRef DoubleBuffer min, @ByRef DoubleBuffer max, @ByRef DoubleBuffer step, @ByRef DoubleBuffer def);
    public native void get_option_range(@Cast("rs_option") int option, @ByRef double[] min, @ByRef double[] max, @ByRef double[] step, @ByRef double[] def);
    public native void set_options(@Cast("const rs_option*") IntPointer options, @Cast("size_t") long count, @Const DoublePointer values);
    public native void set_options(@Cast("const rs_option*") IntBuffer options, @Cast("size_t") long count, @Const DoubleBuffer values);
    public native void set_options(@Cast("const rs_option*") int[] options, @Cast("size_t") long count, @Const double[] values);
    public native void get_options(@Cast("const rs_option*") IntPointer options, @Cast("size_t") long count, DoublePointer values);
    public native void get_options(@Cast("const rs_option*") IntBuffer options, @Cast("size_t") long count, DoubleBuffer values);
    public native void get_options(@Cast("const rs_option*") int[] options, @Cast("size_t") long count, double[] values);
    public native @Cast("const char*") BytePointer get_option_description(@Cast("rs_option") int option);

    public native void release_frame(rs_frame_ref ref);
    public native rs_frame_ref clone_frame(rs_frame_ref frame);

    public native @Cast("const char*") BytePointer get_usb_port_id();
}

public static class rs_context extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_context(Pointer p) { super(p); }

    public native @Cast("size_t") long get_device_count();
    public native rs_device get_device(int index);
}

public static class rs_motion_callback extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_motion_callback(Pointer p) { super(p); }

    public native void on_event(@ByVal rs_motion_data e);
    public native void release();
}

public static class rs_frame_callback extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_frame_callback(Pointer p) { super(p); }

    public native void on_frame(rs_device device, rs_frame_ref f);
    public native void release();
}

public static class rs_timestamp_callback extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_timestamp_callback(Pointer p) { super(p); }

    public native void on_event(@ByVal rs_timestamp_data data);
    public native void release();
}

public static class rs_log_callback extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public rs_log_callback(Pointer p) { super(p); }

    public native void on_event(@Cast("rs_log_severity") int severity, @Cast("const char*") BytePointer message);
    public native void on_event(@Cast("rs_log_severity") int severity, String message);
    public native void release();
}

// #endif


// Parsed from <librealsense/rsutil.h>

/* License: Apache 2.0. See LICENSE file in root directory.
   Copyright(c) 2015 Intel Corporation. All Rights Reserved. */

// #ifndef LIBREALSENSE_RSUTIL_H
// #define LIBREALSENSE_RSUTIL_H

// #include "rs.h"
// #include "assert.h"

/* Given a point in 3D space, compute the corresponding pixel coordinates in an image with no distortion or forward distortion coefficients produced by the same camera */
public static native void rs_project_point_to_pixel(FloatPointer pixel, @Const rs_intrinsics intrin, @Const FloatPointer point);
public static native void rs_project_point_to_pixel(FloatBuffer pixel, @Const rs_intrinsics intrin, @Const FloatBuffer point);
public static native void rs_project_point_to_pixel(float[] pixel, @Const rs_intrinsics intrin, @Const float[] point);

/* Given pixel coordinates and depth in an image with no distortion or inverse distortion coefficients, compute the corresponding point in 3D space relative to the same camera */
public static native void rs_deproject_pixel_to_point(FloatPointer point, @Const rs_intrinsics intrin, @Const FloatPointer pixel, float depth);
public static native void rs_deproject_pixel_to_point(FloatBuffer point, @Const rs_intrinsics intrin, @Const FloatBuffer pixel, float depth);
public static native void rs_deproject_pixel_to_point(float[] point, @Const rs_intrinsics intrin, @Const float[] pixel, float depth);

/* Transform 3D coordinates relative to one sensor to 3D coordinates relative to another viewpoint */
public static native void rs_transform_point_to_point(FloatPointer to_point, @Const rs_extrinsics extrin, @Const FloatPointer from_point);
public static native void rs_transform_point_to_point(FloatBuffer to_point, @Const rs_extrinsics extrin, @Const FloatBuffer from_point);
public static native void rs_transform_point_to_point(float[] to_point, @Const rs_extrinsics extrin, @Const float[] from_point);

/* Provide access to several recommend sets of depth control parameters */
public static native void rs_apply_depth_control_preset(rs_device device, int preset);

/* Provide access to several recommend sets of option presets for ivcam */
public static native void rs_apply_ivcam_preset(rs_device device, @Cast("rs_ivcam_preset") int preset);

// #endif


}
