/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.FloatBuffer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.indexer.FloatArrayIndexer;
import org.bytedeco.javacpp.indexer.FloatBufferIndexer;
import org.bytedeco.javacpp.indexer.Indexer;

public abstract class FloatIndexer
extends Indexer {
    protected FloatIndexer(int[] sizes, int[] strides) {
        super(sizes, strides);
    }

    public static FloatIndexer create(float[] array, int[] sizes, int[] strides) {
        return new FloatArrayIndexer(array, sizes, strides);
    }

    public static FloatIndexer create(FloatBuffer buffer, int[] sizes, int[] strides) {
        return new FloatBufferIndexer(buffer, sizes, strides);
    }

    public static FloatIndexer create(FloatPointer pointer, int[] sizes, int[] strides) {
        return FloatIndexer.create(pointer, sizes, strides, true);
    }

    public static FloatIndexer create(final FloatPointer pointer, int[] sizes, int[] strides, boolean direct) {
        if (direct) {
            return new FloatBufferIndexer(pointer.asBuffer(), sizes, strides);
        }
        final int position = pointer.position();
        float[] array = new float[pointer.limit() - position];
        pointer.get(array);
        return new FloatArrayIndexer(array, sizes, strides){

            @Override
            public void release() {
                pointer.position(position).put(this.array);
                super.release();
            }
        };
    }

    public abstract float get(int var1);

    public FloatIndexer get(int i, float[] f) {
        return this.get(i, f, 0, f.length);
    }

    public abstract FloatIndexer get(int var1, float[] var2, int var3, int var4);

    public abstract float get(int var1, int var2);

    public FloatIndexer get(int i, int j, float[] f) {
        return this.get(i, j, f, 0, f.length);
    }

    public abstract FloatIndexer get(int var1, int var2, float[] var3, int var4, int var5);

    public abstract float get(int var1, int var2, int var3);

    public abstract float get(int ... var1);

    public FloatIndexer get(int[] indices, float[] f) {
        return this.get(indices, f, 0, f.length);
    }

    public abstract FloatIndexer get(int[] var1, float[] var2, int var3, int var4);

    public abstract FloatIndexer put(int var1, float var2);

    public FloatIndexer put(int i, float ... f) {
        return this.put(i, f, 0, f.length);
    }

    public abstract FloatIndexer put(int var1, float[] var2, int var3, int var4);

    public abstract FloatIndexer put(int var1, int var2, float var3);

    public FloatIndexer put(int i, int j, float ... f) {
        return this.put(i, j, f, 0, f.length);
    }

    public abstract FloatIndexer put(int var1, int var2, float[] var3, int var4, int var5);

    public abstract FloatIndexer put(int var1, int var2, int var3, float var4);

    public abstract FloatIndexer put(int[] var1, float var2);

    public FloatIndexer put(int[] indices, float ... f) {
        return this.put(indices, f, 0, f.length);
    }

    public abstract FloatIndexer put(int[] var1, float[] var2, int var3, int var4);

    @Override
    public double getDouble(int ... indices) {
        return this.get(indices);
    }
}

