/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bytedeco.javacpp.BoolPointer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.CLongPointer;
import org.bytedeco.javacpp.CharPointer;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.FunctionPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.SizeTPointer;
import org.bytedeco.javacpp.annotation.Adapter;
import org.bytedeco.javacpp.annotation.Allocator;
import org.bytedeco.javacpp.annotation.ArrayAllocator;
import org.bytedeco.javacpp.annotation.ByPtr;
import org.bytedeco.javacpp.annotation.ByPtrPtr;
import org.bytedeco.javacpp.annotation.ByPtrRef;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Convention;
import org.bytedeco.javacpp.annotation.Function;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.MemberGetter;
import org.bytedeco.javacpp.annotation.MemberSetter;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.NoDeallocator;
import org.bytedeco.javacpp.annotation.NoException;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Opaque;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.Raw;
import org.bytedeco.javacpp.annotation.ValueGetter;
import org.bytedeco.javacpp.annotation.ValueSetter;
import org.bytedeco.javacpp.annotation.Virtual;
import org.bytedeco.javacpp.tools.AdapterInformation;
import org.bytedeco.javacpp.tools.IndexedSet;
import org.bytedeco.javacpp.tools.Logger;
import org.bytedeco.javacpp.tools.MethodInformation;

public class Generator
implements Closeable {
    static final String JNI_VERSION = "JNI_VERSION_1_4";
    static final List<Class> baseClasses = Arrays.asList(Pointer.class, BytePointer.class, ShortPointer.class, IntPointer.class, LongPointer.class, FloatPointer.class, DoublePointer.class, CharPointer.class, PointerPointer.class, BoolPointer.class, CLongPointer.class, SizeTPointer.class);
    final Logger logger;
    final ClassProperties properties;
    PrintWriter out;
    PrintWriter out2;
    IndexedSet<String> callbacks;
    IndexedSet<Class> functions;
    IndexedSet<Class> deallocators;
    IndexedSet<Class> arrayDeallocators;
    IndexedSet<Class> jclasses;
    IndexedSet<Class> jclassesInit;
    HashMap<Class, LinkedList<String>> members;
    HashMap<Class, LinkedList<String>> virtualFunctions;
    HashMap<Class, LinkedList<String>> virtualMembers;
    boolean mayThrowExceptions;
    boolean usesAdapters;

    public Generator(Logger logger, ClassProperties properties) {
        this.logger = logger;
        this.properties = properties;
    }

    public boolean generate(String sourceFilename, String headerFilename, String classPath, Class<?> ... classes) throws FileNotFoundException {
        this.out = new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        });
        this.out2 = null;
        this.callbacks = new IndexedSet();
        this.functions = new IndexedSet();
        this.deallocators = new IndexedSet();
        this.arrayDeallocators = new IndexedSet();
        this.jclasses = new IndexedSet();
        this.jclassesInit = new IndexedSet();
        this.members = new HashMap();
        this.virtualFunctions = new HashMap();
        this.virtualMembers = new HashMap();
        this.mayThrowExceptions = false;
        this.usesAdapters = false;
        if (this.classes(true, true, classPath, classes)) {
            this.out = new PrintWriter(sourceFilename);
            if (headerFilename != null) {
                this.out2 = new PrintWriter(headerFilename);
            }
            return this.classes(this.mayThrowExceptions, this.usesAdapters, classPath, classes);
        }
        return false;
    }

    @Override
    public void close() {
        if (this.out != null) {
            this.out.close();
        }
        if (this.out2 != null) {
            this.out2.close();
        }
    }

    boolean classes(boolean handleExceptions, boolean defineAdapters, String classPath, Class<?> ... classes) {
        boolean bl;
        String valueTypeName;
        String[] typeName;
        String name;
        String version = Generator.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "unknown";
        }
        String warning = "// Generated by JavaCPP version " + version;
        this.out.println(warning);
        this.out.println();
        if (this.out2 != null) {
            this.out2.println(warning);
            this.out2.println();
        }
        for (String s : this.properties.get("platform.define")) {
            this.out.println("#define " + s);
        }
        this.out.println();
        this.out.println("#ifdef __APPLE__");
        this.out.println("    #define _JAVASOFT_JNI_MD_H_");
        this.out.println();
        this.out.println("    #define JNIEXPORT __attribute__((visibility(\"default\")))");
        this.out.println("    #define JNIIMPORT");
        this.out.println("    #define JNICALL");
        this.out.println();
        this.out.println("    typedef int jint;");
        this.out.println("    typedef long long jlong;");
        this.out.println("    typedef signed char jbyte;");
        this.out.println("#endif");
        this.out.println("#ifdef _WIN32");
        this.out.println("    #define _JAVASOFT_JNI_MD_H_");
        this.out.println();
        this.out.println("    #define JNIEXPORT __declspec(dllexport)");
        this.out.println("    #define JNIIMPORT __declspec(dllimport)");
        this.out.println("    #define JNICALL __stdcall");
        this.out.println();
        this.out.println("    typedef int jint;");
        this.out.println("    typedef long long jlong;");
        this.out.println("    typedef signed char jbyte;");
        this.out.println("#endif");
        this.out.println("#include <jni.h>");
        if (this.out2 != null) {
            this.out2.println("#include <jni.h>");
        }
        this.out.println("#ifdef ANDROID");
        this.out.println("    #include <android/log.h>");
        this.out.println("#elif defined(__APPLE__) && defined(__OBJC__)");
        this.out.println("    #include <TargetConditionals.h>");
        this.out.println("    #include <Foundation/Foundation.h>");
        this.out.println("#endif");
        this.out.println("#if defined(ANDROID) || TARGET_OS_IPHONE");
        this.out.println("    #define NewWeakGlobalRef(obj) NewGlobalRef(obj)");
        this.out.println("    #define DeleteWeakGlobalRef(obj) DeleteGlobalRef(obj)");
        this.out.println("#endif");
        this.out.println();
        this.out.println("#include <stddef.h>");
        this.out.println("#ifndef _WIN32");
        this.out.println("    #include <stdint.h>");
        this.out.println("#endif");
        this.out.println("#include <stdio.h>");
        this.out.println("#include <stdlib.h>");
        this.out.println("#include <string.h>");
        this.out.println("#include <exception>");
        this.out.println("#include <new>");
        this.out.println();
        this.out.println("#define jlong_to_ptr(a) ((void*)(uintptr_t)(a))");
        this.out.println("#define ptr_to_jlong(a) ((jlong)(uintptr_t)(a))");
        this.out.println();
        this.out.println("#if defined(_MSC_VER)");
        this.out.println("    #define JavaCPP_noinline __declspec(noinline)");
        this.out.println("    #define JavaCPP_hidden /* hidden by default */");
        this.out.println("#elif defined(__GNUC__)");
        this.out.println("    #define JavaCPP_noinline __attribute__((noinline))");
        this.out.println("    #define JavaCPP_hidden   __attribute__((visibility(\"hidden\")))");
        this.out.println("#else");
        this.out.println("    #define JavaCPP_noinline");
        this.out.println("    #define JavaCPP_hidden");
        this.out.println("#endif");
        this.out.println();
        List[] include = new List[]{this.properties.get("platform.include"), this.properties.get("platform.cinclude")};
        for (int i = 0; i < include.length; ++i) {
            if (include[i] == null || include[i].size() <= 0) continue;
            if (i == 1) {
                this.out.println("extern \"C\" {");
                if (this.out2 != null) {
                    this.out2.println("#ifdef __cplusplus");
                    this.out2.println("extern \"C\" {");
                    this.out2.println("#endif");
                }
            }
            for (String string : include[i]) {
                String line = "#include ";
                if (!string.startsWith("<") && !string.startsWith("\"")) {
                    line = line + '\"';
                }
                line = line + string;
                if (!string.endsWith(">") && !string.endsWith("\"")) {
                    line = line + '\"';
                }
                this.out.println(line);
                if (this.out2 == null) continue;
                this.out2.println(line);
            }
            if (i == 1) {
                this.out.println("}");
                if (this.out2 != null) {
                    this.out2.println("#ifdef __cplusplus");
                    this.out2.println("}");
                    this.out2.println("#endif");
                }
            }
            this.out.println();
        }
        this.out.println("static JavaVM* JavaCPP_vm = NULL;");
        this.out.println("static bool JavaCPP_haveAllocObject = false;");
        this.out.println("static bool JavaCPP_haveNonvirtual = false;");
        this.out.println("static const char* JavaCPP_classNames[" + this.jclasses.size() + "] = {");
        Iterator<Class> classIterator = this.jclasses.iterator();
        int maxMemberSize = 0;
        while (classIterator.hasNext()) {
            LinkedList<String> m2;
            Class clazz = classIterator.next();
            this.out.print("        \"" + clazz.getName().replace('.', '/') + "\"");
            if (classIterator.hasNext()) {
                this.out.println(",");
            }
            if ((m2 = this.members.get(clazz)) == null || m2.size() <= maxMemberSize) continue;
            maxMemberSize = m2.size();
        }
        this.out.println(" };");
        this.out.println("static jclass JavaCPP_classes[" + this.jclasses.size() + "] = { NULL };");
        this.out.println("static jfieldID JavaCPP_addressFID = NULL;");
        this.out.println("static jfieldID JavaCPP_positionFID = NULL;");
        this.out.println("static jfieldID JavaCPP_limitFID = NULL;");
        this.out.println("static jfieldID JavaCPP_capacityFID = NULL;");
        this.out.println("static jmethodID JavaCPP_initMID = NULL;");
        this.out.println("static jmethodID JavaCPP_toStringMID = NULL;");
        this.out.println();
        this.out.println("static inline void JavaCPP_log(const char* fmt, ...) {");
        this.out.println("    va_list ap;");
        this.out.println("    va_start(ap, fmt);");
        this.out.println("#ifdef ANDROID");
        this.out.println("    __android_log_vprint(ANDROID_LOG_ERROR, \"javacpp\", fmt, ap);");
        this.out.println("#elif defined(__APPLE__) && defined(__OBJC__)");
        this.out.println("    NSLogv([NSString stringWithUTF8String:fmt], ap);");
        this.out.println("#else");
        this.out.println("    vfprintf(stderr, fmt, ap);");
        this.out.println("    fprintf(stderr, \"\\n\");");
        this.out.println("#endif");
        this.out.println("    va_end(ap);");
        this.out.println("}");
        this.out.println();
        this.out.println("static JavaCPP_noinline jclass JavaCPP_getClass(JNIEnv* env, int i) {");
        this.out.println("    if (JavaCPP_classes[i] == NULL && env->PushLocalFrame(1) == 0) {");
        this.out.println("        jclass cls = env->FindClass(JavaCPP_classNames[i]);");
        this.out.println("        if (cls == NULL || env->ExceptionCheck()) {");
        this.out.println("            JavaCPP_log(\"Error loading class %s.\", JavaCPP_classNames[i]);");
        this.out.println("            return NULL;");
        this.out.println("        }");
        this.out.println("        JavaCPP_classes[i] = (jclass)env->NewWeakGlobalRef(cls);");
        this.out.println("        if (JavaCPP_classes[i] == NULL || env->ExceptionCheck()) {");
        this.out.println("            JavaCPP_log(\"Error creating global reference of class %s.\", JavaCPP_classNames[i]);");
        this.out.println("            return NULL;");
        this.out.println("        }");
        this.out.println("        env->PopLocalFrame(NULL);");
        this.out.println("    }");
        this.out.println("    return JavaCPP_classes[i];");
        this.out.println("}");
        this.out.println();
        this.out.println("static JavaCPP_noinline jfieldID JavaCPP_getFieldID(JNIEnv* env, int i, const char* name, const char* sig) {");
        this.out.println("    jclass cls = JavaCPP_getClass(env, i);");
        this.out.println("    if (cls == NULL) {");
        this.out.println("        return NULL;");
        this.out.println("    }");
        this.out.println("    jfieldID fid = env->GetFieldID(cls, name, sig);");
        this.out.println("    if (fid == NULL || env->ExceptionCheck()) {");
        this.out.println("        JavaCPP_log(\"Error getting field ID of %s/%s\", JavaCPP_classNames[i], name);");
        this.out.println("        return NULL;");
        this.out.println("    }");
        this.out.println("    return fid;");
        this.out.println("}");
        this.out.println();
        this.out.println("static JavaCPP_noinline jmethodID JavaCPP_getMethodID(JNIEnv* env, int i, const char* name, const char* sig) {");
        this.out.println("    jclass cls = JavaCPP_getClass(env, i);");
        this.out.println("    if (cls == NULL) {");
        this.out.println("        return NULL;");
        this.out.println("    }");
        this.out.println("    jmethodID mid = env->GetMethodID(cls, name, sig);");
        this.out.println("    if (mid == NULL || env->ExceptionCheck()) {");
        this.out.println("        JavaCPP_log(\"Error getting method ID of %s/%s\", JavaCPP_classNames[i], name);");
        this.out.println("        return NULL;");
        this.out.println("    }");
        this.out.println("    return mid;");
        this.out.println("}");
        this.out.println();
        this.out.println("static JavaCPP_noinline jmethodID JavaCPP_getStaticMethodID(JNIEnv* env, int i, const char* name, const char* sig) {");
        this.out.println("    jclass cls = JavaCPP_getClass(env, i);");
        this.out.println("    if (cls == NULL) {");
        this.out.println("        return NULL;");
        this.out.println("    }");
        this.out.println("    jmethodID mid = env->GetStaticMethodID(cls, name, sig);");
        this.out.println("    if (mid == NULL || env->ExceptionCheck()) {");
        this.out.println("        JavaCPP_log(\"Error getting static method ID of %s/%s\", JavaCPP_classNames[i], name);");
        this.out.println("        return NULL;");
        this.out.println("    }");
        this.out.println("    return mid;");
        this.out.println("}");
        this.out.println();
        this.out.println("static JavaCPP_noinline jobject JavaCPP_createPointer(JNIEnv* env, int i, jclass cls = NULL) {");
        this.out.println("    if (cls == NULL && (cls = JavaCPP_getClass(env, i)) == NULL) {");
        this.out.println("        return NULL;");
        this.out.println("    }");
        this.out.println("    if (JavaCPP_haveAllocObject) {");
        this.out.println("        return env->AllocObject(cls);");
        this.out.println("    } else {");
        this.out.println("        jmethodID mid = env->GetMethodID(cls, \"<init>\", \"()V\");");
        this.out.println("        if (mid == NULL || env->ExceptionCheck()) {");
        this.out.println("            JavaCPP_log(\"Error getting default constructor of %s, while VM does not support AllocObject()\", JavaCPP_classNames[i]);");
        this.out.println("            return NULL;");
        this.out.println("        }");
        this.out.println("        return env->NewObject(cls, mid);");
        this.out.println("    }");
        this.out.println("}");
        this.out.println();
        this.out.println("static JavaCPP_noinline void JavaCPP_initPointer(JNIEnv* env, jobject obj, const void* ptr, int size, void (*deallocator)(void*)) {");
        this.out.println("    if (deallocator != NULL) {");
        this.out.println("        jvalue args[3];");
        this.out.println("        args[0].j = ptr_to_jlong(ptr);");
        this.out.println("        args[1].i = size;");
        this.out.println("        args[2].j = ptr_to_jlong(deallocator);");
        this.out.println("        if (JavaCPP_haveNonvirtual) {");
        this.out.println("            env->CallNonvirtualVoidMethodA(obj, JavaCPP_getClass(env, " + this.jclasses.index(Pointer.class) + "), JavaCPP_initMID, args);");
        this.out.println("        } else {");
        this.out.println("            env->CallVoidMethodA(obj, JavaCPP_initMID, args);");
        this.out.println("        }");
        this.out.println("    } else {");
        this.out.println("        env->SetLongField(obj, JavaCPP_addressFID, ptr_to_jlong(ptr));");
        this.out.println("        env->SetIntField(obj, JavaCPP_limitFID, size);");
        this.out.println("        env->SetIntField(obj, JavaCPP_capacityFID, size);");
        this.out.println("    }");
        this.out.println("}");
        this.out.println();
        this.out.println("class JavaCPP_hidden JavaCPP_exception : public std::exception {");
        this.out.println("public:");
        this.out.println("    JavaCPP_exception(const char* str) throw() {");
        this.out.println("        if (str == NULL) {");
        this.out.println("            strcpy(msg, \"Unknown exception.\");");
        this.out.println("        } else {");
        this.out.println("            strncpy(msg, str, sizeof(msg));");
        this.out.println("            msg[sizeof(msg) - 1] = 0;");
        this.out.println("        }");
        this.out.println("    }");
        this.out.println("    virtual const char* what() const throw() { return msg; }");
        this.out.println("    char msg[1024];");
        this.out.println("};");
        this.out.println();
        if (handleExceptions) {
            this.out.println("static JavaCPP_noinline jthrowable JavaCPP_handleException(JNIEnv* env, int i) {");
            this.out.println("    jstring str = NULL;");
            this.out.println("    try {");
            this.out.println("        throw;");
            this.out.println("    } catch (std::exception& e) {");
            this.out.println("        str = env->NewStringUTF(e.what());");
            this.out.println("    } catch (...) {");
            this.out.println("        str = env->NewStringUTF(\"Unknown exception.\");");
            this.out.println("    }");
            this.out.println("    jmethodID mid = JavaCPP_getMethodID(env, i, \"<init>\", \"(Ljava/lang/String;)V\");");
            this.out.println("    if (mid == NULL) {");
            this.out.println("        return NULL;");
            this.out.println("    }");
            this.out.println("    return (jthrowable)env->NewObject(JavaCPP_getClass(env, i), mid, str);");
            this.out.println("}");
            this.out.println();
        }
        if (defineAdapters) {
            this.out.println("#include <vector>");
            this.out.println("template<typename P, typename T = P> class JavaCPP_hidden VectorAdapter {");
            this.out.println("public:");
            this.out.println("    VectorAdapter(const P* ptr, typename std::vector<T>::size_type size) : ptr((P*)ptr), size(size),");
            this.out.println("        vec2(ptr ? std::vector<T>((P*)ptr, (P*)ptr + size) : std::vector<T>()), vec(vec2) { }");
            this.out.println("    VectorAdapter(const std::vector<T>& vec) : ptr(0), size(0), vec2(vec), vec(vec2) { }");
            this.out.println("    VectorAdapter(      std::vector<T>& vec) : ptr(0), size(0), vec(vec) { }");
            this.out.println("    void assign(P* ptr, typename std::vector<T>::size_type size) {");
            this.out.println("        this->ptr = ptr;");
            this.out.println("        this->size = size;");
            this.out.println("        vec.assign(ptr, ptr + size);");
            this.out.println("    }");
            this.out.println("    static void deallocate(void* ptr) { delete[] (P*)ptr; }");
            this.out.println("    operator P*() {");
            this.out.println("        if (vec.size() > size) {");
            this.out.println("            ptr = new (std::nothrow) P[vec.size()];");
            this.out.println("        }");
            this.out.println("        if (ptr) {");
            this.out.println("            std::copy(vec.begin(), vec.end(), ptr);");
            this.out.println("        }");
            this.out.println("        size = vec.size();");
            this.out.println("        return ptr;");
            this.out.println("    }");
            this.out.println("    operator const P*()        { return &vec[0]; }");
            this.out.println("    operator std::vector<T>&() { return vec; }");
            this.out.println("    operator std::vector<T>*() { return ptr ? &vec : 0; }");
            this.out.println("    P* ptr;");
            this.out.println("    typename std::vector<T>::size_type size;");
            this.out.println("    std::vector<T> vec2;");
            this.out.println("    std::vector<T>& vec;");
            this.out.println("};");
            this.out.println();
            this.out.println("#include <string>");
            this.out.println("class JavaCPP_hidden StringAdapter {");
            this.out.println("public:");
            this.out.println("    StringAdapter(const          char* ptr, size_t size) : ptr((char*)ptr), size(size),");
            this.out.println("        str2(ptr ? (char*)ptr : \"\"), str(str2) { }");
            this.out.println("    StringAdapter(const signed   char* ptr, size_t size) : ptr((char*)ptr), size(size),");
            this.out.println("        str2(ptr ? (char*)ptr : \"\"), str(str2) { }");
            this.out.println("    StringAdapter(const unsigned char* ptr, size_t size) : ptr((char*)ptr), size(size),");
            this.out.println("        str2(ptr ? (char*)ptr : \"\"), str(str2) { }");
            this.out.println("    StringAdapter(const std::string& str) : ptr(0), size(0), str2(str), str(str2) { }");
            this.out.println("    StringAdapter(      std::string& str) : ptr(0), size(0), str(str) { }");
            this.out.println("    void assign(char* ptr, size_t size) {");
            this.out.println("        this->ptr = ptr;");
            this.out.println("        this->size = size;");
            this.out.println("        str.assign(ptr ? ptr : \"\");");
            this.out.println("    }");
            this.out.println("    static void deallocate(void* ptr) { free(ptr); }");
            this.out.println("    operator char*() {");
            this.out.println("        const char* c_str = str.c_str();");
            this.out.println("        if (ptr == NULL || strcmp(c_str, ptr) != 0) {");
            this.out.println("            ptr = strdup(c_str);");
            this.out.println("        }");
            this.out.println("        size = strlen(c_str) + 1;");
            this.out.println("        return ptr;");
            this.out.println("    }");
            this.out.println("    operator       signed   char*() { return (signed   char*)(operator char*)(); }");
            this.out.println("    operator       unsigned char*() { return (unsigned char*)(operator char*)(); }");
            this.out.println("    operator const          char*() { return                 str.c_str(); }");
            this.out.println("    operator const signed   char*() { return (signed   char*)str.c_str(); }");
            this.out.println("    operator const unsigned char*() { return (unsigned char*)str.c_str(); }");
            this.out.println("    operator         std::string&() { return str; }");
            this.out.println("    operator         std::string*() { return ptr ? &str : 0; }");
            this.out.println("    char* ptr;");
            this.out.println("    size_t size;");
            this.out.println("    std::string str2;");
            this.out.println("    std::string& str;");
            this.out.println("};");
            this.out.println();
        }
        if (!this.functions.isEmpty() || !this.virtualFunctions.isEmpty()) {
            this.out.println("static JavaCPP_noinline void JavaCPP_detach(bool detach) {");
            this.out.println("    if (detach && JavaCPP_vm->DetachCurrentThread() != JNI_OK) {");
            this.out.println("        JavaCPP_log(\"Could not detach the JavaVM from the current thread.\");");
            this.out.println("    }");
            this.out.println("}");
            this.out.println();
            this.out.println("static JavaCPP_noinline bool JavaCPP_getEnv(JNIEnv** env) {");
            this.out.println("    bool attached = false;");
            this.out.println("    JavaVM *vm = JavaCPP_vm;");
            this.out.println("    if (vm == NULL) {");
            if (this.out2 != null) {
                this.out.println("#if !defined(ANDROID) && !TARGET_OS_IPHONE");
                this.out.println("        int size = 1;");
                this.out.println("        if (JNI_GetCreatedJavaVMs(&vm, 1, &size) != JNI_OK || size == 0) {");
                this.out.println("#endif");
            }
            this.out.println("            JavaCPP_log(\"Could not get any created JavaVM.\");");
            this.out.println("            *env = NULL;");
            this.out.println("            return false;");
            if (this.out2 != null) {
                this.out.println("#if !defined(ANDROID) && !TARGET_OS_IPHONE");
                this.out.println("        }");
                this.out.println("#endif");
            }
            this.out.println("    }");
            this.out.println("    if (vm->GetEnv((void**)env, JNI_VERSION_1_4) != JNI_OK) {");
            this.out.println("        struct {");
            this.out.println("            JNIEnv **env;");
            this.out.println("            operator JNIEnv**() { return env; } // Android JNI");
            this.out.println("            operator void**() { return (void**)env; } // standard JNI");
            this.out.println("        } env2 = { env };");
            this.out.println("        if (vm->AttachCurrentThread(env2, NULL) != JNI_OK) {");
            this.out.println("            JavaCPP_log(\"Could not attach the JavaVM to the current thread.\");");
            this.out.println("            *env = NULL;");
            this.out.println("            return false;");
            this.out.println("        }");
            this.out.println("        attached = true;");
            this.out.println("    }");
            this.out.println("    if (JavaCPP_vm == NULL) {");
            this.out.println("        if (JNI_OnLoad(vm, NULL) < 0) {");
            this.out.println("            JavaCPP_detach(attached);");
            this.out.println("            *env = NULL;");
            this.out.println("            return false;");
            this.out.println("        }");
            this.out.println("    }");
            this.out.println("    return attached;");
            this.out.println("}");
            this.out.println();
        }
        for (Class c2 : this.functions) {
            String[] typeName2 = this.cppTypeName(c2);
            String[] returnConvention = typeName2[0].split("\\(");
            returnConvention[1] = Generator.constValueTypeName(returnConvention[1]);
            String parameterDeclaration = typeName2[1].substring(1);
            String instanceTypeName = Generator.functionClassName(c2);
            this.out.println("struct JavaCPP_hidden " + instanceTypeName + " {");
            this.out.println("    " + instanceTypeName + "() : ptr(NULL), obj(NULL) { }");
            this.out.println("    " + returnConvention[0] + "operator()" + parameterDeclaration + ";");
            this.out.println("    " + typeName2[0] + "ptr" + typeName2[1] + ";");
            this.out.println("    jobject obj; static jmethodID mid;");
            this.out.println("};");
            this.out.println("jmethodID " + instanceTypeName + "::mid = NULL;");
        }
        this.out.println();
        for (Class c : this.jclasses) {
            LinkedList<String> functionList = this.virtualFunctions.get(c);
            if (functionList == null) continue;
            LinkedList<String> memberList = this.virtualMembers.get(c);
            String[] typeName3 = this.cppTypeName(c);
            String valueTypeName2 = Generator.valueTypeName(typeName3);
            String subType = "JavaCPP_" + Generator.mangle(valueTypeName2);
            this.out.println("class JavaCPP_hidden " + subType + " : public " + valueTypeName2 + " {");
            this.out.println("public:");
            this.out.println("    jobject obj;");
            for (String s : functionList) {
                this.out.println("    static jmethodID " + s + ";");
            }
            this.out.println();
            for (String s : memberList) {
                this.out.println(s);
            }
            this.out.println("};");
            for (String s : functionList) {
                this.out.println("jmethodID " + subType + "::" + s + " = NULL;");
            }
        }
        this.out.println();
        for (String s : this.callbacks) {
            this.out.println(s);
        }
        this.out.println();
        for (Class c : this.deallocators) {
            name = "JavaCPP_" + Generator.mangle(c.getName());
            this.out.print("static void " + name + "_deallocate(void *p) { ");
            if (FunctionPointer.class.isAssignableFrom(c)) {
                typeName = Generator.functionClassName(c) + "*";
                this.out.println("JNIEnv *e; bool a = JavaCPP_getEnv(&e); if (e != NULL) e->DeleteWeakGlobalRef(((" + (String)typeName + ")p)->obj); delete (" + (String)typeName + ")p; JavaCPP_detach(a); }");
                continue;
            }
            if (this.virtualFunctions.containsKey(c)) {
                typeName = this.cppTypeName(c);
                valueTypeName = Generator.valueTypeName(typeName);
                String subType = "JavaCPP_" + Generator.mangle(valueTypeName);
                this.out.println("JNIEnv *e; bool a = JavaCPP_getEnv(&e); if (e != NULL) e->DeleteWeakGlobalRef(((" + subType + "*)p)->obj); delete (" + subType + "*)p; JavaCPP_detach(a); }");
                continue;
            }
            typeName = this.cppTypeName(c);
            this.out.println("delete (" + typeName[0] + typeName[1] + ")p; }");
        }
        for (Class c : this.arrayDeallocators) {
            name = "JavaCPP_" + Generator.mangle(c.getName());
            typeName = this.cppTypeName(c);
            this.out.println("static void " + name + "_deallocateArray(void* p) { delete[] (" + typeName[0] + typeName[1] + ")p; }");
        }
        this.out.println();
        this.out.println("extern \"C\" {");
        if (this.out2 != null) {
            this.out2.println();
            this.out2.println("#ifdef __cplusplus");
            this.out2.println("extern \"C\" {");
            this.out2.println("#endif");
            this.out2.println("JNIIMPORT int JavaCPP_init(int argc, const char *argv[]);");
            this.out.println();
            this.out.println("JNIEXPORT int JavaCPP_init(int argc, const char *argv[]) {");
            this.out.println("#if defined(ANDROID) || TARGET_OS_IPHONE");
            this.out.println("    return JNI_OK;");
            this.out.println("#else");
            this.out.println("    if (JavaCPP_vm != NULL) {");
            this.out.println("        return JNI_OK;");
            this.out.println("    }");
            this.out.println("    int err;");
            this.out.println("    JavaVM *vm;");
            this.out.println("    JNIEnv *env;");
            this.out.println("    int nOptions = 1 + (argc > 255 ? 255 : argc);");
            this.out.println("    JavaVMOption options[256] = { { NULL } };");
            this.out.println("    options[0].optionString = (char*)\"-Djava.class.path=" + classPath.replace('\\', '/') + "\";");
            this.out.println("    for (int i = 1; i < nOptions && argv != NULL; i++) {");
            this.out.println("        options[i].optionString = (char*)argv[i - 1];");
            this.out.println("    }");
            this.out.println("    JavaVMInitArgs vm_args = { JNI_VERSION_1_4, nOptions, options };");
            this.out.println("    return (err = JNI_CreateJavaVM(&vm, (void**)&env, &vm_args)) == JNI_OK && vm != NULL && (err = JNI_OnLoad(vm, NULL)) >= 0 ? JNI_OK : err;");
            this.out.println("#endif");
            this.out.println("}");
        }
        this.out.println();
        this.out.println("JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM* vm, void* reserved) {");
        this.out.println("    JNIEnv* env;");
        this.out.println("    if (vm->GetEnv((void**)&env, JNI_VERSION_1_4) != JNI_OK) {");
        this.out.println("        JavaCPP_log(\"Could not get JNIEnv for JNI_VERSION_1_4 inside JNI_OnLoad().\");");
        this.out.println("        return JNI_ERR;");
        this.out.println("    }");
        this.out.println("    if (JavaCPP_vm == vm) {");
        this.out.println("        return env->GetVersion();");
        this.out.println("    }");
        this.out.println("    JavaCPP_vm = vm;");
        this.out.println("    JavaCPP_haveAllocObject = env->functions->AllocObject != NULL;");
        this.out.println("    JavaCPP_haveNonvirtual = env->functions->CallNonvirtualVoidMethodA != NULL;");
        this.out.println("    const char* members[" + this.jclasses.size() + "][" + maxMemberSize + "] = {");
        classIterator = this.jclasses.iterator();
        while (classIterator.hasNext()) {
            Iterator memberIterator;
            this.out.print("            { ");
            LinkedList<String> linkedList = this.members.get(classIterator.next());
            Iterator iterator = memberIterator = linkedList == null ? null : linkedList.iterator();
            while (memberIterator != null && memberIterator.hasNext()) {
                this.out.print("\"" + (String)memberIterator.next() + "\"");
                if (!memberIterator.hasNext()) continue;
                this.out.print(", ");
            }
            this.out.print(" }");
            if (!classIterator.hasNext()) continue;
            this.out.println(",");
        }
        this.out.println(" };");
        this.out.println("    int offsets[" + this.jclasses.size() + "][" + maxMemberSize + "] = {");
        classIterator = this.jclasses.iterator();
        while (classIterator.hasNext()) {
            Iterator memberIterator;
            this.out.print("            { ");
            Class clazz = classIterator.next();
            LinkedList<String> m = this.members.get(clazz);
            Iterator iterator = memberIterator = m == null ? null : m.iterator();
            while (memberIterator != null && memberIterator.hasNext()) {
                typeName = this.cppTypeName(clazz);
                valueTypeName = Generator.valueTypeName(typeName);
                String memberName = (String)memberIterator.next();
                if ("sizeof".equals(memberName)) {
                    if ("void".equals(valueTypeName)) {
                        valueTypeName = "void*";
                    }
                    this.out.print("sizeof(" + valueTypeName + ")");
                } else {
                    this.out.print("offsetof(" + valueTypeName + ", " + memberName + ")");
                }
                if (!memberIterator.hasNext()) continue;
                this.out.print(", ");
            }
            this.out.print(" }");
            if (!classIterator.hasNext()) continue;
            this.out.println(",");
        }
        this.out.println(" };");
        this.out.print("    int memberOffsetSizes[" + this.jclasses.size() + "] = { ");
        classIterator = this.jclasses.iterator();
        while (classIterator.hasNext()) {
            LinkedList<String> linkedList = this.members.get(classIterator.next());
            this.out.print(linkedList == null ? 0 : linkedList.size());
            if (!classIterator.hasNext()) continue;
            this.out.print(", ");
        }
        this.out.println(" };");
        this.out.println("    jmethodID putMemberOffsetMID = JavaCPP_getStaticMethodID(env, " + this.jclasses.index(Loader.class) + ", \"putMemberOffset\", \"(Ljava/lang/String;Ljava/lang/String;I)V\");");
        this.out.println("    if (putMemberOffsetMID == NULL) {");
        this.out.println("        return JNI_ERR;");
        this.out.println("    }");
        this.out.println("    for (int i = 0; i < " + this.jclasses.size() + " && !env->ExceptionCheck(); i++) {");
        this.out.println("        for (int j = 0; j < memberOffsetSizes[i] && !env->ExceptionCheck(); j++) {");
        this.out.println("            if (env->PushLocalFrame(2) == 0) {");
        this.out.println("                jvalue args[3];");
        this.out.println("                args[0].l = env->NewStringUTF(JavaCPP_classNames[i]);");
        this.out.println("                args[1].l = env->NewStringUTF(members[i][j]);");
        this.out.println("                args[2].i = offsets[i][j];");
        this.out.println("                env->CallStaticVoidMethodA(JavaCPP_getClass(env, " + this.jclasses.index(Loader.class) + "), putMemberOffsetMID, args);");
        this.out.println("                env->PopLocalFrame(NULL);");
        this.out.println("            }");
        this.out.println("        }");
        this.out.println("    }");
        this.out.println("    JavaCPP_addressFID = JavaCPP_getFieldID(env, " + this.jclasses.index(Pointer.class) + ", \"address\", \"J\");");
        this.out.println("    if (JavaCPP_addressFID == NULL) {");
        this.out.println("        return JNI_ERR;");
        this.out.println("    }");
        this.out.println("    JavaCPP_positionFID = JavaCPP_getFieldID(env, " + this.jclasses.index(Pointer.class) + ", \"position\", \"I\");");
        this.out.println("    if (JavaCPP_positionFID == NULL) {");
        this.out.println("        return JNI_ERR;");
        this.out.println("    }");
        this.out.println("    JavaCPP_limitFID = JavaCPP_getFieldID(env, " + this.jclasses.index(Pointer.class) + ", \"limit\", \"I\");");
        this.out.println("    if (JavaCPP_limitFID == NULL) {");
        this.out.println("        return JNI_ERR;");
        this.out.println("    }");
        this.out.println("    JavaCPP_capacityFID = JavaCPP_getFieldID(env, " + this.jclasses.index(Pointer.class) + ", \"capacity\", \"I\");");
        this.out.println("    if (JavaCPP_capacityFID == NULL) {");
        this.out.println("        return JNI_ERR;");
        this.out.println("    }");
        this.out.println("    JavaCPP_initMID = JavaCPP_getMethodID(env, " + this.jclasses.index(Pointer.class) + ", \"init\", \"(JIJ)V\");");
        this.out.println("    if (JavaCPP_initMID == NULL) {");
        this.out.println("        return JNI_ERR;");
        this.out.println("    }");
        this.out.println("    JavaCPP_toStringMID = JavaCPP_getMethodID(env, " + this.jclasses.index(Object.class) + ", \"toString\", \"()Ljava/lang/String;\");");
        this.out.println("    if (JavaCPP_toStringMID == NULL) {");
        this.out.println("        return JNI_ERR;");
        this.out.println("    }");
        for (Class clazz : this.jclassesInit) {
            if (clazz == Pointer.class) continue;
            this.out.println("    if (JavaCPP_getClass(env, " + this.jclasses.index(clazz) + ") == NULL) {");
            this.out.println("        return JNI_ERR;");
            this.out.println("    }");
        }
        this.out.println("    return env->GetVersion();");
        this.out.println("}");
        this.out.println();
        if (this.out2 != null) {
            this.out2.println("JNIIMPORT int JavaCPP_uninit();");
            this.out2.println();
            this.out.println("JNIEXPORT int JavaCPP_uninit() {");
            this.out.println("#if defined(ANDROID) || TARGET_OS_IPHONE");
            this.out.println("    return JNI_OK;");
            this.out.println("#else");
            this.out.println("    JavaVM *vm = JavaCPP_vm;");
            this.out.println("    JNI_OnUnload(JavaCPP_vm, NULL);");
            this.out.println("    return vm->DestroyJavaVM();");
            this.out.println("#endif");
            this.out.println("}");
        }
        this.out.println();
        this.out.println("JNIEXPORT void JNICALL JNI_OnUnload(JavaVM* vm, void* reserved) {");
        this.out.println("    JNIEnv* env;");
        this.out.println("    if (vm->GetEnv((void**)&env, JNI_VERSION_1_4) != JNI_OK) {");
        this.out.println("        JavaCPP_log(\"Could not get JNIEnv for JNI_VERSION_1_4 inside JNI_OnUnLoad().\");");
        this.out.println("        return;");
        this.out.println("    }");
        this.out.println("    for (int i = 0; i < " + this.jclasses.size() + "; i++) {");
        this.out.println("        env->DeleteWeakGlobalRef(JavaCPP_classes[i]);");
        this.out.println("        JavaCPP_classes[i] = NULL;");
        this.out.println("    }");
        this.out.println("    JavaCPP_vm = NULL;");
        this.out.println("}");
        this.out.println();
        for (Class cls : baseClasses) {
            this.methods(cls);
        }
        boolean bl2 = false;
        for (Class<?> cls : classes) {
            try {
                bl |= this.methods(cls);
            }
            catch (NoClassDefFoundError e) {
                this.logger.warn("Could not generate code for class " + cls.getCanonicalName() + ": " + e);
            }
        }
        this.out.println("}");
        this.out.println();
        if (this.out2 != null) {
            this.out2.println("#ifdef __cplusplus");
            this.out2.println("}");
            this.out2.println("#endif");
        }
        return bl;
    }

    boolean methods(Class<?> cls) {
        if (!this.checkPlatform(cls)) {
            return false;
        }
        LinkedList<String> memberList = this.members.get(cls);
        if (!cls.isAnnotationPresent(Opaque.class) && !FunctionPointer.class.isAssignableFrom(cls)) {
            if (memberList == null) {
                memberList = new LinkedList();
                this.members.put(cls, memberList);
            }
            if (!memberList.contains("sizeof")) {
                memberList.add("sizeof");
            }
        }
        boolean didSomething = false;
        for (Class<?> c : cls.getDeclaredClasses()) {
            if (!Pointer.class.isAssignableFrom(c) && !Pointer.class.isAssignableFrom(c.getEnclosingClass())) continue;
            didSomething |= this.methods(c);
        }
        Method[] methods = cls.getDeclaredMethods();
        boolean[] callbackAllocators = new boolean[methods.length];
        Method functionMethod = Generator.functionMethod(cls, callbackAllocators);
        boolean firstCallback = true;
        for (int i = 0; i < methods.length; ++i) {
            String nativeName = Generator.mangle(cls.getName()) + "_" + Generator.mangle(methods[i].getName());
            if (!this.checkPlatform(methods[i].getAnnotation(Platform.class))) continue;
            MethodInformation methodInfo = this.methodInformation(methods[i]);
            String callbackName = "JavaCPP_" + nativeName + "_callback";
            if (callbackAllocators[i] && functionMethod == null) {
                this.logger.warn("No callback method call() or apply() has been not declared in \"" + cls.getCanonicalName() + "\". No code will be generated for callback allocator.");
                continue;
            }
            if (callbackAllocators[i] || methods[i].equals(functionMethod) && !Modifier.isNative(methods[i].getModifiers())) {
                this.functions.index(cls);
                Name name = methods[i].getAnnotation(Name.class);
                if (name != null && name.value().length > 0 && name.value()[0].length() > 0) {
                    callbackName = name.value()[0];
                }
                this.callback(cls, functionMethod, callbackName, firstCallback, null);
                firstCallback = false;
                didSomething = true;
            }
            if (!(!Modifier.isNative(methods[i].getModifiers()) && !Modifier.isAbstract(methods[i].getModifiers()) || methodInfo.valueGetter || methodInfo.valueSetter || methodInfo.memberGetter || methodInfo.memberSetter || cls.isInterface() || !methods[i].isAnnotationPresent(Virtual.class) && !methodInfo.allocator)) {
                this.callback(cls, methods[i], methodInfo.memberName[0], !methodInfo.allocator, methodInfo);
            }
            if (!Modifier.isNative(methods[i].getModifiers())) continue;
            if (!(!methodInfo.memberGetter && !methodInfo.memberSetter || methodInfo.noOffset || memberList == null || Modifier.isStatic(methodInfo.modifiers) || memberList.contains(methodInfo.memberName[0]))) {
                memberList.add(methodInfo.memberName[0]);
            }
            didSomething = true;
            this.out.print("JNIEXPORT " + Generator.jniTypeName(methodInfo.returnType) + " JNICALL Java_" + nativeName);
            if (methodInfo.overloaded) {
                this.out.print("__" + Generator.mangle(Generator.signature(methodInfo.parameterTypes)));
            }
            if (Modifier.isStatic(methodInfo.modifiers)) {
                this.out.print("(JNIEnv* env, jclass cls");
            } else {
                this.out.print("(JNIEnv* env, jobject obj");
            }
            for (int j = 0; j < methodInfo.parameterTypes.length; ++j) {
                this.out.print(", " + Generator.jniTypeName(methodInfo.parameterTypes[j]) + " arg" + j);
            }
            this.out.println(") {");
            if (callbackAllocators[i]) {
                this.callbackAllocator(cls, callbackName);
                continue;
            }
            if (!(Modifier.isStatic(methodInfo.modifiers) || methodInfo.allocator || methodInfo.arrayAllocator || methodInfo.deallocator)) {
                String[] typeName = this.cppTypeName(cls);
                if ("void*".equals(typeName[0]) && !cls.isAnnotationPresent(Opaque.class)) {
                    typeName[0] = "char*";
                } else if (FunctionPointer.class.isAssignableFrom(cls)) {
                    this.functions.index(cls);
                    typeName[0] = Generator.functionClassName(cls) + "*";
                    typeName[1] = "";
                }
                this.out.println("    " + typeName[0] + " ptr" + typeName[1] + " = (" + typeName[0] + typeName[1] + ")jlong_to_ptr(env->GetLongField(obj, JavaCPP_addressFID));");
                this.out.println("    if (ptr == NULL) {");
                this.out.println("        env->ThrowNew(JavaCPP_getClass(env, " + this.jclasses.index(NullPointerException.class) + "), \"This pointer address is NULL.\");");
                this.out.println("        return" + (methodInfo.returnType == Void.TYPE ? ";" : " 0;"));
                this.out.println("    }");
                if (FunctionPointer.class.isAssignableFrom(cls)) {
                    this.out.println("    if (ptr->ptr == NULL) {");
                    this.out.println("        env->ThrowNew(JavaCPP_getClass(env, " + this.jclasses.index(NullPointerException.class) + "), \"This function pointer address is NULL.\");");
                    this.out.println("        return" + (methodInfo.returnType == Void.TYPE ? ";" : " 0;"));
                    this.out.println("    }");
                }
                if (!cls.isAnnotationPresent(Opaque.class)) {
                    this.out.println("    jint position = env->GetIntField(obj, JavaCPP_positionFID);");
                    this.out.println("    ptr += position;");
                    if (methodInfo.bufferGetter) {
                        this.out.println("    jint size = env->GetIntField(obj, JavaCPP_limitFID);");
                        this.out.println("    size -= position;");
                    }
                }
            }
            this.parametersBefore(methodInfo);
            String returnPrefix = this.returnBefore(methodInfo);
            this.call(methodInfo, returnPrefix, false);
            this.returnAfter(methodInfo);
            this.parametersAfter(methodInfo);
            if (methodInfo.throwsException != null) {
                this.out.println("    if (exc != NULL) {");
                this.out.println("        env->Throw(exc);");
                this.out.println("    }");
            }
            if (methodInfo.returnType != Void.TYPE) {
                this.out.println("    return rarg;");
            }
            this.out.println("}");
        }
        this.out.println();
        return didSomething;
    }

    void parametersBefore(MethodInformation methodInfo) {
        int skipParameters;
        String adapterLine = "";
        AdapterInformation prevAdapterInfo = null;
        for (int j = skipParameters = methodInfo.parameterTypes.length > 0 && methodInfo.parameterTypes[0] == Class.class ? 1 : 0; j < methodInfo.parameterTypes.length; ++j) {
            AdapterInformation adapterInfo;
            String[] stringArray;
            if (methodInfo.parameterTypes[j].isPrimitive()) continue;
            Annotation passBy = this.by(methodInfo, j);
            String cast = this.cast(methodInfo, j);
            if (methodInfo.parameterRaw[j]) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            } else {
                stringArray = this.cppTypeName(methodInfo.parameterTypes[j]);
            }
            String[] typeName = stringArray;
            AdapterInformation adapterInformation = adapterInfo = methodInfo.parameterRaw[j] ? null : this.adapterInformation(false, methodInfo, j);
            if (FunctionPointer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                this.functions.index(methodInfo.parameterTypes[j]);
                if (methodInfo.parameterTypes[j] == FunctionPointer.class) {
                    this.logger.warn("Method \"" + methodInfo.method + "\" has an abstract FunctionPointer parameter, " + "but a concrete subclass is required. Compilation will most likely fail.");
                }
                typeName[0] = Generator.functionClassName(methodInfo.parameterTypes[j]) + "*";
                typeName[1] = "";
            }
            if (typeName[0].length() == 0 || methodInfo.parameterRaw[j]) {
                methodInfo.parameterRaw[j] = true;
                typeName[0] = Generator.jniTypeName(methodInfo.parameterTypes[j]);
                this.out.println("    " + typeName[0] + " ptr" + j + " = arg" + j + ";");
                continue;
            }
            if ("void*".equals(typeName[0]) && !methodInfo.parameterTypes[j].isAnnotationPresent(Opaque.class)) {
                typeName[0] = "char*";
            }
            this.out.print("    " + typeName[0] + " ptr" + j + typeName[1] + " = ");
            if (Pointer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                this.out.println("arg" + j + " == NULL ? NULL : (" + typeName[0] + typeName[1] + ")jlong_to_ptr(env->GetLongField(arg" + j + ", JavaCPP_addressFID));");
                if (j == 0 && FunctionPointer.class.isAssignableFrom(methodInfo.cls) && methodInfo.cls.isAnnotationPresent(Namespace.class) || passBy instanceof ByVal || passBy instanceof ByRef) {
                    this.out.println("    if (ptr" + j + " == NULL) {");
                    this.out.println("        env->ThrowNew(JavaCPP_getClass(env, " + this.jclasses.index(NullPointerException.class) + "), \"Pointer address of argument " + j + " is NULL.\");");
                    this.out.println("        return" + (methodInfo.returnType == Void.TYPE ? ";" : " 0;"));
                    this.out.println("    }");
                }
                if (adapterInfo != null || prevAdapterInfo != null) {
                    this.out.println("    jint size" + j + " = arg" + j + " == NULL ? 0 : env->GetIntField(arg" + j + ", JavaCPP_limitFID);");
                }
                if (!methodInfo.parameterTypes[j].isAnnotationPresent(Opaque.class)) {
                    this.out.println("    jint position" + j + " = arg" + j + " == NULL ? 0 : env->GetIntField(arg" + j + ", JavaCPP_positionFID);");
                    this.out.println("    ptr" + j + " += position" + j + ";");
                    if (adapterInfo != null || prevAdapterInfo != null) {
                        this.out.println("    size" + j + " -= position" + j + ";");
                    }
                }
            } else if (methodInfo.parameterTypes[j] == String.class) {
                this.out.println("arg" + j + " == NULL ? NULL : env->GetStringUTFChars(arg" + j + ", NULL);");
                if (adapterInfo != null || prevAdapterInfo != null) {
                    this.out.println("    jint size" + j + " = 0;");
                }
            } else if (methodInfo.parameterTypes[j].isArray() && methodInfo.parameterTypes[j].getComponentType().isPrimitive()) {
                this.out.print("arg" + j + " == NULL ? NULL : ");
                String s = methodInfo.parameterTypes[j].getComponentType().getName();
                if (methodInfo.valueGetter || methodInfo.valueSetter || methodInfo.memberGetter || methodInfo.memberSetter) {
                    this.out.println("(j" + s + "*)env->GetPrimitiveArrayCritical(arg" + j + ", NULL);");
                } else {
                    s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
                    this.out.println("env->Get" + s + "ArrayElements(arg" + j + ", NULL);");
                }
                if (adapterInfo != null || prevAdapterInfo != null) {
                    this.out.println("    jint size" + j + " = arg" + j + " == NULL ? 0 : env->GetArrayLength(arg" + j + ");");
                }
            } else if (Buffer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                this.out.println("arg" + j + " == NULL ? NULL : (" + typeName[0] + typeName[1] + ")env->GetDirectBufferAddress(arg" + j + ");");
                if (adapterInfo != null || prevAdapterInfo != null) {
                    this.out.println("    jint size" + j + " = arg" + j + " == NULL ? 0 : env->GetDirectBufferCapacity(arg" + j + ");");
                }
            } else {
                this.out.println("arg" + j + ";");
                this.logger.warn("Method \"" + methodInfo.method + "\" has an unsupported parameter of type \"" + methodInfo.parameterTypes[j].getCanonicalName() + "\". Compilation will most likely fail.");
            }
            if (adapterInfo != null) {
                this.usesAdapters = true;
                adapterLine = "    " + adapterInfo.name + " adapter" + j + "(";
                prevAdapterInfo = adapterInfo;
            }
            if (prevAdapterInfo != null) {
                if (!FunctionPointer.class.isAssignableFrom(methodInfo.cls)) {
                    adapterLine = adapterLine + cast;
                }
                adapterLine = adapterLine + "ptr" + j + ", size" + j;
                if (--prevAdapterInfo.argc > 0) {
                    adapterLine = adapterLine + ", ";
                }
            }
            if (prevAdapterInfo == null || prevAdapterInfo.argc > 0) continue;
            this.out.println(adapterLine + ");");
            prevAdapterInfo = null;
        }
    }

    String returnBefore(MethodInformation methodInfo) {
        String returnPrefix = "";
        if (methodInfo.returnType == Void.TYPE) {
            if (methodInfo.allocator || methodInfo.arrayAllocator) {
                if (methodInfo.cls != Pointer.class && !this.virtualFunctions.containsKey(methodInfo.cls)) {
                    this.out.println("    if (!env->IsSameObject(env->GetObjectClass(obj), JavaCPP_getClass(env, " + this.jclasses.index(methodInfo.cls) + "))) {");
                    this.out.println("        return;");
                    this.out.println("    }");
                }
                String[] typeName = this.cppTypeName(methodInfo.cls);
                returnPrefix = typeName[0] + " rptr" + typeName[1] + " = ";
            }
        } else {
            String[] typeName;
            String[] stringArray;
            String cast = this.cast(methodInfo.returnType, methodInfo.annotations);
            if (methodInfo.returnRaw) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            } else {
                stringArray = typeName = this.cppCastTypeName(methodInfo.returnType, methodInfo.annotations);
            }
            if (methodInfo.valueSetter || methodInfo.memberSetter || methodInfo.noReturnGetter) {
                this.out.println("    jobject rarg = obj;");
            } else if (methodInfo.returnType.isPrimitive()) {
                this.out.println("    " + Generator.jniTypeName(methodInfo.returnType) + " rarg = 0;");
                returnPrefix = typeName[0] + " rvalue" + typeName[1] + " = " + cast;
            } else {
                Annotation returnBy = this.by(methodInfo.annotations);
                String valueTypeName = Generator.valueTypeName(typeName);
                returnPrefix = "rptr = " + cast;
                if (typeName[0].length() == 0 || methodInfo.returnRaw) {
                    methodInfo.returnRaw = true;
                    typeName[0] = Generator.jniTypeName(methodInfo.returnType);
                    this.out.println("    " + typeName[0] + " rarg = NULL;");
                    this.out.println("    " + typeName[0] + " rptr;");
                } else if (Pointer.class.isAssignableFrom(methodInfo.returnType) || Buffer.class.isAssignableFrom(methodInfo.returnType) || methodInfo.returnType.isArray() && methodInfo.returnType.getComponentType().isPrimitive()) {
                    if (FunctionPointer.class.isAssignableFrom(methodInfo.returnType)) {
                        this.functions.index(methodInfo.returnType);
                        returnPrefix = "if (rptr != NULL) rptr->ptr = ";
                        if (methodInfo.method.isAnnotationPresent(Virtual.class)) {
                            returnPrefix = returnPrefix + "(" + typeName[0] + typeName[1] + ")&";
                        }
                        typeName[0] = Generator.functionClassName(methodInfo.returnType) + "*";
                        typeName[1] = "";
                        valueTypeName = Generator.valueTypeName(typeName);
                    } else if (this.virtualFunctions.containsKey(methodInfo.cls)) {
                        String subType;
                        valueTypeName = subType = "JavaCPP_" + Generator.mangle(valueTypeName);
                    }
                    if (returnBy instanceof ByVal) {
                        returnPrefix = returnPrefix + (Generator.noException(methodInfo.returnType, methodInfo.method) ? "new (std::nothrow) " : "new ") + valueTypeName + typeName[1] + "(";
                    } else if (returnBy instanceof ByRef) {
                        returnPrefix = returnPrefix + "&";
                    } else if (returnBy instanceof ByPtrPtr) {
                        if (cast.length() > 0) {
                            typeName[0] = typeName[0].substring(0, typeName[0].length() - 1);
                        }
                        returnPrefix = "rptr = NULL; " + typeName[0] + "* rptrptr" + typeName[1] + " = " + cast;
                    }
                    if (methodInfo.bufferGetter) {
                        this.out.println("    jobject rarg = NULL;");
                        this.out.println("    char* rptr;");
                    } else {
                        this.out.println("    " + Generator.jniTypeName(methodInfo.returnType) + " rarg = NULL;");
                        this.out.println("    " + typeName[0] + " rptr" + typeName[1] + ";");
                    }
                    if (FunctionPointer.class.isAssignableFrom(methodInfo.returnType)) {
                        this.out.println("    rptr = new (std::nothrow) " + valueTypeName + ";");
                    }
                } else if (methodInfo.returnType == String.class) {
                    this.out.println("    jstring rarg = NULL;");
                    this.out.println("    const char* rptr;");
                    returnPrefix = returnBy instanceof ByRef ? "std::string rstr(" : returnPrefix + "(const char*)";
                } else {
                    this.logger.warn("Method \"" + methodInfo.method + "\" has unsupported return type \"" + methodInfo.returnType.getCanonicalName() + "\". Compilation will most likely fail.");
                }
                AdapterInformation adapterInfo = this.adapterInformation(false, valueTypeName, methodInfo.annotations);
                if (adapterInfo != null) {
                    this.usesAdapters = true;
                    returnPrefix = adapterInfo.name + " radapter(";
                }
            }
        }
        if (methodInfo.throwsException != null) {
            this.out.println("    jthrowable exc = NULL;");
            this.out.println("    try {");
        }
        return returnPrefix;
    }

    void call(MethodInformation methodInfo, String returnPrefix, boolean secondCall) {
        boolean index;
        boolean needSecondCall = false;
        String indent = secondCall ? "" : (methodInfo.throwsException != null ? "        " : "    ");
        String prefix = "(";
        String suffix = ")";
        int skipParameters = methodInfo.parameterTypes.length > 0 && methodInfo.parameterTypes[0] == Class.class ? 1 : 0;
        boolean bl = index = methodInfo.method.isAnnotationPresent(Index.class) || methodInfo.pairedMethod != null && methodInfo.pairedMethod.isAnnotationPresent(Index.class);
        if (methodInfo.deallocator) {
            this.out.println(indent + "void* allocatedAddress = jlong_to_ptr(arg0);");
            this.out.println(indent + "void (*deallocatorAddress)(void*) = (void(*)(void*))jlong_to_ptr(arg1);");
            this.out.println(indent + "if (deallocatorAddress != NULL && allocatedAddress != NULL) {");
            this.out.println(indent + "    (*deallocatorAddress)(allocatedAddress);");
            this.out.println(indent + "}");
            return;
        }
        if (methodInfo.valueGetter || methodInfo.valueSetter || methodInfo.memberGetter || methodInfo.memberSetter) {
            boolean wantsPointer = false;
            int k = methodInfo.parameterTypes.length - 1;
            if ((methodInfo.valueSetter || methodInfo.memberSetter) && !(this.by(methodInfo, k) instanceof ByRef) && this.adapterInformation(false, methodInfo, k) == null && methodInfo.parameterTypes[k] == String.class) {
                this.out.print(indent + "strcpy((char*)");
                wantsPointer = true;
                prefix = ", ";
            } else if (k >= 1 && methodInfo.parameterTypes[0].isArray() && methodInfo.parameterTypes[0].getComponentType().isPrimitive() && (methodInfo.parameterTypes[1] == Integer.TYPE || methodInfo.parameterTypes[1] == Long.TYPE)) {
                this.out.print(indent + "memcpy(");
                wantsPointer = true;
                prefix = ", ";
                if (methodInfo.memberGetter || methodInfo.valueGetter) {
                    this.out.print("ptr0 + arg1, ");
                } else {
                    prefix = prefix + "ptr0 + arg1, ";
                }
                skipParameters = 2;
                suffix = " * sizeof(*ptr0)" + suffix;
            } else {
                this.out.print(indent + returnPrefix);
                prefix = methodInfo.valueGetter || methodInfo.memberGetter ? "" : " = ";
                suffix = "";
            }
            if (Modifier.isStatic(methodInfo.modifiers)) {
                this.out.print(Generator.cppScopeName(methodInfo));
            } else if (methodInfo.memberGetter || methodInfo.memberSetter) {
                if (index) {
                    this.out.print("(*ptr)");
                    prefix = "." + methodInfo.memberName[0] + prefix;
                } else {
                    this.out.print("ptr->" + methodInfo.memberName[0]);
                }
            } else {
                this.out.print(index ? "(*ptr)" : (methodInfo.dim > 0 || wantsPointer ? "ptr" : "*ptr"));
            }
        } else if (methodInfo.bufferGetter) {
            this.out.print(indent + returnPrefix + "ptr");
            prefix = "";
            suffix = "";
        } else {
            this.out.print(indent + returnPrefix);
            if (FunctionPointer.class.isAssignableFrom(methodInfo.cls)) {
                if (methodInfo.cls.isAnnotationPresent(Namespace.class)) {
                    this.out.print("(ptr0->*(ptr->ptr))");
                    skipParameters = 1;
                } else {
                    this.out.print("(*ptr->ptr)");
                }
            } else if (methodInfo.allocator) {
                String[] typeName = this.cppTypeName(methodInfo.cls);
                String valueTypeName = Generator.valueTypeName(typeName);
                if (this.virtualFunctions.containsKey(methodInfo.cls)) {
                    String subType;
                    valueTypeName = subType = "JavaCPP_" + Generator.mangle(valueTypeName);
                }
                if (methodInfo.cls == Pointer.class) {
                    prefix = "";
                    suffix = "";
                } else {
                    this.out.print((Generator.noException(methodInfo.cls, methodInfo.method) ? "new (std::nothrow) " : "new ") + valueTypeName + typeName[1]);
                    if (methodInfo.arrayAllocator) {
                        prefix = "[";
                        suffix = "]";
                    }
                }
            } else if (Modifier.isStatic(methodInfo.modifiers)) {
                this.out.print(Generator.cppScopeName(methodInfo));
            } else {
                String name = methodInfo.memberName[0];
                String[] typeName = this.cppTypeName(methodInfo.cls);
                String valueTypeName = Generator.valueTypeName(typeName);
                if (this.virtualFunctions.containsKey(methodInfo.cls) && !secondCall) {
                    String subType = "JavaCPP_" + Generator.mangle(valueTypeName);
                    this.out.print("dynamic_cast<" + subType + "*>(ptr) != NULL ? ");
                    name = valueTypeName + "::" + name;
                    needSecondCall = true;
                }
                if (index) {
                    this.out.print("(*ptr)");
                    prefix = "." + name + prefix;
                } else {
                    this.out.print("ptr->" + name);
                }
            }
        }
        for (int j = skipParameters; j <= methodInfo.parameterTypes.length; ++j) {
            AdapterInformation adapterInfo;
            if (j == skipParameters + methodInfo.dim) {
                if (methodInfo.memberName.length > 1) {
                    this.out.print(methodInfo.memberName[1]);
                }
                this.out.print(prefix);
                if (methodInfo.withEnv) {
                    this.out.print(Modifier.isStatic(methodInfo.modifiers) ? "env, cls" : "env, obj");
                    if (methodInfo.parameterTypes.length - skipParameters - methodInfo.dim > 0) {
                        this.out.print(", ");
                    }
                }
            }
            if (j == methodInfo.parameterTypes.length) break;
            if (j < skipParameters + methodInfo.dim) {
                this.out.print("[");
            }
            Annotation passBy = this.by(methodInfo, j);
            String cast = this.cast(methodInfo, j);
            AdapterInformation adapterInformation = adapterInfo = methodInfo.parameterRaw[j] ? null : this.adapterInformation(false, methodInfo, j);
            if (("(void*)".equals(cast) || "(void *)".equals(cast)) && methodInfo.parameterTypes[j] == Long.TYPE) {
                this.out.print("jlong_to_ptr(arg" + j + ")");
            } else if (methodInfo.parameterTypes[j].isPrimitive()) {
                this.out.print(cast + "arg" + j);
            } else if (adapterInfo != null) {
                cast = adapterInfo.cast.trim();
                if (cast.length() > 0 && !cast.startsWith("(") && !cast.endsWith(")")) {
                    cast = "(" + cast + ")";
                }
                this.out.print(cast + "adapter" + j);
                j += adapterInfo.argc - 1;
            } else if (FunctionPointer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                this.out.print(cast + "(ptr" + j + " == NULL ? NULL : " + (passBy instanceof ByPtrPtr ? "&ptr" : "ptr") + j + "->ptr)");
            } else if (passBy instanceof ByVal || passBy instanceof ByRef && methodInfo.parameterTypes[j] != String.class) {
                this.out.print("*" + cast + "ptr" + j);
            } else if (passBy instanceof ByPtrPtr) {
                this.out.print(cast + "(arg" + j + " == NULL ? NULL : &ptr" + j + ")");
            } else {
                this.out.print(cast + "ptr" + j);
            }
            if (j < skipParameters + methodInfo.dim) {
                this.out.print("]");
                continue;
            }
            if (j >= methodInfo.parameterTypes.length - 1) continue;
            this.out.print(", ");
        }
        this.out.print(suffix);
        if (methodInfo.memberName.length > 2) {
            this.out.print(methodInfo.memberName[2]);
        }
        if (this.by(methodInfo.annotations) instanceof ByRef && methodInfo.returnType == String.class) {
            this.out.print(");\n" + indent + "rptr = rstr.c_str()");
        }
        if (needSecondCall) {
            this.call(methodInfo, " : ", true);
        }
    }

    void returnAfter(MethodInformation methodInfo) {
        String suffix;
        String[] stringArray;
        String indent;
        String string = indent = methodInfo.throwsException != null ? "        " : "    ";
        if (methodInfo.returnRaw) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = this.cppCastTypeName(methodInfo.returnType, methodInfo.annotations);
        }
        String[] typeName = stringArray;
        Annotation returnBy = this.by(methodInfo.annotations);
        String valueTypeName = Generator.valueTypeName(typeName);
        AdapterInformation adapterInfo = this.adapterInformation(false, valueTypeName, methodInfo.annotations);
        String string2 = suffix = methodInfo.deallocator ? "" : ";";
        if (!methodInfo.returnType.isPrimitive() && adapterInfo != null) {
            suffix = ")" + suffix;
        }
        if (Pointer.class.isAssignableFrom(methodInfo.returnType) || methodInfo.returnType.isArray() && methodInfo.returnType.getComponentType().isPrimitive() || Buffer.class.isAssignableFrom(methodInfo.returnType)) {
            if (returnBy instanceof ByVal) {
                suffix = ")" + suffix;
            } else if (returnBy instanceof ByPtrPtr) {
                this.out.println(suffix);
                suffix = "";
                this.out.println(indent + "if (rptrptr == NULL) {");
                this.out.println(indent + "    env->ThrowNew(JavaCPP_getClass(env, " + this.jclasses.index(NullPointerException.class) + "), \"Return pointer address is NULL.\");");
                this.out.println(indent + "} else {");
                this.out.println(indent + "    rptr = *rptrptr;");
                this.out.println(indent + "}");
            }
        }
        this.out.println(suffix);
        if (methodInfo.returnType == Void.TYPE) {
            if (methodInfo.allocator || methodInfo.arrayAllocator) {
                this.out.println(indent + "jint rcapacity = " + (methodInfo.arrayAllocator ? "arg0;" : "1;"));
                boolean noDeallocator = methodInfo.cls == Pointer.class || methodInfo.cls.isAnnotationPresent(NoDeallocator.class) || methodInfo.method.isAnnotationPresent(NoDeallocator.class);
                this.out.print(indent + "JavaCPP_initPointer(env, obj, rptr, rcapacity, ");
                if (noDeallocator) {
                    this.out.println("NULL);");
                } else if (methodInfo.arrayAllocator) {
                    this.out.println("&JavaCPP_" + Generator.mangle(methodInfo.cls.getName()) + "_deallocateArray);");
                    this.arrayDeallocators.index(methodInfo.cls);
                } else {
                    this.out.println("&JavaCPP_" + Generator.mangle(methodInfo.cls.getName()) + "_deallocate);");
                    this.deallocators.index(methodInfo.cls);
                }
                if (this.virtualFunctions.containsKey(methodInfo.cls)) {
                    typeName = this.cppTypeName(methodInfo.cls);
                    valueTypeName = Generator.valueTypeName(typeName);
                    String subType = "JavaCPP_" + Generator.mangle(valueTypeName);
                    this.out.println(indent + "((" + subType + "*)rptr)->obj = env->NewWeakGlobalRef(obj);");
                }
            }
        } else if (!(methodInfo.valueSetter || methodInfo.memberSetter || methodInfo.noReturnGetter)) {
            if (methodInfo.returnType.isPrimitive()) {
                this.out.println(indent + "rarg = (" + Generator.jniTypeName(methodInfo.returnType) + ")rvalue;");
            } else if (methodInfo.returnRaw) {
                this.out.println(indent + "rarg = rptr;");
            } else {
                boolean needInit = false;
                if (adapterInfo != null) {
                    this.out.println(indent + "rptr = radapter;");
                    if (methodInfo.returnType != String.class) {
                        this.out.println(indent + "jint rcapacity = (jint)radapter.size;");
                        this.out.println(indent + "void (*deallocator)(void*) = " + (adapterInfo.constant ? "NULL;" : "&" + adapterInfo.name + "::deallocate;"));
                    }
                    needInit = true;
                } else if (returnBy instanceof ByVal || FunctionPointer.class.isAssignableFrom(methodInfo.returnType)) {
                    this.out.println(indent + "jint rcapacity = 1;");
                    this.out.println(indent + "void (*deallocator)(void*) = &JavaCPP_" + Generator.mangle(methodInfo.returnType.getName()) + "_deallocate;");
                    this.deallocators.index(methodInfo.returnType);
                    needInit = true;
                }
                if (Pointer.class.isAssignableFrom(methodInfo.returnType)) {
                    this.out.print(indent);
                    if (!(returnBy instanceof ByVal)) {
                        if (Modifier.isStatic(methodInfo.modifiers) && methodInfo.parameterTypes.length > 0) {
                            for (int i = 0; i < methodInfo.parameterTypes.length; ++i) {
                                String cast = this.cast(methodInfo, i);
                                if (!Arrays.equals(methodInfo.parameterAnnotations[i], methodInfo.annotations) || methodInfo.parameterTypes[i] != methodInfo.returnType) continue;
                                this.out.println("if (rptr == " + cast + "ptr" + i + ") {");
                                this.out.println(indent + "    rarg = arg" + i + ";");
                                this.out.print(indent + "} else ");
                            }
                        } else if (!Modifier.isStatic(methodInfo.modifiers) && methodInfo.cls == methodInfo.returnType) {
                            this.out.println("if (rptr == ptr) {");
                            this.out.println(indent + "    rarg = obj;");
                            this.out.print(indent + "} else ");
                        }
                    }
                    this.out.println("if (rptr != NULL) {");
                    this.out.println(indent + "    rarg = JavaCPP_createPointer(env, " + this.jclasses.index(methodInfo.returnType) + (methodInfo.parameterTypes.length > 0 && methodInfo.parameterTypes[0] == Class.class ? ", arg0);" : ");"));
                    if (needInit) {
                        this.out.println(indent + "    JavaCPP_initPointer(env, rarg, rptr, rcapacity, deallocator);");
                    } else {
                        this.out.println(indent + "    env->SetLongField(rarg, JavaCPP_addressFID, ptr_to_jlong(rptr));");
                    }
                    if (returnBy instanceof ByVal && this.virtualFunctions.containsKey(methodInfo.cls)) {
                        String subType = "JavaCPP_" + Generator.mangle(valueTypeName);
                        this.out.println(indent + "    ((" + subType + "*))rptr->obj = env->NewWeakGlobalRef(rarg);");
                    }
                    this.out.println(indent + "}");
                } else if (methodInfo.returnType == String.class) {
                    this.out.println(indent + "if (rptr != NULL) {");
                    this.out.println(indent + "    rarg = env->NewStringUTF(rptr);");
                    this.out.println(indent + "}");
                } else if (methodInfo.returnType.isArray() && methodInfo.returnType.getComponentType().isPrimitive()) {
                    if (adapterInfo == null && !(returnBy instanceof ByVal)) {
                        this.out.println(indent + "jint rcapacity = rptr != NULL ? 1 : 0;");
                    }
                    String s = methodInfo.returnType.getComponentType().getName();
                    String S = Character.toUpperCase(s.charAt(0)) + s.substring(1);
                    this.out.println(indent + "if (rptr != NULL) {");
                    this.out.println(indent + "    rarg = env->New" + S + "Array(rcapacity);");
                    this.out.println(indent + "    env->Set" + S + "ArrayRegion(rarg, 0, rcapacity, (j" + s + "*)rptr);");
                    this.out.println(indent + "}");
                    if (adapterInfo != null) {
                        this.out.println(indent + "if (deallocator != 0 && rptr != NULL) {");
                        this.out.println(indent + "    (*(void(*)(void*))jlong_to_ptr(deallocator))((void*)rptr);");
                        this.out.println(indent + "}");
                    }
                } else if (Buffer.class.isAssignableFrom(methodInfo.returnType)) {
                    if (methodInfo.bufferGetter) {
                        this.out.println(indent + "jint rcapacity = size;");
                    } else if (adapterInfo == null && !(returnBy instanceof ByVal)) {
                        this.out.println(indent + "jint rcapacity = rptr != NULL ? 1 : 0;");
                    }
                    this.out.println(indent + "if (rptr != NULL) {");
                    this.out.println(indent + "    rarg = env->NewDirectByteBuffer((void*)rptr, rcapacity);");
                    this.out.println(indent + "}");
                }
            }
        }
    }

    void parametersAfter(MethodInformation methodInfo) {
        int skipParameters;
        if (methodInfo.throwsException != null) {
            this.mayThrowExceptions = true;
            this.out.println("    } catch (...) {");
            this.out.println("        exc = JavaCPP_handleException(env, " + this.jclasses.index(methodInfo.throwsException) + ");");
            this.out.println("    }");
            this.out.println();
        }
        for (int j = skipParameters = methodInfo.parameterTypes.length > 0 && methodInfo.parameterTypes[0] == Class.class ? 1 : 0; j < methodInfo.parameterTypes.length; ++j) {
            if (methodInfo.parameterRaw[j]) continue;
            Annotation passBy = this.by(methodInfo, j);
            String cast = this.cast(methodInfo, j);
            String[] typeName = this.cppCastTypeName(methodInfo.parameterTypes[j], methodInfo.parameterAnnotations[j]);
            AdapterInformation adapterInfo = this.adapterInformation(true, methodInfo, j);
            if ("void*".equals(typeName[0]) && !methodInfo.parameterTypes[j].isAnnotationPresent(Opaque.class)) {
                typeName[0] = "char*";
            }
            if (Pointer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                if (adapterInfo != null) {
                    for (int k = 0; k < adapterInfo.argc; ++k) {
                        this.out.println("    " + typeName[0] + " rptr" + (j + k) + typeName[1] + " = " + cast + "adapter" + j + ";");
                        this.out.println("    jint rsize" + (j + k) + " = (jint)adapter" + j + ".size" + (k > 0 ? k + 1 + ";" : ";"));
                        this.out.println("    if (rptr" + (j + k) + " != " + cast + "ptr" + (j + k) + ") {");
                        this.out.println("        JavaCPP_initPointer(env, arg" + j + ", rptr" + (j + k) + ", rsize" + (j + k) + ", &" + adapterInfo.name + "::deallocate);");
                        this.out.println("    } else {");
                        this.out.println("        env->SetIntField(arg" + j + ", JavaCPP_limitFID, rsize" + (j + k) + " + position" + (j + k) + ");");
                        this.out.println("    }");
                    }
                    continue;
                }
                if (!(passBy instanceof ByPtrPtr) && !(passBy instanceof ByPtrRef) || methodInfo.valueSetter || methodInfo.memberSetter) continue;
                if (!methodInfo.parameterTypes[j].isAnnotationPresent(Opaque.class)) {
                    this.out.println("    ptr" + j + " -= position" + j + ";");
                }
                this.out.println("    if (arg" + j + " != NULL) env->SetLongField(arg" + j + ", JavaCPP_addressFID, ptr_to_jlong(ptr" + j + "));");
                continue;
            }
            if (methodInfo.parameterTypes[j] == String.class) {
                this.out.println("    if (arg" + j + " != NULL) env->ReleaseStringUTFChars(arg" + j + ", ptr" + j + ");");
                continue;
            }
            if (!methodInfo.parameterTypes[j].isArray() || !methodInfo.parameterTypes[j].getComponentType().isPrimitive()) continue;
            this.out.print("    if (arg" + j + " != NULL) ");
            if (methodInfo.valueGetter || methodInfo.valueSetter || methodInfo.memberGetter || methodInfo.memberSetter) {
                this.out.println("env->ReleasePrimitiveArrayCritical(arg" + j + ", ptr" + j + ", 0);");
                continue;
            }
            String s = methodInfo.parameterTypes[j].getComponentType().getName();
            String S = Character.toUpperCase(s.charAt(0)) + s.substring(1);
            this.out.println("env->Release" + S + "ArrayElements(arg" + j + ", (j" + s + "*)ptr" + j + ", 0);");
        }
    }

    void callback(Class<?> cls, Method callbackMethod, String callbackName, boolean needDefinition, MethodInformation methodInfo) {
        String[] typeName;
        Class<?> callbackReturnType = callbackMethod.getReturnType();
        Class<?>[] callbackParameterTypes = callbackMethod.getParameterTypes();
        Annotation[] callbackAnnotations = callbackMethod.getAnnotations();
        Annotation[][] callbackParameterAnnotations = callbackMethod.getParameterAnnotations();
        String instanceTypeName = Generator.functionClassName(cls);
        String[] callbackTypeName = this.cppFunctionTypeName(callbackMethod);
        String[] returnConvention = callbackTypeName[0].split("\\(");
        returnConvention[1] = Generator.constValueTypeName(returnConvention[1]);
        String parameterDeclaration = callbackTypeName[1].substring(1);
        String fieldName = Generator.mangle(callbackMethod.getName()) + "__" + Generator.mangle(Generator.signature(callbackMethod.getParameterTypes()));
        String firstLine = "";
        if (methodInfo != null) {
            String[] stringArray;
            if (methodInfo.returnRaw) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            } else {
                stringArray = this.cppTypeName(methodInfo.cls);
            }
            String[] typeName2 = stringArray;
            String valueTypeName = Generator.valueTypeName(typeName2);
            String subType = "JavaCPP_" + Generator.mangle(valueTypeName);
            LinkedList<String> memberList = this.virtualMembers.get(cls);
            if (memberList == null) {
                memberList = new LinkedList();
                this.virtualMembers.put(cls, memberList);
            }
            String member = "    ";
            if (methodInfo.allocator) {
                member = member + subType + parameterDeclaration + " : " + valueTypeName + "(";
                for (int j = 0; j < callbackParameterTypes.length; ++j) {
                    member = member + "arg" + j;
                    if (j >= callbackParameterTypes.length - 1) continue;
                    member = member + ", ";
                }
                member = member + "), obj(NULL) { }";
            } else {
                LinkedList<String> functionList = this.virtualFunctions.get(cls);
                if (functionList == null) {
                    functionList = new LinkedList();
                    this.virtualFunctions.put(cls, functionList);
                }
                member = member + "virtual " + returnConvention[0] + (returnConvention.length > 1 ? returnConvention[1] : "") + methodInfo.memberName[0] + parameterDeclaration + ";";
                firstLine = returnConvention[0] + (returnConvention.length > 1 ? returnConvention[1] : "") + subType + "::" + methodInfo.memberName[0] + parameterDeclaration + " {";
                functionList.add(fieldName);
                this.jclassesInit.index(cls);
            }
            memberList.add(member);
        } else {
            this.callbacks.index("static " + instanceTypeName + " " + callbackName + "_instance;");
            this.jclassesInit.index(cls);
            if (this.out2 != null) {
                this.out2.println("JNIIMPORT " + returnConvention[0] + (returnConvention.length > 1 ? returnConvention[1] : "") + callbackName + parameterDeclaration + ";");
            }
            this.out.println("JNIEXPORT " + returnConvention[0] + (returnConvention.length > 1 ? returnConvention[1] : "") + callbackName + parameterDeclaration + " {");
            this.out.print((callbackReturnType != Void.TYPE ? "    return " : "    ") + callbackName + "_instance(");
            for (int j = 0; j < callbackParameterTypes.length; ++j) {
                this.out.print("arg" + j);
                if (j >= callbackParameterTypes.length - 1) continue;
                this.out.print(", ");
            }
            this.out.println(");");
            this.out.println("}");
            firstLine = returnConvention[0] + instanceTypeName + "::operator()" + parameterDeclaration + " {";
        }
        if (!needDefinition) {
            return;
        }
        this.out.println(firstLine);
        String returnPrefix = "";
        if (callbackReturnType != Void.TYPE) {
            this.out.println("    " + Generator.jniTypeName(callbackReturnType) + " rarg = 0;");
            returnPrefix = "rarg = ";
            if (callbackReturnType == String.class) {
                returnPrefix = returnPrefix + "(jstring)";
            }
        }
        String callbackReturnCast = this.cast(callbackReturnType, callbackAnnotations);
        Annotation returnBy = this.by(callbackAnnotations);
        String[] returnTypeName = this.cppTypeName(callbackReturnType);
        String returnValueTypeName = Generator.valueTypeName(returnTypeName);
        AdapterInformation returnAdapterInfo = this.adapterInformation(false, returnValueTypeName, callbackAnnotations);
        this.out.println("    jthrowable exc = NULL;");
        this.out.println("    JNIEnv* env;");
        this.out.println("    bool attached = JavaCPP_getEnv(&env);");
        this.out.println("    if (env == NULL) {");
        this.out.println("        goto end;");
        this.out.println("    }");
        this.out.println("{");
        if (callbackParameterTypes.length > 0) {
            this.out.println("    jvalue args[" + callbackParameterTypes.length + "];");
            for (int j = 0; j < callbackParameterTypes.length; ++j) {
                String s;
                if (callbackParameterTypes[j].isPrimitive()) {
                    this.out.println("    args[" + j + "]." + Generator.signature(callbackParameterTypes[j]).toLowerCase() + " = (" + Generator.jniTypeName(callbackParameterTypes[j]) + ")arg" + j + ";");
                    continue;
                }
                Annotation passBy = this.by(callbackParameterAnnotations[j]);
                typeName = this.cppTypeName(callbackParameterTypes[j]);
                String valueTypeName = Generator.valueTypeName(typeName);
                AdapterInformation adapterInfo = this.adapterInformation(false, valueTypeName, callbackParameterAnnotations[j]);
                boolean needInit = false;
                if (adapterInfo != null) {
                    this.usesAdapters = true;
                    this.out.println("    " + adapterInfo.name + " adapter" + j + "(arg" + j + ");");
                    if (callbackParameterTypes[j] != String.class) {
                        this.out.println("    jint size" + j + " = (jint)adapter" + j + ".size;");
                        this.out.println("    void (*deallocator" + j + ")(void*) = &" + adapterInfo.name + "::deallocate;");
                    }
                    needInit = true;
                } else if (passBy instanceof ByVal && callbackParameterTypes[j] != Pointer.class || FunctionPointer.class.isAssignableFrom(callbackParameterTypes[j])) {
                    this.out.println("    jint size" + j + " = 1;");
                    this.out.println("    void (*deallocator" + j + ")(void*) = &JavaCPP_" + Generator.mangle(callbackParameterTypes[j].getName()) + "_deallocate;");
                    this.deallocators.index(callbackParameterTypes[j]);
                    needInit = true;
                }
                if (Pointer.class.isAssignableFrom(callbackParameterTypes[j]) || Buffer.class.isAssignableFrom(callbackParameterTypes[j]) || callbackParameterTypes[j].isArray() && callbackParameterTypes[j].getComponentType().isPrimitive()) {
                    String cast = "(" + typeName[0] + typeName[1] + ")";
                    if (FunctionPointer.class.isAssignableFrom(callbackParameterTypes[j])) {
                        this.functions.index(callbackParameterTypes[j]);
                        typeName[0] = Generator.functionClassName(callbackParameterTypes[j]) + "*";
                        typeName[1] = "";
                        valueTypeName = Generator.valueTypeName(typeName);
                    } else if (this.virtualFunctions.containsKey(callbackParameterTypes[j])) {
                        String subType;
                        valueTypeName = subType = "JavaCPP_" + Generator.mangle(valueTypeName);
                    }
                    this.out.println("    " + Generator.jniTypeName(callbackParameterTypes[j]) + " obj" + j + " = NULL;");
                    this.out.println("    " + typeName[0] + " ptr" + j + typeName[1] + " = NULL;");
                    if (FunctionPointer.class.isAssignableFrom(callbackParameterTypes[j])) {
                        this.out.println("    ptr" + j + " = new (std::nothrow) " + valueTypeName + ";");
                        this.out.println("    if (ptr" + j + " != NULL) {");
                        this.out.println("        ptr" + j + "->ptr = " + cast + "&arg" + j + ";");
                        this.out.println("    }");
                    } else if (adapterInfo != null) {
                        this.out.println("    ptr" + j + " = adapter" + j + ";");
                    } else if (passBy instanceof ByVal && callbackParameterTypes[j] != Pointer.class) {
                        this.out.println("    ptr" + j + (Generator.noException(callbackParameterTypes[j], callbackMethod) ? " = new (std::nothrow) " : " = new ") + valueTypeName + typeName[1] + "(*" + cast + "&arg" + j + ");");
                    } else if (passBy instanceof ByVal || passBy instanceof ByRef) {
                        this.out.println("    ptr" + j + " = " + cast + "&arg" + j + ";");
                    } else if (passBy instanceof ByPtrPtr) {
                        this.out.println("    if (arg" + j + " == NULL) {");
                        this.out.println("        JavaCPP_log(\"Pointer address of argument " + j + " is NULL in callback for " + cls.getCanonicalName() + ".\");");
                        this.out.println("    } else {");
                        this.out.println("        ptr" + j + " = " + cast + "*arg" + j + ";");
                        this.out.println("    }");
                    } else {
                        this.out.println("    ptr" + j + " = " + cast + "arg" + j + ";");
                    }
                }
                if (Pointer.class.isAssignableFrom(callbackParameterTypes[j])) {
                    s = "    obj" + j + " = JavaCPP_createPointer(env, " + this.jclasses.index(callbackParameterTypes[j]) + ");";
                    this.jclassesInit.index(callbackParameterTypes[j]);
                    adapterInfo = this.adapterInformation(true, valueTypeName, callbackParameterAnnotations[j]);
                    if (adapterInfo != null || passBy instanceof ByPtrPtr || passBy instanceof ByPtrRef) {
                        this.out.println(s);
                    } else {
                        this.out.println("    if (ptr" + j + " != NULL) { ");
                        this.out.println("    " + s);
                        this.out.println("    }");
                    }
                    this.out.println("    if (obj" + j + " != NULL) { ");
                    if (needInit) {
                        this.out.println("        JavaCPP_initPointer(env, obj" + j + ", ptr" + j + ", size" + j + ", deallocator" + j + ");");
                    } else {
                        this.out.println("        env->SetLongField(obj" + j + ", JavaCPP_addressFID, ptr_to_jlong(ptr" + j + "));");
                    }
                    this.out.println("    }");
                    this.out.println("    args[" + j + "].l = obj" + j + ";");
                    continue;
                }
                if (callbackParameterTypes[j] == String.class) {
                    this.out.println("    jstring obj" + j + " = (const char*)" + (adapterInfo != null ? "adapter" : "arg") + j + " == NULL ? NULL : env->NewStringUTF((const char*)" + (adapterInfo != null ? "adapter" : "arg") + j + ");");
                    this.out.println("    args[" + j + "].l = obj" + j + ";");
                    continue;
                }
                if (callbackParameterTypes[j].isArray() && callbackParameterTypes[j].getComponentType().isPrimitive()) {
                    if (adapterInfo == null) {
                        this.out.println("    jint size" + j + " = ptr" + j + " != NULL ? 1 : 0;");
                    }
                    s = callbackParameterTypes[j].getComponentType().getName();
                    String S = Character.toUpperCase(s.charAt(0)) + s.substring(1);
                    this.out.println("    if (ptr" + j + " != NULL) {");
                    this.out.println("        obj" + j + " = env->New" + S + "Array(size" + j + ");");
                    this.out.println("        env->Set" + S + "ArrayRegion(obj" + j + ", 0, size" + j + ", (j" + s + "*)ptr" + j + ");");
                    this.out.println("    }");
                    if (adapterInfo == null) continue;
                    this.out.println("    if (deallocator" + j + " != 0 && ptr" + j + " != NULL) {");
                    this.out.println("        (*(void(*)(void*))jlong_to_ptr(deallocator" + j + "))((void*)ptr" + j + ");");
                    this.out.println("    }");
                    continue;
                }
                if (Buffer.class.isAssignableFrom(callbackParameterTypes[j])) {
                    if (adapterInfo == null) {
                        this.out.println("    jint size" + j + " = ptr" + j + " != NULL ? 1 : 0;");
                    }
                    this.out.println("    if (ptr" + j + " != NULL) {");
                    this.out.println("        obj" + j + " = env->NewDirectByteBuffer((void*)ptr" + j + ", size" + j + ");");
                    this.out.println("    }");
                    continue;
                }
                this.logger.warn("Callback \"" + callbackMethod + "\" has unsupported parameter type \"" + callbackParameterTypes[j].getCanonicalName() + "\". Compilation will most likely fail.");
            }
        }
        if (methodInfo != null) {
            this.out.println("    if (" + fieldName + " == NULL) {");
            this.out.println("        " + fieldName + " = JavaCPP_getMethodID(env, " + this.jclasses.index(cls) + ", \"" + methodInfo.method.getName() + "\", \"(" + Generator.signature(methodInfo.method.getParameterTypes()) + ")" + Generator.signature(methodInfo.method.getReturnType()) + "\");");
            this.out.println("    }");
            this.out.println("    jmethodID mid = " + fieldName + ";");
        } else {
            this.out.println("    if (obj == NULL) {");
            this.out.println("        obj = env->NewGlobalRef(JavaCPP_createPointer(env, " + this.jclasses.index(cls) + "));");
            this.out.println("        if (obj == NULL) {");
            this.out.println("            JavaCPP_log(\"Error creating global reference of " + cls.getCanonicalName() + " instance for callback.\");");
            this.out.println("        } else {");
            this.out.println("            env->SetLongField(obj, JavaCPP_addressFID, ptr_to_jlong(this));");
            this.out.println("        }");
            this.out.println("        ptr = &" + callbackName + ";");
            this.out.println("    }");
            this.out.println("    if (mid == NULL) {");
            this.out.println("        mid = JavaCPP_getMethodID(env, " + this.jclasses.index(cls) + ", \"" + callbackMethod.getName() + "\", \"(" + Generator.signature(callbackMethod.getParameterTypes()) + ")" + Generator.signature(callbackMethod.getReturnType()) + "\");");
            this.out.println("    }");
        }
        this.out.println("    if (env->IsSameObject(obj, NULL)) {");
        this.out.println("        JavaCPP_log(\"Function pointer object is NULL in callback for " + cls.getCanonicalName() + ".\");");
        this.out.println("    } else if (mid == NULL) {");
        this.out.println("        JavaCPP_log(\"Error getting method ID of function caller \\\"" + callbackMethod + "\\\" for callback.\");");
        this.out.println("    } else {");
        String s = "Object";
        if (callbackReturnType.isPrimitive()) {
            s = callbackReturnType.getName();
            s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        this.out.println("        " + returnPrefix + "env->Call" + s + "MethodA(obj, mid, " + (callbackParameterTypes.length == 0 ? "NULL);" : "args);"));
        this.out.println("        if ((exc = env->ExceptionOccurred()) != NULL) {");
        this.out.println("            env->ExceptionClear();");
        this.out.println("        }");
        this.out.println("    }");
        for (int j = 0; j < callbackParameterTypes.length; ++j) {
            if (Pointer.class.isAssignableFrom(callbackParameterTypes[j])) {
                typeName = this.cppTypeName(callbackParameterTypes[j]);
                Annotation passBy = this.by(callbackParameterAnnotations[j]);
                String cast = this.cast(callbackParameterTypes[j], callbackParameterAnnotations[j]);
                String valueTypeName = Generator.valueTypeName(typeName);
                AdapterInformation adapterInfo = this.adapterInformation(true, valueTypeName, callbackParameterAnnotations[j]);
                if ("void*".equals(typeName[0]) && !callbackParameterTypes[j].isAnnotationPresent(Opaque.class)) {
                    typeName[0] = "char*";
                }
                if (adapterInfo != null || passBy instanceof ByPtrPtr || passBy instanceof ByPtrRef) {
                    this.out.println("    " + typeName[0] + " rptr" + j + typeName[1] + " = (" + typeName[0] + typeName[1] + ")jlong_to_ptr(env->GetLongField(obj" + j + ", JavaCPP_addressFID));");
                    if (adapterInfo != null) {
                        this.out.println("    jint rsize" + j + " = env->GetIntField(obj" + j + ", JavaCPP_limitFID);");
                    }
                    if (!callbackParameterTypes[j].isAnnotationPresent(Opaque.class)) {
                        this.out.println("    jint rposition" + j + " = env->GetIntField(obj" + j + ", JavaCPP_positionFID);");
                        this.out.println("    rptr" + j + " += rposition" + j + ";");
                        if (adapterInfo != null) {
                            this.out.println("    rsize" + j + " -= rposition" + j + ";");
                        }
                    }
                    if (adapterInfo != null) {
                        this.out.println("    adapter" + j + ".assign(rptr" + j + ", rsize" + j + ");");
                    } else if (passBy instanceof ByPtrPtr) {
                        this.out.println("    if (arg" + j + " != NULL) {");
                        this.out.println("        *arg" + j + " = *" + cast + "&rptr" + j + ";");
                        this.out.println("    }");
                    } else if (passBy instanceof ByPtrRef) {
                        this.out.println("    arg" + j + " = " + cast + "rptr" + j + ";");
                    }
                }
            }
            if (callbackParameterTypes[j].isPrimitive()) continue;
            this.out.println("    env->DeleteLocalRef(obj" + j + ");");
        }
        this.out.println("}");
        this.out.println("end:");
        if (callbackReturnType != Void.TYPE) {
            if ("void*".equals(returnTypeName[0]) && !callbackReturnType.isAnnotationPresent(Opaque.class)) {
                returnTypeName[0] = "char*";
            }
            if (Pointer.class.isAssignableFrom(callbackReturnType)) {
                this.out.println("    " + returnTypeName[0] + " rptr" + returnTypeName[1] + " = rarg == NULL ? NULL : (" + returnTypeName[0] + returnTypeName[1] + ")jlong_to_ptr(env->GetLongField(rarg, JavaCPP_addressFID));");
                if (returnAdapterInfo != null) {
                    this.out.println("    jint rsize = rarg == NULL ? 0 : env->GetIntField(rarg, JavaCPP_limitFID);");
                }
                if (!callbackReturnType.isAnnotationPresent(Opaque.class)) {
                    this.out.println("    jint rposition = rarg == NULL ? 0 : env->GetIntField(rarg, JavaCPP_positionFID);");
                    this.out.println("    rptr += rposition;");
                    if (returnAdapterInfo != null) {
                        this.out.println("    rsize -= rposition;");
                    }
                }
            } else if (callbackReturnType == String.class) {
                this.out.println("    " + returnTypeName[0] + " rptr" + returnTypeName[1] + " = rarg == NULL ? NULL : env->GetStringUTFChars(rarg, NULL);");
                if (returnAdapterInfo != null) {
                    this.out.println("    jint rsize = 0;");
                }
            } else if (Buffer.class.isAssignableFrom(callbackReturnType)) {
                this.out.println("    " + returnTypeName[0] + " rptr" + returnTypeName[1] + " = rarg == NULL ? NULL : env->GetDirectBufferAddress(rarg);");
                if (returnAdapterInfo != null) {
                    this.out.println("    jint rsize = rarg == NULL ? 0 : env->GetDirectBufferCapacity(rarg);");
                }
            } else if (!callbackReturnType.isPrimitive()) {
                this.logger.warn("Callback \"" + callbackMethod + "\" has unsupported return type \"" + callbackReturnType.getCanonicalName() + "\". Compilation will most likely fail.");
            }
        }
        this.out.println("    if (exc != NULL) {");
        this.out.println("        jstring str = (jstring)env->CallObjectMethod(exc, JavaCPP_toStringMID);");
        this.out.println("        env->DeleteLocalRef(exc);");
        this.out.println("        const char *msg = env->GetStringUTFChars(str, NULL);");
        this.out.println("        JavaCPP_exception e(msg);");
        this.out.println("        env->ReleaseStringUTFChars(str, msg);");
        this.out.println("        env->DeleteLocalRef(str);");
        this.out.println("        JavaCPP_detach(attached);");
        this.out.println("        throw e;");
        this.out.println("    } else {");
        this.out.println("        JavaCPP_detach(attached);");
        this.out.println("    }");
        if (callbackReturnType != Void.TYPE) {
            if (callbackReturnType.isPrimitive()) {
                this.out.println("    return " + callbackReturnCast + "rarg;");
            } else if (returnAdapterInfo != null) {
                this.usesAdapters = true;
                this.out.println("    return " + returnAdapterInfo.name + "(" + callbackReturnCast + "rptr, rsize);");
            } else if (FunctionPointer.class.isAssignableFrom(callbackReturnType)) {
                this.functions.index(callbackReturnType);
                this.out.println("    return " + callbackReturnCast + "(rptr == NULL ? NULL : rptr->ptr);");
            } else if (returnBy instanceof ByVal || returnBy instanceof ByRef) {
                this.out.println("    if (rptr == NULL) {");
                this.out.println("        JavaCPP_log(\"Return pointer address is NULL in callback for " + cls.getCanonicalName() + ".\");");
                this.out.println("        static " + returnValueTypeName + " empty" + returnTypeName[1] + ";");
                this.out.println("        return empty;");
                this.out.println("    } else {");
                this.out.println("        return *" + callbackReturnCast + "rptr;");
                this.out.println("    }");
            } else if (returnBy instanceof ByPtrPtr) {
                this.out.println("    return " + callbackReturnCast + "&rptr;");
            } else {
                this.out.println("    return " + callbackReturnCast + "rptr;");
            }
        }
        this.out.println("}");
    }

    void callbackAllocator(Class cls, String callbackName) {
        String instanceTypeName = Generator.functionClassName(cls);
        this.out.println("    obj = env->NewWeakGlobalRef(obj);");
        this.out.println("    if (obj == NULL) {");
        this.out.println("        JavaCPP_log(\"Error creating global reference of " + cls.getCanonicalName() + " instance for callback.\");");
        this.out.println("        return;");
        this.out.println("    }");
        this.out.println("    " + instanceTypeName + "* rptr = new (std::nothrow) " + instanceTypeName + ";");
        this.out.println("    if (rptr != NULL) {");
        this.out.println("        rptr->ptr = &" + callbackName + ";");
        this.out.println("        rptr->obj = obj;");
        this.out.println("        JavaCPP_initPointer(env, obj, rptr, 1, &JavaCPP_" + Generator.mangle(cls.getName()) + "_deallocate);");
        this.deallocators.index(cls);
        this.out.println("        " + callbackName + "_instance = *rptr;");
        this.out.println("    }");
        this.out.println("}");
    }

    boolean checkPlatform(Class<?> cls) {
        while (!cls.isAnnotationPresent(Properties.class) && !cls.isAnnotationPresent(Platform.class) && cls.getSuperclass() != null) {
            cls = cls.getSuperclass();
        }
        Properties classProperties = cls.getAnnotation(Properties.class);
        if (classProperties != null) {
            Platform[] platforms;
            Class[] classes = classProperties.inherit();
            if (classes != null) {
                for (Class c : classes) {
                    if (!this.checkPlatform(c)) continue;
                    return true;
                }
            }
            if ((platforms = classProperties.value()) != null) {
                for (Platform p : platforms) {
                    if (!this.checkPlatform(p)) continue;
                    return true;
                }
            }
        } else if (this.checkPlatform(cls.getAnnotation(Platform.class))) {
            return true;
        }
        return false;
    }

    boolean checkPlatform(Platform platform) {
        if (platform == null) {
            return true;
        }
        String platform2 = this.properties.getProperty("platform");
        String[][] names = new String[][]{platform.value(), platform.not()};
        boolean[] matches = new boolean[]{false, false};
        block0: for (int i = 0; i < names.length; ++i) {
            for (String s : names[i]) {
                if (!platform2.startsWith(s)) continue;
                matches[i] = true;
                continue block0;
            }
        }
        return !(names[0].length != 0 && !matches[0] || names[1].length != 0 && matches[1]);
    }

    static String functionClassName(Class<?> cls) {
        Name name = cls.getAnnotation(Name.class);
        return name != null ? name.value()[0] : "JavaCPP_" + Generator.mangle(cls.getName());
    }

    static Method functionMethod(Class<?> cls, boolean[] callbackAllocators) {
        if (!FunctionPointer.class.isAssignableFrom(cls)) {
            return null;
        }
        Method[] methods = cls.getDeclaredMethods();
        Method functionMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            int modifiers = methods[i].getModifiers();
            Class<?>[] parameterTypes = methods[i].getParameterTypes();
            Class<?> returnType = methods[i].getReturnType();
            if (Modifier.isStatic(modifiers)) continue;
            if (callbackAllocators != null && methodName.startsWith("allocate") && Modifier.isNative(modifiers) && returnType == Void.TYPE && parameterTypes.length == 0) {
                callbackAllocators[i] = true;
                continue;
            }
            if (!methodName.startsWith("call") && !methodName.startsWith("apply")) continue;
            functionMethod = methods[i];
        }
        return functionMethod;
    }

    MethodInformation methodInformation(Method method) {
        String[] stringArray;
        MethodInformation info = new MethodInformation();
        info.cls = method.getDeclaringClass();
        info.method = method;
        info.annotations = method.getAnnotations();
        info.modifiers = method.getModifiers();
        info.returnType = method.getReturnType();
        info.name = method.getName();
        Name name = method.getAnnotation(Name.class);
        if (name != null) {
            stringArray = name.value();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = info.name;
        }
        info.memberName = stringArray;
        Index index = method.getAnnotation(Index.class);
        info.dim = index != null ? index.value() : 0;
        info.parameterTypes = method.getParameterTypes();
        info.parameterAnnotations = method.getParameterAnnotations();
        info.returnRaw = method.isAnnotationPresent(Raw.class);
        info.withEnv = info.returnRaw ? method.getAnnotation(Raw.class).withEnv() : false;
        info.parameterRaw = new boolean[info.parameterAnnotations.length];
        for (int i = 0; i < info.parameterAnnotations.length; ++i) {
            for (int j = 0; j < info.parameterAnnotations[i].length; ++j) {
                if (!(info.parameterAnnotations[i][j] instanceof Raw)) continue;
                info.parameterRaw[i] = true;
                info.withEnv |= ((Raw)info.parameterAnnotations[i][j]).withEnv();
            }
        }
        boolean canBeGetter = info.returnType != Void.TYPE || info.parameterTypes.length > 0 && info.parameterTypes[0].isArray() && info.parameterTypes[0].getComponentType().isPrimitive();
        boolean canBeSetter = (info.returnType == Void.TYPE || info.returnType == info.cls) && info.parameterTypes.length > 0;
        boolean canBeAllocator = !Modifier.isStatic(info.modifiers) && info.returnType == Void.TYPE;
        boolean canBeArrayAllocator = canBeAllocator && info.parameterTypes.length == 1 && (info.parameterTypes[0] == Integer.TYPE || info.parameterTypes[0] == Long.TYPE);
        boolean valueGetter = false;
        boolean valueSetter = false;
        boolean memberGetter = false;
        boolean memberSetter = false;
        boolean noReturnGetter = false;
        Method pairedMethod = null;
        for (Method method2 : info.cls.getDeclaredMethods()) {
            boolean parameterAsReturn2;
            int skipParameters2;
            int modifiers2 = method2.getModifiers();
            Class<?> returnType2 = method2.getReturnType();
            String methodName2 = method2.getName();
            Class<?>[] parameterTypes2 = method2.getParameterTypes();
            Object[] annotations2 = method2.getAnnotations();
            Annotation[][] parameterAnnotations2 = method2.getParameterAnnotations();
            int skipParameters = info.parameterTypes.length > 0 && info.parameterTypes[0] == Class.class ? 1 : 0;
            int n = skipParameters2 = parameterTypes2.length > 0 && parameterTypes2[0] == Class.class ? 1 : 0;
            if (method.equals(method2) || !Modifier.isNative(modifiers2)) continue;
            boolean canBeValueGetter = false;
            boolean canBeValueSetter = false;
            boolean canBeMemberGetter = false;
            boolean canBeMemberSetter = false;
            if (canBeGetter && "get".equals(info.name) && "put".equals(methodName2)) {
                canBeValueGetter = true;
            } else if (canBeSetter && "put".equals(info.name) && "get".equals(methodName2)) {
                canBeValueSetter = true;
            } else {
                if (!methodName2.equals(info.name)) continue;
                info.overloaded = true;
                canBeMemberGetter = canBeGetter;
                canBeMemberSetter = canBeSetter;
                for (int j = skipParameters; j < info.parameterTypes.length; ++j) {
                    if (info.parameterTypes[j] == Integer.TYPE || info.parameterTypes[j] == Long.TYPE) continue;
                    canBeMemberGetter = false;
                    if (j >= info.parameterTypes.length - 1) continue;
                    canBeMemberSetter = false;
                }
            }
            boolean sameIndexParameters = true;
            for (int j = 0; j < info.parameterTypes.length - skipParameters && j < parameterTypes2.length - skipParameters2; ++j) {
                if (info.parameterTypes[j + skipParameters] == parameterTypes2[j + skipParameters2]) continue;
                sameIndexParameters = false;
            }
            if (!sameIndexParameters) continue;
            boolean parameterAsReturn = canBeValueGetter && info.parameterTypes.length > 0 && info.parameterTypes[0].isArray() && info.parameterTypes[0].getComponentType().isPrimitive();
            boolean bl = parameterAsReturn2 = canBeValueSetter && parameterTypes2.length > 0 && parameterTypes2[0].isArray() && parameterTypes2[0].getComponentType().isPrimitive();
            if (canBeGetter && parameterTypes2.length - (parameterAsReturn ? 0 : 1) == info.parameterTypes.length - skipParameters && (parameterAsReturn ? info.parameterTypes[info.parameterTypes.length - 1] : info.returnType) == parameterTypes2[parameterTypes2.length - 1] && (returnType2 == Void.TYPE || returnType2 == info.cls) && (parameterAnnotations2[parameterAnnotations2.length - 1].length == 0 || Arrays.equals(parameterAnnotations2[parameterAnnotations2.length - 1], info.annotations))) {
                pairedMethod = method2;
                valueGetter = canBeValueGetter;
                memberGetter = canBeMemberGetter;
                noReturnGetter = parameterAsReturn;
                continue;
            }
            if (!canBeSetter || info.parameterTypes.length - (parameterAsReturn2 ? 0 : 1) != parameterTypes2.length - skipParameters2 || (parameterAsReturn2 ? parameterTypes2[parameterTypes2.length - 1] : returnType2) != info.parameterTypes[info.parameterTypes.length - 1] || info.returnType != Void.TYPE && info.returnType != info.cls || info.parameterAnnotations[info.parameterAnnotations.length - 1].length != 0 && !Arrays.equals(info.parameterAnnotations[info.parameterAnnotations.length - 1], annotations2)) continue;
            pairedMethod = method2;
            valueSetter = canBeValueSetter;
            memberSetter = canBeMemberSetter;
        }
        Annotation behavior = this.behavior(info.annotations);
        if (canBeGetter && behavior instanceof ValueGetter) {
            info.valueGetter = true;
            info.noReturnGetter = noReturnGetter;
        } else if (canBeSetter && behavior instanceof ValueSetter) {
            info.valueSetter = true;
        } else if (canBeGetter && behavior instanceof MemberGetter) {
            info.memberGetter = true;
            info.noReturnGetter = noReturnGetter;
        } else if (canBeSetter && behavior instanceof MemberSetter) {
            info.memberSetter = true;
        } else if (canBeAllocator && behavior instanceof Allocator) {
            info.allocator = true;
        } else if (canBeArrayAllocator && behavior instanceof ArrayAllocator) {
            info.arrayAllocator = true;
            info.allocator = true;
        } else if (behavior == null) {
            if (info.returnType == Void.TYPE && "deallocate".equals(info.name) && !Modifier.isStatic(info.modifiers) && info.parameterTypes.length == 2 && info.parameterTypes[0] == Long.TYPE && info.parameterTypes[1] == Long.TYPE) {
                info.deallocator = true;
            } else if (canBeAllocator && "allocate".equals(info.name)) {
                info.allocator = true;
            } else if (canBeArrayAllocator && "allocateArray".equals(info.name)) {
                info.arrayAllocator = true;
                info.allocator = true;
            } else if (info.returnType.isAssignableFrom(ByteBuffer.class) && "asDirectBuffer".equals(info.name) && !Modifier.isStatic(info.modifiers) && info.parameterTypes.length == 0) {
                info.bufferGetter = true;
            } else if (valueGetter) {
                info.valueGetter = true;
                info.noReturnGetter = noReturnGetter;
                info.pairedMethod = pairedMethod;
            } else if (valueSetter) {
                info.valueSetter = true;
                info.pairedMethod = pairedMethod;
            } else if (memberGetter) {
                info.memberGetter = true;
                info.noReturnGetter = noReturnGetter;
                info.pairedMethod = pairedMethod;
            } else if (memberSetter) {
                info.memberSetter = true;
                info.pairedMethod = pairedMethod;
            }
        } else if (!(behavior instanceof Function)) {
            this.logger.warn("Method \"" + method + "\" cannot behave like a \"" + behavior.annotationType().getSimpleName() + "\". No code will be generated.");
            return null;
        }
        if (name == null && info.pairedMethod != null && (name = info.pairedMethod.getAnnotation(Name.class)) != null) {
            info.memberName = name.value();
        }
        boolean bl = info.noOffset = info.cls.isAnnotationPresent(NoOffset.class) || method.isAnnotationPresent(NoOffset.class) || method.isAnnotationPresent(Index.class);
        if (!info.noOffset && info.pairedMethod != null) {
            boolean bl2 = info.noOffset = info.pairedMethod.isAnnotationPresent(NoOffset.class) || info.pairedMethod.isAnnotationPresent(Index.class);
        }
        if (info.parameterTypes.length == 0 || !info.parameterTypes[0].isArray()) {
            if (info.valueGetter || info.memberGetter) {
                info.dim = info.parameterTypes.length;
            } else if (info.memberSetter || info.valueSetter) {
                info.dim = info.parameterTypes.length - 1;
            }
        }
        info.throwsException = null;
        if (!(Generator.noException(info.cls, method) || (!(this.by(info.annotations) instanceof ByVal) || Generator.noException(info.returnType, method)) && (info.deallocator || info.valueGetter || info.valueSetter || info.memberGetter || info.memberSetter || info.bufferGetter))) {
            Class<?>[] exceptions = method.getExceptionTypes();
            info.throwsException = exceptions.length > 0 ? exceptions[0] : RuntimeException.class;
        }
        return info;
    }

    static boolean noException(Class<?> cls, Method method) {
        boolean noException;
        boolean bl = noException = baseClasses.contains(cls) || method.isAnnotationPresent(NoException.class);
        while (!noException && cls != null && !(noException = cls.isAnnotationPresent(NoException.class))) {
            cls = cls.getDeclaringClass();
        }
        return noException;
    }

    AdapterInformation adapterInformation(boolean out, MethodInformation methodInfo, int j) {
        String valueTypeName;
        AdapterInformation adapter;
        if (out && (methodInfo.parameterTypes[j] == String.class || methodInfo.valueSetter || methodInfo.memberSetter)) {
            return null;
        }
        String typeName = this.cast(methodInfo, j);
        if (typeName != null && typeName.startsWith("(") && typeName.endsWith(")")) {
            typeName = typeName.substring(1, typeName.length() - 1);
        }
        if (typeName == null || typeName.length() == 0) {
            typeName = this.cppCastTypeName(methodInfo.parameterTypes[j], methodInfo.parameterAnnotations[j])[0];
        }
        if ((adapter = this.adapterInformation(out, valueTypeName = Generator.valueTypeName(typeName), methodInfo.parameterAnnotations[j])) == null && methodInfo.pairedMethod != null && j == methodInfo.parameterTypes.length - 1 && (methodInfo.valueSetter || methodInfo.memberSetter)) {
            adapter = this.adapterInformation(out, valueTypeName, methodInfo.pairedMethod.getAnnotations());
        }
        return adapter;
    }

    AdapterInformation adapterInformation(boolean out, String valueTypeName, Annotation ... annotations) {
        AdapterInformation adapterInfo = null;
        boolean constant = false;
        String cast = "";
        for (Annotation a : annotations) {
            Cast c;
            Adapter adapter;
            Adapter adapter2 = adapter = a instanceof Adapter ? (Adapter)a : a.annotationType().getAnnotation(Adapter.class);
            if (adapter != null) {
                adapterInfo = new AdapterInformation();
                adapterInfo.name = adapter.value();
                adapterInfo.argc = adapter.argc();
                if (a == adapter) continue;
                try {
                    Class<? extends Annotation> cls = a.annotationType();
                    if (cls.isAnnotationPresent(Const.class)) {
                        constant = true;
                    }
                    try {
                        String value = cls.getDeclaredMethod("value", new Class[0]).invoke((Object)a, new Object[0]).toString();
                        if (value != null && value.length() > 0) {
                            valueTypeName = value;
                        }
                    }
                    catch (NoSuchMethodException e) {
                        valueTypeName = null;
                    }
                    Cast c2 = cls.getAnnotation(Cast.class);
                    if (c2 != null && cast.length() == 0) {
                        cast = c2.value()[0];
                        if (valueTypeName != null) {
                            cast = cast + "< " + valueTypeName + " >";
                        }
                        if (c2.value().length > 1) {
                            cast = cast + c2.value()[1];
                        }
                    }
                }
                catch (Exception ex) {
                    this.logger.warn("Could not invoke the value() method on annotation \"" + a + "\": " + ex);
                }
                if (valueTypeName == null || valueTypeName.length() <= 0) continue;
                adapterInfo.name = adapterInfo.name + "< " + valueTypeName + " >";
                continue;
            }
            if (a instanceof Const) {
                constant = true;
                continue;
            }
            if (!(a instanceof Cast) || (c = (Cast)a).value().length <= 1) continue;
            cast = c.value()[1];
        }
        if (adapterInfo != null) {
            adapterInfo.cast = cast;
            adapterInfo.constant = constant;
        }
        return out && constant ? null : adapterInfo;
    }

    String cast(MethodInformation methodInfo, int j) {
        String cast = this.cast(methodInfo.parameterTypes[j], methodInfo.parameterAnnotations[j]);
        if ((cast == null || cast.length() == 0) && j == methodInfo.parameterTypes.length - 1 && (methodInfo.valueSetter || methodInfo.memberSetter) && methodInfo.pairedMethod != null) {
            cast = this.cast(methodInfo.pairedMethod.getReturnType(), methodInfo.pairedMethod.getAnnotations());
        }
        return cast;
    }

    String cast(Class<?> type, Annotation ... annotations) {
        String[] typeName = null;
        for (Annotation a : annotations) {
            if ((!(a instanceof Cast) || ((Cast)a).value()[0].length() <= 0) && !(a instanceof Const)) continue;
            typeName = this.cppCastTypeName(type, annotations);
            break;
        }
        return typeName != null && typeName.length > 0 ? "(" + (String)typeName[0] + typeName[1] + ")" : "";
    }

    Annotation by(MethodInformation methodInfo, int j) {
        Annotation passBy = this.by(methodInfo.parameterAnnotations[j]);
        if (passBy == null && methodInfo.pairedMethod != null && (methodInfo.valueSetter || methodInfo.memberSetter)) {
            passBy = this.by(methodInfo.pairedMethod.getAnnotations());
        }
        return passBy;
    }

    Annotation by(Annotation ... annotations) {
        Annotation byAnnotation = null;
        for (Annotation a : annotations) {
            if (!(a instanceof ByPtr) && !(a instanceof ByPtrPtr) && !(a instanceof ByPtrRef) && !(a instanceof ByRef) && !(a instanceof ByVal)) continue;
            if (byAnnotation != null) {
                this.logger.warn("\"By\" annotation \"" + byAnnotation + "\" already found. Ignoring superfluous annotation \"" + a + "\".");
                continue;
            }
            byAnnotation = a;
        }
        return byAnnotation;
    }

    Annotation behavior(Annotation ... annotations) {
        Annotation behaviorAnnotation = null;
        for (Annotation a : annotations) {
            if (!(a instanceof Function) && !(a instanceof Allocator) && !(a instanceof ArrayAllocator) && !(a instanceof ValueSetter) && !(a instanceof ValueGetter) && !(a instanceof MemberGetter) && !(a instanceof MemberSetter)) continue;
            if (behaviorAnnotation != null) {
                this.logger.warn("Behavior annotation \"" + behaviorAnnotation + "\" already found. Ignoring superfluous annotation \"" + a + "\".");
                continue;
            }
            behaviorAnnotation = a;
        }
        return behaviorAnnotation;
    }

    static String constValueTypeName(String ... typeName) {
        String type = typeName[0];
        if (type.endsWith("*") || type.endsWith("&")) {
            type = type.substring(0, type.length() - 1);
        }
        return type;
    }

    static String valueTypeName(String ... typeName) {
        String type = typeName[0];
        if (type.startsWith("const ")) {
            type = type.substring(6, type.length() - 1);
        } else if (type.endsWith("*") || type.endsWith("&")) {
            type = type.substring(0, type.length() - 1);
        }
        return type;
    }

    String[] cppAnnotationTypeName(Class<?> type, Annotation ... annotations) {
        Annotation by;
        String[] typeName = this.cppCastTypeName(type, annotations);
        String prefix = typeName[0];
        String suffix = typeName[1];
        boolean casted = false;
        for (Annotation a : annotations) {
            if ((!(a instanceof Cast) || ((Cast)a).value()[0].length() <= 0) && !(a instanceof Const)) continue;
            casted = true;
            break;
        }
        if ((by = this.by(annotations)) instanceof ByVal) {
            prefix = Generator.constValueTypeName(typeName);
        } else if (by instanceof ByRef) {
            prefix = Generator.constValueTypeName(typeName) + "&";
        } else if (by instanceof ByPtrPtr && !casted) {
            prefix = prefix + "*";
        } else if (by instanceof ByPtrRef) {
            prefix = prefix + "&";
        }
        typeName[0] = prefix;
        typeName[1] = suffix;
        return typeName;
    }

    String[] cppCastTypeName(Class<?> type, Annotation ... annotations) {
        String[] typeName = null;
        boolean warning = false;
        boolean adapter = false;
        for (Annotation a : annotations) {
            if (a instanceof Cast) {
                String[] stringArray;
                warning = typeName != null;
                String prefix = ((Cast)a).value()[0];
                String suffix = "";
                int parenthesis = prefix.indexOf(41);
                if (parenthesis > 0) {
                    suffix = prefix.substring(parenthesis).trim();
                    prefix = prefix.substring(0, parenthesis).trim();
                }
                if (prefix.length() > 0) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = prefix;
                    stringArray = stringArray2;
                    stringArray2[1] = suffix;
                } else {
                    stringArray = null;
                }
                typeName = stringArray;
                continue;
            }
            if (a instanceof Const) {
                Annotation by;
                warning = typeName != null;
                if (warning) continue;
                typeName = this.cppTypeName(type);
                boolean[] b = ((Const)a).value();
                if (b.length > 1 && b[1]) {
                    typeName[0] = Generator.valueTypeName(typeName) + " const *";
                }
                if (b.length > 0 && b[0]) {
                    typeName[0] = "const " + typeName[0];
                }
                if ((by = this.by(annotations)) instanceof ByPtrPtr) {
                    typeName[0] = typeName[0] + "*";
                    continue;
                }
                if (!(by instanceof ByPtrRef)) continue;
                typeName[0] = typeName[0] + "&";
                continue;
            }
            if (!(a instanceof Adapter) && !a.annotationType().isAnnotationPresent(Adapter.class)) continue;
            adapter = true;
        }
        if (warning && !adapter) {
            this.logger.warn("Without \"Adapter\", \"Cast\" and \"Const\" annotations are mutually exclusive.");
        }
        if (typeName == null) {
            typeName = this.cppTypeName(type);
        }
        return typeName;
    }

    String[] cppTypeName(Class<?> type) {
        String prefix = "";
        String suffix = "";
        if (type == Buffer.class || type == Pointer.class) {
            prefix = "void*";
        } else if (type == byte[].class || type == ByteBuffer.class || type == BytePointer.class) {
            prefix = "signed char*";
        } else if (type == short[].class || type == ShortBuffer.class || type == ShortPointer.class) {
            prefix = "short*";
        } else if (type == int[].class || type == IntBuffer.class || type == IntPointer.class) {
            prefix = "int*";
        } else if (type == long[].class || type == LongBuffer.class || type == LongPointer.class) {
            prefix = "jlong*";
        } else if (type == float[].class || type == FloatBuffer.class || type == FloatPointer.class) {
            prefix = "float*";
        } else if (type == double[].class || type == DoubleBuffer.class || type == DoublePointer.class) {
            prefix = "double*";
        } else if (type == char[].class || type == CharBuffer.class || type == CharPointer.class) {
            prefix = "unsigned short*";
        } else if (type == boolean[].class) {
            prefix = "unsigned char*";
        } else if (type == PointerPointer.class) {
            prefix = "void**";
        } else if (type == String.class) {
            prefix = "const char*";
        } else if (type == Byte.TYPE) {
            prefix = "signed char";
        } else if (type == Long.TYPE) {
            prefix = "jlong";
        } else if (type == Character.TYPE) {
            prefix = "unsigned short";
        } else if (type == Boolean.TYPE) {
            prefix = "unsigned char";
        } else if (type.isPrimitive()) {
            prefix = type.getName();
        } else if (FunctionPointer.class.isAssignableFrom(type)) {
            Method functionMethod = Generator.functionMethod(type, null);
            if (functionMethod != null) {
                return this.cppFunctionTypeName(functionMethod);
            }
        } else {
            String scopedType = Generator.cppScopeName(type);
            if (scopedType.length() > 0) {
                prefix = scopedType + "*";
            } else {
                this.logger.warn("The class " + type.getCanonicalName() + " does not map to any C++ type. Compilation will most likely fail.");
            }
        }
        return new String[]{prefix, suffix};
    }

    String[] cppFunctionTypeName(Method functionMethod) {
        int j;
        String spaceName;
        String prefix = "";
        String suffix = "";
        Class<?> type = functionMethod.getDeclaringClass();
        Convention convention = type.getAnnotation(Convention.class);
        String callingConvention = convention == null ? "" : convention.value() + " ";
        Namespace namespace = type.getAnnotation(Namespace.class);
        String string = spaceName = namespace == null ? "" : namespace.value();
        if (spaceName.length() > 0 && !spaceName.endsWith("::")) {
            spaceName = spaceName + "::";
        }
        Class<?> returnType = functionMethod.getReturnType();
        Class<?>[] parameterTypes = functionMethod.getParameterTypes();
        Annotation[] annotations = functionMethod.getAnnotations();
        Annotation[][] parameterAnnotations = functionMethod.getParameterAnnotations();
        String[] returnTypeName = this.cppAnnotationTypeName(returnType, annotations);
        AdapterInformation returnAdapterInfo = this.adapterInformation(false, Generator.valueTypeName(returnTypeName), annotations);
        prefix = returnAdapterInfo != null && returnAdapterInfo.cast.length() > 0 ? returnAdapterInfo.cast : returnTypeName[0] + returnTypeName[1];
        prefix = prefix + " (" + callingConvention + spaceName + "*";
        suffix = ")(";
        if (FunctionPointer.class.isAssignableFrom(type) && namespace != null && (parameterTypes.length == 0 || !Pointer.class.isAssignableFrom(parameterTypes[0]))) {
            this.logger.warn("First parameter of caller method call() or apply() for member function pointer " + type.getCanonicalName() + " is not a Pointer. Compilation will most likely fail.");
        }
        int n = j = namespace == null ? 0 : 1;
        while (j < parameterTypes.length) {
            String[] paramTypeName = this.cppAnnotationTypeName(parameterTypes[j], parameterAnnotations[j]);
            AdapterInformation paramAdapterInfo = this.adapterInformation(false, Generator.valueTypeName(paramTypeName), parameterAnnotations[j]);
            suffix = paramAdapterInfo != null && paramAdapterInfo.cast.length() > 0 ? suffix + paramAdapterInfo.cast + " arg" + j : suffix + paramTypeName[0] + " arg" + j + paramTypeName[1];
            if (j < parameterTypes.length - 1) {
                suffix = suffix + ", ";
            }
            ++j;
        }
        suffix = suffix + ")";
        if (type.isAnnotationPresent(Const.class)) {
            suffix = suffix + " const";
        }
        return new String[]{prefix, suffix};
    }

    static String cppScopeName(MethodInformation methodInfo) {
        Namespace namespace;
        String spaceName;
        String scopeName = Generator.cppScopeName(methodInfo.cls);
        if (methodInfo.method.isAnnotationPresent(Virtual.class)) {
            String subType;
            scopeName = subType = "JavaCPP_" + Generator.mangle(scopeName);
        }
        String string = spaceName = (namespace = methodInfo.method.getAnnotation(Namespace.class)) == null ? "" : namespace.value();
        if (namespace != null && namespace.value().length() == 0 || spaceName.startsWith("::")) {
            scopeName = "";
        }
        if (scopeName.length() > 0 && !scopeName.endsWith("::")) {
            scopeName = scopeName + "::";
        }
        scopeName = scopeName + spaceName;
        if (spaceName.length() > 0 && !spaceName.endsWith("::")) {
            scopeName = scopeName + "::";
        }
        return scopeName + methodInfo.memberName[0];
    }

    static String cppScopeName(Class<?> type) {
        String scopeName = "";
        while (type != null) {
            String spaceName;
            Namespace namespace = type.getAnnotation(Namespace.class);
            String string = spaceName = namespace == null ? "" : namespace.value();
            if (Pointer.class.isAssignableFrom(type) && type != Pointer.class) {
                String s;
                Name name = type.getAnnotation(Name.class);
                if (name == null) {
                    s = type.getName();
                    int i = s.lastIndexOf("$");
                    if (i < 0) {
                        i = s.lastIndexOf(".");
                    }
                    s = s.substring(i + 1);
                } else {
                    s = name.value()[0];
                }
                if (spaceName.length() > 0 && !spaceName.endsWith("::")) {
                    spaceName = spaceName + "::";
                }
                spaceName = spaceName + s;
            }
            if (scopeName.length() > 0 && !spaceName.endsWith("::")) {
                spaceName = spaceName + "::";
            }
            scopeName = spaceName + scopeName;
            if (namespace != null && namespace.value().length() == 0 || spaceName.startsWith("::")) break;
            type = type.getDeclaringClass();
        }
        return scopeName;
    }

    static String jniTypeName(Class type) {
        if (type == Byte.TYPE) {
            return "jbyte";
        }
        if (type == Short.TYPE) {
            return "jshort";
        }
        if (type == Integer.TYPE) {
            return "jint";
        }
        if (type == Long.TYPE) {
            return "jlong";
        }
        if (type == Float.TYPE) {
            return "jfloat";
        }
        if (type == Double.TYPE) {
            return "jdouble";
        }
        if (type == Character.TYPE) {
            return "jchar";
        }
        if (type == Boolean.TYPE) {
            return "jboolean";
        }
        if (type == byte[].class) {
            return "jbyteArray";
        }
        if (type == short[].class) {
            return "jshortArray";
        }
        if (type == int[].class) {
            return "jintArray";
        }
        if (type == long[].class) {
            return "jlongArray";
        }
        if (type == float[].class) {
            return "jfloatArray";
        }
        if (type == double[].class) {
            return "jdoubleArray";
        }
        if (type == char[].class) {
            return "jcharArray";
        }
        if (type == boolean[].class) {
            return "jbooleanArray";
        }
        if (type.isArray()) {
            return "jobjectArray";
        }
        if (type == String.class) {
            return "jstring";
        }
        if (type == Class.class) {
            return "jclass";
        }
        if (type == Void.TYPE) {
            return "void";
        }
        return "jobject";
    }

    static String signature(Class ... types) {
        StringBuilder signature = new StringBuilder(2 * types.length);
        for (Class type : types) {
            if (type == Byte.TYPE) {
                signature.append("B");
                continue;
            }
            if (type == Short.TYPE) {
                signature.append("S");
                continue;
            }
            if (type == Integer.TYPE) {
                signature.append("I");
                continue;
            }
            if (type == Long.TYPE) {
                signature.append("J");
                continue;
            }
            if (type == Float.TYPE) {
                signature.append("F");
                continue;
            }
            if (type == Double.TYPE) {
                signature.append("D");
                continue;
            }
            if (type == Boolean.TYPE) {
                signature.append("Z");
                continue;
            }
            if (type == Character.TYPE) {
                signature.append("C");
                continue;
            }
            if (type == Void.TYPE) {
                signature.append("V");
                continue;
            }
            if (type.isArray()) {
                signature.append(type.getName().replace('.', '/'));
                continue;
            }
            signature.append("L").append(type.getName().replace('.', '/')).append(";");
        }
        return signature.toString();
    }

    static String mangle(String name) {
        StringBuilder mangledName = new StringBuilder(2 * name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                mangledName.append(c);
                continue;
            }
            if (c == '_') {
                mangledName.append("_1");
                continue;
            }
            if (c == ';') {
                mangledName.append("_2");
                continue;
            }
            if (c == '[') {
                mangledName.append("_3");
                continue;
            }
            if (c == '.' || c == '/') {
                mangledName.append("_");
                continue;
            }
            String code = Integer.toHexString(c);
            mangledName.append("_0");
            switch (code.length()) {
                case 1: {
                    mangledName.append("0");
                }
                case 2: {
                    mangledName.append("0");
                }
                case 3: {
                    mangledName.append("0");
                }
            }
            mangledName.append(code);
        }
        return mangledName.toString();
    }
}

