/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.tools.Attribute;
import org.bytedeco.javacpp.tools.Context;
import org.bytedeco.javacpp.tools.Declaration;
import org.bytedeco.javacpp.tools.DeclarationList;
import org.bytedeco.javacpp.tools.Declarator;
import org.bytedeco.javacpp.tools.Generator;
import org.bytedeco.javacpp.tools.Info;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.InfoMapper;
import org.bytedeco.javacpp.tools.Logger;
import org.bytedeco.javacpp.tools.Parameters;
import org.bytedeco.javacpp.tools.ParserException;
import org.bytedeco.javacpp.tools.TemplateMap;
import org.bytedeco.javacpp.tools.Token;
import org.bytedeco.javacpp.tools.TokenIndexer;
import org.bytedeco.javacpp.tools.Tokenizer;
import org.bytedeco.javacpp.tools.Type;

public class Parser {
    final Logger logger;
    final Properties properties;
    InfoMap infoMap = null;
    InfoMap leafInfoMap = null;
    TokenIndexer tokens = null;
    String lineSeparator = null;

    public Parser(Logger logger, Properties properties) {
        this(logger, properties, null);
    }

    public Parser(Logger logger, Properties properties, String lineSeparator) {
        this.logger = logger;
        this.properties = properties;
        this.lineSeparator = lineSeparator;
    }

    Parser(Parser p, String text) {
        this.logger = p.logger;
        this.properties = p.properties;
        this.infoMap = p.infoMap;
        this.tokens = new TokenIndexer(this.infoMap, new Tokenizer(text).tokenize());
        this.lineSeparator = p.lineSeparator;
    }

    String translate(String text) {
        int namespace = text.lastIndexOf("::");
        if (namespace >= 0) {
            Info info2 = this.infoMap.getFirst(text.substring(0, namespace));
            text = text.substring(namespace + 2);
            if (info2.pointerTypes != null) {
                text = info2.pointerTypes[0] + "." + text;
            }
        }
        return text;
    }

    void containers(Context context, DeclarationList declList) throws ParserException {
        for (String containerName : InfoMap.containers) {
            LinkedList<Info> infoList = this.leafInfoMap.get(containerName);
            for (Info info : infoList) {
                int i;
                Type valueType;
                Type indexType;
                Declaration decl = new Declaration();
                if (info == null || info.skip || !info.define) continue;
                int dim = 1;
                boolean resizable = true;
                Type containerType = new Parser(this, info.cppNames[0]).type(context);
                Type firstType = null;
                Type secondType = null;
                if (containerType.arguments == null || containerType.arguments.length == 0) continue;
                if (containerType.arguments.length > 1) {
                    resizable = false;
                    indexType = containerType.arguments[0];
                    valueType = containerType.arguments[1];
                } else {
                    indexType = new Type();
                    indexType.annotations = "@Cast(\"size_t\") ";
                    indexType.cppName = "size_t";
                    indexType.javaName = "long";
                    valueType = containerType.arguments[0];
                }
                while (valueType.cppName.startsWith(containerName)) {
                    ++dim;
                    valueType = valueType.arguments[0];
                }
                if (valueType.cppName.startsWith("std::pair")) {
                    firstType = valueType.arguments[0];
                    secondType = valueType.arguments[1];
                    if (firstType.annotations == null || firstType.annotations.length() == 0) {
                        firstType.annotations = "@ByRef ";
                    }
                    if (secondType.annotations == null || secondType.annotations.length() == 0) {
                        secondType.annotations = "@ByRef ";
                    }
                }
                if (valueType.annotations == null || valueType.annotations.length() == 0) {
                    valueType.annotations = "@ByRef ";
                }
                String arrayBrackets = "";
                for (i = 0; i < dim - 1; ++i) {
                    arrayBrackets = arrayBrackets + "[]";
                }
                decl.text = decl.text + "\n@Name(\"" + containerType.cppName + "\") public static class " + containerType.javaName + " extends Pointer {\n" + "    static { Loader.load(); }\n" + "    public " + containerType.javaName + "(Pointer p) { super(p); }\n" + (!resizable || firstType != null || secondType != null ? "" : "    public " + containerType.javaName + "(" + valueType.javaName + arrayBrackets + " ... array) { this(array.length); put(array); }\n") + "    public " + containerType.javaName + "()       { allocate();  }\n" + (!resizable ? "" : "    public " + containerType.javaName + "(long n) { allocate(n); }\n") + "    private native void allocate();\n" + (!resizable ? "" : "    private native void allocate(@Cast(\"size_t\") long n);\n") + "    public native @Name(\"operator=\") @ByRef " + containerType.javaName + " put(@ByRef " + containerType.javaName + " x);\n\n";
                for (i = 0; i < dim; ++i) {
                    String indexAnnotation = i > 0 ? "@Index" + (i > 1 ? "(" + i + ") " : " ") : "";
                    String indices = "";
                    String separator = "";
                    for (int j = 0; j < i; ++j) {
                        indices = indices + separator + indexType.annotations + indexType.javaName + " " + (char)(105 + j);
                        separator = ", ";
                    }
                    decl.text = decl.text + "    public native " + indexAnnotation + "long size(" + indices + ");\n" + (!resizable ? "" : "    public native " + indexAnnotation + "void resize(" + indices + separator + "@Cast(\"size_t\") long n);\n");
                }
                String params = "";
                String separator = "";
                for (int i2 = 0; i2 < dim; ++i2) {
                    params = params + separator + indexType.annotations + indexType.javaName + " " + (char)(105 + i2);
                    separator = ", ";
                }
                if (firstType != null && secondType != null) {
                    String indexAnnotation = "@Index" + (dim > 1 ? "(" + dim + ") " : " ");
                    decl.text = decl.text + "\n    " + indexAnnotation + "public native " + firstType.annotations + firstType.javaName + " first(" + params + ");" + " public native " + containerType.javaName + " first(" + params + separator + firstType.javaName + " first);\n" + "    " + indexAnnotation + "public native " + secondType.annotations + secondType.javaName + " second(" + params + "); " + " public native " + containerType.javaName + " second(" + params + separator + secondType.javaName + " second);\n";
                } else {
                    decl.text = decl.text + "\n    @Index public native " + valueType.annotations + valueType.javaName + " get(" + params + ");\n" + "    public native " + containerType.javaName + " put(" + params + separator + valueType.javaName + " value);\n";
                }
                if (resizable && firstType == null && secondType == null) {
                    int i3;
                    decl.text = decl.text + "\n    public " + containerType.javaName + " put(" + valueType.javaName + arrayBrackets + " ... array) {\n";
                    String indent = "        ";
                    String indices = "";
                    String args = "";
                    separator = "";
                    for (i3 = 0; i3 < dim; ++i3) {
                        char c = (char)(105 + i3);
                        decl.text = decl.text + indent + "if (size(" + args + ") != array" + indices + ".length) { resize(" + args + separator + "array" + indices + ".length); }\n" + indent + "for (int " + c + " = 0; " + c + " < array" + indices + ".length; " + c + "++) {\n";
                        indent = indent + "    ";
                        indices = indices + "[" + c + "]";
                        args = args + separator + c;
                        separator = ", ";
                    }
                    decl.text = decl.text + indent + "put(" + args + separator + "array" + indices + ");\n";
                    for (i3 = 0; i3 < dim; ++i3) {
                        indent = indent.substring(4);
                        decl.text = decl.text + indent + "}\n";
                    }
                    decl.text = decl.text + "        return this;\n    }\n";
                }
                decl.text = decl.text + "}\n";
                declList.add(decl);
            }
        }
    }

    TemplateMap template(Context context) throws ParserException {
        if (!this.tokens.get().match(Token.TEMPLATE)) {
            return null;
        }
        TemplateMap map = new TemplateMap(context.templateMap);
        this.tokens.next().expect(Character.valueOf('<'));
        Token token = this.tokens.next();
        while (!token.match(Token.EOF)) {
            if (token.match(5)) {
                String key = this.tokens.next().expect((Object[])new Object[]{Integer.valueOf((int)5)}).value;
                map.put(key, map.get(key));
                token = this.tokens.next();
            }
            if (!token.match(Character.valueOf(','), Character.valueOf('>'))) {
                int count = 0;
                token = this.tokens.get();
                while (!(token.match(Token.EOF) || count == 0 && token.match(Character.valueOf(','), Character.valueOf('>')))) {
                    if (token.match(Character.valueOf('<'), Character.valueOf('('))) {
                        ++count;
                    } else if (token.match(Character.valueOf('>'), Character.valueOf(')'))) {
                        --count;
                    }
                    token = this.tokens.next();
                }
            }
            if (token.expect(Character.valueOf(','), Character.valueOf('>')).match(Character.valueOf('>'))) {
                if (!this.tokens.next().match(Token.TEMPLATE)) break;
                this.tokens.next().expect(Character.valueOf('<'));
            }
            token = this.tokens.next();
        }
        return map;
    }

    Type[] templateArguments(Context context) throws ParserException {
        if (!this.tokens.get().match(Character.valueOf('<'))) {
            return null;
        }
        ArrayList<Type> arguments = new ArrayList<Type>();
        Token token = this.tokens.next();
        while (!token.match(Token.EOF)) {
            Type type = this.type(context);
            arguments.add(type);
            token = this.tokens.get();
            if (!token.match(Character.valueOf(','), Character.valueOf('>'))) {
                int count = 0;
                token = this.tokens.get();
                while (!(token.match(Token.EOF) || count == 0 && token.match(Character.valueOf(','), Character.valueOf('>')))) {
                    if (token.match(Character.valueOf('<'), Character.valueOf('('))) {
                        ++count;
                    } else if (token.match(Character.valueOf('>'), Character.valueOf(')'))) {
                        --count;
                    }
                    type.cppName = type.cppName + token;
                    token = this.tokens.next();
                }
                if (type.cppName.endsWith("*")) {
                    type.javaName = "PointerPointer";
                    type.annotations = type.annotations + "@Cast(\"" + type.cppName + "*\") ";
                }
            }
            if (token.expect(Character.valueOf(','), Character.valueOf('>')).match(Character.valueOf('>'))) break;
            token = this.tokens.next();
        }
        return arguments.toArray(new Type[arguments.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    Type type(Context context) throws ParserException {
        int attr2;
        String[] backIndex2;
        Info info;
        Type type = new Type();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Token token = this.tokens.get();
        while (true) {
            block37: {
                int n;
                Type[] typeArray;
                String separator;
                block41: {
                    block38: {
                        block50: {
                            block52: {
                                int backIndex2;
                                block51: {
                                    block49: {
                                        block47: {
                                            block48: {
                                                block46: {
                                                    block45: {
                                                        block44: {
                                                            block43: {
                                                                block42: {
                                                                    block40: {
                                                                        block39: {
                                                                            if (token.match(Token.EOF)) break block38;
                                                                            if (!token.match("::")) break block39;
                                                                            type.cppName = type.cppName + token;
                                                                            break block37;
                                                                        }
                                                                        if (!token.match(Character.valueOf('<'))) break block40;
                                                                        type.arguments = this.templateArguments(context);
                                                                        type.cppName = type.cppName + "<";
                                                                        separator = "";
                                                                        typeArray = type.arguments;
                                                                        n = typeArray.length;
                                                                        break block41;
                                                                    }
                                                                    if (!token.match(Token.CONST)) break block42;
                                                                    if (type.cppName.length() == 0) {
                                                                        type.constValue = true;
                                                                        break block37;
                                                                    } else {
                                                                        type.constPointer = true;
                                                                    }
                                                                    break block37;
                                                                }
                                                                if (!token.match(Character.valueOf('*'))) break block43;
                                                                type.pointer = true;
                                                                this.tokens.next();
                                                                break block38;
                                                            }
                                                            if (!token.match(Character.valueOf('&'))) break block44;
                                                            type.reference = true;
                                                            this.tokens.next();
                                                            break block38;
                                                        }
                                                        if (!token.match(Character.valueOf('~'))) break block45;
                                                        type.destructor = true;
                                                        break block37;
                                                    }
                                                    if (!token.match(Token.STATIC)) break block46;
                                                    type.staticMember = true;
                                                    break block37;
                                                }
                                                if (!token.match(Token.OPERATOR)) break block47;
                                                if (type.cppName.length() != 0) break block48;
                                                type.operator = true;
                                                break block37;
                                            }
                                            if (type.cppName.endsWith("::")) {
                                                type.operator = true;
                                                this.tokens.next();
                                            }
                                            break block38;
                                        }
                                        if (token.match(Token.ENUM, Token.EXPLICIT, Token.EXTERN, Token.INLINE, Token.CLASS, Token.STRUCT, Token.UNION, Token.TYPEDEF, Token.TYPENAME, Token.USING, Token.VIRTUAL)) break block37;
                                        if (!token.match(InfoMap.simpleTypes)) break block49;
                                        type.cppName = type.cppName + token.value + " ";
                                        type.simple = true;
                                        break block37;
                                    }
                                    if (!token.match(5)) break block50;
                                    backIndex2 = this.tokens.index--;
                                    Attribute attr2 = this.attribute();
                                    if (attr2 == null || !attr2.annotation) break block51;
                                    type.annotations = type.annotations + attr2.javaName;
                                    attributes.add(attr2);
                                    break block37;
                                }
                                this.tokens.index = backIndex2;
                                if (type.cppName.length() != 0 && !type.cppName.endsWith("::")) break block52;
                                type.cppName = type.cppName + token.value;
                                break block37;
                            }
                            Info info2 = this.infoMap.getFirst(this.tokens.get((int)1).value);
                            if ((info2 == null || info2.annotations == null) && this.tokens.get(1).match(Character.valueOf('*'), Character.valueOf('&'), 5, Token.CONST)) break block37;
                            break block38;
                        }
                        if (token.match(Character.valueOf('}'))) {
                            type.anonymous = true;
                            this.tokens.next();
                        }
                    }
                    if (attributes.size() > 0) {
                        type.attributes = attributes.toArray(new Attribute[attributes.size()]);
                    }
                    type.cppName = type.cppName.trim();
                    if ("...".equals(this.tokens.get().value)) {
                        this.tokens.next();
                        return null;
                    }
                    if (type.operator) {
                        token = this.tokens.get();
                        while (!token.match(Token.EOF, Character.valueOf('('))) {
                            type.cppName = type.cppName + token;
                            token = this.tokens.next();
                        }
                    }
                    if (type.cppName.endsWith("*")) {
                        type.pointer = true;
                        type.cppName = type.cppName.substring(0, type.cppName.length() - 1);
                    }
                    if (type.cppName.endsWith("&")) {
                        type.reference = true;
                        type.cppName = type.cppName.substring(0, type.cppName.length() - 1);
                    }
                    if (context.templateMap != null && context.templateMap.get(type.cppName) != null) {
                        type.cppName = context.templateMap.get(type.cppName);
                    }
                    if (type.cppName.startsWith("const ")) {
                        type.constValue = true;
                        type.cppName = type.cppName.substring(6);
                    }
                    if (type.cppName.endsWith("*")) {
                        type.pointer = true;
                        type.cppName = type.cppName.substring(0, type.cppName.length() - 1);
                    }
                    if (type.cppName.endsWith("&")) {
                        type.reference = true;
                        type.cppName = type.cppName.substring(0, type.cppName.length() - 1);
                    }
                    if (type.cppName.endsWith(" const")) {
                        type.constPointer = true;
                        type.cppName = type.cppName.substring(0, type.cppName.length() - 6);
                    }
                    info = null;
                    backIndex2 = context.qualify(type.cppName);
                    attr2 = backIndex2.length;
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    String s;
                    Type t = typeArray[i];
                    type.cppName = type.cppName + separator;
                    Info info3 = this.infoMap.getFirst(t.cppName);
                    String string = s = info3 != null && info3.cppTypes != null ? info3.cppTypes[0] : t.cppName;
                    if (t.constValue) {
                        s = "const " + s;
                    }
                    if (t.constPointer) {
                        s = s + " const";
                    }
                    if (t.pointer) {
                        s = s + "*";
                    }
                    if (t.reference) {
                        s = s + "&";
                    }
                    type.cppName = type.cppName + s;
                    separator = ",";
                }
                type.cppName = type.cppName + (type.cppName.endsWith(">") ? " >" : ">");
            }
            token = this.tokens.next();
        }
        for (int info2 = 0; info2 < attr2; ++info2) {
            String name = backIndex2[info2];
            info = this.infoMap.getFirst(name, false);
            if (info != null) {
                type.cppName = name;
                break;
            }
            if (this.infoMap.getFirst(name) == null) continue;
            type.cppName = name;
        }
        int namespace = type.cppName.lastIndexOf("::");
        int template = type.cppName.lastIndexOf(60);
        type.javaName = namespace >= 0 && template < 0 ? type.cppName.substring(namespace + 2) : type.cppName;
        boolean valueType = false;
        if (info != null) {
            if (!type.pointer && !type.reference && info.valueTypes != null && info.valueTypes.length > 0) {
                type.javaName = info.valueTypes[0];
                valueType = true;
            } else if (info.pointerTypes != null && info.pointerTypes.length > 0) {
                type.javaName = info.pointerTypes[0];
            }
        }
        if (type.operator) {
            if (type.constValue) {
                type.annotations = type.annotations + "@Const ";
            }
            if (!(valueType || type.pointer || type.reference)) {
                type.annotations = type.annotations + "@ByVal ";
            } else if (!valueType && !type.pointer && type.reference) {
                type.annotations = type.annotations + "@ByRef ";
            }
            type.annotations = type.annotations + "@Name(\"operator " + (type.constValue ? "const " : "") + type.cppName + (type.pointer ? "*" : (type.reference ? "&" : "")) + "\") ";
        }
        if (info != null && info.annotations != null) {
            for (String s : info.annotations) {
                type.annotations = type.annotations + s + " ";
            }
        }
        if (context.group != null && type.javaName.length() > 0) {
            int template2;
            String groupName = context.group.cppName;
            int n = template2 = groupName != null ? groupName.lastIndexOf(60) : -1;
            if (template < 0 && template2 >= 0) {
                groupName = groupName.substring(0, template2);
            }
            if (type.cppName.equals(groupName)) {
                type.constructor = !type.destructor && !type.operator && !type.pointer && !type.reference && this.tokens.get().match(Character.valueOf('('), Character.valueOf(':'));
            }
            type.javaName = context.shorten(type.javaName);
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    Declarator declarator(Context context, String defaultName, int infoNumber, boolean useDefaults, int varNumber, boolean arrayAsPointer, boolean pointerAsArray) throws ParserException {
        boolean typedef = this.tokens.get().match(Token.TYPEDEF);
        boolean using = this.tokens.get().match(Token.USING);
        Declarator dcl = new Declarator();
        Type type = this.type(context);
        if (type == null) {
            return null;
        }
        int count = 0;
        int number = 0;
        Token token = this.tokens.get();
        while (number < varNumber && !token.match(Token.EOF)) {
            if (token.match(Character.valueOf('('), Character.valueOf('['), Character.valueOf('{'))) {
                ++count;
            } else if (token.match(Character.valueOf(')'), Character.valueOf(']'), Character.valueOf('}'))) {
                --count;
            } else if (count <= 0) {
                if (token.match(Character.valueOf(','))) {
                    ++number;
                } else if (token.match(Character.valueOf(';'))) {
                    this.tokens.next();
                    return null;
                }
            }
            token = this.tokens.next();
        }
        String cast = type.cppName;
        if (type.constPointer) {
            dcl.constPointer = true;
            cast = cast + " const";
        }
        if (varNumber == 0 && type.pointer) {
            ++dcl.indirections;
            cast = cast + "*";
        }
        if (varNumber == 0 && type.reference) {
            dcl.reference = true;
            cast = cast + "&";
        }
        Token token2 = this.tokens.get();
        while (!token2.match(Token.EOF)) {
            if (token2.match(Character.valueOf('*'))) {
                ++dcl.indirections;
            } else if (token2.match(Character.valueOf('&'))) {
                dcl.reference = true;
            } else {
                if (!token2.match(Token.CONST)) break;
                dcl.constPointer = true;
            }
            cast = cast + token2;
            token2 = this.tokens.next();
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (type.attributes != null) {
            attributes.addAll(Arrays.asList(type.attributes));
        }
        int backIndex = this.tokens.index;
        Attribute attr = this.attribute();
        while (attr != null && attr.annotation) {
            type.annotations = type.annotations + attr.javaName;
            attributes.add(attr);
            backIndex = this.tokens.index;
            attr = this.attribute();
        }
        attr = null;
        this.tokens.index = backIndex;
        for (Attribute a : attributes) {
            if (a.arguments.length() > 0 && Character.isJavaIdentifierStart(a.arguments.charAt(0))) {
                attr = a;
                for (char c : a.arguments.toCharArray()) {
                    if (Character.isJavaIdentifierPart(c)) continue;
                    attr = null;
                    break;
                }
            }
            if (attr == null) continue;
            break;
        }
        count = 0;
        while (this.tokens.get().match(Character.valueOf('(')) && this.tokens.get(1).match(Character.valueOf('('))) {
            this.tokens.next();
            ++count;
        }
        int[] dims = new int[256];
        int indirections2 = 0;
        dcl.cppName = "";
        Info groupInfo = null;
        Declaration definition = new Declaration();
        boolean operator = false;
        if (this.tokens.get().match(Character.valueOf('(')) || typedef && this.tokens.get(1).match(Character.valueOf('('))) {
            if (this.tokens.get().match(Character.valueOf('('))) {
                this.tokens.next();
            }
            Token token3 = this.tokens.get();
            while (!token3.match(Token.EOF)) {
                if (token3.match(5, "::")) {
                    dcl.cppName = dcl.cppName + token3;
                } else if (token3.match(Character.valueOf('*'))) {
                    ++indirections2;
                    if (dcl.cppName.endsWith("::")) {
                        dcl.cppName = dcl.cppName.substring(0, dcl.cppName.length() - 2);
                        for (String name : context.qualify(dcl.cppName)) {
                            groupInfo = this.infoMap.getFirst(name, false);
                            if (groupInfo != null) {
                                dcl.cppName = name;
                                break;
                            }
                            if (this.infoMap.getFirst(name) == null) continue;
                            dcl.cppName = name;
                        }
                        definition.text = definition.text + "@Namespace(\"" + dcl.cppName + "\") ";
                    } else if (dcl.cppName.length() > 0) {
                        definition.text = definition.text + "@Convention(\"" + dcl.cppName + "\") ";
                    }
                    dcl.cppName = "";
                } else if (token3.match(Character.valueOf('['))) {
                    Token n = this.tokens.get(1);
                    dims[dcl.indices++] = n.match(1) ? Integer.parseInt(n.value) : -1;
                } else if (token3.match(Character.valueOf('('), Character.valueOf(')'))) break;
                token3 = this.tokens.next();
            }
            if (this.tokens.get().match(Character.valueOf(')'))) {
                this.tokens.next();
            }
        } else if (this.tokens.get().match(5)) {
            Token token4 = this.tokens.get();
            while (!token4.match(Token.EOF)) {
                if (token4.match("::")) {
                    dcl.cppName = dcl.cppName + token4;
                } else if (token4.match(Token.OPERATOR)) {
                    operator = true;
                    if (!this.tokens.get(1).match(5)) {
                        dcl.cppName = dcl.cppName + "operator" + this.tokens.next();
                        token4 = this.tokens.next();
                        while (!token4.match(Token.EOF, Character.valueOf('('))) {
                            dcl.cppName = dcl.cppName + token4;
                            token4 = this.tokens.next();
                        }
                        break;
                    }
                } else if (token4.match(Character.valueOf('<'))) {
                    dcl.cppName = dcl.cppName + token4;
                    int count2 = 0;
                    token4 = this.tokens.next();
                    while (!token4.match(Token.EOF)) {
                        dcl.cppName = dcl.cppName + token4;
                        if (count2 != 0 || !token4.match(Character.valueOf('>'))) {
                            if (token4.match(Character.valueOf('<'))) {
                                ++count2;
                            } else if (token4.match(Character.valueOf('>'))) {
                                --count2;
                            }
                            token4 = this.tokens.next();
                            continue;
                        }
                        break;
                    }
                } else {
                    if (!token4.match(5) || dcl.cppName.length() != 0 && !dcl.cppName.endsWith("::")) break;
                    dcl.cppName = dcl.cppName + token4;
                }
                token4 = this.tokens.next();
            }
        }
        if (dcl.cppName.length() == 0) {
            dcl.cppName = defaultName;
        }
        boolean bracket = false;
        Token token5 = this.tokens.get();
        while (!token5.match(Token.EOF)) {
            if (!bracket && token5.match(Character.valueOf('['))) {
                bracket = true;
                Token n = this.tokens.get(1);
                dims[dcl.indices++] = n.match(1) ? Integer.parseInt(n.value) : -1;
            } else {
                if (!bracket) break;
                if (bracket && token5.match(Character.valueOf(']'))) {
                    bracket = false;
                }
            }
            token5 = this.tokens.next();
        }
        while (dcl.indices > 0 && indirections2 > 0) {
            dims[dcl.indices++] = -1;
            --indirections2;
        }
        if (arrayAsPointer && dcl.indices > 0) {
            ++dcl.indirections;
            String dimCast = "";
            for (int i = 1; i < dcl.indices; ++i) {
                if (dims[i] <= 0) continue;
                dimCast = dimCast + "[" + dims[i] + "]";
            }
            cast = cast + (dimCast.length() > 0 ? "(*)" + dimCast : "*");
        }
        if (pointerAsArray && dcl.indirections > (type.anonymous ? 0 : 1)) {
            dims[dcl.indices++] = -1;
            --dcl.indirections;
            cast = cast.substring(0, cast.length() - 1);
        }
        if (this.tokens.get().match(Character.valueOf(':'))) {
            type.annotations = type.annotations + "@NoOffset ";
            this.tokens.next().expect(1);
            this.tokens.next().expect(Character.valueOf(','), Character.valueOf(';'));
        }
        int infoLength = 1;
        boolean valueType = false;
        boolean needCast = arrayAsPointer && dcl.indices > 1;
        boolean implicitConst = false;
        String prefix = type.constValue && dcl.indirections < 2 && !dcl.reference ? "const " : "";
        Info info = this.infoMap.getFirst(prefix + type.cppName, false);
        if (!typedef && (info == null || info.cppTypes != null && info.cppTypes.length > 0)) {
            void var30_45;
            Type type2 = type;
            if (info != null) {
                Type type3 = new Parser(this, info.cppTypes[0]).type(context);
            }
            LinkedList<Info> infoList = this.infoMap.get(var30_45.cppName);
            for (Info info2 : infoList) {
                if (var30_45.arguments == null || info2.annotations == null) continue;
                type.constPointer = var30_45.arguments[0].constPointer;
                type.constValue = var30_45.arguments[0].constValue;
                type.simple = var30_45.arguments[0].simple;
                type.pointer = var30_45.arguments[0].pointer;
                type.reference = var30_45.arguments[0].reference;
                type.annotations = var30_45.arguments[0].annotations;
                type.cppName = var30_45.arguments[0].cppName;
                type.javaName = var30_45.arguments[0].javaName;
                dcl.indirections = 1;
                dcl.reference = false;
                cast = type.cppName + "*";
                if (type.constValue) {
                    cast = "const " + cast;
                }
                if (type.constPointer) {
                    cast = cast + " const";
                }
                if (type.pointer) {
                    ++dcl.indirections;
                    cast = cast + "*";
                }
                if (type.reference) {
                    dcl.reference = true;
                    cast = cast + "&";
                }
                for (String s : info2.annotations) {
                    type.annotations = type.annotations + s + " ";
                }
                info = this.infoMap.getFirst(type.cppName, false);
                break;
            }
        }
        if (!using && info != null) {
            valueType = info.valueTypes != null && (type.constValue && dcl.reference || dcl.indirections == 0 && !dcl.reference || info.pointerTypes == null);
            implicitConst = info.cppNames[0].startsWith("const ");
            infoLength = valueType ? info.valueTypes.length : (info.pointerTypes != null ? info.pointerTypes.length : 1);
            int n = dcl.infoNumber = infoNumber < 0 ? 0 : infoNumber % infoLength;
            type.javaName = valueType ? info.valueTypes[dcl.infoNumber] : (info.pointerTypes != null ? info.pointerTypes[dcl.infoNumber] : type.javaName);
            type.javaName = context.shorten(type.javaName);
            needCast |= info.cast && !type.cppName.equals(type.javaName);
        }
        if (!valueType) {
            if (dcl.indirections == 0 && !dcl.reference) {
                type.annotations = type.annotations + "@ByVal ";
            } else if (dcl.indirections == 0 && dcl.reference) {
                type.annotations = type.annotations + "@ByRef ";
            } else if (dcl.indirections == 1 && dcl.reference) {
                type.annotations = type.annotations + "@ByPtrRef ";
            } else if (dcl.indirections == 2 && !dcl.reference && infoNumber >= 0) {
                type.annotations = type.annotations + "@ByPtrPtr ";
                needCast |= type.cppName.equals("void");
            } else if (dcl.indirections >= 2) {
                dcl.infoNumber += infoLength;
                needCast = true;
                type.javaName = "PointerPointer";
                if (dcl.reference) {
                    type.annotations = type.annotations + "@ByRef ";
                }
            }
            if (!needCast && type.constValue && !implicitConst && !type.javaName.contains("@Cast")) {
                type.annotations = "@Const " + type.annotations;
            }
        }
        if (needCast) {
            if (dcl.indirections == 0 && dcl.reference) {
                cast = cast.replace('&', '*');
            }
            if (valueType && type.constValue && dcl.reference) {
                cast = cast.substring(0, cast.length() - 1);
            }
            if (type.constValue) {
                cast = "const " + cast;
            }
            type.annotations = !valueType && dcl.indirections == 0 && !dcl.reference ? type.annotations + "@Cast(\"" + cast + "*\") " : "@Cast(\"" + cast + "\") " + type.annotations;
        }
        dcl.javaName = attr != null ? attr.arguments : dcl.cppName;
        String[] stringArray = context.qualify(dcl.cppName);
        int infoList = stringArray.length;
        for (int i = 0; i < infoList; ++i) {
            String name = stringArray[i];
            info = this.infoMap.getFirst(name, false);
            if (info != null) {
                dcl.cppName = name;
                break;
            }
            if (this.infoMap.getFirst(name) == null) continue;
            dcl.cppName = name;
        }
        if (attr == null && defaultName == null && info != null && info.javaNames != null && info.javaNames.length > 0 && (operator || !info.cppNames[0].contains("<") || context.templateMap != null && context.templateMap.type == null)) {
            dcl.javaName = info.javaNames[0];
        }
        if (dcl.cppName != null) {
            void var30_49;
            String string = dcl.cppName;
            int namespace = string.lastIndexOf("::");
            if (namespace >= 0 && context.namespace != null && context.namespace.startsWith(string.substring(0, namespace - 2))) {
                String string2 = dcl.cppName.substring(namespace + 2);
            }
            if (!var30_49.equals(dcl.javaName)) {
                type.annotations = type.annotations + "@Name(\"" + (String)var30_49 + "\") ";
            }
        }
        if (info != null && info.annotations != null) {
            for (String s : info.annotations) {
                type.annotations = type.annotations + s + " ";
            }
        }
        dcl.signature = dcl.javaName;
        dcl.parameters = this.parameters(context, infoNumber, useDefaults);
        if (dcl.parameters != null) {
            dcl.infoNumber = Math.max(dcl.infoNumber, dcl.parameters.infoNumber);
            if (indirections2 == 0 && !typedef) {
                dcl.signature = dcl.signature + dcl.parameters.signature;
            } else {
                void var30_57;
                String string = Character.toUpperCase(dcl.javaName.charAt(0)) + dcl.javaName.substring(1);
                if (typedef) {
                    String string3 = dcl.javaName;
                } else if (dcl.parameters.signature.length() > 0) {
                    String string4 = string + dcl.parameters.signature;
                } else if (!type.javaName.equals("void")) {
                    String string5 = type.javaName + "_" + string;
                }
                definition.text = definition.text + (this.tokens.get().match(Token.CONST) ? "@Const " : "") + "public static class " + (String)var30_57 + " extends FunctionPointer {\n" + "    static { Loader.load(); }\n" + "    public    " + (String)var30_57 + "(Pointer p) { super(p); }\n" + (groupInfo != null ? "" : "    protected " + (String)var30_57 + "() { allocate(); }\n" + "    private native void allocate();\n") + "    public native " + type.annotations + type.javaName + " call" + (groupInfo != null ? "(" + groupInfo.pointerTypes[0] + " o" + (dcl.parameters.list.charAt(1) == ')' ? ")" : ", " + dcl.parameters.list.substring(1)) : dcl.parameters.list) + ";\n" + "}\n";
                definition.signature = var30_57;
                definition.declarator = new Declarator();
                definition.declarator.parameters = dcl.parameters;
                dcl.definition = definition;
                dcl.parameters = null;
                type.annotations = "";
                type.javaName = var30_57;
            }
        }
        dcl.type = type;
        while (this.tokens.get().match(Character.valueOf(')')) && count > 0) {
            this.tokens.next();
            --count;
        }
        return dcl;
    }

    String commentBefore() throws ParserException {
        String comment = "";
        this.tokens.raw = true;
        while (this.tokens.index > 0 && this.tokens.get(-1).match(4)) {
            --this.tokens.index;
        }
        boolean closeComment = false;
        Token token = this.tokens.get();
        while (token.match(4)) {
            block10: {
                String s;
                block9: {
                    s = token.value;
                    if (!s.startsWith("/**") && !s.startsWith("/*!") && !s.startsWith("///") && !s.startsWith("//!")) break block9;
                    if (s.charAt(3) == '<') break block10;
                    if (s.startsWith("/// ") || s.startsWith("//!")) {
                        s = (comment.length() == 0 || comment.contains("*/") || !comment.contains("/*") ? "/**" : " * ") + s.substring(3);
                        closeComment = true;
                    } else if (!s.startsWith("///")) {
                        s = "/**" + s.substring(3);
                    }
                }
                comment = comment + token.spacing + s;
            }
            token = this.tokens.next();
        }
        if (closeComment && !comment.endsWith("*/")) {
            comment = comment + " */";
        }
        this.tokens.raw = false;
        return comment;
    }

    String commentAfter() throws ParserException {
        String comment = "";
        this.tokens.raw = true;
        while (this.tokens.index > 0 && this.tokens.get(-1).match(4)) {
            --this.tokens.index;
        }
        boolean closeComment = false;
        Token token = this.tokens.get();
        while (token.match(4)) {
            String s = token.value;
            if ((s.startsWith("/**") || s.startsWith("/*!") || s.startsWith("///") || s.startsWith("//!")) && s.charAt(3) == '<') {
                if (s.startsWith("///") || s.startsWith("//!")) {
                    s = (comment.length() == 0 || comment.contains("*/") || !comment.contains("/*") ? "/**" : " * ") + s.substring(4);
                    closeComment = true;
                } else {
                    s = "/**" + s.substring(4);
                }
                comment = comment + s;
            }
            token = this.tokens.next();
        }
        if (closeComment && !comment.endsWith("*/")) {
            comment = comment + " */";
        }
        if (comment.length() > 0) {
            comment = comment + "\n";
        }
        this.tokens.raw = false;
        return comment;
    }

    Attribute attribute() throws ParserException {
        if (!this.tokens.get().match(5)) {
            return null;
        }
        Attribute attr = new Attribute();
        attr.cppName = this.tokens.get().value;
        Info info = this.infoMap.getFirst(attr.cppName);
        attr.annotation = info != null && info.annotations != null && info.javaNames == null && info.valueTypes == null && info.pointerTypes == null;
        if (attr.annotation) {
            for (String s : info.annotations) {
                attr.javaName = attr.javaName + s + " ";
            }
        }
        if (!this.tokens.next().match(Character.valueOf('('))) {
            return attr;
        }
        int count = 1;
        this.tokens.raw = true;
        Token token = this.tokens.next();
        while (!token.match(Token.EOF) && count > 0) {
            if (token.match(Character.valueOf('('))) {
                ++count;
            } else if (token.match(Character.valueOf(')'))) {
                --count;
            } else if (info == null || !info.skip) {
                attr.arguments = attr.arguments + token.value;
            }
            token = this.tokens.next();
        }
        this.tokens.raw = false;
        return attr;
    }

    String body() throws ParserException {
        if (!this.tokens.get().match(Character.valueOf('{'))) {
            return null;
        }
        int count = 1;
        this.tokens.raw = true;
        Token token = this.tokens.next();
        while (!token.match(Token.EOF) && count > 0) {
            if (token.match(Character.valueOf('{'))) {
                ++count;
            } else if (token.match(Character.valueOf('}'))) {
                --count;
            }
            token = this.tokens.next();
        }
        this.tokens.raw = false;
        return "";
    }

    Parameters parameters(Context context, int infoNumber, boolean useDefaults) throws ParserException {
        if (!this.tokens.get().match(Character.valueOf('('))) {
            return null;
        }
        int count = 0;
        Parameters params = new Parameters();
        ArrayList<Declarator> dcls = new ArrayList<Declarator>();
        params.list = "(";
        params.names = "(";
        Token token = this.tokens.next();
        while (!token.match(Token.EOF)) {
            boolean hasDefault;
            String spacing = token.spacing;
            if (token.match(Character.valueOf(')'))) {
                params.list = params.list + spacing + ")";
                params.names = params.names + ")";
                this.tokens.next();
                break;
            }
            Declarator dcl = this.declarator(context, "arg" + count++, infoNumber, useDefaults, 0, true, false);
            boolean bl = hasDefault = !this.tokens.get().match(Character.valueOf(','), Character.valueOf(')'));
            if (!(dcl == null || dcl.type.javaName.equals("void") || hasDefault && useDefaults)) {
                params.infoNumber = Math.max(params.infoNumber, dcl.infoNumber);
                params.list = params.list + (count > 1 ? "," : "") + spacing + dcl.type.annotations + dcl.type.javaName + " " + dcl.javaName;
                params.signature = params.signature + '_';
                for (char c : dcl.type.javaName.substring(dcl.type.javaName.lastIndexOf(32) + 1).toCharArray()) {
                    params.signature = params.signature + (Character.isJavaIdentifierPart(c) ? c : (char)'_');
                }
                params.names = params.names + (count > 1 ? ", " : "") + dcl.javaName;
                if (dcl.javaName.startsWith("arg")) {
                    try {
                        count = Integer.parseInt(dcl.javaName.substring(3)) + 1;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            if (!hasDefault || !useDefaults) {
                dcls.add(dcl);
            }
            if (hasDefault) {
                if (!useDefaults) {
                    params.list = params.list + "/*" + this.tokens.get();
                }
                int count2 = 0;
                token = this.tokens.next();
                token.spacing = "";
                while (!(token.match(Token.EOF) || count2 == 0 && token.match(Character.valueOf(','), Character.valueOf(')')))) {
                    if (token.match(Character.valueOf('('))) {
                        ++count2;
                    } else if (token.match(Character.valueOf(')'))) {
                        --count2;
                    }
                    if (!useDefaults) {
                        params.list = params.list + token.spacing + token;
                    }
                    token = this.tokens.next();
                }
                if (!useDefaults) {
                    params.list = params.list + "*/";
                }
            }
            if (this.tokens.get().expect(Character.valueOf(','), Character.valueOf(')')).match(Character.valueOf(','))) {
                this.tokens.next();
            }
            token = this.tokens.get();
        }
        params.declarators = dcls.toArray(new Declarator[dcls.size()]);
        return params;
    }

    boolean function(Context context, DeclarationList declList) throws ParserException {
        String localName;
        int backIndex = this.tokens.index;
        String spacing = this.tokens.get().spacing;
        String modifiers = "public native ";
        boolean friend = false;
        if (this.tokens.get().match(Token.FRIEND)) {
            friend = true;
            this.tokens.next();
        }
        Type type = this.type(context);
        Parameters params = this.parameters(context, 0, false);
        Declarator dcl = new Declarator();
        Declaration decl = new Declaration();
        if (type.javaName.length() == 0) {
            this.tokens.index = backIndex;
            return false;
        }
        if (context.group == null && !type.operator && params != null) {
            if (this.tokens.get().match(Character.valueOf(':'))) {
                Token token = this.tokens.next();
                while (!token.match(Token.EOF) && !token.match(Character.valueOf('{'), Character.valueOf(';'))) {
                    token = this.tokens.next();
                }
            }
            if (this.tokens.get().match(Character.valueOf('{'))) {
                this.body();
            } else {
                this.tokens.next();
            }
            decl.text = spacing;
            declList.add(decl);
            return true;
        }
        if (type.constructor || type.destructor || type.operator) {
            dcl.type = type;
            dcl.parameters = params;
            dcl.cppName = type.cppName;
            dcl.javaName = type.javaName.substring(type.javaName.lastIndexOf(32) + 1);
            if (type.operator) {
                dcl.cppName = "operator " + dcl.cppName;
                dcl.javaName = "as" + Character.toUpperCase(dcl.javaName.charAt(0)) + dcl.javaName.substring(1);
            }
            dcl.signature = dcl.javaName + params.signature;
        } else {
            this.tokens.index = backIndex;
            dcl = this.declarator(context, null, 0, false, 0, false, false);
            type = dcl.type;
        }
        if (dcl.cppName == null) {
            this.tokens.index = backIndex;
            return false;
        }
        int namespace = dcl.cppName.lastIndexOf("::");
        if (context.namespace != null && namespace < 0) {
            dcl.cppName = context.namespace + "::" + dcl.cppName;
        }
        Info info = null;
        if (dcl.parameters != null) {
            String name = dcl.cppName + "(";
            String separator = "";
            for (Declarator d : dcl.parameters.declarators) {
                if (d == null) continue;
                name = name + separator + d.type.cppName;
                for (int i = 0; i < d.indirections; ++i) {
                    name = name + "*";
                }
                if (d.reference) {
                    name = name + "&";
                }
                separator = ", ";
            }
            info = this.infoMap.getFirst(name + ")");
        }
        if (info == null) {
            info = this.infoMap.getFirst(dcl.cppName);
        }
        if ((localName = dcl.cppName).startsWith(context.namespace + "::")) {
            localName = dcl.cppName.substring(context.namespace.length() + 2);
        }
        if (type.javaName.length() == 0 || dcl.parameters == null) {
            this.tokens.index = backIndex;
            return false;
        }
        if (friend || context.group == null && localName.contains("::") || info != null && info.skip) {
            Token token = this.tokens.get();
            while (!token.match(Token.EOF) && this.attribute() != null) {
                token = this.tokens.get();
            }
            if (this.tokens.get().match(Character.valueOf(':'))) {
                token = this.tokens.next();
                while (!token.match(Token.EOF) && !token.match(Character.valueOf('{'), Character.valueOf(';'))) {
                    token = this.tokens.next();
                }
            }
            if (this.tokens.get().match(Character.valueOf('{'))) {
                this.body();
            } else {
                this.tokens.next();
            }
            decl.text = spacing;
            declList.add(decl);
            return true;
        }
        if (type.staticMember || context.group == null) {
            modifiers = "public static native ";
        }
        LinkedList<Declarator> prevDcl = new LinkedList<Declarator>();
        boolean first = true;
        for (int n = -2; n < Integer.MAX_VALUE; ++n) {
            decl = new Declaration();
            this.tokens.index = backIndex;
            if (type.constructor || type.destructor || type.operator) {
                type = this.type(context);
                params = this.parameters(context, n / 2, n % 2 != 0);
                dcl = new Declarator();
                dcl.type = type;
                dcl.parameters = params;
                dcl.cppName = type.cppName;
                dcl.javaName = type.javaName.substring(type.javaName.lastIndexOf(32) + 1);
                if (type.operator) {
                    dcl.cppName = "operator " + dcl.cppName;
                    dcl.javaName = "as" + Character.toUpperCase(dcl.javaName.charAt(0)) + dcl.javaName.substring(1);
                }
                dcl.signature = dcl.javaName + params.signature;
                if (this.tokens.get().match(Character.valueOf(':'))) {
                    Token token = this.tokens.next();
                    while (!token.match(Token.EOF) && !token.match(Character.valueOf('{'), Character.valueOf(';'))) {
                        token = this.tokens.next();
                    }
                }
            } else {
                dcl = this.declarator(context, null, n / 2, n % 2 != 0, 0, false, false);
                type = dcl.type;
                namespace = dcl.cppName.lastIndexOf("::");
                if (context.namespace != null && namespace < 0) {
                    dcl.cppName = context.namespace + "::" + dcl.cppName;
                }
            }
            Token token = this.tokens.get();
            while (!token.match(Token.EOF)) {
                decl.constMember |= token.match(Token.CONST);
                if (this.attribute() == null) break;
                token = this.tokens.get();
            }
            if (this.tokens.get().match(Character.valueOf('{'))) {
                this.body();
            } else {
                if (this.tokens.get().match(Character.valueOf('='))) {
                    this.tokens.next().expect("0");
                    this.tokens.next().expect(Character.valueOf(';'));
                    if (context.virtualize) {
                        modifiers = decl.inaccessible ? "@Virtual protected abstract " : "@Virtual public abstract ";
                        decl.inaccessible = false;
                    }
                    decl.abstractMember = true;
                }
                this.tokens.next();
            }
            decl.declarator = dcl;
            if (context.namespace != null && context.group == null) {
                decl.text = decl.text + "@Namespace(\"" + context.namespace + "\") ";
            }
            decl.text = type.constructor ? decl.text + "public " + dcl.javaName + dcl.parameters.list + " { allocate" + params.names + "; }\n" + "private native void allocate" + dcl.parameters.list + ";\n" : decl.text + modifiers + type.annotations + type.javaName + " " + dcl.javaName + dcl.parameters.list + ";\n";
            decl.signature = dcl.signature;
            if (info != null && info.javaText != null) {
                if (!first) break;
                decl.text = info.javaText;
            }
            String comment = this.commentAfter();
            if (first) {
                first = false;
                declList.spacing = spacing;
                decl.text = comment + decl.text;
            }
            boolean found = false;
            for (Declarator d : prevDcl) {
                found |= dcl.signature.equals(d.signature);
            }
            if (dcl.javaName.length() > 0 && !found && !type.destructor) {
                declList.add(decl);
                if (context.virtualize && decl.abstractMember) {
                    break;
                }
            } else if (found && n / 2 > 0 && n % 2 == 0) break;
            prevDcl.add(dcl);
        }
        declList.spacing = null;
        return true;
    }

    boolean variable(Context context, DeclarationList declList) throws ParserException {
        Info info;
        int backIndex = this.tokens.index;
        String spacing = this.tokens.get().spacing;
        String modifiers = "public static native ";
        String setterType = "void ";
        Declarator dcl = this.declarator(context, null, 0, false, 0, false, true);
        Declaration decl = new Declaration();
        String cppName = dcl.cppName;
        String javaName = dcl.javaName;
        if (javaName == null || !this.tokens.get().match(Character.valueOf('['), Character.valueOf('='), Character.valueOf(','), Character.valueOf(':'), Character.valueOf(';'))) {
            this.tokens.index = backIndex;
            return false;
        }
        if (!dcl.type.staticMember && context.group != null) {
            modifiers = "public native ";
            setterType = context.shorten(context.group.javaName) + " ";
        }
        int namespace = cppName.lastIndexOf("::");
        if (context.namespace != null && namespace < 0) {
            cppName = context.namespace + "::" + cppName;
        }
        if ((info = this.infoMap.getFirst(cppName)) != null && info.skip) {
            decl.text = spacing;
            declList.add(decl);
            return true;
        }
        boolean first = true;
        Declarator metadcl = context.variable;
        for (int n = 0; n < Integer.MAX_VALUE; ++n) {
            int i;
            String indices;
            decl = new Declaration();
            this.tokens.index = backIndex;
            dcl = this.declarator(context, null, -1, false, n, false, true);
            if (dcl == null) break;
            decl.declarator = dcl;
            javaName = dcl.javaName;
            if (metadcl == null || metadcl.indices == 0 || dcl.indices == 0) {
                indices = "";
                for (i = 0; i < (metadcl == null || metadcl.indices == 0 ? dcl.indices : metadcl.indices); ++i) {
                    if (i > 0) {
                        indices = indices + ", ";
                    }
                    indices = indices + "int " + (char)(105 + i);
                }
                if (context.namespace != null && context.group == null) {
                    decl.text = decl.text + "@Namespace(\"" + context.namespace + "\") ";
                }
                if (metadcl != null && metadcl.cppName.length() > 0) {
                    decl.text = decl.text + (metadcl.indices == 0 ? "@Name(\"" + metadcl.cppName + "." + dcl.cppName + "\") " : "@Name({\"" + metadcl.cppName + "\", \"." + dcl.cppName + "\"}) ");
                    javaName = metadcl.javaName + "_" + dcl.javaName;
                }
                if (dcl.type.constValue) {
                    decl.text = decl.text + "@MemberGetter ";
                }
                decl.text = decl.text + modifiers + dcl.type.annotations.replace("@ByVal ", "@ByRef ") + dcl.type.javaName + " " + javaName + "(" + indices + ");";
                if (!dcl.type.constValue) {
                    if (indices.length() > 0) {
                        indices = indices + ", ";
                    }
                    decl.text = decl.text + " " + modifiers + setterType + javaName + "(" + indices + dcl.type.javaName + " " + javaName + ");";
                }
                decl.text = decl.text + "\n";
            }
            if (dcl.indices > 0) {
                this.tokens.index = backIndex;
                dcl = this.declarator(context, null, -1, false, n, true, false);
                indices = "";
                for (i = 0; i < (metadcl == null ? 0 : metadcl.indices); ++i) {
                    if (i > 0) {
                        indices = indices + ", ";
                    }
                    indices = indices + "int " + (char)(105 + i);
                }
                if (context.namespace != null && context.group == null) {
                    decl.text = decl.text + "@Namespace(\"" + context.namespace + "\") ";
                }
                if (metadcl != null && metadcl.cppName.length() > 0) {
                    decl.text = decl.text + (metadcl.indices == 0 ? "@Name(\"" + metadcl.cppName + "." + dcl.cppName + "\") " : "@Name({\"" + metadcl.cppName + "\", \"." + dcl.cppName + "\"}) ");
                    javaName = metadcl.javaName + "_" + dcl.javaName;
                }
                decl.text = decl.text + "@MemberGetter " + modifiers + dcl.type.annotations.replace("@ByVal ", "@ByRef ") + dcl.type.javaName + " " + javaName + "(" + indices + ");\n";
            }
            decl.signature = dcl.signature;
            if (info != null && info.javaText != null) {
                decl.text = info.javaText;
                decl.declarator = null;
            }
            while (!this.tokens.get().match(Token.EOF, Character.valueOf(';'))) {
                this.tokens.next();
            }
            this.tokens.next();
            String comment = this.commentAfter();
            if (first) {
                first = false;
                declList.spacing = spacing;
                decl.text = comment + decl.text;
            }
            decl.variable = true;
            declList.add(decl);
        }
        declList.spacing = null;
        return true;
    }

    boolean macro(Context context, DeclarationList declList) throws ParserException {
        int backIndex = this.tokens.index;
        if (!this.tokens.get().match(Character.valueOf('#'))) {
            return false;
        }
        this.tokens.raw = true;
        String spacing = this.tokens.get().spacing;
        Token keyword = this.tokens.next();
        this.tokens.next();
        int beginIndex = this.tokens.index;
        Token token = this.tokens.get();
        while (!token.match(Token.EOF) && token.spacing.indexOf(10) < 0) {
            token = this.tokens.next();
        }
        int endIndex = this.tokens.index;
        while (this.tokens.get(-1).match(4)) {
            --this.tokens.index;
        }
        int lastIndex = this.tokens.index;
        Declaration decl = new Declaration();
        if (keyword.match(Token.DEFINE) && beginIndex + 1 < endIndex) {
            Info info;
            this.tokens.index = beginIndex;
            String macroName = this.tokens.get().value;
            Token first = this.tokens.next();
            boolean hasArgs = first.spacing.length() == 0 && first.match(Character.valueOf('('));
            LinkedList<Info> infoList = this.infoMap.get(macroName);
            Iterator iterator = (infoList.size() > 0 ? infoList : Arrays.asList(new Info[]{null})).iterator();
            while (iterator.hasNext() && ((info = (Info)iterator.next()) == null || !info.skip)) {
                int i;
                if (hasArgs && info == null || info != null && info.cppText == null && info.cppTypes != null && info.cppTypes.length == 0) {
                    info = new Info(macroName).cppText("");
                    this.tokens.index = backIndex;
                    Token token2 = this.tokens.get();
                    while (this.tokens.index < endIndex) {
                        info.cppText = info.cppText + (token2.match("\n") ? token2 : token2.spacing + token2);
                        token2 = this.tokens.next();
                    }
                    this.infoMap.putFirst(info);
                    break;
                }
                if (info != null && info.cppText == null && info.cppTypes != null && info.cppTypes.length > (hasArgs ? 0 : 1)) {
                    LinkedList<Declarator> prevDcl = new LinkedList<Declarator>();
                    for (int n = -1; n < Integer.MAX_VALUE; ++n) {
                        int count = 1;
                        this.tokens.index = beginIndex + 2;
                        String params = "(";
                        Token token3 = this.tokens.get();
                        while (hasArgs && this.tokens.index < lastIndex && count < info.cppTypes.length) {
                            if (token3.match(5)) {
                                String type = info.cppTypes[count];
                                String name = token3.value;
                                if (name.equals("...")) {
                                    name = "arg" + count;
                                }
                                params = params + type + " " + name;
                                if (++count < info.cppTypes.length) {
                                    params = params + ", ";
                                }
                            } else if (token3.match(Character.valueOf(')'))) break;
                            token3 = this.tokens.next();
                        }
                        while (count < info.cppTypes.length) {
                            String type = info.cppTypes[count];
                            String name = "arg" + count;
                            params = params + type + " " + name;
                            if (++count >= info.cppTypes.length) continue;
                            params = params + ", ";
                        }
                        params = params + ")";
                        Declarator dcl = new Parser(this, info.cppTypes[0] + " " + macroName + params).declarator(context, null, n, false, 0, false, false);
                        for (i = 0; i < info.cppNames.length; ++i) {
                            if (!macroName.equals(info.cppNames[i]) || info.javaNames == null) continue;
                            macroName = "@Name(\"" + info.cppNames[0] + "\") " + info.javaNames[i];
                            break;
                        }
                        boolean found = false;
                        for (Declarator d : prevDcl) {
                            found |= dcl.signature.equals(d.signature);
                        }
                        if (!found) {
                            decl.text = decl.text + "public static native " + dcl.type.annotations + dcl.type.javaName + " " + macroName + dcl.parameters.list + ";\n";
                        } else if (found && n > 0) break;
                        prevDcl.add(dcl);
                    }
                } else if (info == null || info.cppText == null && (info.cppTypes == null || info.cppTypes.length == 1)) {
                    String value = "";
                    String type = "int";
                    String cat = "";
                    this.tokens.index = beginIndex + 1;
                    Token prevToken = new Token();
                    boolean translate = true;
                    Token token4 = this.tokens.get();
                    while (this.tokens.index < lastIndex) {
                        if (token4.match(3)) {
                            type = "String";
                            cat = " + ";
                            break;
                        }
                        if (token4.match(2)) {
                            type = "double";
                            cat = "";
                            break;
                        }
                        if (token4.match(1) && token4.value.endsWith("L")) {
                            type = "long";
                            cat = "";
                            break;
                        }
                        if (prevToken.match(5, Character.valueOf('>')) && token4.match(Character.valueOf('(')) || token4.match(Character.valueOf('{'), Character.valueOf('}'))) {
                            translate = false;
                        }
                        prevToken = token4;
                        token4 = this.tokens.next();
                    }
                    if (info != null) {
                        if (info.cppTypes != null) {
                            Declarator dcl = new Parser(this, info.cppTypes[0]).declarator(context, null, -1, false, 0, false, true);
                            type = dcl.type.annotations + dcl.type.javaName;
                        }
                        for (int i2 = 0; i2 < info.cppNames.length; ++i2) {
                            if (!macroName.equals(info.cppNames[i2]) || info.javaNames == null) continue;
                            macroName = "@Name(\"" + info.cppNames[0] + "\") " + info.javaNames[i2];
                            break;
                        }
                        translate = info.translate;
                    }
                    this.tokens.index = beginIndex + 1;
                    if (translate) {
                        token = this.tokens.get();
                        while (this.tokens.index < lastIndex) {
                            value = value + token.spacing + token + (this.tokens.index + 1 < lastIndex ? cat : "");
                            token = this.tokens.next();
                        }
                        value = this.translate(value);
                    } else {
                        decl.text = decl.text + "public static native @MemberGetter " + type + " " + macroName + "();\n";
                        value = " " + macroName + "()";
                    }
                    i = type.lastIndexOf(32);
                    if (i >= 0) {
                        type = type.substring(i + 1);
                    }
                    if (value.length() > 0) {
                        decl.text = decl.text + "public static final " + type + " " + macroName + " =" + value + ";\n";
                    }
                    decl.signature = macroName;
                }
                if (info == null || info.javaText == null) continue;
                decl.text = info.javaText;
                break;
            }
        }
        if (decl.text.length() == 0) {
            this.tokens.index = beginIndex;
            int n = spacing.lastIndexOf(10) + 1;
            decl.text = decl.text + "// " + spacing.substring(n) + "#" + keyword.spacing + keyword;
            Token token5 = this.tokens.get();
            while (this.tokens.index < lastIndex) {
                decl.text = decl.text + (token5.match("\n") ? "\n// " : token5.spacing + token5);
                token5 = this.tokens.next();
            }
            spacing = spacing.substring(0, n);
        }
        if (decl.text.length() > 0) {
            this.tokens.index = lastIndex;
            String comment = this.commentAfter();
            decl.text = comment + decl.text;
        }
        this.tokens.raw = false;
        declList.spacing = spacing;
        declList.add(decl);
        declList.spacing = null;
        return true;
    }

    boolean typedef(Context context, DeclarationList declList) throws ParserException {
        Info info;
        String spacing = this.tokens.get().spacing;
        if (!this.tokens.get().match(Token.TYPEDEF)) {
            return false;
        }
        Declaration decl = new Declaration();
        Declarator dcl = this.declarator(context, null, 0, false, 0, true, false);
        this.tokens.next();
        String typeName = dcl.type.cppName;
        String defName = dcl.cppName;
        if (context.namespace != null) {
            defName = context.namespace + "::" + defName;
        }
        if (dcl.definition != null) {
            decl = dcl.definition;
            if (dcl.javaName.length() > 0 && context.group != null) {
                dcl.javaName = context.group.javaName + "." + dcl.javaName;
            }
            this.infoMap.put(new Info(defName).valueTypes(dcl.javaName).pointerTypes((dcl.indirections > 0 ? "@ByPtrPtr " : "") + dcl.javaName));
        } else if (typeName.equals("void")) {
            info = this.infoMap.getFirst(defName);
            if (info == null || !info.skip) {
                if (dcl.indirections > 0) {
                    decl.text = decl.text + "@Namespace @Name(\"void\") ";
                    info = info != null ? new Info(info) : new Info(defName);
                    this.infoMap.put(info.valueTypes(dcl.javaName).pointerTypes("@ByPtrPtr " + dcl.javaName));
                } else if (context.namespace != null && context.group == null) {
                    decl.text = decl.text + "@Namespace(\"" + context.namespace + "\") ";
                }
                decl.text = decl.text + "@Opaque public static class " + dcl.javaName + " extends Pointer {\n" + "    public " + dcl.javaName + "() { }\n" + "    public " + dcl.javaName + "(Pointer p) { super(p); }\n" + "}";
            }
        } else {
            info = this.infoMap.getFirst(typeName);
            if (info == null || !info.skip) {
                Info info2 = info = info != null ? new Info(info).cppNames(defName) : new Info(defName);
                if (info.cppTypes == null) {
                    info.cppTypes(typeName);
                }
                if (info.valueTypes == null && dcl.indirections > 0) {
                    info.valueTypes(typeName);
                    info.pointerTypes("PointerPointer");
                } else if (info.pointerTypes == null) {
                    info.pointerTypes(typeName);
                }
                if (info.annotations == null) {
                    info.cast(!dcl.cppName.equals(info.pointerTypes[0]));
                }
                this.infoMap.put(info);
            }
        }
        String comment = this.commentAfter();
        decl.text = comment + decl.text;
        declList.spacing = spacing;
        declList.add(decl);
        declList.spacing = null;
        return true;
    }

    boolean using(Context context, DeclarationList declList) throws ParserException {
        if (!this.tokens.get().match(Token.USING)) {
            return false;
        }
        String spacing = this.tokens.get().spacing;
        boolean namespace = this.tokens.get(1).match(Token.NAMESPACE);
        Declarator dcl = this.declarator(context, null, 0, false, 0, true, false);
        this.tokens.next();
        context.usingList.add(dcl.type.cppName + (namespace ? "::" : ""));
        Declaration decl = new Declaration();
        if (dcl.definition != null) {
            decl = dcl.definition;
        }
        String comment = this.commentAfter();
        decl.text = comment + decl.text;
        declList.spacing = spacing;
        declList.add(decl);
        declList.spacing = null;
        return true;
    }

    boolean group(Context context, DeclarationList declList) throws ParserException {
        Info info;
        int backIndex = this.tokens.index;
        String spacing = this.tokens.get().spacing;
        boolean typedef = this.tokens.get().match(Token.TYPEDEF);
        boolean foundGroup = false;
        boolean friend = false;
        Context ctx = new Context(context);
        Token token = this.tokens.get();
        while (!token.match(Token.EOF)) {
            if (token.match(Token.CLASS, Token.STRUCT, Token.UNION)) {
                foundGroup = true;
                ctx.inaccessible = token.match(Token.CLASS);
                break;
            }
            if (token.match(Token.FRIEND)) {
                friend = true;
            } else if (!token.match(5)) break;
            token = this.tokens.next();
        }
        if (!foundGroup) {
            this.tokens.index = backIndex;
            return false;
        }
        this.tokens.next().expect(5, Character.valueOf('{'));
        if (!this.tokens.get().match(Character.valueOf('{')) && this.tokens.get(1).match(5) && (typedef || !this.tokens.get(2).match(Character.valueOf(';')))) {
            this.tokens.next();
        }
        Type type = this.type(context);
        ArrayList<Type> baseClasses = new ArrayList<Type>();
        Declaration decl = new Declaration();
        decl.text = type.annotations;
        String name = type.javaName;
        boolean anonymous = !typedef && type.cppName.length() == 0;
        boolean derivedClass = false;
        if (type.cppName.length() > 0 && this.tokens.get().match(Character.valueOf(':'))) {
            derivedClass = true;
            Token token2 = this.tokens.next();
            while (!token2.match(Token.EOF)) {
                boolean accessible = false;
                if (!token2.match(Token.VIRTUAL)) {
                    if (token2.match(Token.PRIVATE, Token.PROTECTED, Token.PUBLIC)) {
                        accessible = token2.match(Token.PUBLIC);
                        this.tokens.next();
                    }
                    Type t = this.type(context);
                    if (accessible) {
                        baseClasses.add(t);
                    }
                    if (this.tokens.get().expect(Character.valueOf(','), Character.valueOf('{')).match(Character.valueOf('{'))) break;
                }
                token2 = this.tokens.next();
            }
        }
        if (typedef && type.pointer) {
            while (!this.tokens.get().match(Character.valueOf(';'), Token.EOF)) {
                this.tokens.next();
            }
        }
        if (!this.tokens.get().match(Character.valueOf('{'), Character.valueOf(';'))) {
            this.tokens.index = backIndex;
            return false;
        }
        int startIndex = this.tokens.index;
        ArrayList<Declarator> variables = new ArrayList<Declarator>();
        if (this.body() != null && !this.tokens.get().match(Character.valueOf(';'))) {
            if (typedef) {
                Token token3 = this.tokens.get();
                while (!token3.match(Token.EOF)) {
                    if (token3.match(Character.valueOf(';'))) {
                        decl.text = decl.text + token3.spacing;
                        break;
                    }
                    type.javaName = type.cppName = token3.value;
                    name = type.cppName;
                    token3 = this.tokens.next();
                }
            } else {
                int n;
                int index = this.tokens.index - 1;
                for (n = 0; n < Integer.MAX_VALUE; ++n) {
                    this.tokens.index = index;
                    Declarator dcl = this.declarator(context, null, -1, false, n, false, true);
                    if (dcl == null) break;
                    variables.add(dcl);
                }
                if ((n = spacing.lastIndexOf(10)) >= 0) {
                    decl.text = decl.text + spacing.substring(0, n);
                }
            }
        }
        int namespace = type.cppName.lastIndexOf("::");
        if (context.namespace != null && namespace < 0) {
            type.cppName = context.namespace + "::" + type.cppName;
        }
        if ((info = this.infoMap.getFirst(type.cppName)) != null && info.skip) {
            decl.text = "";
            declList.add(decl);
            return true;
        }
        if (info != null && info.pointerTypes != null && info.pointerTypes.length > 0) {
            name = type.javaName = info.pointerTypes[0];
        } else if (info == null) {
            if (type.javaName.length() > 0 && context.group != null) {
                type.javaName = context.group.javaName + "." + type.javaName;
            }
            info = new Info(type.cppName).pointerTypes(type.javaName);
            this.infoMap.put(info);
        }
        Type base = new Type("Pointer");
        if (baseClasses.size() > 0) {
            base = (Type)baseClasses.remove(0);
        }
        String casts = "";
        if (baseClasses.size() > 0) {
            for (Type t : baseClasses) {
                casts = casts + "    public " + t.javaName + " as" + t.javaName + "() { return as" + t.javaName + "(this); }\n" + "    @Namespace public static native @Name(\"static_cast<" + t.cppName + "*>\") " + t.javaName + " as" + t.javaName + "(" + type.javaName + " pointer);\n";
            }
        }
        decl.signature = type.javaName;
        this.tokens.index = startIndex;
        if (name.length() > 0 && this.tokens.get().match(Character.valueOf(';'))) {
            String fullName;
            this.tokens.next();
            if (friend) {
                decl.text = "";
                declList.add(decl);
                return true;
            }
            if (info != null && info.base != null) {
                base.javaName = info.base;
            }
            String string = fullName = context.namespace != null ? context.namespace + "::" + name : name;
            if (!fullName.equals(type.cppName)) {
                decl.text = decl.text + "@Name(\"" + type.cppName + "\") ";
            } else if (context.namespace != null && context.group == null) {
                decl.text = decl.text + "@Namespace(\"" + context.namespace + "\") ";
            }
            decl.text = decl.text + "@Opaque public static class " + name + " extends " + base.javaName + " {\n" + "    public " + name + "() { }\n" + "    public " + name + "(Pointer p) { super(p); }\n" + "}";
            decl.type = type;
            decl.incomplete = true;
            String comment = this.commentAfter();
            decl.text = (String)comment + decl.text;
            declList.spacing = spacing;
            declList.add(decl);
            declList.spacing = null;
            return true;
        }
        if (this.tokens.get().match(Character.valueOf('{'))) {
            this.tokens.next();
        }
        if (!anonymous) {
            ctx.namespace = type.cppName;
            ctx.group = type;
        }
        if (info != null && info.virtualize) {
            ctx.virtualize = true;
        }
        DeclarationList declList2 = new DeclarationList();
        if (variables.size() == 0) {
            this.declarations(ctx, declList2);
        } else {
            for (Declarator var : variables) {
                if (context.variable != null) {
                    var.cppName = context.variable.cppName + "." + var.cppName;
                    var.javaName = context.variable.javaName + "_" + var.javaName;
                }
                ctx.variable = var;
                this.declarations(ctx, declList2);
            }
        }
        String modifiers = "public static ";
        boolean implicitConstructor = true;
        boolean defaultConstructor = false;
        boolean intConstructor = false;
        boolean abstractClass = false;
        boolean haveVariables = false;
        for (Declaration d : declList2) {
            if (d.declarator != null && d.declarator.type != null && d.declarator.type.constructor) {
                implicitConstructor = false;
                Declarator[] paramDcls = d.declarator.parameters.declarators;
                defaultConstructor |= paramDcls.length == 0 && !d.inaccessible;
                intConstructor |= paramDcls.length == 1 && paramDcls[0].type.javaName.equals("int") && !d.inaccessible;
            } else if (d.abstractMember) {
                implicitConstructor = false;
                abstractClass = true;
                if (ctx.virtualize) {
                    modifiers = "public static abstract ";
                }
            }
            haveVariables |= d.variable;
        }
        if (!anonymous) {
            Object fullName;
            Object object = fullName = context.namespace != null ? context.namespace + "::" + name : name;
            if (!((String)fullName).equals(type.cppName)) {
                decl.text = decl.text + "@Name(\"" + type.cppName + "\") ";
            } else if (context.namespace != null && context.group == null) {
                decl.text = decl.text + "@Namespace(\"" + context.namespace + "\") ";
            }
            if ((!implicitConstructor || derivedClass) && haveVariables) {
                decl.text = decl.text + "@NoOffset ";
            }
            if (info != null && info.base != null) {
                base.javaName = info.base;
            }
            decl.text = decl.text + modifiers + "class " + name + " extends " + base.javaName + " {\n" + "    static { Loader.load(); }\n";
            if (implicitConstructor) {
                decl.text = decl.text + "    public " + name + "() { allocate(); }\n" + "    public " + name + "(int size) { allocateArray(size); }\n" + "    public " + name + "(Pointer p) { super(p); }\n" + "    private native void allocate();\n" + "    private native void allocateArray(int size);\n" + "    @Override public " + name + " position(int position) {\n" + "        return (" + name + ")super.position(position);\n" + "    }\n";
            } else {
                if (!defaultConstructor || abstractClass) {
                    decl.text = decl.text + "    public " + name + "() { }\n";
                }
                decl.text = decl.text + "    public " + name + "(Pointer p) { super(p); }\n";
                if (defaultConstructor && !abstractClass && !intConstructor) {
                    decl.text = decl.text + "    public " + name + "(int size) { allocateArray(size); }\n" + "    private native void allocateArray(int size);\n" + "    @Override public " + name + " position(int position) {\n" + "        return (" + name + ")super.position(position);\n" + "    }\n";
                }
            }
            declList.spacing = spacing;
            decl.text = declList.rescan(decl.text + casts + "\n");
            declList.spacing = null;
        }
        for (Declaration d : declList2) {
            if (d.inaccessible || d.declarator != null && d.declarator.type != null && d.declarator.type.constructor && abstractClass) continue;
            decl.text = decl.text + d.text;
        }
        decl.text = decl.text + this.commentBefore();
        if (!anonymous) {
            decl.text = decl.text + this.tokens.get().spacing + '}';
        }
        Token token4 = this.tokens.next();
        while (!token4.match(Token.EOF)) {
            if (token4.match(Character.valueOf(';'))) {
                decl.text = decl.text + token4.spacing;
                break;
            }
            token4 = this.tokens.next();
        }
        this.tokens.next();
        decl.type = type;
        if (info != null && info.javaText != null) {
            decl.text = info.javaText;
        }
        declList.add(decl);
        return true;
    }

    boolean enumeration(Context context, DeclarationList declList) throws ParserException {
        int backIndex = this.tokens.index;
        String enumSpacing = this.tokens.get().spacing;
        boolean typedef = this.tokens.get().match(Token.TYPEDEF);
        boolean foundEnum = false;
        Token token = this.tokens.get();
        while (!token.match(Token.EOF)) {
            if (token.match(Token.ENUM)) {
                foundEnum = true;
                break;
            }
            if (!token.match(5)) break;
            token = this.tokens.next();
        }
        if (!foundEnum) {
            this.tokens.index = backIndex;
            return false;
        }
        if (typedef && !this.tokens.get(1).match(Character.valueOf('{')) && this.tokens.get(2).match(5)) {
            this.tokens.next();
        }
        int count = 0;
        String separator = "";
        String enumPrefix = "public static final int";
        String countPrefix = " ";
        String enumerators = "";
        String extraText = "";
        String name = this.tokens.next().expect((Object[])new Object[]{Integer.valueOf((int)5), Character.valueOf((char)'{')}).value;
        if (!this.tokens.get().match(Character.valueOf('{')) && !this.tokens.next().match(Character.valueOf('{'))) {
            this.tokens.index = backIndex;
            return false;
        }
        Token token2 = this.tokens.next();
        while (!token2.match(Token.EOF, Character.valueOf('}'))) {
            if (this.macro(context, declList)) {
                Declaration macroDecl = (Declaration)declList.removeLast();
                extraText = extraText + macroDecl.text;
                if (separator.equals(",") && !macroDecl.text.trim().startsWith("//")) {
                    separator = ";";
                    enumPrefix = "\npublic static final int";
                }
            } else {
                Info info;
                String cppName;
                String comment = this.commentBefore();
                Token enumerator = this.tokens.get();
                String javaName = cppName = enumerator.value;
                if (context.namespace != null) {
                    cppName = context.namespace + "::" + cppName;
                }
                if ((info = this.infoMap.getFirst(cppName)) != null && info.javaNames != null && info.javaNames.length > 0) {
                    javaName = info.javaNames[0];
                }
                String spacing2 = " ";
                if (this.tokens.next().match(Character.valueOf('='))) {
                    spacing2 = this.tokens.get().spacing;
                    countPrefix = " ";
                    int count2 = 0;
                    Token prevToken = new Token();
                    boolean translate = true;
                    token2 = this.tokens.next();
                    while (!token2.match(Token.EOF, Character.valueOf(','), Character.valueOf('}')) || count2 > 0) {
                        countPrefix = countPrefix + token2.spacing + token2;
                        if (token2.match(Character.valueOf('('))) {
                            ++count2;
                        } else if (token2.match(Character.valueOf(')'))) {
                            --count2;
                        }
                        if (prevToken.match(5) && token2.match(Character.valueOf('(')) || token2.match(Character.valueOf('{'), Character.valueOf('}'))) {
                            translate = false;
                        }
                        prevToken = token2;
                        token2 = this.tokens.next();
                    }
                    try {
                        count = Integer.parseInt(countPrefix.trim());
                        countPrefix = " ";
                    }
                    catch (NumberFormatException e) {
                        count = 0;
                        if (translate) {
                            countPrefix = this.translate(countPrefix);
                        }
                        if (separator.equals(",")) {
                            separator = ";";
                        }
                        extraText = "\npublic static native @MemberGetter int " + javaName + "();\n";
                        enumPrefix = "public static final int";
                        countPrefix = " " + javaName + "()";
                    }
                }
                enumerators = enumerators + separator + extraText + enumPrefix + comment;
                separator = ",";
                enumPrefix = "";
                extraText = "";
                comment = this.commentAfter();
                if (comment.length() == 0 && this.tokens.get().match(Character.valueOf(','))) {
                    this.tokens.next();
                    comment = this.commentAfter();
                }
                String spacing = enumerator.spacing;
                if (comment.length() > 0) {
                    enumerators = enumerators + spacing + comment;
                    int newline = spacing.lastIndexOf(10);
                    if (newline >= 0) {
                        spacing = spacing.substring(newline + 1);
                    }
                }
                if (spacing.length() == 0 && !enumerators.endsWith(",")) {
                    spacing = " ";
                }
                enumerators = enumerators + spacing + javaName + spacing2 + "=" + countPrefix;
                if (countPrefix.trim().length() > 0) {
                    if (count > 0) {
                        enumerators = enumerators + " + " + count;
                    }
                } else {
                    enumerators = enumerators + count;
                }
                ++count;
            }
            token2 = this.tokens.get();
        }
        String comment = this.commentBefore();
        Declaration decl = new Declaration();
        Token token3 = this.tokens.next();
        if (token3.match(5)) {
            name = token3.value;
            token3 = this.tokens.next();
        }
        if (context.namespace != null) {
            name = context.namespace + "::" + name;
        }
        decl.text = decl.text + enumSpacing + "/** enum " + name + " */\n";
        int newline = enumSpacing.lastIndexOf(10);
        if (newline >= 0) {
            enumSpacing = enumSpacing.substring(newline + 1);
        }
        decl.text = decl.text + enumSpacing + enumerators + token3.expect((Object[])new Object[]{Character.valueOf((char)';')}).spacing + ";";
        if (name.length() > 0) {
            this.infoMap.put(new Info(name).cast().valueTypes("int").pointerTypes("IntPointer", "IntBuffer", "int[]"));
        }
        this.tokens.next();
        decl.text = decl.text + extraText + comment;
        declList.add(decl);
        return true;
    }

    boolean namespace(Context context, DeclarationList declList) throws ParserException {
        if (!this.tokens.get().match(Token.NAMESPACE)) {
            return false;
        }
        Declaration decl = new Declaration();
        String name = this.tokens.next().expect((Object[])new Object[]{Integer.valueOf((int)5)}).value;
        this.tokens.next().expect(Character.valueOf('{'));
        this.tokens.next();
        context = new Context(context);
        context.namespace = context.namespace != null ? context.namespace + "::" + name : name;
        this.declarations(context, declList);
        decl.text = decl.text + this.tokens.get().expect((Object[])new Object[]{Character.valueOf((char)'}')}).spacing;
        this.tokens.next();
        declList.add(decl);
        return true;
    }

    boolean extern(Context context, DeclarationList declList) throws ParserException {
        if (!this.tokens.get().match(Token.EXTERN) || !this.tokens.get(1).match(3)) {
            return false;
        }
        Declaration decl = new Declaration();
        this.tokens.next().expect("\"C\"");
        if (!this.tokens.next().match(Character.valueOf('{'))) {
            declList.add(decl);
            return true;
        }
        this.tokens.next();
        this.declarations(context, declList);
        this.tokens.get().expect(Character.valueOf('}'));
        this.tokens.next();
        declList.add(decl);
        return true;
    }

    void declarations(Context context, DeclarationList declList) throws ParserException {
        Token token = this.tokens.get();
        while (!token.match(Token.EOF, Character.valueOf('}'))) {
            while (token.match(Token.PRIVATE, Token.PROTECTED, Token.PUBLIC) && this.tokens.get(1).match(Character.valueOf(':'))) {
                context.inaccessible = !token.match(Token.PUBLIC);
                this.tokens.next();
                this.tokens.next();
            }
            Context ctx = context;
            String comment = this.commentBefore();
            token = this.tokens.get();
            String spacing = token.spacing;
            TemplateMap map = this.template(ctx);
            if (map != null) {
                token = this.tokens.get();
                token.spacing = spacing;
                ctx = new Context(ctx);
                ctx.templateMap = map;
            }
            Declaration decl = new Declaration();
            if (comment != null && comment.length() > 0) {
                decl.inaccessible = ctx.inaccessible;
                decl.text = comment;
                declList.add(decl);
            }
            int startIndex = this.tokens.index;
            declList.infoMap = this.infoMap;
            declList.context = ctx;
            declList.templateMap = map;
            declList.infoIterator = null;
            declList.spacing = null;
            do {
                if (map != null && declList.infoIterator != null && declList.infoIterator.hasNext()) {
                    Info info = declList.infoIterator.next();
                    if (info == null) continue;
                    Type type = new Parser(this, info.cppNames[0]).type(context);
                    if (type.arguments == null) continue;
                    int count = 0;
                    for (Map.Entry entry : map.entrySet()) {
                        if (count >= type.arguments.length) continue;
                        Type t = type.arguments[count++];
                        String s = t.cppName;
                        if (t.constValue) {
                            s = "const " + s;
                        }
                        if (t.constPointer) {
                            s = s + " const";
                        }
                        if (t.pointer) {
                            s = s + "*";
                        }
                        if (t.reference) {
                            s = s + "&";
                        }
                        entry.setValue(s);
                    }
                    this.tokens.index = startIndex;
                }
                if (!(this.macro(ctx, declList) || this.extern(ctx, declList) || this.namespace(ctx, declList) || this.enumeration(ctx, declList) || this.group(ctx, declList) || this.typedef(ctx, declList) || this.using(ctx, declList) || this.function(ctx, declList) || this.variable(ctx, declList))) {
                    spacing = this.tokens.get().spacing;
                    if (this.attribute() != null) {
                        this.tokens.get().spacing = spacing;
                    } else {
                        throw new ParserException(token.file + ":" + token.lineNumber + ": Could not parse declaration at '" + token + "'");
                    }
                }
                while (this.tokens.get().match(Character.valueOf(';')) && !this.tokens.get().match(Token.EOF)) {
                    this.tokens.next();
                }
            } while (declList.infoIterator != null && declList.infoIterator.hasNext());
            token = this.tokens.get();
        }
    }

    void parse(String outputFilename, Context context, String[] includePath, String ... includes) throws IOException, ParserException {
        this.parse(new File(outputFilename), context, includePath, includes);
    }

    /*
     * WARNING - void declaration
     */
    void parse(File outputFile, Context context, String[] includePath, String ... includes) throws IOException, ParserException {
        ArrayList<Token> tokenList = new ArrayList<Token>();
        for (String include : includes) {
            void var10_12;
            Info info;
            void var10_17;
            void var10_15;
            Object var10_13 = null;
            Object filename = include;
            if (((String)filename).startsWith("<") && ((String)filename).endsWith(">")) {
                filename = ((String)filename).substring(1, ((String)filename).length() - 1);
            } else {
                String[] f = new File((String)filename);
                if (f.exists()) {
                    String[] stringArray = f;
                }
            }
            if (var10_15 == null && includePath != null) {
                for (String path : includePath) {
                    File f = new File(path, (String)filename);
                    if (!f.exists()) continue;
                    File file = f;
                    break;
                }
            }
            if (var10_17 == null) {
                File file = new File((String)filename);
            }
            if ((info = this.infoMap.getFirst(var10_12.getName())) != null && info.skip) continue;
            if (!var10_12.exists()) {
                throw new FileNotFoundException("Could not parse \"" + var10_12 + "\": File does not exist");
            }
            this.logger.info("Parsing " + var10_12);
            Token token = new Token();
            token.type = 4;
            token.value = "\n// Parsed from " + (String)include + "\n\n";
            tokenList.add(token);
            Tokenizer tokenizer = new Tokenizer((File)var10_12);
            while (!(token = tokenizer.nextToken()).isEmpty()) {
                if (token.type == -1) {
                    token.type = 4;
                }
                tokenList.add(token);
            }
            if (this.lineSeparator == null) {
                this.lineSeparator = tokenizer.lineSeparator;
            }
            tokenizer.close();
            token = new Token();
            token.type = 4;
            token.spacing = "\n";
            tokenList.add(token);
        }
        this.tokens = new TokenIndexer(this.infoMap, tokenList.toArray(new Token[tokenList.size()]));
        final String newline = this.lineSeparator != null ? this.lineSeparator : "\n";
        Writer out = outputFile != null ? new FileWriter(outputFile){

            @Override
            public Writer append(CharSequence text) throws IOException {
                return super.append(((String)text).replace("\n", newline).replace("\\u", "\\u005Cu"));
            }
        } : new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
        LinkedList<Info> infoList = this.leafInfoMap.get(null);
        for (Info info : infoList) {
            if (info.javaText == null || info.javaText.startsWith("import")) continue;
            out.append(info.javaText + "\n");
        }
        out.append("    static { Loader.load(); }\n");
        DeclarationList declList = new DeclarationList();
        this.containers(context, declList);
        this.declarations(context, declList);
        for (Declaration d : declList) {
            out.append(d.text);
        }
        String string = this.commentBefore();
        if (string != null) {
            out.append(string);
        }
        out.append("\n}\n").close();
    }

    public File parse(String outputDirectory, String[] classPath, Class cls) throws IOException, ParserException {
        return this.parse(new File(outputDirectory), classPath, cls);
    }

    public File parse(File outputDirectory, String[] classPath, Class cls) throws IOException, ParserException {
        ClassProperties allProperties = Loader.loadProperties(cls, this.properties, true);
        ClassProperties clsProperties = Loader.loadProperties(cls, this.properties, false);
        LinkedList<String> clsIncludes = new LinkedList<String>();
        clsIncludes.addAll(clsProperties.get("platform.include"));
        clsIncludes.addAll(clsProperties.get("platform.cinclude"));
        LinkedList<String> allIncludes = new LinkedList<String>();
        allIncludes.addAll(allProperties.get("platform.include"));
        allIncludes.addAll(allProperties.get("platform.cinclude"));
        LinkedList<String> allTargets = allProperties.get("target");
        LinkedList<String> clsTargets = clsProperties.get("target");
        LinkedList<String> clsHelpers = clsProperties.get("helper");
        String target = clsTargets.getFirst();
        LinkedList<Class> allInherited = allProperties.getInheritedClasses();
        this.infoMap = new InfoMap();
        for (Class c : allInherited) {
            try {
                ((InfoMapper)c.newInstance()).map(this.infoMap);
            }
            catch (ClassCastException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {}
        }
        this.leafInfoMap = new InfoMap();
        try {
            ((InfoMapper)cls.newInstance()).map(this.leafInfoMap);
        }
        catch (ClassCastException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        this.infoMap.putAll(this.leafInfoMap);
        String version = Generator.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "unknown";
        }
        String text = "// Targeted by JavaCPP version " + version + "\n\n";
        int n = target.lastIndexOf(46);
        if (n >= 0) {
            text = text + "package " + target.substring(0, n) + ";\n\n";
        }
        LinkedList<Info> infoList = this.leafInfoMap.get(null);
        for (Info info : infoList) {
            if (info.javaText == null || !info.javaText.startsWith("import")) continue;
            text = text + info.javaText + "\n";
        }
        text = text + "import java.nio.*;\nimport org.bytedeco.javacpp.*;\nimport org.bytedeco.javacpp.annotation.*;\n\n";
        for (String s : allTargets) {
            if (target.equals(s)) continue;
            text = text + "import static " + s + ".*;\n";
        }
        if (allTargets.size() > 1) {
            text = text + "\n";
        }
        text = text + "public class " + target.substring(n + 1) + " extends " + (clsHelpers.size() > 0 ? clsHelpers.getFirst() : cls.getCanonicalName()) + " {";
        this.leafInfoMap.putFirst(new Info().javaText(text));
        String targetPath = target.replace('.', File.separatorChar);
        File targetFile = new File(outputDirectory, targetPath + ".java");
        this.logger.info("Targeting " + targetFile);
        Context context = new Context();
        String[] includePath = classPath;
        n = targetPath.lastIndexOf(File.separatorChar);
        if (n >= 0) {
            includePath = (String[])classPath.clone();
            int i = 0;
            while (i < includePath.length) {
                int n2 = i++;
                includePath[n2] = includePath[n2] + File.separator + targetPath.substring(0, n);
            }
        }
        LinkedList<String> paths = allProperties.get("platform.includepath");
        String[] includePaths = paths.toArray(new String[paths.size() + includePath.length]);
        System.arraycopy(includePath, 0, includePaths, paths.size(), includePath.length);
        for (String include : allIncludes) {
            if (clsIncludes.contains(include)) continue;
            this.parse((File)null, context, includePaths, include);
        }
        this.parse(targetFile, context, includePaths, clsIncludes.toArray(new String[clsIncludes.size()]));
        return targetFile;
    }
}

