/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH
 * under one or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information regarding copyright
 * ownership. Camunda licenses this file to you under the Apache License,
 * Version 2.0; you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author Askar Akhmerov
 */
public class SetJobsRetriesBatchCmd extends AbstractSetJobsRetriesBatchCmd {
  protected final List<String> jobIds;
  protected final JobQuery jobQuery;

  public SetJobsRetriesBatchCmd(List<String> jobIds, JobQuery jobQuery, int retries) {
    this.jobQuery = jobQuery;
    this.jobIds = jobIds;
    this.retries = retries;
  }

  protected List<String> collectJobIds(CommandContext commandContext) {
    Set<String> collectedJobIds = new HashSet<String>();

    List<String> jobIds = this.getJobIds();
    if (jobIds != null) {
      collectedJobIds.addAll(jobIds);
    }

    final JobQuery jobQuery = this.jobQuery;
    if (jobQuery != null) {
      for (Job job : jobQuery.list()) {
        collectedJobIds.add(job.getId());
      }
    }

    return new ArrayList<String>(collectedJobIds);
  }

  public List<String> getJobIds() {
    return jobIds;
  }

  public int getRetries() {
    return retries;
  }

  public JobQuery getJobQuery() {
    return jobQuery;
  }
}
