/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.variable.VariableMap;

public class ThrowSignalEventActivityBehavior
extends AbstractBpmnActivityBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;
    protected final EventSubscriptionDeclaration signalDefinition;

    public ThrowSignalEventActivityBehavior(EventSubscriptionDeclaration signalDefinition) {
        this.signalDefinition = signalDefinition;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        String businessKey = this.signalDefinition.getEventPayload().getBusinessKey(execution);
        VariableMap variableMap = this.signalDefinition.getEventPayload().getInputVariables(execution);
        String eventName = this.signalDefinition.resolveExpressionOfEventName(execution);
        List<EventSubscriptionEntity> signalEventSubscriptions = this.findSignalEventSubscriptions(eventName, execution.getTenantId());
        for (EventSubscriptionEntity signalEventSubscription : signalEventSubscriptions) {
            if (!this.isActiveEventSubscription(signalEventSubscription)) continue;
            signalEventSubscription.eventReceived(variableMap, null, businessKey, this.signalDefinition.isAsync());
        }
        this.leave(execution);
    }

    protected List<EventSubscriptionEntity> findSignalEventSubscriptions(String signalName, String tenantId) {
        EventSubscriptionManager eventSubscriptionManager = Context.getCommandContext().getEventSubscriptionManager();
        if (tenantId != null) {
            return eventSubscriptionManager.findSignalEventSubscriptionsByEventNameAndTenantIdIncludeWithoutTenantId(signalName, tenantId);
        }
        return eventSubscriptionManager.findSignalEventSubscriptionsByEventNameAndTenantId(signalName, null);
    }

    protected boolean isActiveEventSubscription(EventSubscriptionEntity signalEventSubscriptionEntity) {
        return this.isStartEventSubscription(signalEventSubscriptionEntity) || this.isActiveIntermediateEventSubscription(signalEventSubscriptionEntity);
    }

    protected boolean isStartEventSubscription(EventSubscriptionEntity signalEventSubscriptionEntity) {
        return signalEventSubscriptionEntity.getExecutionId() == null;
    }

    protected boolean isActiveIntermediateEventSubscription(EventSubscriptionEntity signalEventSubscriptionEntity) {
        ExecutionEntity execution = signalEventSubscriptionEntity.getExecution();
        return execution != null && !execution.isEnded() && !execution.isCanceled();
    }
}

