/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.concurrent.Callable;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnExceptionHandler;
import org.camunda.bpm.engine.impl.bpmn.helper.ErrorPropagationException;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;

public class AbstractBpmnActivityBehavior
extends FlowNodeActivityBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;

    @Override
    public void doLeave(ActivityExecution execution) {
        PvmActivity currentActivity = execution.getActivity();
        ActivityImpl compensationHandler = ((ActivityImpl)currentActivity).findCompensationHandler();
        if (compensationHandler != null && !this.isCompensationEventSubprocess(compensationHandler)) {
            this.createCompensateEventSubscription(execution, compensationHandler);
        }
        super.doLeave(execution);
    }

    protected boolean isCompensationEventSubprocess(ActivityImpl activity) {
        return activity.isCompensationHandler() && activity.isSubProcessScope() && activity.isTriggeredByEvent();
    }

    protected void createCompensateEventSubscription(ActivityExecution execution, ActivityImpl compensationHandler) {
        PvmActivity currentActivity = execution.getActivity();
        ActivityExecution scopeExecution = execution.findExecutionForFlowScope(currentActivity.getFlowScope());
        EventSubscriptionEntity.createAndInsert((ExecutionEntity)scopeExecution, EventType.COMPENSATE, compensationHandler);
    }

    protected void executeWithErrorPropagation(ActivityExecution execution, Callable<Void> toExecute) throws Exception {
        String activityInstanceId = execution.getActivityInstanceId();
        try {
            toExecute.call();
        }
        catch (Exception ex) {
            if (activityInstanceId.equals(execution.getActivityInstanceId())) {
                try {
                    BpmnExceptionHandler.propagateException(execution, ex);
                }
                catch (ErrorPropagationException e) {
                    throw ex;
                }
            }
            throw ex;
        }
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if ("compensationDone".equals(signalName)) {
            this.signalCompensationDone(execution);
        } else {
            super.signal(execution, signalName, signalData);
        }
    }

    protected void signalCompensationDone(ActivityExecution execution) {
        if (((PvmExecutionImpl)execution).getNonEventScopeExecutions().isEmpty()) {
            if (execution.getParent() != null) {
                ActivityExecution parent = execution.getParent();
                execution.remove();
                parent.signal("compensationDone", null);
            }
        } else {
            ((ExecutionEntity)execution).forceUpdate();
        }
    }
}

