/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.metrics.reporter;

import java.util.ArrayList;
import java.util.TimerTask;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.metrics.MetricsLogger;
import org.camunda.bpm.engine.impl.metrics.MetricsRegistry;
import org.camunda.bpm.engine.impl.persistence.entity.MeterLogEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class MetricsCollectionTask
extends TimerTask {
    private static final MetricsLogger LOG = ProcessEngineLogger.METRICS_LOGGER;
    protected MetricsRegistry metricsRegistry;
    protected CommandExecutor commandExecutor;
    protected String reporterId = null;

    public MetricsCollectionTask(MetricsRegistry metricsRegistry, CommandExecutor commandExecutor) {
        this.metricsRegistry = metricsRegistry;
        this.commandExecutor = commandExecutor;
    }

    @Override
    public void run() {
        try {
            this.collectMetrics();
        }
        catch (Exception e) {
            try {
                LOG.couldNotCollectAndLogMetrics(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void collectMetrics() {
        final ArrayList<MeterLogEntity> logs = new ArrayList<MeterLogEntity>();
        for (Meter meter : this.metricsRegistry.getDbMeters().values()) {
            logs.add(new MeterLogEntity(meter.getName(), this.reporterId, meter.getAndClear(), ClockUtil.getCurrentTime()));
        }
        this.commandExecutor.execute(new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                for (MeterLogEntity meterLogEntity : logs) {
                    commandContext.getMeterLogManager().insert(meterLogEntity);
                }
                return null;
            }
        });
    }

    public String getReporter() {
        return this.reporterId;
    }

    public void setReporter(String reporterId) {
        this.reporterId = reporterId;
    }
}

