/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.telemetry.dto;

import camundajar.impl.com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.impl.telemetry.dto.ApplicationServer;
import org.camunda.bpm.engine.impl.telemetry.dto.Command;
import org.camunda.bpm.engine.impl.telemetry.dto.Database;
import org.camunda.bpm.engine.impl.telemetry.dto.Jdk;
import org.camunda.bpm.engine.impl.telemetry.dto.LicenseKeyData;
import org.camunda.bpm.engine.impl.telemetry.dto.Metric;

public class Internals {
    public static final String SERIALIZED_APPLICATION_SERVER = "application-server";
    public static final String SERIALIZED_CAMUNDA_INTEGRATION = "camunda-integration";
    public static final String SERIALIZED_LICENSE_KEY = "license-key";
    public static final String SERIALIZED_TELEMETRY_ENABLED = "telemetry-enabled";
    protected Database database;
    @SerializedName(value="application-server")
    protected ApplicationServer applicationServer;
    @SerializedName(value="license-key")
    protected LicenseKeyData licenseKey;
    protected Map<String, Command> commands;
    @SerializedName(value="camunda-integration")
    protected Set<String> camundaIntegration;
    protected Map<String, Metric> metrics;
    protected Jdk jdk;
    @SerializedName(value="telemetry-enabled")
    protected Boolean telemetryEnabled;

    public Internals() {
        this(null, null, null, null);
    }

    public Internals(Database database, ApplicationServer server, LicenseKeyData licenseKey, Jdk jdk) {
        this.database = database;
        this.applicationServer = server;
        this.licenseKey = licenseKey;
        this.commands = new HashMap<String, Command>();
        this.jdk = jdk;
        this.camundaIntegration = new HashSet<String>();
    }

    public Internals(Internals internals) {
        this(internals.database, internals.applicationServer, internals.licenseKey, internals.jdk);
        this.camundaIntegration = internals.camundaIntegration == null ? null : new HashSet<String>(internals.getCamundaIntegration());
        this.commands = new HashMap<String, Command>(internals.getCommands());
        this.metrics = internals.metrics == null ? null : new HashMap<String, Metric>(internals.getMetrics());
        this.telemetryEnabled = internals.telemetryEnabled;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public ApplicationServer getApplicationServer() {
        return this.applicationServer;
    }

    public void setApplicationServer(ApplicationServer applicationServer) {
        this.applicationServer = applicationServer;
    }

    public Map<String, Command> getCommands() {
        return this.commands;
    }

    public void setCommands(Map<String, Command> commands) {
        this.commands = commands;
    }

    public Map<String, Metric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Metric> metrics) {
        this.metrics = metrics;
    }

    public void mergeDynamicData(Internals other) {
        this.commands = other.commands;
        this.metrics = other.metrics;
    }

    public Jdk getJdk() {
        return this.jdk;
    }

    public void setJdk(Jdk jdk) {
        this.jdk = jdk;
    }

    public Set<String> getCamundaIntegration() {
        return this.camundaIntegration;
    }

    public void setCamundaIntegration(Set<String> camundaIntegration) {
        this.camundaIntegration = camundaIntegration;
    }

    public LicenseKeyData getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(LicenseKeyData licenseKey) {
        this.licenseKey = licenseKey;
    }

    public Boolean getTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    public void setTelemetryEnabled(Boolean telemetryEnabled) {
        this.telemetryEnabled = telemetryEnabled;
    }
}

