/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.telemetry.reporter;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.IsTelemetryEnabledCmd;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.metrics.MetricsRegistry;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.camunda.bpm.engine.impl.telemetry.CommandCounter;
import org.camunda.bpm.engine.impl.telemetry.TelemetryLogger;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.impl.telemetry.dto.ApplicationServer;
import org.camunda.bpm.engine.impl.telemetry.dto.Command;
import org.camunda.bpm.engine.impl.telemetry.dto.Data;
import org.camunda.bpm.engine.impl.telemetry.dto.Internals;
import org.camunda.bpm.engine.impl.telemetry.dto.Metric;
import org.camunda.bpm.engine.impl.telemetry.dto.Product;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.ConnectUtil;
import org.camunda.bpm.engine.impl.util.ExceptionUtil;
import org.camunda.bpm.engine.impl.util.JsonUtil;
import org.camunda.bpm.engine.impl.util.TelemetryUtil;
import org.camunda.connect.spi.CloseableConnectorResponse;
import org.camunda.connect.spi.Connector;
import org.camunda.connect.spi.ConnectorRequest;

public class TelemetrySendingTask
extends TimerTask {
    protected static final TelemetryLogger LOG = ProcessEngineLogger.TELEMETRY_LOGGER;
    protected static final Set<String> METRICS_TO_REPORT = new HashSet<String>();
    protected static final String TELEMETRY_INIT_MESSAGE_SENT_NAME = "camunda.telemetry.initial.message.sent";
    protected CommandExecutor commandExecutor;
    protected String telemetryEndpoint;
    protected Data staticData;
    protected Connector<? extends ConnectorRequest<?>> httpConnector;
    protected int telemetryRequestRetries;
    protected TelemetryRegistry telemetryRegistry;
    protected MetricsRegistry metricsRegistry;
    protected int telemetryRequestTimeout;
    protected boolean sendInitialMessage;

    public TelemetrySendingTask(CommandExecutor commandExecutor, String telemetryEndpoint, int telemetryRequestRetries, Data data, Connector<? extends ConnectorRequest<?>> httpConnector, TelemetryRegistry telemetryRegistry, MetricsRegistry metricsRegistry, int telemetryRequestTimeout, boolean sendInitialMessage) {
        this.commandExecutor = commandExecutor;
        this.telemetryEndpoint = telemetryEndpoint;
        this.telemetryRequestRetries = telemetryRequestRetries;
        this.staticData = data;
        this.httpConnector = httpConnector;
        this.telemetryRegistry = telemetryRegistry;
        this.metricsRegistry = metricsRegistry;
        this.telemetryRequestTimeout = telemetryRequestTimeout;
        this.sendInitialMessage = sendInitialMessage;
    }

    @Override
    public void run() {
        LOG.startTelemetrySendingTask();
        if (this.sendInitialMessage) {
            this.sendInitialMessage();
        }
        if (!this.isTelemetryEnabled()) {
            LOG.telemetryDisabled();
            this.updateTelemetryFlag(false);
            return;
        }
        this.updateTelemetryFlag(true);
        int triesLeft = this.telemetryRequestRetries + 1;
        boolean requestSuccessful = false;
        do {
            try {
                --triesLeft;
                this.updateStaticData();
                Internals dynamicData = this.resolveDynamicData();
                Data mergedData = new Data(this.staticData);
                mergedData.mergeInternals(dynamicData);
                try {
                    this.sendData(mergedData, false);
                }
                catch (Exception e) {
                    this.restoreDynamicData(dynamicData);
                    throw e;
                }
                requestSuccessful = true;
            }
            catch (Exception e) {
                LOG.exceptionWhileSendingTelemetryData(e, false);
            }
        } while (!requestSuccessful && triesLeft > 0);
    }

    protected void sendInitialMessage() {
        try {
            this.commandExecutor.execute(commandContext -> {
                this.sendInitialMessage(commandContext);
                return null;
            });
        }
        catch (ProcessEngineException pex) {
            if (!ExceptionUtil.checkConstraintViolationException(pex)) {
                LOG.exceptionWhileSendingTelemetryData(pex, true);
            }
        }
        catch (Exception e) {
            LOG.exceptionWhileSendingTelemetryData(e, true);
        }
    }

    protected void sendInitialMessage(CommandContext commandContext) {
        if (null == commandContext.getPropertyManager().findPropertyById(TELEMETRY_INIT_MESSAGE_SENT_NAME)) {
            int triesLeft = this.telemetryRequestRetries + 1;
            boolean requestSuccessful = false;
            do {
                try {
                    --triesLeft;
                    Data initData = new Data(this.staticData.getInstallation(), new Product(this.staticData.getProduct()));
                    Internals internals = new Internals();
                    internals.setTelemetryEnabled(new IsTelemetryEnabledCmd().execute(commandContext));
                    initData.getProduct().setInternals(internals);
                    this.sendData(initData, true);
                    requestSuccessful = true;
                    this.sendInitialMessage = false;
                    commandContext.getPropertyManager().insert(new PropertyEntity(TELEMETRY_INIT_MESSAGE_SENT_NAME, "true"));
                }
                catch (Exception e) {
                    LOG.exceptionWhileSendingTelemetryData(e, true);
                }
            } while (!requestSuccessful && triesLeft > 0);
        } else {
            this.sendInitialMessage = false;
        }
    }

    protected void updateStaticData() {
        Internals internals = this.staticData.getProduct().getInternals();
        if (internals.getApplicationServer() == null) {
            ApplicationServer applicationServer = this.telemetryRegistry.getApplicationServer();
            internals.setApplicationServer(applicationServer);
        }
        if (internals.getTelemetryEnabled() == null) {
            internals.setTelemetryEnabled(true);
        }
        internals.setLicenseKey(this.telemetryRegistry.getLicenseKey());
    }

    protected boolean isTelemetryEnabled() {
        Boolean telemetryEnabled = this.commandExecutor.execute(new IsTelemetryEnabledCmd());
        return telemetryEnabled != null && telemetryEnabled != false;
    }

    protected void sendData(Data dataToSend, boolean isInitialMessage) {
        String telemetryData = JsonUtil.asString(dataToSend);
        Map<String, Object> requestParams = ConnectUtil.assembleRequestParameters("POST", this.telemetryEndpoint, "application/json", telemetryData);
        requestParams = ConnectUtil.addRequestTimeoutConfiguration(requestParams, this.telemetryRequestTimeout);
        ConnectorRequest request = this.httpConnector.createRequest();
        request.setRequestParameters(requestParams);
        LOG.sendingTelemetryData(telemetryData, isInitialMessage);
        CloseableConnectorResponse response = (CloseableConnectorResponse)request.execute();
        if (response == null) {
            LOG.unexpectedResponseWhileSendingTelemetryData(isInitialMessage);
        } else {
            int responseCode = (Integer)response.getResponseParameter("statusCode");
            if (this.isSuccessStatusCode(responseCode)) {
                if (responseCode != 202) {
                    LOG.unexpectedResponseSuccessCode(responseCode, isInitialMessage);
                }
                LOG.telemetrySentSuccessfully(isInitialMessage);
            } else {
                throw LOG.unexpectedResponseWhileSendingTelemetryData(responseCode, isInitialMessage);
            }
        }
    }

    protected boolean isSuccessStatusCode(int statusCode) {
        return statusCode / 100 == 2;
    }

    protected void clearDynamicData() {
        Internals internals = this.staticData.getProduct().getInternals();
        internals.setApplicationServer(null);
        internals.setCommands(null);
        internals.setMetrics(null);
        internals.setLicenseKey(null);
    }

    protected void restoreDynamicData(Internals internals) {
        Map<String, Command> commands = internals.getCommands();
        for (Map.Entry<String, Command> entry : commands.entrySet()) {
            this.telemetryRegistry.markOccurrence(entry.getKey(), entry.getValue().getCount());
        }
        if (this.metricsRegistry != null) {
            Map<String, Metric> metrics = internals.getMetrics();
            for (String metricToReport : METRICS_TO_REPORT) {
                Metric metricValue = metrics.get(metricToReport);
                this.metricsRegistry.markTelemetryOccurrence(metricToReport, metricValue.getCount());
            }
        }
    }

    protected Internals resolveDynamicData() {
        Internals result = new Internals();
        Map<String, Metric> metrics = this.calculateMetrics();
        result.setMetrics(metrics);
        Map<String, Command> commands = this.fetchAndResetCommandCounts();
        result.setCommands(commands);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Command> fetchAndResetCommandCounts() {
        Map<String, CommandCounter> originalCounts;
        HashMap<String, Command> commandsToReport = new HashMap<String, Command>();
        Map<String, CommandCounter> map = originalCounts = this.telemetryRegistry.getCommands();
        synchronized (map) {
            for (Map.Entry<String, CommandCounter> counter : originalCounts.entrySet()) {
                long occurrences = counter.getValue().getAndClear();
                commandsToReport.put(counter.getKey(), new Command(occurrences));
            }
        }
        return commandsToReport;
    }

    protected Map<String, Metric> calculateMetrics() {
        Date currentTime = ClockUtil.getCurrentTime();
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        if (this.metricsRegistry != null) {
            Map<String, Meter> telemetryMeters = this.metricsRegistry.getTelemetryMeters();
            for (String metricToReport : METRICS_TO_REPORT) {
                long value = telemetryMeters.get(metricToReport).getAndClear();
                metrics.put(metricToReport, new Metric(value));
            }
        }
        Long taskWorkers = this.commandExecutor.execute(c -> this.calculateUniqueUserCount(c, c.getProcessEngineConfiguration().getHistoryLevel(), currentTime));
        metrics.put("unique-task-workers", new Metric(taskWorkers));
        return metrics;
    }

    protected long calculateMetricCount(ManagementService managementService, Date startReportTime, Date currentTime, String metricName) {
        return managementService.createMetricsQuery().name(metricName).startDate(startReportTime).endDate(currentTime).sum();
    }

    protected long calculateUniqueUserCount(CommandContext commandContext, HistoryLevel historyLevel, Date currentTime) {
        if (historyLevel.equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
            return 0L;
        }
        Date previousDay = this.previousDay(currentTime);
        long workerCount = commandContext.getHistoricTaskInstanceManager().findUniqueTaskWorkerCount(previousDay, currentTime);
        return workerCount;
    }

    protected Date previousDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, -1);
        Date result = calendar.getTime();
        return result;
    }

    protected void updateTelemetryFlag(boolean enabled) {
        TelemetryUtil.updateCollectingTelemetryDataEnabled(this.telemetryRegistry, this.metricsRegistry, enabled);
    }

    static {
        METRICS_TO_REPORT.add("root-process-instance-start");
        METRICS_TO_REPORT.add("executed-decision-instances");
        METRICS_TO_REPORT.add("executed-decision-elements");
        METRICS_TO_REPORT.add("activity-instance-start");
    }
}

