/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmd.ExternalTaskCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public abstract class HandleExternalTaskCmd
extends ExternalTaskCmd {
    protected String workerId;

    public HandleExternalTaskCmd(String externalTaskId, String workerId) {
        super(externalTaskId);
        this.workerId = workerId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.validateInput();
        ExternalTaskEntity externalTask = commandContext.getExternalTaskManager().findExternalTaskById(this.externalTaskId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "Cannot find external task with id " + this.externalTaskId, "externalTask", (Object)externalTask);
        if (this.validateWorkerViolation(externalTask)) {
            throw new BadUserRequestException(this.getErrorMessageOnWrongWorkerAccess() + "'. It is locked by worker '" + externalTask.getWorkerId() + "'.");
        }
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessInstanceById(externalTask.getProcessInstanceId());
        }
        this.execute(externalTask);
        return null;
    }

    public abstract String getErrorMessageOnWrongWorkerAccess();

    @Override
    protected void validateInput() {
        EnsureUtil.ensureNotNull("workerId", (Object)this.workerId);
    }

    protected boolean validateWorkerViolation(ExternalTaskEntity externalTask) {
        return !this.workerId.equals(externalTask.getWorkerId());
    }
}

