/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.deploy.cache;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.ResourceDefinitionCache;
import org.camunda.bpm.engine.impl.repository.ResourceDefinitionEntity;
import org.camunda.bpm.engine.repository.ResourceDefinition;
import org.camunda.bpm.model.xml.ModelInstance;
import org.camunda.commons.utils.cache.Cache;

public abstract class ModelInstanceCache<InstanceType extends ModelInstance, DefinitionType extends ResourceDefinitionEntity> {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected Cache<String, InstanceType> instanceCache;
    protected ResourceDefinitionCache<DefinitionType> definitionCache;

    public ModelInstanceCache(CacheFactory factory, int cacheCapacity, ResourceDefinitionCache<DefinitionType> definitionCache) {
        this.instanceCache = factory.createCache(cacheCapacity);
        this.definitionCache = definitionCache;
    }

    public InstanceType findBpmnModelInstanceForDefinition(DefinitionType definitionEntity) {
        Object bpmnModelInstance = (ModelInstance)this.instanceCache.get((Object)definitionEntity.getId());
        if (bpmnModelInstance == null) {
            bpmnModelInstance = this.loadAndCacheBpmnModelInstance(definitionEntity);
        }
        return (InstanceType)bpmnModelInstance;
    }

    public InstanceType findBpmnModelInstanceForDefinition(String definitionId) {
        Object bpmnModelInstance = (ModelInstance)this.instanceCache.get((Object)definitionId);
        if (bpmnModelInstance == null) {
            DefinitionType definition = this.definitionCache.findDeployedDefinitionById(definitionId);
            bpmnModelInstance = this.loadAndCacheBpmnModelInstance(definition);
        }
        return (InstanceType)bpmnModelInstance;
    }

    protected InstanceType loadAndCacheBpmnModelInstance(final DefinitionType definitionEntity) {
        final CommandContext commandContext = Context.getCommandContext();
        InputStream bpmnResourceInputStream = commandContext.runWithoutAuthorization(new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                return new GetDeploymentResourceCmd(definitionEntity.getDeploymentId(), definitionEntity.getResourceName()).execute(commandContext);
            }
        });
        try {
            InstanceType bpmnModelInstance = this.readModelFromStream(bpmnResourceInputStream);
            this.instanceCache.put((Object)definitionEntity.getId(), bpmnModelInstance);
            return bpmnModelInstance;
        }
        catch (Exception e) {
            this.throwLoadModelException(definitionEntity.getId(), e);
            return null;
        }
    }

    public void removeAllDefinitionsByDeploymentId(String deploymentId) {
        List<ResourceDefinition> allDefinitionsForDeployment = this.getAllDefinitionsForDeployment(deploymentId);
        for (ResourceDefinition definition : allDefinitionsForDeployment) {
            try {
                this.instanceCache.remove((Object)definition.getId());
                this.definitionCache.removeDefinitionFromCache(definition.getId());
            }
            catch (Exception e) {
                this.logRemoveEntryFromDeploymentCacheFailure(definition.getId(), e);
            }
        }
    }

    public void remove(String definitionId) {
        this.instanceCache.remove((Object)definitionId);
    }

    public void clear() {
        this.instanceCache.clear();
    }

    public Cache<String, InstanceType> getCache() {
        return this.instanceCache;
    }

    protected abstract void throwLoadModelException(String var1, Exception var2);

    protected abstract void logRemoveEntryFromDeploymentCacheFailure(String var1, Exception var2);

    protected abstract InstanceType readModelFromStream(InputStream var1);

    protected abstract List<? extends ResourceDefinition> getAllDefinitionsForDeployment(String var1);
}

