/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.nio.charset.StandardCharsets;
import org.camunda.bpm.engine.impl.cmd.DeleteLicenseKeyCmd;
import org.camunda.bpm.engine.impl.cmd.DeletePropertyCmd;
import org.camunda.bpm.engine.impl.cmd.LicenseCmd;
import org.camunda.bpm.engine.impl.cmd.SetPropertyCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.LicenseKeyUtil;

public class SetLicenseKeyCmd
extends LicenseCmd
implements Command<Object> {
    protected String licenseKey;

    public SetLicenseKeyCmd(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("licenseKey", (Object)this.licenseKey);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkCamundaAdmin();
        ResourceManager resourceManager = commandContext.getResourceManager();
        ResourceEntity key = resourceManager.findLicenseKeyResource();
        if (key != null) {
            new DeleteLicenseKeyCmd(false, false).execute(commandContext);
        }
        key = new ResourceEntity();
        key.setName("camunda-license-key");
        key.setBytes(this.licenseKey.getBytes(StandardCharsets.UTF_8));
        resourceManager.insertResource(key);
        new SetPropertyCmd("camunda-license-key-id", key.getId()).execute(commandContext);
        new DeletePropertyCmd("camunda-license-key").execute(commandContext);
        LicenseKeyUtil.addToTelemetry(this.licenseKey, commandContext.getProcessEngineConfiguration().getTelemetryRegistry());
        return null;
    }
}

