/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.model.BaseCallableElement;
import org.camunda.bpm.engine.impl.el.StartProcessVariableScope;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class CallableElementUtil {
    public static DeploymentCache getDeploymentCache() {
        return Context.getProcessEngineConfiguration().getDeploymentCache();
    }

    public static ProcessDefinitionImpl getProcessDefinitionToCall(VariableScope execution, BaseCallableElement callableElement) {
        String processDefinitionKey = callableElement.getDefinitionKey(execution);
        String tenantId = callableElement.getDefinitionTenantId(execution);
        return CallableElementUtil.getCalledProcessDefinition(execution, callableElement, processDefinitionKey, tenantId);
    }

    public static ProcessDefinition getStaticallyBoundProcessDefinition(String callingProcessDefinitionId, String activityId, BaseCallableElement callableElement, String tenantId) {
        if (callableElement.hasDynamicReferences()) {
            return null;
        }
        StartProcessVariableScope emptyVariableScope = StartProcessVariableScope.getSharedInstance();
        String targetTenantId = tenantId;
        try {
            targetTenantId = callableElement.getDefinitionTenantId(emptyVariableScope);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String processDefinitionKey = callableElement.getDefinitionKey(emptyVariableScope);
            return CallableElementUtil.getCalledProcessDefinition(emptyVariableScope, callableElement, processDefinitionKey, targetTenantId);
        }
        catch (ProcessEngineException e) {
            ProcessEngineLogger.UTIL_LOGGER.debugCouldNotResolveCallableElement(callingProcessDefinitionId, activityId, e);
            return null;
        }
    }

    private static ProcessDefinitionEntity getCalledProcessDefinition(VariableScope execution, BaseCallableElement callableElement, String processDefinitionKey, String tenantId) {
        DeploymentCache deploymentCache = CallableElementUtil.getDeploymentCache();
        ProcessDefinitionEntity processDefinition = null;
        if (callableElement.isLatestBinding()) {
            processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, tenantId);
        } else if (callableElement.isDeploymentBinding()) {
            String deploymentId = callableElement.getDeploymentId();
            processDefinition = deploymentCache.findDeployedProcessDefinitionByDeploymentAndKey(deploymentId, processDefinitionKey);
        } else if (callableElement.isVersionBinding()) {
            Integer version = callableElement.getVersion(execution);
            processDefinition = deploymentCache.findDeployedProcessDefinitionByKeyVersionAndTenantId(processDefinitionKey, version, tenantId);
        } else if (callableElement.isVersionTagBinding()) {
            String versionTag = callableElement.getVersionTag(execution);
            processDefinition = deploymentCache.findDeployedProcessDefinitionByKeyVersionTagAndTenantId(processDefinitionKey, versionTag, tenantId);
        }
        return processDefinition;
    }

    public static CmmnCaseDefinition getCaseDefinitionToCall(VariableScope execution, BaseCallableElement callableElement) {
        String caseDefinitionKey = callableElement.getDefinitionKey(execution);
        String tenantId = callableElement.getDefinitionTenantId(execution);
        DeploymentCache deploymentCache = CallableElementUtil.getDeploymentCache();
        CaseDefinitionEntity caseDefinition = null;
        if (callableElement.isLatestBinding()) {
            caseDefinition = deploymentCache.findDeployedLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, tenantId);
        } else if (callableElement.isDeploymentBinding()) {
            String deploymentId = callableElement.getDeploymentId();
            caseDefinition = deploymentCache.findDeployedCaseDefinitionByDeploymentAndKey(deploymentId, caseDefinitionKey);
        } else if (callableElement.isVersionBinding()) {
            Integer version = callableElement.getVersion(execution);
            caseDefinition = deploymentCache.findDeployedCaseDefinitionByKeyVersionAndTenantId(caseDefinitionKey, version, tenantId);
        }
        return caseDefinition;
    }

    public static DecisionDefinition getDecisionDefinitionToCall(VariableScope execution, BaseCallableElement callableElement) {
        String decisionDefinitionKey = callableElement.getDefinitionKey(execution);
        String tenantId = callableElement.getDefinitionTenantId(execution);
        DeploymentCache deploymentCache = CallableElementUtil.getDeploymentCache();
        DecisionDefinition decisionDefinition = null;
        if (callableElement.isLatestBinding()) {
            decisionDefinition = deploymentCache.findDeployedLatestDecisionDefinitionByKeyAndTenantId(decisionDefinitionKey, tenantId);
        } else if (callableElement.isDeploymentBinding()) {
            String deploymentId = callableElement.getDeploymentId();
            decisionDefinition = deploymentCache.findDeployedDecisionDefinitionByDeploymentAndKey(deploymentId, decisionDefinitionKey);
        } else if (callableElement.isVersionBinding()) {
            Integer version = callableElement.getVersion(execution);
            decisionDefinition = deploymentCache.findDeployedDecisionDefinitionByKeyVersionAndTenantId(decisionDefinitionKey, version, tenantId);
        } else if (callableElement.isVersionTagBinding()) {
            String versionTag = callableElement.getVersionTag(execution);
            decisionDefinition = deploymentCache.findDeployedDecisionDefinitionByKeyVersionTagAndTenantId(decisionDefinitionKey, versionTag, tenantId);
        }
        return decisionDefinition;
    }
}

