/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder;
import org.camunda.bpm.engine.history.SetRemovalTimeToHistoricProcessInstancesBuilder;
import org.camunda.bpm.engine.impl.cmd.batch.removaltime.SetRemovalTimeToHistoricProcessInstancesCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetRemovalTimeToHistoricProcessInstancesBuilderImpl
implements SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder {
    protected HistoricProcessInstanceQuery query;
    protected List<String> ids;
    protected Date removalTime;
    protected Mode mode = null;
    protected boolean isHierarchical;
    protected CommandExecutor commandExecutor;

    public SetRemovalTimeToHistoricProcessInstancesBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public SetRemovalTimeToHistoricProcessInstancesBuilder byQuery(HistoricProcessInstanceQuery query) {
        this.query = query;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricProcessInstancesBuilder byIds(String ... ids) {
        this.ids = ids != null ? Arrays.asList(ids) : null;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricProcessInstancesBuilder absoluteRemovalTime(Date removalTime) {
        EnsureUtil.ensureNull(BadUserRequestException.class, "The removal time modes are mutually exclusive", "mode", (Object)this.mode);
        this.mode = Mode.ABSOLUTE_REMOVAL_TIME;
        this.removalTime = removalTime;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricProcessInstancesBuilder calculatedRemovalTime() {
        EnsureUtil.ensureNull(BadUserRequestException.class, "The removal time modes are mutually exclusive", "mode", (Object)this.mode);
        this.mode = Mode.CALCULATED_REMOVAL_TIME;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricProcessInstancesBuilder clearedRemovalTime() {
        EnsureUtil.ensureNull(BadUserRequestException.class, "The removal time modes are mutually exclusive", "mode", (Object)this.mode);
        this.mode = Mode.CLEARED_REMOVAL_TIME;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricProcessInstancesBuilder hierarchical() {
        this.isHierarchical = true;
        return this;
    }

    @Override
    public Batch executeAsync() {
        return this.commandExecutor.execute(new SetRemovalTimeToHistoricProcessInstancesCmd(this));
    }

    public HistoricProcessInstanceQuery getQuery() {
        return this.query;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public Date getRemovalTime() {
        return this.removalTime;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isHierarchical() {
        return this.isHierarchical;
    }

    public static enum Mode {
        CALCULATED_REMOVAL_TIME,
        ABSOLUTE_REMOVAL_TIME,
        CLEARED_REMOVAL_TIME;

    }
}

