/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.task;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.calendar.BusinessCalendar;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.task.TaskDefinition;

public class TaskDecorator {
    protected TaskDefinition taskDefinition;
    protected ExpressionManager expressionManager;

    public TaskDecorator(TaskDefinition taskDefinition, ExpressionManager expressionManager) {
        this.taskDefinition = taskDefinition;
        this.expressionManager = expressionManager;
    }

    public void decorate(TaskEntity task, VariableScope variableScope) {
        task.setTaskDefinition(this.taskDefinition);
        this.initializeTaskName(task, variableScope);
        this.initializeTaskDescription(task, variableScope);
        this.initializeTaskDueDate(task, variableScope);
        this.initializeTaskFollowUpDate(task, variableScope);
        this.initializeTaskPriority(task, variableScope);
        this.initializeTaskAssignments(task, variableScope);
    }

    protected void initializeTaskName(TaskEntity task, VariableScope variableScope) {
        Expression nameExpression = this.taskDefinition.getNameExpression();
        if (nameExpression != null) {
            String name = (String)nameExpression.getValue(variableScope);
            task.setName(name);
        }
    }

    protected void initializeTaskDescription(TaskEntity task, VariableScope variableScope) {
        Expression descriptionExpression = this.taskDefinition.getDescriptionExpression();
        if (descriptionExpression != null) {
            String description = (String)descriptionExpression.getValue(variableScope);
            task.setDescription(description);
        }
    }

    protected void initializeTaskDueDate(TaskEntity task, VariableScope variableScope) {
        Object dueDate;
        Expression dueDateExpression = this.taskDefinition.getDueDateExpression();
        if (dueDateExpression != null && (dueDate = dueDateExpression.getValue(variableScope)) != null) {
            if (dueDate instanceof Date) {
                task.setDueDate((Date)dueDate);
            } else if (dueDate instanceof String) {
                BusinessCalendar businessCalendar = this.getBusinessCalender();
                task.setDueDate(businessCalendar.resolveDuedate((String)dueDate, task));
            } else {
                throw new ProcessEngineException("Due date expression does not resolve to a Date or Date string: " + dueDateExpression.getExpressionText());
            }
        }
    }

    protected void initializeTaskFollowUpDate(TaskEntity task, VariableScope variableScope) {
        Object followUpDate;
        Expression followUpDateExpression = this.taskDefinition.getFollowUpDateExpression();
        if (followUpDateExpression != null && (followUpDate = followUpDateExpression.getValue(variableScope)) != null) {
            if (followUpDate instanceof Date) {
                task.setFollowUpDate((Date)followUpDate);
            } else if (followUpDate instanceof String) {
                BusinessCalendar businessCalendar = this.getBusinessCalender();
                task.setFollowUpDate(businessCalendar.resolveDuedate((String)followUpDate, task));
            } else {
                throw new ProcessEngineException("Follow up date expression does not resolve to a Date or Date string: " + followUpDateExpression.getExpressionText());
            }
        }
    }

    protected void initializeTaskPriority(TaskEntity task, VariableScope variableScope) {
        Object priority;
        Expression priorityExpression = this.taskDefinition.getPriorityExpression();
        if (priorityExpression != null && (priority = priorityExpression.getValue(variableScope)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.valueOf((String)priority));
                }
                catch (NumberFormatException e) {
                    throw new ProcessEngineException("Priority does not resolve to a number: " + priority, e);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new ProcessEngineException("Priority expression does not resolve to a number: " + priorityExpression.getExpressionText());
            }
        }
    }

    protected void initializeTaskAssignments(TaskEntity task, VariableScope variableScope) {
        this.initializeTaskAssignee(task, variableScope);
        this.initializeTaskCandidateUsers(task, variableScope);
        this.initializeTaskCandidateGroups(task, variableScope);
    }

    protected void initializeTaskAssignee(TaskEntity task, VariableScope variableScope) {
        Expression assigneeExpression = this.taskDefinition.getAssigneeExpression();
        if (assigneeExpression != null) {
            task.setAssignee((String)assigneeExpression.getValue(variableScope));
        }
    }

    protected void initializeTaskCandidateGroups(TaskEntity task, VariableScope variableScope) {
        Set<Expression> candidateGroupIdExpressions = this.taskDefinition.getCandidateGroupIdExpressions();
        for (Expression groupIdExpr : candidateGroupIdExpressions) {
            Object value = groupIdExpr.getValue(variableScope);
            if (value instanceof String) {
                List<String> candiates = this.extractCandidates((String)value);
                task.addCandidateGroups(candiates);
                continue;
            }
            if (value instanceof Collection) {
                task.addCandidateGroups((Collection)value);
                continue;
            }
            throw new ProcessEngineException("Expression did not resolve to a string or collection of strings");
        }
    }

    protected void initializeTaskCandidateUsers(TaskEntity task, VariableScope variableScope) {
        Set<Expression> candidateUserIdExpressions = this.taskDefinition.getCandidateUserIdExpressions();
        for (Expression userIdExpr : candidateUserIdExpressions) {
            Object value = userIdExpr.getValue(variableScope);
            if (value instanceof String) {
                List<String> candiates = this.extractCandidates((String)value);
                task.addCandidateUsers(candiates);
                continue;
            }
            if (value instanceof Collection) {
                task.addCandidateUsers((Collection)value);
                continue;
            }
            throw new ProcessEngineException("Expression did not resolve to a string or collection of strings");
        }
    }

    protected List<String> extractCandidates(String str) {
        return Arrays.asList(str.split("[\\s]*,[\\s]*"));
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    protected BusinessCalendar getBusinessCalender() {
        return Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar("dueDate");
    }
}

