/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstanceQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.HistoricCaseActivityInstanceQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class HistoricCaseActivityInstanceQueryImpl
extends AbstractQuery<HistoricCaseActivityInstanceQuery, HistoricCaseActivityInstance>
implements HistoricCaseActivityInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String caseActivityInstanceId;
    protected String caseInstanceId;
    protected String caseDefinitionId;
    protected String caseExecutionId;
    protected String caseActivityId;
    protected String caseActivityName;
    protected String caseActivityType;
    protected Date createdBefore;
    protected Date createdAfter;
    protected Date endedBefore;
    protected Date endedAfter;
    protected Boolean ended;
    protected Integer caseActivityInstanceState;

    public HistoricCaseActivityInstanceQueryImpl() {
    }

    public HistoricCaseActivityInstanceQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoricCaseActivityInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricCaseActivityInstanceManager().findHistoricCaseActivityInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricCaseActivityInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getHistoricCaseActivityInstanceManager().findHistoricCaseActivityInstancesByQueryCriteria(this, page);
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseActivityInstanceId(String caseActivityInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseActivityInstanceId", (Object)caseActivityInstanceId);
        this.caseActivityInstanceId = caseActivityInstanceId;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseInstanceId(String caseInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseInstanceId", (Object)caseInstanceId);
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseDefinitionId(String caseDefinitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseDefinitionId", (Object)caseDefinitionId);
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseExecutionId(String caseExecutionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseExecutionId", (Object)caseExecutionId);
        this.caseActivityInstanceId = caseExecutionId;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseActivityId(String caseActivityId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseActivityId", (Object)caseActivityId);
        this.caseActivityId = caseActivityId;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseActivityName(String caseActivityName) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseActivityName", (Object)caseActivityName);
        this.caseActivityName = caseActivityName;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery caseActivityType(String caseActivityType) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseActivityType", (Object)caseActivityType);
        this.caseActivityType = caseActivityType;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery createdBefore(Date date) {
        EnsureUtil.ensureNotNull(NotValidException.class, "createdBefore", (Object)date);
        this.createdBefore = date;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery createdAfter(Date date) {
        EnsureUtil.ensureNotNull(NotValidException.class, "createdAfter", (Object)date);
        this.createdAfter = date;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery endedBefore(Date date) {
        EnsureUtil.ensureNotNull(NotValidException.class, "finishedBefore", (Object)date);
        this.endedBefore = date;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery endedAfter(Date date) {
        EnsureUtil.ensureNotNull(NotValidException.class, "finishedAfter", (Object)date);
        this.endedAfter = date;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery ended() {
        this.ended = true;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery notEnded() {
        this.ended = false;
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery available() {
        EnsureUtil.ensureNull(NotValidException.class, "Already querying for case activity instance state '" + this.caseActivityInstanceState + "'", "caseActivityState", this.caseActivityInstanceState);
        this.caseActivityInstanceState = CaseExecutionState.AVAILABLE.getStateCode();
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery enabled() {
        EnsureUtil.ensureNull(NotValidException.class, "Already querying for case activity instance state '" + this.caseActivityInstanceState + "'", "caseActivityState", this.caseActivityInstanceState);
        this.caseActivityInstanceState = CaseExecutionState.ENABLED.getStateCode();
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery disabled() {
        EnsureUtil.ensureNull(NotValidException.class, "Already querying for case activity instance state '" + this.caseActivityInstanceState + "'", "caseActivityState", this.caseActivityInstanceState);
        this.caseActivityInstanceState = CaseExecutionState.DISABLED.getStateCode();
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery active() {
        EnsureUtil.ensureNull(NotValidException.class, "Already querying for case activity instance state '" + this.caseActivityInstanceState + "'", "caseActivityState", this.caseActivityInstanceState);
        this.caseActivityInstanceState = CaseExecutionState.ACTIVE.getStateCode();
        return this;
    }

    public HistoricCaseActivityInstanceQuery suspended() {
        EnsureUtil.ensureNull(NotValidException.class, "Already querying for case activity instance state '" + this.caseActivityInstanceState + "'", "caseActivityState", this.caseActivityInstanceState);
        this.caseActivityInstanceState = CaseExecutionState.SUSPENDED.getStateCode();
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery completed() {
        EnsureUtil.ensureNull(NotValidException.class, "Already querying for case activity instance state '" + this.caseActivityInstanceState + "'", "caseActivityState", this.caseActivityInstanceState);
        this.caseActivityInstanceState = CaseExecutionState.COMPLETED.getStateCode();
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery terminated() {
        EnsureUtil.ensureNull(NotValidException.class, "Already querying for case activity instance state '" + this.caseActivityInstanceState + "'", "caseActivityState", this.caseActivityInstanceState);
        this.caseActivityInstanceState = CaseExecutionState.TERMINATED.getStateCode();
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByHistoricCaseActivityInstanceId() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.HISTORIC_CASE_ACTIVITY_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByCaseInstanceId() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.CASE_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByCaseExecutionId() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.HISTORIC_CASE_ACTIVITY_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByCaseActivityId() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.CASE_ACTIVITY_ID);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByCaseActivityName() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.CASE_ACTIVITY_NAME);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByCaseActivityType() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.CASE_ACTIVITY_TYPE);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByHistoricCaseActivityInstanceCreateTime() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.CREATE);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByHistoricCaseActivityInstanceEndTime() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.END);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByHistoricCaseActivityInstanceDuration() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.DURATION);
        return this;
    }

    @Override
    public HistoricCaseActivityInstanceQuery orderByCaseDefinitionId() {
        this.orderBy(HistoricCaseActivityInstanceQueryProperty.CASE_DEFINITION_ID);
        return this;
    }

    public String getCaseActivityInstanceId() {
        return this.caseActivityInstanceId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseActivityId() {
        return this.caseActivityId;
    }

    public String getCaseActivityName() {
        return this.caseActivityName;
    }

    public String getCaseActivityType() {
        return this.caseActivityType;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public Date getEndedBefore() {
        return this.endedBefore;
    }

    public Date getEndedAfter() {
        return this.endedAfter;
    }

    public Boolean getEnded() {
        return this.ended;
    }

    public Integer getCaseActivityInstanceState() {
        return this.caseActivityInstanceState;
    }
}

