/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.task.IdentityLink;

public class IdentityLinkEntity
implements Serializable,
IdentityLink,
DbEntity {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String type;
    protected String userId;
    protected String groupId;
    protected String taskId;
    protected String processDefId;
    protected TaskEntity task;
    protected ProcessDefinitionEntity processDef;

    @Override
    public Object getPersistentState() {
        return this.type;
    }

    public static IdentityLinkEntity createAndInsert() {
        IdentityLinkEntity identityLinkEntity = new IdentityLinkEntity();
        Context.getCommandContext().getDbEntityManager().insert(identityLinkEntity);
        return identityLinkEntity;
    }

    public boolean isUser() {
        return this.userId != null;
    }

    public boolean isGroup() {
        return this.groupId != null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        if (this.groupId != null && userId != null) {
            throw new ProcessEngineException("Cannot assign a userId to a task assignment that already has a groupId");
        }
        this.userId = userId;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        if (this.userId != null && groupId != null) {
            throw new ProcessEngineException("Cannot assign a groupId to a task assignment that already has a userId");
        }
        this.groupId = groupId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }

    public TaskEntity getTask() {
        if (this.task == null && this.taskId != null) {
            this.task = Context.getCommandContext().getTaskManager().findTaskById(this.taskId);
        }
        return this.task;
    }

    public void setTask(TaskEntity task) {
        this.task = task;
        this.taskId = task.getId();
    }

    public ProcessDefinitionEntity getProcessDef() {
        if (this.processDef == null && this.processDefId != null) {
            this.processDef = Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionById(this.processDefId);
        }
        return this.processDef;
    }

    public void setProcessDef(ProcessDefinitionEntity processDef) {
        this.processDef = processDef;
        this.processDefId = processDef.getId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", type=" + this.type + ", userId=" + this.userId + ", groupId=" + this.groupId + ", taskId=" + this.taskId + ", processDefId=" + this.processDefId + ", task=" + this.task + ", processDef=" + this.processDef + "]";
    }
}

