/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.util.json.JSONArray;
import org.camunda.bpm.engine.impl.util.json.JSONObject;

public final class JsonUtil {
    public static Map<String, Object> jsonObjectAsMap(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (jsonObject.optJSONObject(key) != null) {
                map.put(key, JsonUtil.jsonObjectAsMap(jsonObject.getJSONObject(key)));
                continue;
            }
            if (jsonObject.optJSONArray(key) != null) {
                map.put(key, JsonUtil.jsonArrayAsList(jsonObject.getJSONArray(key)));
                continue;
            }
            map.put(key, jsonObject.get(key));
        }
        return map;
    }

    public static List<Object> jsonArrayAsList(JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            if (jsonArray.optJSONObject(i) != null) {
                list.add(JsonUtil.jsonObjectAsMap(jsonArray.getJSONObject(i)));
                continue;
            }
            if (jsonArray.optJSONArray(i) != null) {
                list.add(JsonUtil.jsonArrayAsList(jsonArray.getJSONArray(i)));
                continue;
            }
            list.add(jsonArray.get(i));
        }
        return list;
    }
}

