/*
 * Decompiled with CFR 0.152.
 */
package camundajar.impl.com.cronutils.descriptor;

import camundajar.impl.com.cronutils.descriptor.DescriptionStrategyFactory;
import camundajar.impl.com.cronutils.model.Cron;
import camundajar.impl.com.cronutils.model.RebootCron;
import camundajar.impl.com.cronutils.model.field.CronField;
import camundajar.impl.com.cronutils.model.field.CronFieldName;
import camundajar.impl.com.cronutils.model.field.definition.FieldDefinition;
import camundajar.impl.com.cronutils.utils.Preconditions;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class CronDescriptor {
    public static final Locale DEFAULT_LOCALE = Locale.UK;
    private static final String BUNDLE = "camundajar.impl.com.cronutils.CronUtilsI18N";
    private final ResourceBundle resourceBundle;

    public CronDescriptor(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    private CronDescriptor(Locale locale) {
        this.resourceBundle = ResourceBundle.getBundle(BUNDLE, locale);
    }

    private CronDescriptor() {
        this.resourceBundle = ResourceBundle.getBundle(BUNDLE, DEFAULT_LOCALE);
    }

    public String describe(Cron cron) {
        Preconditions.checkNotNull(cron, "Cron must not be null");
        if (cron instanceof RebootCron) {
            return this.resourceBundle.getString("on_reboot");
        }
        Map<CronFieldName, CronField> expressions = cron.retrieveFieldsAsMap();
        Map<CronFieldName, FieldDefinition> fieldDefinitions = cron.getCronDefinition().retrieveFieldDefinitionsAsMap();
        return (this.describeHHmmss(expressions) + " " + this.describeDayOfMonth(expressions) + " " + this.describeMonth(expressions) + " " + this.describeDayOfWeek(expressions, fieldDefinitions) + " " + this.describeYear(expressions)).replaceAll("\\s+", " ").trim();
    }

    public String describeHHmmss(Map<CronFieldName, CronField> fields) {
        return DescriptionStrategyFactory.hhMMssInstance(this.resourceBundle, fields.containsKey((Object)CronFieldName.HOUR) ? fields.get((Object)CronFieldName.HOUR).getExpression() : null, fields.containsKey((Object)CronFieldName.MINUTE) ? fields.get((Object)CronFieldName.MINUTE).getExpression() : null, fields.containsKey((Object)CronFieldName.SECOND) ? fields.get((Object)CronFieldName.SECOND).getExpression() : null).describe();
    }

    public String describeDayOfMonth(Map<CronFieldName, CronField> fields) {
        String description = DescriptionStrategyFactory.daysOfMonthInstance(this.resourceBundle, fields.containsKey((Object)CronFieldName.DAY_OF_MONTH) ? fields.get((Object)CronFieldName.DAY_OF_MONTH).getExpression() : null).describe();
        return this.addTimeExpressions(description, this.resourceBundle.getString("day"), this.resourceBundle.getString("days"));
    }

    public String describeMonth(Map<CronFieldName, CronField> fields) {
        String description = DescriptionStrategyFactory.monthsInstance(this.resourceBundle, fields.containsKey((Object)CronFieldName.MONTH) ? fields.get((Object)CronFieldName.MONTH).getExpression() : null).describe();
        return this.addTimeExpressions(description, this.resourceBundle.getString("month"), this.resourceBundle.getString("months"));
    }

    private String addTimeExpressions(String description, String singular, String plural) {
        return description.replaceAll("%s", singular).replaceAll("replace_plural", plural);
    }

    public String describeDayOfWeek(Map<CronFieldName, CronField> fields, Map<CronFieldName, FieldDefinition> definitions) {
        String description = DescriptionStrategyFactory.daysOfWeekInstance(this.resourceBundle, fields.containsKey((Object)CronFieldName.DAY_OF_WEEK) ? fields.get((Object)CronFieldName.DAY_OF_WEEK).getExpression() : null, definitions.containsKey((Object)CronFieldName.DAY_OF_WEEK) ? definitions.get((Object)CronFieldName.DAY_OF_WEEK) : null).describe();
        return this.addExpressions(description, this.resourceBundle.getString("day"), this.resourceBundle.getString("days"));
    }

    private String addExpressions(String description, String singular, String plural) {
        return description.replaceAll("%s", singular).replaceAll("replace_plural", plural);
    }

    public String describeYear(Map<CronFieldName, CronField> fields) {
        String description = DescriptionStrategyFactory.plainInstance(this.resourceBundle, fields.containsKey((Object)CronFieldName.YEAR) ? fields.get((Object)CronFieldName.YEAR).getExpression() : null).describe();
        return this.addExpressions(description, this.resourceBundle.getString("year"), this.resourceBundle.getString("years"));
    }

    public static CronDescriptor instance() {
        return new CronDescriptor();
    }

    public static CronDescriptor instance(Locale locale) {
        return new CronDescriptor(locale);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }
}

