/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.batch.BatchMonitorJobDeclaration;
import org.camunda.bpm.engine.impl.batch.BatchSeedJobDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbReferences;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.Nameable;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.util.ByteArrayField;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ResourceTypes;

public class BatchEntity
implements Batch,
DbEntity,
HasDbReferences,
Nameable,
HasDbRevision {
    public static final BatchSeedJobDeclaration BATCH_SEED_JOB_DECLARATION = new BatchSeedJobDeclaration();
    public static final BatchMonitorJobDeclaration BATCH_MONITOR_JOB_DECLARATION = new BatchMonitorJobDeclaration();
    protected String id;
    protected String type;
    protected int totalJobs;
    protected int jobsCreated;
    protected int batchJobsPerSeed;
    protected int invocationsPerBatchJob;
    protected String seedJobDefinitionId;
    protected String monitorJobDefinitionId;
    protected String batchJobDefinitionId;
    protected ByteArrayField configuration = new ByteArrayField(this, ResourceTypes.RUNTIME);
    protected String tenantId;
    protected String createUserId;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected Date startTime;
    protected Date executionStartTime;
    protected int revision;
    protected JobDefinitionEntity seedJobDefinition;
    protected JobDefinitionEntity monitorJobDefinition;
    protected JobDefinitionEntity batchJobDefinition;
    protected BatchJobHandler<?> batchJobHandler;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public int getTotalJobs() {
        return this.totalJobs;
    }

    public void setTotalJobs(int totalJobs) {
        this.totalJobs = totalJobs;
    }

    @Override
    public int getJobsCreated() {
        return this.jobsCreated;
    }

    public void setJobsCreated(int jobsCreated) {
        this.jobsCreated = jobsCreated;
    }

    @Override
    public int getBatchJobsPerSeed() {
        return this.batchJobsPerSeed;
    }

    public void setBatchJobsPerSeed(int batchJobsPerSeed) {
        this.batchJobsPerSeed = batchJobsPerSeed;
    }

    @Override
    public int getInvocationsPerBatchJob() {
        return this.invocationsPerBatchJob;
    }

    public void setInvocationsPerBatchJob(int invocationsPerBatchJob) {
        this.invocationsPerBatchJob = invocationsPerBatchJob;
    }

    @Override
    public String getSeedJobDefinitionId() {
        return this.seedJobDefinitionId;
    }

    public void setSeedJobDefinitionId(String seedJobDefinitionId) {
        this.seedJobDefinitionId = seedJobDefinitionId;
    }

    @Override
    public String getMonitorJobDefinitionId() {
        return this.monitorJobDefinitionId;
    }

    public void setMonitorJobDefinitionId(String monitorJobDefinitionId) {
        this.monitorJobDefinitionId = monitorJobDefinitionId;
    }

    @Override
    public String getBatchJobDefinitionId() {
        return this.batchJobDefinitionId;
    }

    public void setBatchJobDefinitionId(String batchJobDefinitionId) {
        this.batchJobDefinitionId = batchJobDefinitionId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getCreateUserId() {
        return this.createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public String getConfiguration() {
        return this.configuration.getByteArrayId();
    }

    public void setConfiguration(String configuration) {
        this.configuration.setByteArrayId(configuration);
    }

    public void setSuspensionState(int state) {
        this.suspensionState = state;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Override
    public Date getExecutionStartTime() {
        return this.executionStartTime;
    }

    public void setExecutionStartTime(Date executionStartTime) {
        this.executionStartTime = executionStartTime;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public JobDefinitionEntity getSeedJobDefinition() {
        if (this.seedJobDefinition == null && this.seedJobDefinitionId != null) {
            this.seedJobDefinition = Context.getCommandContext().getJobDefinitionManager().findById(this.seedJobDefinitionId);
        }
        return this.seedJobDefinition;
    }

    public JobDefinitionEntity getMonitorJobDefinition() {
        if (this.monitorJobDefinition == null && this.monitorJobDefinitionId != null) {
            this.monitorJobDefinition = Context.getCommandContext().getJobDefinitionManager().findById(this.monitorJobDefinitionId);
        }
        return this.monitorJobDefinition;
    }

    public JobDefinitionEntity getBatchJobDefinition() {
        if (this.batchJobDefinition == null && this.batchJobDefinitionId != null) {
            this.batchJobDefinition = Context.getCommandContext().getJobDefinitionManager().findById(this.batchJobDefinitionId);
        }
        return this.batchJobDefinition;
    }

    public byte[] getConfigurationBytes() {
        return this.configuration.getByteArrayValue();
    }

    public void setConfigurationBytes(byte[] configuration) {
        this.configuration.setByteArrayValue(configuration);
    }

    public BatchJobHandler<?> getBatchJobHandler() {
        if (this.batchJobHandler == null) {
            this.batchJobHandler = Context.getCommandContext().getProcessEngineConfiguration().getBatchHandlers().get(this.type);
        }
        return this.batchJobHandler;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Comparable<Integer>> persistentState = new HashMap<String, Comparable<Integer>>();
        persistentState.put("jobsCreated", Integer.valueOf(this.jobsCreated));
        persistentState.put("executionStartTime", this.executionStartTime);
        return persistentState;
    }

    public JobDefinitionEntity createSeedJobDefinition(String deploymentId) {
        this.seedJobDefinition = new JobDefinitionEntity(BATCH_SEED_JOB_DECLARATION);
        this.seedJobDefinition.setJobConfiguration(this.id);
        this.seedJobDefinition.setTenantId(this.tenantId);
        this.seedJobDefinition.setDeploymentId(deploymentId);
        Context.getCommandContext().getJobDefinitionManager().insert(this.seedJobDefinition);
        this.seedJobDefinitionId = this.seedJobDefinition.getId();
        return this.seedJobDefinition;
    }

    public JobDefinitionEntity createMonitorJobDefinition() {
        this.monitorJobDefinition = new JobDefinitionEntity(BATCH_MONITOR_JOB_DECLARATION);
        this.monitorJobDefinition.setJobConfiguration(this.id);
        this.monitorJobDefinition.setTenantId(this.tenantId);
        Context.getCommandContext().getJobDefinitionManager().insert(this.monitorJobDefinition);
        this.monitorJobDefinitionId = this.monitorJobDefinition.getId();
        return this.monitorJobDefinition;
    }

    public JobDefinitionEntity createBatchJobDefinition() {
        this.batchJobDefinition = new JobDefinitionEntity(this.getBatchJobHandler().getJobDeclaration());
        this.batchJobDefinition.setJobConfiguration(this.id);
        this.batchJobDefinition.setTenantId(this.tenantId);
        Context.getCommandContext().getJobDefinitionManager().insert(this.batchJobDefinition);
        this.batchJobDefinitionId = this.batchJobDefinition.getId();
        return this.batchJobDefinition;
    }

    public JobEntity createSeedJob() {
        Object seedJob = BATCH_SEED_JOB_DECLARATION.createJobInstance(this);
        Context.getCommandContext().getJobManager().insertAndHintJobExecutor((JobEntity)seedJob);
        return seedJob;
    }

    public void deleteSeedJob() {
        List<JobEntity> seedJobs = Context.getCommandContext().getJobManager().findJobsByJobDefinitionId(this.seedJobDefinitionId);
        for (JobEntity job : seedJobs) {
            job.delete();
        }
    }

    public JobEntity createMonitorJob(boolean setDueDate) {
        Object monitorJob = BATCH_MONITOR_JOB_DECLARATION.createJobInstance(this);
        if (setDueDate) {
            ((AcquirableJobEntity)monitorJob).setDuedate(this.calculateMonitorJobDueDate());
        }
        Context.getCommandContext().getJobManager().insertAndHintJobExecutor((JobEntity)monitorJob);
        return monitorJob;
    }

    protected Date calculateMonitorJobDueDate() {
        int pollTime = Context.getCommandContext().getProcessEngineConfiguration().getBatchPollTime();
        long dueTime = ClockUtil.getCurrentTime().getTime() + (long)(pollTime * 1000);
        return new Date(dueTime);
    }

    public void deleteMonitorJob() {
        List<JobEntity> monitorJobs = Context.getCommandContext().getJobManager().findJobsByJobDefinitionId(this.monitorJobDefinitionId);
        for (JobEntity monitorJob : monitorJobs) {
            monitorJob.delete();
        }
    }

    public void delete(boolean cascadeToHistory, boolean deleteJobs) {
        CommandContext commandContext = Context.getCommandContext();
        if ("set-variables".equals(this.type) || "instance-migration".equals(this.type) || "correlate-message".equals(this.type)) {
            this.deleteVariables(commandContext);
        }
        this.deleteSeedJob();
        this.deleteMonitorJob();
        if (deleteJobs) {
            this.getBatchJobHandler().deleteJobs(this);
        }
        JobDefinitionManager jobDefinitionManager = commandContext.getJobDefinitionManager();
        jobDefinitionManager.delete(this.getSeedJobDefinition());
        jobDefinitionManager.delete(this.getMonitorJobDefinition());
        jobDefinitionManager.delete(this.getBatchJobDefinition());
        commandContext.getBatchManager().delete(this);
        this.configuration.deleteByteArrayValue();
        this.fireHistoricEndEvent();
        if (cascadeToHistory) {
            HistoricIncidentManager historicIncidentManager = commandContext.getHistoricIncidentManager();
            historicIncidentManager.deleteHistoricIncidentsByJobDefinitionId(this.seedJobDefinitionId);
            historicIncidentManager.deleteHistoricIncidentsByJobDefinitionId(this.monitorJobDefinitionId);
            historicIncidentManager.deleteHistoricIncidentsByJobDefinitionId(this.batchJobDefinitionId);
            HistoricJobLogManager historicJobLogManager = commandContext.getHistoricJobLogManager();
            historicJobLogManager.deleteHistoricJobLogsByJobDefinitionId(this.seedJobDefinitionId);
            historicJobLogManager.deleteHistoricJobLogsByJobDefinitionId(this.monitorJobDefinitionId);
            historicJobLogManager.deleteHistoricJobLogsByJobDefinitionId(this.batchJobDefinitionId);
            commandContext.getHistoricBatchManager().deleteHistoricBatchById(this.id);
        }
    }

    protected void deleteVariables(CommandContext commandContext) {
        VariableInstanceManager variableInstanceManager = commandContext.getVariableInstanceManager();
        List<VariableInstanceEntity> variableInstances = variableInstanceManager.findVariableInstancesByBatchId(this.id);
        variableInstances.forEach(VariableInstanceEntity::delete);
    }

    public void fireHistoricStartEvent() {
        Context.getCommandContext().getHistoricBatchManager().createHistoricBatch(this);
    }

    public void fireHistoricEndEvent() {
        Context.getCommandContext().getHistoricBatchManager().completeHistoricBatch(this);
    }

    public void fireHistoricUpdateEvent() {
        Context.getCommandContext().getHistoricBatchManager().updateHistoricBatch(this);
    }

    public boolean isCompleted() {
        return Context.getCommandContext().getProcessEngineConfiguration().getManagementService().createJobQuery().jobDefinitionId(this.batchJobDefinitionId).count() == 0L;
    }

    public String toString() {
        return "BatchEntity{batchHandler=" + this.batchJobHandler + ", id='" + this.id + "', type='" + this.type + "', size=" + this.totalJobs + ", jobCreated=" + this.jobsCreated + ", batchJobsPerSeed=" + this.batchJobsPerSeed + ", invocationsPerBatchJob=" + this.invocationsPerBatchJob + ", seedJobDefinitionId='" + this.seedJobDefinitionId + "', monitorJobDefinitionId='" + this.seedJobDefinitionId + "', batchJobDefinitionId='" + this.batchJobDefinitionId + "', configurationId='" + this.configuration.getByteArrayId() + "'}";
    }

    @Override
    public Set<String> getReferencedEntityIds() {
        HashSet<String> referencedEntityIds = new HashSet<String>();
        return referencedEntityIds;
    }

    @Override
    public Map<String, Class> getReferencedEntitiesIdAndClass() {
        HashMap<String, Class> referenceIdAndClass = new HashMap<String, Class>();
        if (this.seedJobDefinitionId != null) {
            referenceIdAndClass.put(this.seedJobDefinitionId, JobDefinitionEntity.class);
        }
        if (this.batchJobDefinitionId != null) {
            referenceIdAndClass.put(this.batchJobDefinitionId, JobDefinitionEntity.class);
        }
        if (this.monitorJobDefinitionId != null) {
            referenceIdAndClass.put(this.monitorJobDefinitionId, JobDefinitionEntity.class);
        }
        return referenceIdAndClass;
    }
}

