/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.calendar;

import camundajar.impl.com.cronutils.model.Cron;
import camundajar.impl.com.cronutils.model.CronType;
import camundajar.impl.com.cronutils.model.definition.CronDefinitionBuilder;
import camundajar.impl.com.cronutils.model.time.ExecutionTime;
import camundajar.impl.com.cronutils.parser.CronParser;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Date;
import java.util.Optional;

public class CronTimer {
    protected final Cron cron;

    public CronTimer(Cron cron) {
        this.cron = cron;
    }

    public Date getDueDate(Date afterTime) {
        long fromEpochMilli = afterTime.getTime();
        Optional<Long> next = ExecutionTime.forCron(this.cron).nextExecution(ZonedDateTime.ofInstant(Instant.ofEpochMilli(fromEpochMilli), ZoneId.systemDefault())).map(ChronoZonedDateTime::toInstant).map(Instant::toEpochMilli);
        return new Date(next.orElse(fromEpochMilli));
    }

    public static CronTimer parse(String text) throws ParseException {
        try {
            Cron cron = new CronParser(CronDefinitionBuilder.instanceDefinitionFor(CronType.SPRING53)).parse(text);
            return new CronTimer(cron);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }
}

