/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.CustomActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ServiceTaskJavaDelegateActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.camunda.bpm.engine.impl.util.ClassDelegateUtil;

public class ClassDelegateActivityBehavior
extends AbstractBpmnActivityBehavior {
    protected String className;
    protected List<FieldDeclaration> fieldDeclarations;

    public ClassDelegateActivityBehavior(String className, List<FieldDeclaration> fieldDeclarations) {
        this.className = className;
        this.fieldDeclarations = fieldDeclarations;
    }

    public ClassDelegateActivityBehavior(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        this(clazz.getName(), fieldDeclarations);
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        ActivityBehavior activityBehaviorInstance = this.getActivityBehaviorInstance(execution);
        try {
            activityBehaviorInstance.execute(execution);
        }
        catch (BpmnError error) {
            this.propagateBpmnError(error, execution);
        }
        catch (Exception ex) {
            this.propagateExceptionAsError(ex, execution);
        }
    }

    @Override
    public void signal(final ActivityExecution execution, final String signalName, final Object signalData) throws Exception {
        ProcessApplicationReference targetProcessApplication = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        if (ProcessApplicationContextUtil.requiresContextSwitch(targetProcessApplication)) {
            Context.executeWithinProcessApplication(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ClassDelegateActivityBehavior.this.signal(execution, signalName, signalData);
                    return null;
                }
            }, targetProcessApplication);
        } else {
            this.doSignal(execution, signalName, signalData);
        }
    }

    protected void doSignal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        CustomActivityBehavior behavior;
        ActivityBehavior delegate;
        ActivityBehavior activityBehaviorInstance = this.getActivityBehaviorInstance(execution);
        if (activityBehaviorInstance instanceof CustomActivityBehavior && !((delegate = (behavior = (CustomActivityBehavior)activityBehaviorInstance).getDelegateActivityBehavior()) instanceof SignallableActivityBehavior)) {
            throw new ProcessEngineException("signal() can only be called on a " + SignallableActivityBehavior.class.getName() + " instance");
        }
        try {
            ((SignallableActivityBehavior)activityBehaviorInstance).signal(execution, signalName, signalData);
        }
        catch (BpmnError error) {
            this.propagateBpmnError(error, execution);
        }
        catch (Exception exception) {
            this.propagateExceptionAsError(exception, execution);
        }
    }

    protected ActivityBehavior getActivityBehaviorInstance(ActivityExecution execution) {
        Object delegateInstance = ClassDelegateUtil.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof ActivityBehavior) {
            return new CustomActivityBehavior((ActivityBehavior)delegateInstance);
        }
        if (delegateInstance instanceof JavaDelegate) {
            return new ServiceTaskJavaDelegateActivityBehavior((JavaDelegate)delegateInstance);
        }
        throw new ProcessEngineException(delegateInstance.getClass().getName() + " doesn't implement " + JavaDelegate.class.getName() + " nor " + ActivityBehavior.class.getName());
    }
}

