/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;

public class ServiceTaskExpressionActivityBehavior
extends TaskActivityBehavior {
    protected Expression expression;
    protected String resultVariable;

    public ServiceTaskExpressionActivityBehavior(Expression expression, String resultVariable) {
        this.expression = expression;
        this.resultVariable = resultVariable;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        Object value = null;
        try {
            value = this.expression.getValue(execution);
            if (this.resultVariable != null) {
                execution.setVariable(this.resultVariable, value);
            }
            this.leave(execution);
        }
        catch (Exception exc) {
            BpmnError error = null;
            for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof BpmnError)) continue;
                error = (BpmnError)cause;
                break;
            }
            if (error != null) {
                this.propagateBpmnError(error, execution);
            }
            this.propagateExceptionAsError(exc, execution);
        }
    }
}

