/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Date;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobDefinitionStateCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractSetProcessInstanceStateCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractSetStateCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.TimerChangeProcessDefinitionSuspensionStateJobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;

public abstract class AbstractSetProcessDefinitionStateCmd
extends AbstractSetStateCmd {
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected ProcessDefinitionEntity processDefinitionEntity;
    protected Date executionDate;

    public AbstractSetProcessDefinitionStateCmd(ProcessDefinitionEntity processDefinitionEntity, boolean includeProcessInstances, Date executionDate) {
        super(includeProcessInstances, executionDate);
        this.processDefinitionEntity = processDefinitionEntity;
        this.processDefinitionId = processDefinitionEntity.getId();
        this.executionDate = executionDate;
    }

    public AbstractSetProcessDefinitionStateCmd(String processDefinitionId, String processDefinitionKey, boolean includeProcessInstances, Date executionDate) {
        super(includeProcessInstances, executionDate);
        this.processDefinitionId = processDefinitionId;
        this.processDefinitionKey = processDefinitionKey;
        this.executionDate = executionDate;
    }

    @Override
    protected void checkParameters(CommandContext commandContext) {
        if (this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ProcessEngineException("Process definition id / key cannot be null");
        }
    }

    @Override
    protected void checkAuthorization(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        if (this.processDefinitionId != null) {
            authorizationManager.checkUpdateProcessDefinitionById(this.processDefinitionId);
            if (this.includeSubResources) {
                authorizationManager.checkUpdateProcessInstanceByProcessDefinitionId(this.processDefinitionId);
            }
        } else if (this.processDefinitionKey != null) {
            authorizationManager.checkUpdateProcessDefinitionByKey(this.processDefinitionKey);
            if (this.includeSubResources) {
                authorizationManager.checkUpdateProcessInstanceByProcessDefinitionKey(this.processDefinitionKey);
            }
        }
    }

    @Override
    protected void updateSuspensionState(final CommandContext commandContext, SuspensionState suspensionState) {
        ProcessDefinitionManager processDefinitionManager = commandContext.getProcessDefinitionManager();
        if (this.processDefinitionId != null) {
            processDefinitionManager.updateProcessDefinitionSuspensionStateById(this.processDefinitionId, suspensionState);
        } else if (this.processDefinitionKey != null) {
            processDefinitionManager.updateProcessDefinitionSuspensionStateByKey(this.processDefinitionKey, suspensionState);
        }
        commandContext.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AbstractSetJobDefinitionStateCmd jobDefinitionCmd = AbstractSetProcessDefinitionStateCmd.this.getSetJobDefinitionStateCmd();
                jobDefinitionCmd.disableLogUserOperation();
                jobDefinitionCmd.execute(commandContext);
                return null;
            }
        });
    }

    @Override
    protected String getJobHandlerConfiguration() {
        String jobConfiguration = null;
        if (this.processDefinitionId != null) {
            jobConfiguration = TimerChangeProcessDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByProcessDefinitionId(this.processDefinitionId, this.isIncludeSubResources());
        } else if (this.processDefinitionKey != null) {
            jobConfiguration = TimerChangeProcessDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByProcessDefinitionKey(this.processDefinitionKey, this.isIncludeSubResources());
        }
        return jobConfiguration;
    }

    @Override
    protected void logUserOperation(CommandContext commandContext) {
        PropertyChange propertyChange = new PropertyChange("suspensionState", null, this.getNewSuspensionState().getName());
        commandContext.getOperationLogManager().logProcessDefinitionOperation(this.getLogEntryOperation(), this.processDefinitionId, this.processDefinitionKey, propertyChange);
    }

    @Override
    protected abstract String getDelayedExecutionJobHandlerType();

    protected abstract AbstractSetJobDefinitionStateCmd getSetJobDefinitionStateCmd();

    @Override
    protected abstract AbstractSetProcessInstanceStateCmd getNextCommand();
}

