/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import org.camunda.bpm.engine.impl.core.variable.VariableMapImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.variable.VariableMap;

public class GetExecutionVariablesCmd
implements Command<VariableMap>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected Collection<String> variableNames;
    protected boolean isLocal;
    protected boolean deserializeValues;

    public GetExecutionVariablesCmd(String executionId, Collection<String> variableNames, boolean isLocal, boolean deserializeValues) {
        this.executionId = executionId;
        this.variableNames = variableNames;
        this.isLocal = isLocal;
        this.deserializeValues = deserializeValues;
    }

    @Override
    public VariableMap execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("executionId", (Object)this.executionId);
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
        EnsureUtil.ensureNotNull("execution " + this.executionId + " doesn't exist", "execution", (Object)execution);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkReadProcessInstance(execution);
        VariableMapImpl executionVariables = new VariableMapImpl();
        execution.collectVariables(executionVariables, this.variableNames, this.isLocal, this.deserializeValues);
        return executionVariables;
    }
}

