/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.handler;

import java.util.List;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.cmmn.behavior.ProcessOrCaseTaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.handler.TaskItemHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.core.model.CallableElement;
import org.camunda.bpm.engine.impl.core.model.CallableElementParameter;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ConstantValueProvider;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.NullValueProvider;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import org.camunda.bpm.engine.impl.el.ElValueProvider;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.camunda.CamundaIn;
import org.camunda.bpm.model.cmmn.instance.camunda.CamundaOut;

public abstract class ProcessOrCaseTaskItemHandler
extends TaskItemHandler {
    @Override
    protected void initializeActivity(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        super.initializeActivity(element, activity, context);
        this.initializeCallableElement(element, activity, context);
    }

    protected void initializeCallableElement(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        Deployment deployment = context.getDeployment();
        String deploymentId = null;
        if (deployment != null) {
            deploymentId = deployment.getId();
        }
        CallableElement callableElement = new CallableElement();
        callableElement.setDeploymentId(deploymentId);
        ProcessOrCaseTaskActivityBehavior behavior = (ProcessOrCaseTaskActivityBehavior)activity.getActivityBehavior();
        behavior.setCallableElement(callableElement);
        this.initializeDefinitionKey(element, activity, context, callableElement);
        this.initializeBinding(element, activity, context, callableElement);
        this.initializeVersion(element, activity, context, callableElement);
        this.initializeInputParameter(element, activity, context);
        this.initializeOutputParameter(element, activity, context);
    }

    protected void initializeDefinitionKey(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, CallableElement callableElement) {
        ExpressionManager expressionManager = context.getExpressionManager();
        String definitionKey = this.getDefinitionKey(element, activity, context);
        ParameterValueProvider definitionKeyProvider = this.createParameterValueProvider(definitionKey, expressionManager);
        callableElement.setDefinitionKeyValueProvider(definitionKeyProvider);
    }

    protected void initializeBinding(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, CallableElement callableElement) {
        String binding = this.getBinding(element, activity, context);
        if (CallableElement.CallableElementBinding.DEPLOYMENT.getValue().equals(binding)) {
            callableElement.setBinding(CallableElement.CallableElementBinding.DEPLOYMENT);
        } else if (CallableElement.CallableElementBinding.LATEST.getValue().equals(binding)) {
            callableElement.setBinding(CallableElement.CallableElementBinding.LATEST);
        } else if (CallableElement.CallableElementBinding.VERSION.getValue().equals(binding)) {
            callableElement.setBinding(CallableElement.CallableElementBinding.VERSION);
        }
    }

    protected void initializeVersion(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, CallableElement callableElement) {
        ExpressionManager expressionManager = context.getExpressionManager();
        String version = this.getVersion(element, activity, context);
        ParameterValueProvider versionProvider = this.createParameterValueProvider(version, expressionManager);
        callableElement.setVersionValueProvider(versionProvider);
    }

    protected void initializeInputParameter(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        ProcessOrCaseTaskActivityBehavior behavior = (ProcessOrCaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ExpressionManager expressionManager = context.getExpressionManager();
        List<CamundaIn> inputs = this.getInputs(element);
        for (CamundaIn input : inputs) {
            String businessKey = input.getCamundaBusinessKey();
            if (businessKey != null && !businessKey.isEmpty()) {
                ParameterValueProvider businessKeyValueProvider = this.createParameterValueProvider(businessKey, expressionManager);
                callableElement.setBusinessKeyValueProvider(businessKeyValueProvider);
                continue;
            }
            CallableElementParameter parameter = new CallableElementParameter();
            callableElement.addInput(parameter);
            String variables = input.getCamundaVariables();
            if ("all".equals(variables)) {
                parameter.setAllVariables(true);
                continue;
            }
            String source = input.getCamundaSource();
            if (source == null || source.isEmpty()) {
                source = input.getCamundaSourceExpression();
            }
            ParameterValueProvider sourceValueProvider = this.createParameterValueProvider(source, expressionManager);
            parameter.setSourceValueProvider(sourceValueProvider);
            String target = input.getCamundaTarget();
            parameter.setTarget(target);
        }
    }

    protected void initializeOutputParameter(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        ProcessOrCaseTaskActivityBehavior behavior = (ProcessOrCaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        ExpressionManager expressionManager = context.getExpressionManager();
        List<CamundaOut> outputs = this.getOutputs(element);
        for (CamundaOut output : outputs) {
            CallableElementParameter parameter = new CallableElementParameter();
            callableElement.addOutput(parameter);
            String variables = output.getCamundaVariables();
            if ("all".equals(variables)) {
                parameter.setAllVariables(true);
                continue;
            }
            String source = output.getCamundaSource();
            if (source == null || source.isEmpty()) {
                source = output.getCamundaSourceExpression();
            }
            ParameterValueProvider sourceValueProvider = this.createParameterValueProvider(source, expressionManager);
            parameter.setSourceValueProvider(sourceValueProvider);
            String target = output.getCamundaTarget();
            parameter.setTarget(target);
        }
    }

    protected List<CamundaIn> getInputs(CmmnElement element) {
        PlanItemDefinition definition = this.getDefinition(element);
        return this.queryExtensionElementsByClass((CmmnElement)definition, CamundaIn.class);
    }

    protected List<CamundaOut> getOutputs(CmmnElement element) {
        PlanItemDefinition definition = this.getDefinition(element);
        return this.queryExtensionElementsByClass((CmmnElement)definition, CamundaOut.class);
    }

    protected ParameterValueProvider createParameterValueProvider(String value, ExpressionManager expressionManager) {
        if (value == null) {
            return new NullValueProvider();
        }
        if (StringUtil.isExpression(value)) {
            Expression expression = expressionManager.createExpression(value);
            return new ElValueProvider(expression);
        }
        return new ConstantValueProvider(value);
    }

    protected abstract String getDefinitionKey(CmmnElement var1, CmmnActivity var2, CmmnHandlerContext var3);

    protected abstract String getBinding(CmmnElement var1, CmmnActivity var2, CmmnHandlerContext var3);

    protected abstract String getVersion(CmmnElement var1, CmmnActivity var2, CmmnHandlerContext var3);
}

