/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.identity.db;

import java.util.HashMap;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.identity.WritableIdentityProvider;
import org.camunda.bpm.engine.impl.identity.db.DbReadOnlyIdentityServiceProvider;
import org.camunda.bpm.engine.impl.persistence.entity.GroupEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MembershipEntity;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;

public class DbIdentityServiceProvider
extends DbReadOnlyIdentityServiceProvider
implements WritableIdentityProvider {
    @Override
    public UserEntity createNewUser(String userId) {
        this.checkAuthorization(Permissions.CREATE, Resources.USER, null);
        return new UserEntity(userId);
    }

    @Override
    public User saveUser(User user) {
        UserEntity userEntity = (UserEntity)user;
        userEntity.encryptPassword();
        if (userEntity.getRevision() == 0) {
            this.checkAuthorization(Permissions.CREATE, Resources.USER, null);
            this.getDbEntityManager().insert(userEntity);
            this.createDefaultAuthorizations(userEntity);
        } else {
            this.checkAuthorization(Permissions.UPDATE, Resources.USER, user.getId());
            this.getDbEntityManager().merge(userEntity);
        }
        return userEntity;
    }

    @Override
    public void deleteUser(String userId) {
        this.checkAuthorization(Permissions.DELETE, Resources.USER, userId);
        UserEntity user = this.findUserById(userId);
        if (user != null) {
            this.deleteMembershipsByUserId(userId);
            this.deleteAuthorizations(Resources.USER, userId);
            this.getDbEntityManager().delete(user);
        }
    }

    @Override
    public GroupEntity createNewGroup(String groupId) {
        this.checkAuthorization(Permissions.CREATE, Resources.GROUP, null);
        return new GroupEntity(groupId);
    }

    @Override
    public GroupEntity saveGroup(Group group) {
        GroupEntity groupEntity = (GroupEntity)group;
        if (groupEntity.getRevision() == 0) {
            this.checkAuthorization(Permissions.CREATE, Resources.GROUP, null);
            this.getDbEntityManager().insert(groupEntity);
            this.createDefaultAuthorizations(group);
        } else {
            this.checkAuthorization(Permissions.UPDATE, Resources.GROUP, group.getId());
            this.getDbEntityManager().merge(groupEntity);
        }
        return groupEntity;
    }

    @Override
    public void deleteGroup(String groupId) {
        this.checkAuthorization(Permissions.DELETE, Resources.GROUP, groupId);
        GroupEntity group = this.findGroupById(groupId);
        if (group != null) {
            this.deleteMembershipsByGroupId(groupId);
            this.deleteAuthorizations(Resources.GROUP, groupId);
            this.getDbEntityManager().delete(group);
        }
    }

    @Override
    public void createMembership(String userId, String groupId) {
        this.checkAuthorization(Permissions.CREATE, Resources.GROUP_MEMBERSHIP, groupId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        this.getDbSqlSession().getSqlSession().insert("insertMembership", parameters);
        this.createDefaultMembershipAuthorizations(userId, groupId);
    }

    @Override
    public void deleteMembership(String userId, String groupId) {
        this.checkAuthorization(Permissions.DELETE, Resources.GROUP_MEMBERSHIP, groupId);
        this.deleteAuthorizations(Resources.GROUP_MEMBERSHIP, groupId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        this.getDbEntityManager().delete(MembershipEntity.class, "deleteMembership", parameters);
    }

    protected void deleteMembershipsByUserId(String userId) {
        this.getDbEntityManager().delete(MembershipEntity.class, "deleteMembershipsByUserId", userId);
    }

    protected void deleteMembershipsByGroupId(String groupId) {
        this.getDbEntityManager().delete(MembershipEntity.class, "deleteMembershipsByGroupId", groupId);
    }

    protected void createDefaultAuthorizations(UserEntity userEntity) {
        if (Context.getProcessEngineConfiguration().isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().newUser(userEntity));
        }
    }

    protected void createDefaultAuthorizations(Group group) {
        if (this.isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().newGroup(group));
        }
    }

    protected void createDefaultMembershipAuthorizations(String userId, String groupId) {
        if (this.isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().groupMembershipCreated(groupId, userId));
        }
    }
}

