/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.DbEntityLifecycleAware;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class HistoricVariableInstanceEntity
implements ValueFields,
HistoricVariableInstance,
DbEntity,
HasDbRevision,
Serializable,
DbEntityLifecycleAware {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected String processInstanceId;
    protected String taskId;
    protected String executionId;
    protected String activityInstanceId;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected String caseInstanceId;
    protected String caseExecutionId;
    protected String name;
    protected int revision;
    protected String serializerName;
    protected TypedValueSerializer<?> serializer;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected ByteArrayEntity byteArrayValue;
    protected String byteArrayId;
    protected TypedValue cachedValue;
    protected String errorMessage;

    public HistoricVariableInstanceEntity() {
    }

    public HistoricVariableInstanceEntity(HistoricVariableUpdateEventEntity historyEvent) {
        this.updateFromEvent(historyEvent);
    }

    public void updateFromEvent(HistoricVariableUpdateEventEntity historyEvent) {
        this.id = historyEvent.getVariableInstanceId();
        this.processDefinitionKey = historyEvent.getProcessDefinitionKey();
        this.processDefinitionId = historyEvent.getProcessDefinitionId();
        this.processInstanceId = historyEvent.getProcessInstanceId();
        this.taskId = historyEvent.getTaskId();
        this.executionId = historyEvent.getExecutionId();
        this.activityInstanceId = historyEvent.getScopeActivityInstanceId();
        this.caseDefinitionKey = historyEvent.getCaseDefinitionKey();
        this.caseDefinitionId = historyEvent.getCaseDefinitionId();
        this.caseInstanceId = historyEvent.getCaseInstanceId();
        this.caseExecutionId = historyEvent.getCaseExecutionId();
        this.name = historyEvent.getVariableName();
        this.serializerName = historyEvent.getSerializerName();
        this.longValue = historyEvent.getLongValue();
        this.doubleValue = historyEvent.getDoubleValue();
        this.textValue = historyEvent.getTextValue();
        this.textValue2 = historyEvent.getTextValue2();
        this.deleteByteArrayValue();
        if (historyEvent.getByteValue() != null) {
            this.setByteArrayValue(historyEvent.getByteValue());
        }
    }

    public void delete() {
        this.deleteByteArrayValue();
        Context.getCommandContext().getDbEntityManager().delete(this);
    }

    @Override
    public Object getPersistentState() {
        ArrayList<Object> state = new ArrayList<Object>(5);
        state.add(this.serializerName);
        state.add(this.textValue);
        state.add(this.textValue2);
        state.add(this.doubleValue);
        state.add(this.longValue);
        state.add(this.byteArrayId);
        return state;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public Object getValue() {
        TypedValue typedValue = this.getTypedValue();
        if (typedValue != null) {
            return typedValue.getValue();
        }
        return null;
    }

    @Override
    public TypedValue getTypedValue() {
        return this.getTypedValue(true);
    }

    public TypedValue getTypedValue(boolean deserializeValue) {
        if (this.cachedValue == null && this.errorMessage == null) {
            try {
                this.cachedValue = this.getSerializer().readValue(this, deserializeValue);
            }
            catch (RuntimeException e) {
                this.errorMessage = e.getMessage();
                throw e;
            }
        }
        return this.cachedValue;
    }

    public TypedValueSerializer<?> getSerializer() {
        this.ensureSerializerInitialized();
        return this.serializer;
    }

    protected void ensureSerializerInitialized() {
        if (this.serializerName != null && this.serializer == null) {
            this.serializer = HistoricVariableInstanceEntity.getSerializers().getSerializerByName(this.serializerName);
            if (this.serializer == null) {
                throw new ProcessEngineException("No serializer defined for variable instance '" + this + "'.");
            }
        }
    }

    public static VariableSerializers getSerializers() {
        if (Context.getCommandContext() != null) {
            return Context.getProcessEngineConfiguration().getVariableSerializers();
        }
        throw new ProcessEngineException("Cannot work with serializers outside of command context.");
    }

    @Override
    public String getByteArrayValueId() {
        return this.byteArrayId;
    }

    public String getByteArrayId() {
        return this.byteArrayId;
    }

    public void setByteArrayId(String byteArrayId) {
        this.byteArrayId = byteArrayId;
        this.byteArrayValue = null;
    }

    @Override
    public ByteArrayEntity getByteArrayValue() {
        if (this.byteArrayValue == null && this.byteArrayId != null && Context.getCommandContext() != null) {
            this.byteArrayValue = Context.getCommandContext().getDbEntityManager().selectById(ByteArrayEntity.class, this.byteArrayId);
        }
        return this.byteArrayValue;
    }

    @Override
    public void setByteArrayValue(byte[] bytes) {
        ByteArrayEntity byteArrayValue = null;
        this.deleteByteArrayValue();
        if (bytes != null) {
            byteArrayValue = new ByteArrayEntity(this.name, bytes);
            Context.getCommandContext().getDbEntityManager().insert(byteArrayValue);
        }
        this.byteArrayValue = byteArrayValue;
        this.byteArrayId = byteArrayValue != null ? byteArrayValue.getId() : null;
    }

    protected void deleteByteArrayValue() {
        if (this.byteArrayId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(this.byteArrayId);
            this.byteArrayId = null;
        }
    }

    @Override
    public void postLoad() {
        this.ensureSerializerInitialized();
    }

    public String getSerializerName() {
        return this.serializerName;
    }

    public void setSerializerName(String serializerName) {
        this.serializerName = serializerName;
    }

    @Override
    public String getTypeName() {
        if (this.serializerName == null) {
            return ValueType.NULL.getName();
        }
        return this.getSerializer().getType().getName();
    }

    @Override
    public String getVariableTypeName() {
        return this.getTypeName();
    }

    @Override
    public String getVariableName() {
        return this.name;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Long getLongValue() {
        return this.longValue;
    }

    @Override
    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    @Override
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    @Override
    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    @Override
    public String getTextValue() {
        return this.textValue;
    }

    @Override
    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    @Override
    public String getTextValue2() {
        return this.textValue2;
    }

    @Override
    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    public void setByteArrayValue(ByteArrayEntity byteArrayValue) {
        this.byteArrayValue = byteArrayValue;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    @Deprecated
    public String getActivtyInstanceId() {
        return this.activityInstanceId;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    @Override
    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    @Override
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @Override
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @Override
    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", processDefinitionKey=" + this.processDefinitionKey + ", processDefinitionId=" + this.processDefinitionId + ", processInstanceId=" + this.processInstanceId + ", taskId=" + this.taskId + ", executionId=" + this.executionId + ", activityInstanceId=" + this.activityInstanceId + ", caseDefinitionKey=" + this.caseDefinitionKey + ", caseDefinitionId=" + this.caseDefinitionId + ", caseInstanceId=" + this.caseInstanceId + ", caseExecutionId=" + this.caseExecutionId + ", name=" + this.name + ", revision=" + this.revision + ", serializerName=" + this.serializerName + ", longValue=" + this.longValue + ", doubleValue=" + this.doubleValue + ", textValue=" + this.textValue + ", textValue2=" + this.textValue2 + ", byteArrayId=" + this.byteArrayId + "]";
    }
}

