/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.bpmn.parser.Escalation;
import org.camunda.bpm.engine.impl.bpmn.parser.EscalationEventDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.tree.ActivityExecutionHierarchyWalker;
import org.camunda.bpm.engine.impl.tree.ActivityExecutionMappingCollector;
import org.camunda.bpm.engine.impl.tree.ActivityExecutionTuple;
import org.camunda.bpm.engine.impl.tree.OutputVariablesPropagator;
import org.camunda.bpm.engine.impl.tree.TreeVisitor;
import org.camunda.bpm.engine.impl.tree.TreeWalker;

public class ThrowEscalationEventActivityBehavior
extends AbstractBpmnActivityBehavior {
    protected final Escalation escalation;

    public ThrowEscalationEventActivityBehavior(Escalation escalation) {
        this.escalation = escalation;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        PvmActivity currentActivity = execution.getActivity();
        final EscalationEventDefinitionFinder escalationEventDefinitionFinder = new EscalationEventDefinitionFinder(this.escalation.getEscalationCode(), currentActivity);
        ActivityExecutionMappingCollector activityExecutionMappingCollector = new ActivityExecutionMappingCollector(execution);
        ActivityExecutionHierarchyWalker walker = new ActivityExecutionHierarchyWalker(execution);
        walker.addScopePreVisitor(escalationEventDefinitionFinder);
        walker.addExecutionPreVisitor(activityExecutionMappingCollector);
        walker.addExecutionPreVisitor(new OutputVariablesPropagator());
        walker.walkUntil(new TreeWalker.WalkCondition<ActivityExecutionTuple>(){

            @Override
            public boolean isFulfilled(ActivityExecutionTuple element) {
                return escalationEventDefinitionFinder.getEscalationEventDefinition() != null || element == null;
            }
        });
        EscalationEventDefinition escalationEventDefinition = escalationEventDefinitionFinder.getEscalationEventDefinition();
        if (escalationEventDefinition != null) {
            this.executeEscalationHandler(escalationEventDefinition, activityExecutionMappingCollector);
        }
        if (escalationEventDefinition == null || !escalationEventDefinition.isCancelActivity()) {
            this.leaveExecution(execution, currentActivity, escalationEventDefinition);
        }
    }

    protected void executeEscalationHandler(EscalationEventDefinition escalationEventDefinition, ActivityExecutionMappingCollector activityExecutionMappingCollector) {
        PvmActivity escalationHandler = escalationEventDefinition.getEscalationHandler();
        PvmScope escalationScope = this.getScopeForEscalation(escalationEventDefinition);
        PvmExecutionImpl escalationExecution = activityExecutionMappingCollector.getExecutionForScope(escalationScope);
        if (escalationEventDefinition.getEscalationCodeVariable() != null) {
            escalationExecution.setVariable(escalationEventDefinition.getEscalationCodeVariable(), this.escalation.getEscalationCode());
        }
        escalationExecution.executeActivity(escalationHandler);
    }

    protected PvmScope getScopeForEscalation(EscalationEventDefinition escalationEventDefinition) {
        PvmActivity escalationHandler = escalationEventDefinition.getEscalationHandler();
        if (escalationEventDefinition.isCancelActivity()) {
            return escalationHandler.getEventScope();
        }
        return escalationHandler.getFlowScope();
    }

    protected void leaveExecution(ActivityExecution execution, PvmActivity currentActivity, EscalationEventDefinition escalationEventDefinition) {
        if (escalationEventDefinition != null && this.isEscalationEventSubprocessOnTheSameScope(escalationEventDefinition.getEscalationHandler(), currentActivity)) {
            ActivityExecution childExecution = this.getChildExecutionForActivity(execution, currentActivity);
            this.leave(childExecution);
        } else {
            this.leave(execution);
        }
    }

    protected boolean isEscalationEventSubprocessOnTheSameScope(PvmActivity escalationHandler, PvmActivity activity) {
        return escalationHandler.isSubProcessScope() && escalationHandler.getFlowScope().equals(activity.getFlowScope());
    }

    protected ActivityExecution getChildExecutionForActivity(ActivityExecution execution, PvmActivity activity) {
        for (ActivityExecution activityExecution : execution.getExecutions()) {
            if (!activity.equals(activityExecution.getActivity())) continue;
            return activityExecution;
        }
        return null;
    }

    protected class EscalationEventDefinitionFinder
    implements TreeVisitor<PvmScope> {
        protected EscalationEventDefinition escalationEventDefinition;
        protected final String escalationCode;
        protected final PvmActivity throwEscalationActivity;

        public EscalationEventDefinitionFinder(String escalationCode, PvmActivity throwEscalationActivity) {
            this.escalationCode = escalationCode;
            this.throwEscalationActivity = throwEscalationActivity;
        }

        @Override
        public void visit(PvmScope scope) {
            List<EscalationEventDefinition> escalationEventDefinitions = scope.getProperties().get(BpmnProperties.ESCALATION_EVENT_DEFINITIONS);
            this.escalationEventDefinition = this.findMatchingEscalationEventDefinition(escalationEventDefinitions);
        }

        protected EscalationEventDefinition findMatchingEscalationEventDefinition(List<EscalationEventDefinition> escalationEventDefinitions) {
            for (EscalationEventDefinition escalationEventDefinition : escalationEventDefinitions) {
                if (!this.isMatchingEscalationCode(escalationEventDefinition) || this.isReThrowingEscalationEventSubprocess(escalationEventDefinition)) continue;
                return escalationEventDefinition;
            }
            return null;
        }

        protected boolean isMatchingEscalationCode(EscalationEventDefinition escalationEventDefinition) {
            String escalationCode = escalationEventDefinition.getEscalationCode();
            return escalationCode == null || escalationCode.equals(this.escalationCode);
        }

        protected boolean isReThrowingEscalationEventSubprocess(EscalationEventDefinition escalationEventDefinition) {
            PvmActivity escalationHandler = escalationEventDefinition.getEscalationHandler();
            return escalationHandler.isSubProcessScope() && escalationHandler.equals(this.throwEscalationActivity.getFlowScope());
        }

        public EscalationEventDefinition getEscalationEventDefinition() {
            return this.escalationEventDefinition;
        }
    }
}

