/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;

public class RetryInterceptor
extends CommandInterceptor {
    private static final CommandLogger LOG = CommandLogger.CMD_LOGGER;
    protected int numOfRetries = 3;
    protected int waitTimeInMs = 50;
    protected int waitIncreaseFactor = 5;

    @Override
    public <T> T execute(Command<T> command) {
        long waitTime = this.waitTimeInMs;
        int failedAttempts = 0;
        while (true) {
            if (failedAttempts > 0) {
                LOG.debugWaitingFor(waitTime);
                this.waitBeforeRetry(waitTime);
                waitTime *= (long)this.waitIncreaseFactor;
            }
            try {
                return this.next.execute(command);
            }
            catch (OptimisticLockingException e) {
                LOG.debugCaughtOptimisticLockingException(e);
                if (++failedAttempts <= this.numOfRetries) continue;
                throw new ProcessEngineException(this.numOfRetries + " retries failed with OptimisticLockingException. Giving up.");
            }
            break;
        }
    }

    protected void waitBeforeRetry(long waitTime) {
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setNumOfRetries(int numOfRetries) {
        this.numOfRetries = numOfRetries;
    }

    public void setWaitIncreaseFactor(int waitIncreaseFactor) {
        this.waitIncreaseFactor = waitIncreaseFactor;
    }

    public void setWaitTimeInMs(int waitTimeInMs) {
        this.waitTimeInMs = waitTimeInMs;
    }

    public int getNumOfRetries() {
        return this.numOfRetries;
    }

    public int getWaitIncreaseFactor() {
        return this.waitIncreaseFactor;
    }

    public int getWaitTimeInMs() {
        return this.waitTimeInMs;
    }
}

