/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.util.EngineUtilLogger;

public final class EnsureUtil {
    private static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;

    public static void ensureNotNull(String variableName, Object value) {
        EnsureUtil.ensureNotNull("", variableName, value);
    }

    public static void ensureNotNull(Class<? extends ProcessEngineException> exceptionClass, String variableName, Object value) {
        EnsureUtil.ensureNotNull(exceptionClass, null, variableName, value);
    }

    public static void ensureNotNull(String message, String variableName, Object value) {
        EnsureUtil.ensureNotNull(NullValueException.class, message, variableName, value);
    }

    public static void ensureNotNull(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Object value) {
        if (value == null) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "is null");
        }
    }

    public static void ensureNull(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Object value) {
        if (value != null) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "is not null");
        }
    }

    public static void ensureNotNull(String variableName, Object ... values) {
        EnsureUtil.ensureNotNull("", variableName, values);
    }

    public static void ensureNotNull(Class<? extends ProcessEngineException> exceptionClass, String variableName, Object ... values) {
        EnsureUtil.ensureNotNull(exceptionClass, null, variableName, values);
    }

    public static void ensureNotNull(String message, String variableName, Object ... values) {
        EnsureUtil.ensureNotNull(NullValueException.class, message, variableName, values);
    }

    public static void ensureNotNull(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Object ... values) {
        if (values == null) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "is null");
        }
        for (Object value : values) {
            if (value != null) continue;
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "contains null value");
        }
    }

    public static void ensureNotEmpty(String variableName, String value) {
        EnsureUtil.ensureNotEmpty("", variableName, value);
    }

    public static void ensureNotEmpty(Class<? extends ProcessEngineException> exceptionClass, String variableName, String value) {
        EnsureUtil.ensureNotEmpty(exceptionClass, null, variableName, value);
    }

    public static void ensureNotEmpty(String message, String variableName, String value) {
        EnsureUtil.ensureNotEmpty(ProcessEngineException.class, message, variableName, value);
    }

    public static void ensureNotEmpty(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, String value) {
        EnsureUtil.ensureNotNull(exceptionClass, message, variableName, (Object)value);
        if (value.trim().isEmpty()) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "is empty");
        }
    }

    public static void ensureNotEmpty(String variableName, Collection collection) {
        EnsureUtil.ensureNotEmpty("", variableName, collection);
    }

    public static void ensureNotEmpty(Class<? extends ProcessEngineException> exceptionClass, String variableName, Collection collection) {
        EnsureUtil.ensureNotEmpty(exceptionClass, null, variableName, collection);
    }

    public static void ensureNotEmpty(String message, String variableName, Collection collection) {
        EnsureUtil.ensureNotEmpty(ProcessEngineException.class, message, variableName, collection);
    }

    public static void ensureNotEmpty(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Collection collection) {
        EnsureUtil.ensureNotNull(exceptionClass, message, variableName, (Object)collection);
        if (collection.isEmpty()) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "is empty");
        }
    }

    public static void ensureNotEmpty(String variableName, Map map) {
        EnsureUtil.ensureNotEmpty("", variableName, map);
    }

    public static void ensureNotEmpty(Class<? extends ProcessEngineException> exceptionClass, String variableName, Map map) {
        EnsureUtil.ensureNotEmpty(exceptionClass, null, variableName, map);
    }

    public static void ensureNotEmpty(String message, String variableName, Map map) {
        EnsureUtil.ensureNotEmpty(ProcessEngineException.class, message, variableName, map);
    }

    public static void ensureNotEmpty(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Map map) {
        EnsureUtil.ensureNotNull(exceptionClass, message, variableName, (Object)map);
        if (map.isEmpty()) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "is empty");
        }
    }

    public static void ensurePositive(String variableName, Long value) {
        EnsureUtil.ensurePositive("", variableName, value);
    }

    public static void ensurePositive(Class<? extends ProcessEngineException> exceptionClass, String variableName, Long value) {
        EnsureUtil.ensurePositive(exceptionClass, null, variableName, value);
    }

    public static void ensurePositive(String message, String variableName, Long value) {
        EnsureUtil.ensurePositive(ProcessEngineException.class, message, variableName, value);
    }

    public static void ensurePositive(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Long value) {
        EnsureUtil.ensureNotNull(exceptionClass, variableName, (Object)value);
        if (value <= 0L) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "is not greater than 0");
        }
    }

    public static void ensureGreaterThanOrEqual(String variableName, long value1, long value2) {
        EnsureUtil.ensureGreaterThanOrEqual("", variableName, value1, value2);
    }

    public static void ensureGreaterThanOrEqual(String message, String variableName, long value1, long value2) {
        EnsureUtil.ensureGreaterThanOrEqual(ProcessEngineException.class, message, variableName, value1, value2);
    }

    public static void ensureGreaterThanOrEqual(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, long value1, long value2) {
        if (value1 < value2) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "is not greater than or equal to " + value2);
        }
    }

    public static void ensureInstanceOf(String variableName, Object value, Class<?> expectedClass) {
        EnsureUtil.ensureInstanceOf("", variableName, value, expectedClass);
    }

    public static void ensureInstanceOf(Class<? extends ProcessEngineException> exceptionClass, String variableName, Object value, Class<?> expectedClass) {
        EnsureUtil.ensureInstanceOf(exceptionClass, null, variableName, value, expectedClass);
    }

    public static void ensureInstanceOf(String message, String variableName, Object value, Class<?> expectedClass) {
        EnsureUtil.ensureInstanceOf(ProcessEngineException.class, message, variableName, value, expectedClass);
    }

    public static void ensureInstanceOf(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Object value, Class<?> expectedClass) {
        EnsureUtil.ensureNotNull(exceptionClass, message, variableName, value);
        Class<?> valueClass = value.getClass();
        if (!expectedClass.isAssignableFrom(valueClass)) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "has class " + valueClass.getName() + " and not " + expectedClass.getName());
        }
    }

    public static void ensureOnlyOneNotNull(String message, Object ... values) {
        EnsureUtil.ensureOnlyOneNotNull(NullValueException.class, message, values);
    }

    public static void ensureOnlyOneNotNull(Class<? extends ProcessEngineException> exceptionClass, String message, Object ... values) {
        boolean oneNotNull = false;
        for (Object value : values) {
            if (value == null) continue;
            if (oneNotNull) {
                throw EnsureUtil.generateException(exceptionClass, null, null, message);
            }
            oneNotNull = true;
        }
        if (!oneNotNull) {
            throw EnsureUtil.generateException(exceptionClass, null, null, message);
        }
    }

    public static void ensureAtLeastOneNotNull(String message, Object ... values) {
        EnsureUtil.ensureAtLeastOneNotNull(NullValueException.class, message, values);
    }

    public static void ensureAtLeastOneNotNull(Class<? extends ProcessEngineException> exceptionClass, String message, Object ... values) {
        for (Object value : values) {
            if (value == null) continue;
            return;
        }
        throw EnsureUtil.generateException(exceptionClass, null, null, message);
    }

    public static void ensureAtLeastOneNotEmpty(String message, String ... values) {
        EnsureUtil.ensureAtLeastOneNotEmpty(ProcessEngineException.class, message, values);
    }

    public static void ensureAtLeastOneNotEmpty(Class<? extends ProcessEngineException> exceptionClass, String message, String ... values) {
        for (String value : values) {
            if (value == null || value.isEmpty()) continue;
            return;
        }
        throw EnsureUtil.generateException(exceptionClass, null, null, message);
    }

    public static void ensureNotContainsEmptyString(String variableName, Collection<String> values) {
        EnsureUtil.ensureNotContainsEmptyString((String)null, variableName, values);
    }

    public static void ensureNotContainsEmptyString(String message, String variableName, Collection<String> values) {
        EnsureUtil.ensureNotContainsEmptyString(NotValidException.class, message, variableName, values);
    }

    public static void ensureNotContainsEmptyString(Class<? extends ProcessEngineException> exceptionClass, String variableName, Collection<String> values) {
        EnsureUtil.ensureNotContainsEmptyString(exceptionClass, null, variableName, values);
    }

    public static void ensureNotContainsEmptyString(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Collection<String> values) {
        EnsureUtil.ensureNotNull(exceptionClass, message, variableName, values);
        for (String value : values) {
            if (!value.isEmpty()) continue;
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "contains empty string");
        }
    }

    public static void ensureNotContainsNull(String variableName, Collection<?> values) {
        EnsureUtil.ensureNotContainsNull((String)null, variableName, values);
    }

    public static void ensureNotContainsNull(String message, String variableName, Collection<?> values) {
        EnsureUtil.ensureNotContainsNull(NullValueException.class, message, variableName, values);
    }

    public static void ensureNotContainsNull(Class<? extends ProcessEngineException> exceptionClass, String variableName, Collection<?> values) {
        EnsureUtil.ensureNotContainsNull(exceptionClass, null, variableName, values);
    }

    public static void ensureNotContainsNull(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Collection<?> values) {
        EnsureUtil.ensureNotNull(exceptionClass, message, variableName, values.toArray(new Object[values.size()]));
    }

    public static void ensureNumberOfElements(String variableName, Collection collection, int elements) {
        EnsureUtil.ensureNumberOfElements("", variableName, collection, elements);
    }

    public static void ensureNumberOfElements(String message, String variableName, Collection collection, int elements) {
        EnsureUtil.ensureNumberOfElements(ProcessEngineException.class, message, variableName, collection, elements);
    }

    public static void ensureNumberOfElements(Class<? extends ProcessEngineException> exceptionClass, String message, String variableName, Collection collection, int elements) {
        EnsureUtil.ensureNotNull(exceptionClass, message, variableName, (Object)collection);
        if (collection.size() != elements) {
            throw EnsureUtil.generateException(exceptionClass, message, variableName, "does not have " + elements + " elements");
        }
    }

    public static void ensureValidIndividualResourceId(String message, String id) {
        EnsureUtil.ensureValidIndividualResourceId(ProcessEngineException.class, message, id);
    }

    public static void ensureValidIndividualResourceId(Class<? extends ProcessEngineException> exceptionClass, String message, String id) {
        EnsureUtil.ensureNotNull(exceptionClass, message, "id", (Object)id);
        if ("*".equals(id)) {
            throw EnsureUtil.generateException(exceptionClass, message, "id", "cannot be *. * is a reserved identifier.");
        }
    }

    public static void ensureValidIndividualResourceIds(String message, Collection<String> ids) {
        EnsureUtil.ensureValidIndividualResourceIds(ProcessEngineException.class, message, ids);
    }

    public static void ensureValidIndividualResourceIds(Class<? extends ProcessEngineException> exceptionClass, String message, Collection<String> ids) {
        EnsureUtil.ensureNotNull(exceptionClass, message, "id", ids);
        for (String id : ids) {
            EnsureUtil.ensureValidIndividualResourceId(exceptionClass, message, id);
        }
    }

    protected static <T extends ProcessEngineException> T generateException(Class<T> exceptionClass, String message, String variableName, String description) {
        String formattedMessage = EnsureUtil.formatMessage(message, variableName, description);
        try {
            Constructor<T> constructor = exceptionClass.getConstructor(String.class);
            return (T)((ProcessEngineException)constructor.newInstance(formattedMessage));
        }
        catch (Exception e) {
            throw LOG.exceptionWhileInstantiatingClass(exceptionClass.getName(), e);
        }
    }

    protected static String formatMessage(String message, String variableName, String description) {
        return EnsureUtil.formatMessageElement(message, ": ") + EnsureUtil.formatMessageElement(variableName, " ") + description;
    }

    protected static String formatMessageElement(String element, String delimiter) {
        if (element != null && !element.isEmpty()) {
            return element.concat(delimiter);
        }
        return "";
    }

    public static void ensureActiveCommandContext(String operation) {
        if (Context.getCommandContext() == null) {
            throw LOG.notInsideCommandContext(operation);
        }
    }
}

