/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.parser;

import org.camunda.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.bpmn.parser.AbstractBpmnParseListener;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.camunda.bpm.engine.impl.core.model.PropertyKey;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.camunda.bpm.engine.impl.util.xml.Namespace;

public class FoxFailedJobParseListener
extends AbstractBpmnParseListener {
    protected static final String TYPE = "type";
    protected static final String START_TIMER_EVENT = "startTimerEvent";
    protected static final String BOUNDARY_TIMER = "boundaryTimer";
    protected static final String INTERMEDIATE_SIGNAL_THROW = "intermediateSignalThrow";
    protected static final String INTERMEDIATE_TIMER = "intermediateTimer";
    protected static final String SIGNAL_EVENT_DEFINITION = "signalEventDefinition";
    protected static final String MULTI_INSTANCE_LOOP_CHARACTERISTICS = "multiInstanceLoopCharacteristics";
    protected static final String EXTENSION_ELEMENTS = "extensionElements";
    protected static final String FAILED_JOB_RETRY_TIME_CYCLE = "failedJobRetryTimeCycle";
    @Deprecated
    public static final Namespace FOX_ENGINE_NS = new Namespace("http://www.camunda.com/fox");
    public static final PropertyKey<String> FOX_FAILED_JOB_CONFIGURATION = new PropertyKey("FOX_FAILED_JOB_CONFIGURATION");

    @Override
    public void parseStartEvent(Element startEventElement, ScopeImpl scope, ActivityImpl startEventActivity) {
        String type = startEventActivity.getProperties().get(BpmnProperties.TYPE);
        if (type != null && type.equals(START_TIMER_EVENT)) {
            this.setFailedJobRetryTimeCycleValue(startEventElement, startEventActivity);
        }
    }

    @Override
    public void parseBoundaryEvent(Element boundaryEventElement, ScopeImpl scopeElement, ActivityImpl nestedActivity) {
        String type = nestedActivity.getProperties().get(BpmnProperties.TYPE);
        if (type != null && type.equals(BOUNDARY_TIMER)) {
            this.setFailedJobRetryTimeCycleValue(boundaryEventElement, nestedActivity);
        }
    }

    @Override
    public void parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        Element signalDefElement;
        boolean asynch;
        String type = activity.getProperties().get(BpmnProperties.TYPE);
        if (type != null && type.equals(INTERMEDIATE_SIGNAL_THROW) && (asynch = "true".equals((signalDefElement = intermediateEventElement.element(SIGNAL_EVENT_DEFINITION)).attributeNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, "async", "false")))) {
            this.setFailedJobRetryTimeCycleValue(intermediateEventElement, activity);
        }
    }

    @Override
    public void parseIntermediateCatchEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        String type = activity.getProperties().get(BpmnProperties.TYPE);
        if (type != null && type.equals(INTERMEDIATE_TIMER)) {
            this.setFailedJobRetryTimeCycleValue(intermediateEventElement, activity);
        }
    }

    @Override
    public void parseScriptTask(Element scriptTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseActivity(scriptTaskElement, activity);
    }

    @Override
    public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseActivity(serviceTaskElement, activity);
    }

    @Override
    public void parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseActivity(businessRuleTaskElement, activity);
    }

    @Override
    public void parseTask(Element taskElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseActivity(taskElement, activity);
    }

    @Override
    public void parseUserTask(Element userTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseActivity(userTaskElement, activity);
    }

    @Override
    public void parseCallActivity(Element callActivityElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseActivity(callActivityElement, activity);
    }

    @Override
    public void parseReceiveTask(Element receiveTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseActivity(receiveTaskElement, activity);
    }

    @Override
    public void parseSendTask(Element sendTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseActivity(sendTaskElement, activity);
    }

    @Override
    public void parseSubProcess(Element subProcessElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseActivity(subProcessElement, activity);
    }

    @Override
    public void parseTransaction(Element transactionElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseActivity(transactionElement, activity);
    }

    protected boolean isAsync(ActivityImpl activity) {
        return activity.isAsyncBefore() || activity.isAsyncAfter();
    }

    protected void parseActivity(Element element, ActivityImpl activity) {
        if (this.isMultiInstance(activity)) {
            ActivityImpl miBody = activity.getParentFlowScopeActivity();
            if (this.isAsync(miBody)) {
                this.setFailedJobRetryTimeCycleValue(element, miBody);
            }
            if (this.isAsync(activity)) {
                Element multiInstanceLoopCharacteristics = element.element(MULTI_INSTANCE_LOOP_CHARACTERISTICS);
                this.setFailedJobRetryTimeCycleValue(multiInstanceLoopCharacteristics, activity);
            }
        } else if (this.isAsync(activity)) {
            this.setFailedJobRetryTimeCycleValue(element, activity);
        }
    }

    protected void setFailedJobRetryTimeCycleValue(Element element, ActivityImpl activity) {
        Element extensionElements = element.element(EXTENSION_ELEMENTS);
        if (extensionElements != null) {
            Element failedJobRetryTimeCycleElement = extensionElements.elementNS(FOX_ENGINE_NS, FAILED_JOB_RETRY_TIME_CYCLE);
            if (failedJobRetryTimeCycleElement == null) {
                failedJobRetryTimeCycleElement = extensionElements.elementNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, FAILED_JOB_RETRY_TIME_CYCLE);
            }
            if (failedJobRetryTimeCycleElement != null) {
                String failedJobRetryTimeCycleValue = failedJobRetryTimeCycleElement.getText();
                activity.getProperties().set(FOX_FAILED_JOB_CONFIGURATION, failedJobRetryTimeCycleValue);
            }
        }
    }

    protected boolean isMultiInstance(ActivityImpl activity) {
        ActivityImpl parent = activity.getParentFlowScopeActivity();
        return parent != null && parent.getActivityBehavior() instanceof MultiInstanceActivityBehavior;
    }
}

