/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.OptimisticLockingListener;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class AcquireJobsCmd
implements Command<AcquiredJobs>,
OptimisticLockingListener {
    private final JobExecutor jobExecutor;
    protected AcquiredJobs acquiredJobs;
    protected int numJobsToAcquire;

    public AcquireJobsCmd(JobExecutor jobExecutor) {
        this(jobExecutor, jobExecutor.getMaxJobsPerAcquisition());
    }

    public AcquireJobsCmd(JobExecutor jobExecutor, int numJobsToAcquire) {
        this.jobExecutor = jobExecutor;
        this.numJobsToAcquire = numJobsToAcquire;
    }

    @Override
    public AcquiredJobs execute(CommandContext commandContext) {
        this.acquiredJobs = new AcquiredJobs(this.numJobsToAcquire);
        List<JobEntity> jobs = commandContext.getJobManager().findNextJobsToExecute(new Page(0, this.numJobsToAcquire));
        for (JobEntity job : jobs) {
            if (job == null || this.acquiredJobs.contains(job.getId())) continue;
            if (job.isExclusive() && job.getProcessInstanceId() != null) {
                List<String> jobIds = this.lockExclusiveJobs(commandContext, job);
                this.acquiredJobs.addJobIdBatch(jobIds);
                continue;
            }
            this.lockJob(job);
            this.acquiredJobs.addJobIdBatch(job.getId());
        }
        commandContext.getDbEntityManager().registerOptimisticLockingListener(this);
        return this.acquiredJobs;
    }

    protected List<String> lockExclusiveJobs(CommandContext commandContext, JobEntity job) {
        ArrayList<String> jobIds = new ArrayList<String>();
        List<JobEntity> exclusiveJobs = commandContext.getJobManager().findExclusiveJobsToExecute(job.getProcessInstanceId());
        if (exclusiveJobs.contains(job)) {
            for (JobEntity exclusiveJob : exclusiveJobs) {
                if (exclusiveJob == null || this.acquiredJobs.contains(exclusiveJob.getId())) continue;
                this.lockJob(exclusiveJob);
                jobIds.add(exclusiveJob.getId());
            }
        }
        return jobIds;
    }

    protected void lockJob(JobEntity job) {
        String lockOwner = this.jobExecutor.getLockOwner();
        job.setLockOwner(lockOwner);
        int lockTimeInMillis = this.jobExecutor.getLockTimeInMillis();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(ClockUtil.getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        job.setLockExpirationTime(gregorianCalendar.getTime());
    }

    @Override
    public Class<? extends DbEntity> getEntityType() {
        return JobEntity.class;
    }

    @Override
    public void failedOperation(DbOperation operation) {
        DbEntityOperation entityOperation;
        if (operation instanceof DbEntityOperation && JobEntity.class.isAssignableFrom((entityOperation = (DbEntityOperation)operation).getEntityType())) {
            this.acquiredJobs.removeJobId(entityOperation.getEntity().getId());
        }
    }
}

