/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.ExternalTaskActivityBehavior;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.incident.IncidentContext;
import org.camunda.bpm.engine.impl.incident.IncidentHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class ExternalTaskEntity
implements ExternalTask,
DbEntity,
HasDbRevision {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected String id;
    protected int revision;
    protected String topicName;
    protected String workerId;
    protected Date lockExpirationTime;
    protected Integer retries;
    protected String errorMessage;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected String executionId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String activityId;
    protected String activityInstanceId;
    protected String tenantId;
    protected long priority;
    protected ExecutionEntity execution;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topic) {
        this.topicName = topic;
    }

    @Override
    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    @Override
    public Date getLockExpirationTime() {
        return this.lockExpirationTime;
    }

    public void setLockExpirationTime(Date lockExpirationTime) {
        this.lockExpirationTime = lockExpirationTime;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean areRetriesLeft() {
        return this.retries == null || this.retries > 0;
    }

    @Override
    public long getPriority() {
        return this.priority;
    }

    public void setPriority(long priority) {
        this.priority = priority;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("topic", this.topicName);
        persistentState.put("workerId", this.workerId);
        persistentState.put("lockExpirationTime", this.lockExpirationTime);
        persistentState.put("retries", this.retries);
        persistentState.put("errorMessage", this.errorMessage);
        persistentState.put("executionId", this.executionId);
        persistentState.put("processInstanceId", this.processInstanceId);
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("processDefinitionKey", this.processDefinitionKey);
        persistentState.put("activityId", this.activityId);
        persistentState.put("activityInstanceId", this.activityInstanceId);
        persistentState.put("suspensionState", this.suspensionState);
        persistentState.put("tenantId", this.tenantId);
        persistentState.put("priority", this.priority);
        return persistentState;
    }

    public void insert() {
        Context.getCommandContext().getExternalTaskManager().insert(this);
        this.getExecution().addExternalTask(this);
    }

    public void delete() {
        this.getExecution().removeExternalTask(this);
        Context.getCommandContext().getExternalTaskManager().delete(this);
    }

    public void complete(Map<String, Object> variables) {
        this.ensureActive();
        ExecutionEntity associatedExecution = this.getExecution();
        if (variables != null) {
            associatedExecution.setVariables(variables);
        }
        this.delete();
        associatedExecution.signal(null, null);
    }

    public void failed(String errorMessage, int retries, long retryDuration) {
        this.ensureActive();
        this.errorMessage = errorMessage;
        this.lockExpirationTime = new Date(ClockUtil.getCurrentTime().getTime() + retryDuration);
        this.setRetriesAndManageIncidents(retries);
    }

    public void bpmnError(String errorCode) {
        this.ensureActive();
        ExecutionEntity activityExecution = this.getExecution();
        BpmnError bpmnError = new BpmnError(errorCode);
        try {
            ExternalTaskActivityBehavior behavior = (ExternalTaskActivityBehavior)activityExecution.getActivity().getActivityBehavior();
            behavior.propagateBpmnError(bpmnError, activityExecution);
        }
        catch (Exception ex) {
            throw ProcessEngineLogger.CMD_LOGGER.exceptionBpmnErrorPropagationFailed(errorCode, ex);
        }
    }

    public void setRetriesAndManageIncidents(int retries) {
        if (this.areRetriesLeft() && retries <= 0) {
            this.createIncident();
        } else if (!this.areRetriesLeft() && retries > 0) {
            this.removeIncident();
        }
        this.setRetries(retries);
    }

    protected void createIncident() {
        IncidentHandler incidentHandler = Context.getProcessEngineConfiguration().getIncidentHandler("failedExternalTask");
        incidentHandler.handleIncident(this.createIncidentContext(), this.errorMessage);
    }

    protected void removeIncident() {
        IncidentHandler handler = Context.getProcessEngineConfiguration().getIncidentHandler("failedExternalTask");
        handler.resolveIncident(this.createIncidentContext());
    }

    protected IncidentContext createIncidentContext() {
        IncidentContext context = new IncidentContext();
        context.setProcessDefinitionId(this.processDefinitionId);
        context.setExecutionId(this.executionId);
        context.setActivityId(this.activityId);
        context.setTenantId(this.tenantId);
        context.setConfiguration(this.id);
        return context;
    }

    public void lock(String workerId, long lockDuration) {
        this.workerId = workerId;
        this.lockExpirationTime = new Date(ClockUtil.getCurrentTime().getTime() + lockDuration);
    }

    public ExecutionEntity getExecution() {
        this.ensureExecutionInitialized();
        return this.execution;
    }

    public void setExecution(ExecutionEntity execution) {
        this.execution = execution;
    }

    protected void ensureExecutionInitialized() {
        if (this.execution == null) {
            this.execution = Context.getCommandContext().getExecutionManager().findExecutionById(this.executionId);
            EnsureUtil.ensureNotNull("Cannot find execution with id " + this.executionId + " for external task " + this.id, "execution", (Object)this.execution);
        }
    }

    protected void ensureActive() {
        if (this.suspensionState == SuspensionState.SUSPENDED.getStateCode()) {
            throw LOG.suspendedEntityException("ExternalTask", this.id);
        }
    }

    public String toString() {
        return "ExternalTaskEntity [id=" + this.id + ", revision=" + this.revision + ", topicName=" + this.topicName + ", workerId=" + this.workerId + ", lockExpirationTime=" + this.lockExpirationTime + ", priority=" + this.priority + ", executionId=" + this.executionId + "]";
    }

    public void unlock() {
        this.workerId = null;
        this.lockExpirationTime = null;
    }

    public static ExternalTaskEntity createAndInsert(ExecutionEntity execution, String topic, long priority) {
        ExternalTaskEntity externalTask = new ExternalTaskEntity();
        externalTask.setTopicName(topic);
        externalTask.setExecutionId(execution.getId());
        externalTask.setProcessInstanceId(execution.getProcessInstanceId());
        externalTask.setProcessDefinitionId(execution.getProcessDefinitionId());
        externalTask.setActivityId(execution.getActivityId());
        externalTask.setActivityInstanceId(execution.getActivityInstanceId());
        externalTask.setTenantId(execution.getTenantId());
        externalTask.setPriority(priority);
        ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
        externalTask.setProcessDefinitionKey(processDefinition.getKey());
        externalTask.insert();
        return externalTask;
    }
}

