/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventProcessor;
import org.camunda.bpm.engine.impl.history.event.HistoryEventType;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.task.IdentityLink;

public class IdentityLinkEntity
implements Serializable,
IdentityLink,
DbEntity {
    private static final long serialVersionUID = 1L;
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected String id;
    protected String type;
    protected String userId;
    protected String groupId;
    protected String taskId;
    protected String processDefId;
    protected String tenantId;
    protected TaskEntity task;
    protected ProcessDefinitionEntity processDef;

    @Override
    public Object getPersistentState() {
        return this.type;
    }

    public static IdentityLinkEntity createAndInsert() {
        IdentityLinkEntity identityLinkEntity = new IdentityLinkEntity();
        identityLinkEntity.insert();
        return identityLinkEntity;
    }

    public static IdentityLinkEntity newIdentityLink() {
        IdentityLinkEntity identityLinkEntity = new IdentityLinkEntity();
        return identityLinkEntity;
    }

    public void insert() {
        Context.getCommandContext().getDbEntityManager().insert(this);
        this.fireHistoricIdentityLinkEvent(HistoryEventTypes.IDENTITY_LINK_ADD);
    }

    public void delete() {
        Context.getCommandContext().getDbEntityManager().delete(this);
        this.fireHistoricIdentityLinkEvent(HistoryEventTypes.IDENTITY_LINK_DELETE);
    }

    public boolean isUser() {
        return this.userId != null;
    }

    public boolean isGroup() {
        return this.groupId != null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        if (this.groupId != null && userId != null) {
            throw LOG.taskIsAlreadyAssignedException("userId", "groupId");
        }
        this.userId = userId;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        if (this.userId != null && groupId != null) {
            throw LOG.taskIsAlreadyAssignedException("groupId", "userId");
        }
        this.groupId = groupId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getProcessDefId() {
        return this.processDefId;
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public TaskEntity getTask() {
        if (this.task == null && this.taskId != null) {
            this.task = Context.getCommandContext().getTaskManager().findTaskById(this.taskId);
        }
        return this.task;
    }

    public void setTask(TaskEntity task) {
        this.task = task;
        this.taskId = task.getId();
    }

    public ProcessDefinitionEntity getProcessDef() {
        if (this.processDef == null && this.processDefId != null) {
            this.processDef = Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionById(this.processDefId);
        }
        return this.processDef;
    }

    public void setProcessDef(ProcessDefinitionEntity processDef) {
        this.processDef = processDef;
        this.processDefId = processDef.getId();
    }

    public void fireHistoricIdentityLinkEvent(final HistoryEventType eventType) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = processEngineConfiguration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(eventType, this)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    HistoryEvent event = null;
                    if (HistoryEvent.IDENTITY_LINK_ADD.equals(eventType.getEventName())) {
                        event = producer.createHistoricIdentityLinkAddEvent(IdentityLinkEntity.this);
                    } else if (HistoryEvent.IDENTITY_LINK_DELETE.equals(eventType.getEventName())) {
                        event = producer.createHistoricIdentityLinkDeleteEvent(IdentityLinkEntity.this);
                    }
                    return event;
                }
            });
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", type=" + this.type + ", userId=" + this.userId + ", groupId=" + this.groupId + ", taskId=" + this.taskId + ", processDefId=" + this.processDefId + ", task=" + this.task + ", processDef=" + this.processDef + ", tenantId=" + this.tenantId + "]";
    }
}

