/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.MissingAuthorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.ActivityStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.AuthorizationQueryImpl;
import org.camunda.bpm.engine.impl.DeploymentQueryImpl;
import org.camunda.bpm.engine.impl.DeploymentStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.camunda.bpm.engine.impl.ExternalTaskQueryImpl;
import org.camunda.bpm.engine.impl.HistoricActivityInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricDecisionInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricDetailQueryImpl;
import org.camunda.bpm.engine.impl.HistoricIdentityLinkLogQueryImpl;
import org.camunda.bpm.engine.impl.HistoricIncidentQueryImpl;
import org.camunda.bpm.engine.impl.HistoricJobLogQueryImpl;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricTaskInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricVariableInstanceQueryImpl;
import org.camunda.bpm.engine.impl.IncidentQueryImpl;
import org.camunda.bpm.engine.impl.JobDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.JobQueryImpl;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.ProcessDefinitionStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.UserOperationLogQueryImpl;
import org.camunda.bpm.engine.impl.VariableInstanceQueryImpl;
import org.camunda.bpm.engine.impl.batch.BatchQueryImpl;
import org.camunda.bpm.engine.impl.batch.BatchStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.batch.history.HistoricBatchQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.AuthorizationCheck;
import org.camunda.bpm.engine.impl.db.CompositePermissionCheck;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.db.PermissionCheck;
import org.camunda.bpm.engine.impl.db.PermissionCheckBuilder;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class AuthorizationManager
extends AbstractManager {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected static final List<String> EMPTY_LIST = new ArrayList<String>();
    protected Set<String> availableAuthorizedGroupIds = null;
    protected Boolean isRevokeAuthCheckUsed = null;

    public PermissionCheck newPermissionCheck() {
        return new PermissionCheck();
    }

    public PermissionCheckBuilder newPermissionCheckBuilder() {
        return new PermissionCheckBuilder();
    }

    public Authorization createNewAuthorization(int type) {
        this.checkAuthorization(Permissions.CREATE, Resources.AUTHORIZATION, null);
        return new AuthorizationEntity(type);
    }

    @Override
    public void insert(DbEntity authorization) {
        this.checkAuthorization(Permissions.CREATE, Resources.AUTHORIZATION, null);
        this.getDbEntityManager().insert(authorization);
    }

    public List<Authorization> selectAuthorizationByQueryCriteria(AuthorizationQueryImpl authorizationQuery) {
        this.configureQuery((AbstractQuery)authorizationQuery, (Resource)Resources.AUTHORIZATION);
        return this.getDbEntityManager().selectList("selectAuthorizationByQueryCriteria", authorizationQuery);
    }

    public Long selectAuthorizationCountByQueryCriteria(AuthorizationQueryImpl authorizationQuery) {
        this.configureQuery((AbstractQuery)authorizationQuery, (Resource)Resources.AUTHORIZATION);
        return (Long)this.getDbEntityManager().selectOne("selectAuthorizationCountByQueryCriteria", authorizationQuery);
    }

    public AuthorizationEntity findAuthorizationByUserIdAndResourceId(int type, String userId, Resource resource, String resourceId) {
        return this.findAuthorization(type, userId, null, resource, resourceId);
    }

    public AuthorizationEntity findAuthorizationByGroupIdAndResourceId(int type, String groupId, Resource resource, String resourceId) {
        return this.findAuthorization(type, null, groupId, resource, resourceId);
    }

    public AuthorizationEntity findAuthorization(int type, String userId, String groupId, Resource resource, String resourceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("userId", userId);
        params.put("groupId", groupId);
        params.put("resourceId", resourceId);
        if (resource != null) {
            params.put("resourceType", resource.resourceType());
        }
        return (AuthorizationEntity)this.getDbEntityManager().selectOne("selectAuthorizationByParameters", params);
    }

    public void update(AuthorizationEntity authorization) {
        this.checkAuthorization(Permissions.UPDATE, Resources.AUTHORIZATION, authorization.getId());
        this.getDbEntityManager().merge(authorization);
    }

    @Override
    public void delete(DbEntity authorization) {
        this.checkAuthorization(Permissions.DELETE, Resources.AUTHORIZATION, authorization.getId());
        this.deleteAuthorizationsByResourceId(Resources.AUTHORIZATION, authorization.getId());
        super.delete(authorization);
    }

    public void checkAuthorization(PermissionCheck ... permissionChecks) {
        EnsureUtil.ensureNotNull("permissionChecks", permissionChecks);
        for (PermissionCheck permissionCheck : permissionChecks) {
            EnsureUtil.ensureNotNull("permissionCheck", (Object)permissionCheck);
        }
        this.checkAuthorization(CollectionUtil.asArrayList(permissionChecks));
    }

    public void checkAuthorization(CompositePermissionCheck compositePermissionCheck) {
        if (this.isAuthCheckExecuted()) {
            Authentication currentAuthentication = this.getCurrentAuthentication();
            String userId = currentAuthentication.getUserId();
            boolean isAuthorized = this.isAuthorized(compositePermissionCheck);
            if (!isAuthorized) {
                ArrayList<MissingAuthorization> missingAuthorizations = new ArrayList<MissingAuthorization>();
                for (PermissionCheck check : compositePermissionCheck.getAllPermissionChecks()) {
                    missingAuthorizations.add(new MissingAuthorization(check.getPermission().getName(), check.getResource().resourceName(), check.getResourceId()));
                }
                throw new AuthorizationException(userId, missingAuthorizations);
            }
        }
    }

    public void checkAuthorization(List<PermissionCheck> permissionChecks) {
        Authentication currentAuthentication;
        String userId;
        boolean isAuthorized;
        if (this.isAuthCheckExecuted() && !(isAuthorized = this.isAuthorized(userId = (currentAuthentication = this.getCurrentAuthentication()).getUserId(), currentAuthentication.getGroupIds(), permissionChecks))) {
            ArrayList<MissingAuthorization> missingAuthorizations = new ArrayList<MissingAuthorization>();
            for (PermissionCheck check : permissionChecks) {
                missingAuthorizations.add(new MissingAuthorization(check.getPermission().getName(), check.getResource().resourceName(), check.getResourceId()));
            }
            throw new AuthorizationException(userId, missingAuthorizations);
        }
    }

    public void checkAuthorization(Permission permission, Resource resource) {
        this.checkAuthorization(permission, resource, null);
    }

    @Override
    public void checkAuthorization(Permission permission, Resource resource, String resourceId) {
        Authentication currentAuthentication;
        boolean isAuthorized;
        if (this.isAuthCheckExecuted() && !(isAuthorized = this.isAuthorized((currentAuthentication = this.getCurrentAuthentication()).getUserId(), currentAuthentication.getGroupIds(), permission, resource, resourceId))) {
            throw new AuthorizationException(currentAuthentication.getUserId(), permission.getName(), resource.resourceName(), resourceId);
        }
    }

    public boolean isAuthorized(Permission permission, Resource resource, String resourceId) {
        Authentication currentAuthentication = this.getCurrentAuthentication();
        if (this.isAuthorizationEnabled() && currentAuthentication != null && currentAuthentication.getUserId() != null) {
            return this.isAuthorized(currentAuthentication.getUserId(), currentAuthentication.getGroupIds(), permission, resource, resourceId);
        }
        return true;
    }

    public boolean isAuthorized(String userId, List<String> groupIds, Permission permission, Resource resource, String resourceId) {
        PermissionCheck permCheck = this.newPermissionCheck();
        permCheck.setPermission(permission);
        permCheck.setResource(resource);
        permCheck.setResourceId(resourceId);
        ArrayList<PermissionCheck> permissionChecks = new ArrayList<PermissionCheck>();
        permissionChecks.add(permCheck);
        return this.isAuthorized(userId, groupIds, permissionChecks);
    }

    public boolean isAuthorized(String userId, List<String> groupIds, List<PermissionCheck> permissionChecks) {
        if (!this.isAuthorizationEnabled()) {
            return true;
        }
        List<String> filteredGroupIds = this.filterAuthenticatedGroupIds(groupIds);
        boolean isRevokeAuthorizationCheckEnabled = this.isRevokeAuthCheckEnabled(userId, groupIds);
        AuthorizationCheck authCheck = new AuthorizationCheck(userId, filteredGroupIds, permissionChecks, isRevokeAuthorizationCheckEnabled);
        return this.getDbEntityManager().selectBoolean("isUserAuthorizedForResource", authCheck);
    }

    protected boolean isRevokeAuthCheckEnabled(String userId, List<String> groupIds) {
        Boolean isRevokeAuthCheckEnabled = this.isRevokeAuthCheckUsed;
        if (isRevokeAuthCheckEnabled == null) {
            String configuredMode = Context.getProcessEngineConfiguration().getAuthorizationCheckRevokes();
            if (configuredMode != null) {
                configuredMode = configuredMode.toLowerCase();
            }
            if ("always".equals(configuredMode)) {
                isRevokeAuthCheckEnabled = true;
            } else if ("never".equals(configuredMode)) {
                isRevokeAuthCheckEnabled = false;
            } else {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("userId", userId);
                params.put("authGroupIds", this.filterAuthenticatedGroupIds(groupIds));
                isRevokeAuthCheckEnabled = this.getDbEntityManager().selectBoolean("selectRevokeAuthorization", params);
            }
            this.isRevokeAuthCheckUsed = isRevokeAuthCheckEnabled;
        }
        return isRevokeAuthCheckEnabled;
    }

    public boolean isAuthorized(String userId, List<String> groupIds, CompositePermissionCheck compositePermissionCheck) {
        List<String> filteredGroupIds = this.filterAuthenticatedGroupIds(groupIds);
        boolean isRevokeAuthorizationCheckEnabled = this.isRevokeAuthCheckEnabled(userId, groupIds);
        AuthorizationCheck authCheck = new AuthorizationCheck(userId, filteredGroupIds, compositePermissionCheck, isRevokeAuthorizationCheckEnabled);
        return this.getDbEntityManager().selectBoolean("isUserAuthorizedForResource", authCheck);
    }

    public boolean isAuthorized(CompositePermissionCheck compositePermissionCheck) {
        Authentication currentAuthentication = this.getCurrentAuthentication();
        if (currentAuthentication != null) {
            return this.isAuthorized(currentAuthentication.getUserId(), currentAuthentication.getGroupIds(), compositePermissionCheck);
        }
        return true;
    }

    public void configureQuery(ListQueryParameterObject query) {
        AuthorizationCheck authCheck = query.getAuthCheck();
        authCheck.getPermissionChecks().clear();
        if (this.isAuthCheckExecuted()) {
            Authentication currentAuthentication = this.getCurrentAuthentication();
            authCheck.setAuthUserId(currentAuthentication.getUserId());
            authCheck.setAuthGroupIds(currentAuthentication.getGroupIds());
            this.enableQueryAuthCheck(authCheck);
        } else {
            authCheck.setAuthorizationCheckEnabled(false);
            authCheck.setAuthUserId(null);
            authCheck.setAuthGroupIds(null);
        }
    }

    public void enableQueryAuthCheck(AuthorizationCheck authCheck) {
        List<String> authGroupIds = authCheck.getAuthGroupIds();
        String authUserId = authCheck.getAuthUserId();
        authCheck.setAuthorizationCheckEnabled(true);
        authCheck.setAuthGroupIds(this.filterAuthenticatedGroupIds(authGroupIds));
        authCheck.setRevokeAuthorizationCheckEnabled(this.isRevokeAuthCheckEnabled(authUserId, authGroupIds));
    }

    public void configureQuery(AbstractQuery query, Resource resource) {
        this.configureQuery(query, resource, "RES.ID_");
    }

    public void configureQuery(AbstractQuery query, Resource resource, String queryParam) {
        this.configureQuery(query, resource, queryParam, Permissions.READ);
    }

    public void configureQuery(AbstractQuery query, Resource resource, String queryParam, Permission permission) {
        this.configureQuery(query);
        this.addPermissionCheck(query, resource, queryParam, permission);
    }

    protected void addPermissionCheck(ListQueryParameterObject query, Resource resource, String queryParam, Permission permission) {
        CommandContext commandContext = this.getCommandContext();
        if (this.isAuthorizationEnabled() && this.getCurrentAuthentication() != null && commandContext.isAuthorizationCheckEnabled()) {
            PermissionCheck permCheck = this.newPermissionCheck();
            permCheck.setResource(resource);
            permCheck.setResourceIdQueryParam(queryParam);
            permCheck.setPermission(permission);
            query.getAuthCheck().addAtomicPermissionCheck(permCheck);
        }
    }

    protected void addPermissionCheck(AuthorizationCheck authCheck, CompositePermissionCheck compositeCheck) {
        CommandContext commandContext = this.getCommandContext();
        if (this.isAuthorizationEnabled() && this.getCurrentAuthentication() != null && commandContext.isAuthorizationCheckEnabled()) {
            authCheck.setPermissionChecks(compositeCheck);
        }
    }

    public void deleteAuthorizationsByResourceId(Resource resource, String resourceId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Resource id cannot be null");
        }
        if (this.isAuthorizationEnabled()) {
            HashMap<String, Object> deleteParams = new HashMap<String, Object>();
            deleteParams.put("resourceType", resource.resourceType());
            deleteParams.put("resourceId", resourceId);
            this.getDbEntityManager().delete(AuthorizationEntity.class, "deleteAuthorizationsForResourceId", deleteParams);
        }
    }

    public void deleteAuthorizationsByResourceIdAndUserId(Resource resource, String resourceId, String userId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Resource id cannot be null");
        }
        if (this.isAuthorizationEnabled()) {
            HashMap<String, Object> deleteParams = new HashMap<String, Object>();
            deleteParams.put("resourceType", resource.resourceType());
            deleteParams.put("resourceId", resourceId);
            deleteParams.put("userId", userId);
            this.getDbEntityManager().delete(AuthorizationEntity.class, "deleteAuthorizationsForResourceId", deleteParams);
        }
    }

    public void deleteAuthorizationsByResourceIdAndGroupId(Resource resource, String resourceId, String groupId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Resource id cannot be null");
        }
        if (this.isAuthorizationEnabled()) {
            HashMap<String, Object> deleteParams = new HashMap<String, Object>();
            deleteParams.put("resourceType", resource.resourceType());
            deleteParams.put("resourceId", resourceId);
            deleteParams.put("groupId", groupId);
            this.getDbEntityManager().delete(AuthorizationEntity.class, "deleteAuthorizationsForResourceId", deleteParams);
        }
    }

    public void checkCamundaAdmin() {
        Authentication currentAuthentication = this.getCurrentAuthentication();
        CommandContext commandContext = Context.getCommandContext();
        if (this.isAuthorizationEnabled() && commandContext.isAuthorizationCheckEnabled() && currentAuthentication != null && !this.isCamundaAdmin(currentAuthentication)) {
            throw LOG.requiredCamundaAdminException();
        }
    }

    public boolean isCamundaAdmin(Authentication authentication) {
        List<String> groupIds = authentication.getGroupIds();
        if (groupIds != null) {
            return groupIds.contains("camunda-admin");
        }
        return false;
    }

    public void configureDeploymentQuery(DeploymentQueryImpl query) {
        this.configureQuery((AbstractQuery)query, (Resource)Resources.DEPLOYMENT);
    }

    public void configureProcessDefinitionQuery(ProcessDefinitionQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.KEY_");
    }

    public void configureExecutionQuery(AbstractQuery query) {
        this.configureQuery(query);
        this.addPermissionCheck(query, Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ);
        this.addPermissionCheck(query, Resources.PROCESS_DEFINITION, "P.KEY_", Permissions.READ_INSTANCE);
    }

    public void configureTaskQuery(TaskQueryImpl query) {
        this.configureQuery(query);
        if (query.getAuthCheck().isAuthorizationCheckEnabled()) {
            CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.TASK, "RES.ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_TASK).build();
            this.addPermissionCheck(query.getAuthCheck(), permissionCheck);
        }
    }

    public void configureEventSubscriptionQuery(EventSubscriptionQueryImpl query) {
        this.configureQuery(query);
        this.addPermissionCheck(query, Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ);
        this.addPermissionCheck(query, Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_INSTANCE);
    }

    public void configureIncidentQuery(IncidentQueryImpl query) {
        this.configureQuery(query);
        this.addPermissionCheck(query, Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ);
        this.addPermissionCheck(query, Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_INSTANCE);
    }

    protected void configureVariableInstanceQuery(VariableInstanceQueryImpl query) {
        this.configureQuery(query);
        if (query.getAuthCheck().isAuthorizationCheckEnabled()) {
            CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_INSTANCE).atomicCheck(Resources.TASK, "RES.TASK_ID_", Permissions.READ).build();
            this.addPermissionCheck(query.getAuthCheck(), permissionCheck);
        }
    }

    public void configureJobDefinitionQuery(JobDefinitionQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_");
    }

    public void configureJobQuery(JobQueryImpl query) {
        this.configureQuery(query);
        this.addPermissionCheck(query, Resources.PROCESS_INSTANCE, "RES.PROCESS_INSTANCE_ID_", Permissions.READ);
        this.addPermissionCheck(query, Resources.PROCESS_DEFINITION, "RES.PROCESS_DEF_KEY_", Permissions.READ_INSTANCE);
    }

    public void configureHistoricProcessInstanceQuery(HistoricProcessInstanceQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "SELF.PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricActivityInstanceQuery(HistoricActivityInstanceQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "SELF.PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricTaskInstanceQuery(HistoricTaskInstanceQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "SELF.PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricVariableInstanceQuery(HistoricVariableInstanceQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "SELF.PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricDetailQuery(HistoricDetailQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "SELF.PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricJobLogQuery(HistoricJobLogQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "SELF.PROCESS_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricIncidentQuery(HistoricIncidentQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "SELF.PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricIdentityLinkQuery(HistoricIdentityLinkLogQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "SELF.PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricDecisionInstanceQuery(HistoricDecisionInstanceQueryImpl query) {
        this.configureQuery(query, Resources.DECISION_DEFINITION, "SELF.DEC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureUserOperationLogQuery(UserOperationLogQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "SELF.PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricBatchQuery(HistoricBatchQueryImpl query) {
        this.configureQuery(query, Resources.BATCH, "RES.ID_", Permissions.READ_HISTORY);
    }

    public void configureDeploymentStatisticsQuery(DeploymentStatisticsQueryImpl query) {
        this.configureQuery(query, Resources.DEPLOYMENT, "RES.ID_");
        query.getProcessInstancePermissionChecks().clear();
        query.getJobPermissionChecks().clear();
        query.getIncidentPermissionChecks().clear();
        if (query.getAuthCheck().isAuthorizationCheckEnabled()) {
            PermissionCheck firstProcessInstancePermissionCheck = this.newPermissionCheck();
            firstProcessInstancePermissionCheck.setResource(Resources.PROCESS_INSTANCE);
            firstProcessInstancePermissionCheck.setPermission(Permissions.READ);
            firstProcessInstancePermissionCheck.setResourceIdQueryParam("EXECUTION.PROC_INST_ID_");
            PermissionCheck secondProcessInstancePermissionCheck = this.newPermissionCheck();
            secondProcessInstancePermissionCheck.setResource(Resources.PROCESS_DEFINITION);
            secondProcessInstancePermissionCheck.setPermission(Permissions.READ_INSTANCE);
            secondProcessInstancePermissionCheck.setResourceIdQueryParam("PROCDEF.KEY_");
            secondProcessInstancePermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            query.addProcessInstancePermissionCheck(firstProcessInstancePermissionCheck);
            query.addProcessInstancePermissionCheck(secondProcessInstancePermissionCheck);
            if (query.isFailedJobsToInclude()) {
                PermissionCheck firstJobPermissionCheck = this.newPermissionCheck();
                firstJobPermissionCheck.setResource(Resources.PROCESS_INSTANCE);
                firstJobPermissionCheck.setPermission(Permissions.READ);
                firstJobPermissionCheck.setResourceIdQueryParam("JOB.PROCESS_INSTANCE_ID_");
                PermissionCheck secondJobPermissionCheck = this.newPermissionCheck();
                secondJobPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
                secondJobPermissionCheck.setPermission(Permissions.READ_INSTANCE);
                secondJobPermissionCheck.setResourceIdQueryParam("JOB.PROCESS_DEF_KEY_");
                secondJobPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
                query.addJobPermissionCheck(firstJobPermissionCheck);
                query.addJobPermissionCheck(secondJobPermissionCheck);
            }
            if (query.isIncidentsToInclude()) {
                PermissionCheck firstIncidentPermissionCheck = this.newPermissionCheck();
                firstIncidentPermissionCheck.setResource(Resources.PROCESS_INSTANCE);
                firstIncidentPermissionCheck.setPermission(Permissions.READ);
                firstIncidentPermissionCheck.setResourceIdQueryParam("INC.PROC_INST_ID_");
                PermissionCheck secondIncidentPermissionCheck = this.newPermissionCheck();
                secondIncidentPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
                secondIncidentPermissionCheck.setPermission(Permissions.READ_INSTANCE);
                secondIncidentPermissionCheck.setResourceIdQueryParam("PROCDEF.KEY_");
                secondIncidentPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
                query.addIncidentPermissionCheck(firstIncidentPermissionCheck);
                query.addIncidentPermissionCheck(secondIncidentPermissionCheck);
            }
        }
    }

    public void configureProcessDefinitionStatisticsQuery(ProcessDefinitionStatisticsQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.KEY_");
    }

    public void configureActivityStatisticsQuery(ActivityStatisticsQueryImpl query) {
        this.configureQuery(query);
        query.getProcessInstancePermissionChecks().clear();
        query.getJobPermissionChecks().clear();
        query.getIncidentPermissionChecks().clear();
        if (query.getAuthCheck().isAuthorizationCheckEnabled()) {
            PermissionCheck firstProcessInstancePermissionCheck = this.newPermissionCheck();
            firstProcessInstancePermissionCheck.setResource(Resources.PROCESS_INSTANCE);
            firstProcessInstancePermissionCheck.setPermission(Permissions.READ);
            firstProcessInstancePermissionCheck.setResourceIdQueryParam("E.PROC_INST_ID_");
            PermissionCheck secondProcessInstancePermissionCheck = this.newPermissionCheck();
            secondProcessInstancePermissionCheck.setResource(Resources.PROCESS_DEFINITION);
            secondProcessInstancePermissionCheck.setPermission(Permissions.READ_INSTANCE);
            secondProcessInstancePermissionCheck.setResourceIdQueryParam("P.KEY_");
            secondProcessInstancePermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            query.addProcessInstancePermissionCheck(firstProcessInstancePermissionCheck);
            query.addProcessInstancePermissionCheck(secondProcessInstancePermissionCheck);
            if (query.isFailedJobsToInclude()) {
                PermissionCheck firstJobPermissionCheck = this.newPermissionCheck();
                firstJobPermissionCheck.setResource(Resources.PROCESS_INSTANCE);
                firstJobPermissionCheck.setPermission(Permissions.READ);
                firstJobPermissionCheck.setResourceIdQueryParam("JOB.PROCESS_INSTANCE_ID_");
                PermissionCheck secondJobPermissionCheck = this.newPermissionCheck();
                secondJobPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
                secondJobPermissionCheck.setPermission(Permissions.READ_INSTANCE);
                secondJobPermissionCheck.setResourceIdQueryParam("JOB.PROCESS_DEF_KEY_");
                secondJobPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
                query.addJobPermissionCheck(firstJobPermissionCheck);
                query.addJobPermissionCheck(secondJobPermissionCheck);
            }
            if (query.isIncidentsToInclude()) {
                PermissionCheck firstIncidentPermissionCheck = this.newPermissionCheck();
                firstIncidentPermissionCheck.setResource(Resources.PROCESS_INSTANCE);
                firstIncidentPermissionCheck.setPermission(Permissions.READ);
                firstIncidentPermissionCheck.setResourceIdQueryParam("I.PROC_INST_ID_");
                PermissionCheck secondIncidentPermissionCheck = this.newPermissionCheck();
                secondIncidentPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
                secondIncidentPermissionCheck.setPermission(Permissions.READ_INSTANCE);
                secondIncidentPermissionCheck.setResourceIdQueryParam("PROCDEF.KEY_");
                secondIncidentPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
                query.addIncidentPermissionCheck(firstIncidentPermissionCheck);
                query.addIncidentPermissionCheck(secondIncidentPermissionCheck);
            }
        }
    }

    public void configureExternalTaskQuery(ExternalTaskQueryImpl query) {
        this.configureQuery(query);
        this.addPermissionCheck(query, Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ);
        this.addPermissionCheck(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_INSTANCE);
    }

    public void configureExternalTaskFetch(ListQueryParameterObject parameter) {
        this.configureQuery(parameter);
        CompositePermissionCheck permissionCheck = this.newPermissionCheckBuilder().conjunctive().composite().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_INSTANCE).done().composite().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.UPDATE).atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.UPDATE_INSTANCE).done().build();
        this.addPermissionCheck(parameter.getAuthCheck(), permissionCheck);
    }

    public void configureDecisionDefinitionQuery(DecisionDefinitionQueryImpl query) {
        this.configureQuery(query, Resources.DECISION_DEFINITION, "RES.KEY_");
    }

    public void configureDecisionRequirementsDefinitionQuery(DecisionRequirementsDefinitionQueryImpl query) {
        this.configureQuery(query, Resources.DECISION_REQUIREMENTS_DEFINITION, "RES.KEY_");
    }

    public void configureBatchQuery(BatchQueryImpl query) {
        this.configureQuery(query);
        this.addPermissionCheck(query, Resources.BATCH, "RES.ID_", Permissions.READ);
    }

    public void configureBatchStatisticsQuery(BatchStatisticsQueryImpl query) {
        this.configureQuery(query);
        this.addPermissionCheck(query, Resources.BATCH, "RES.ID_", Permissions.READ);
    }

    public List<String> filterAuthenticatedGroupIds(List<String> authenticatedGroupIds) {
        if (authenticatedGroupIds == null || authenticatedGroupIds.isEmpty()) {
            return EMPTY_LIST;
        }
        if (this.availableAuthorizedGroupIds == null) {
            this.availableAuthorizedGroupIds = new HashSet<String>(this.getDbEntityManager().selectList("selectAuthorizedGroupIds"));
        }
        HashSet<String> copy = new HashSet<String>(this.availableAuthorizedGroupIds);
        copy.retainAll(authenticatedGroupIds);
        return new ArrayList<String>(copy);
    }

    protected boolean isAuthCheckExecuted() {
        Authentication currentAuthentication = this.getCurrentAuthentication();
        CommandContext commandContext = Context.getCommandContext();
        return this.isAuthorizationEnabled() && commandContext.isAuthorizationCheckEnabled() && currentAuthentication != null && currentAuthentication.getUserId() != null;
    }
}

