/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.List;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.DeploymentQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionManager;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class DeploymentManager
extends AbstractManager {
    public void insertDeployment(DeploymentEntity deployment) {
        this.getDbEntityManager().insert(deployment);
        this.createDefaultAuthorizations(deployment);
        for (ResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceManager().insertResource(resource);
        }
        Context.getProcessEngineConfiguration().getDeploymentCache().deploy(deployment);
    }

    public void deleteDeployment(String deploymentId, boolean cascade) {
        this.deleteDeployment(deploymentId, cascade, false, false);
    }

    public void deleteDeployment(String deploymentId, boolean cascade, boolean skipCustomListeners, boolean skipIoMappings) {
        String processDefinitionId;
        List<ProcessDefinition> processDefinitions = this.getProcessDefinitionManager().findProcessDefinitionsByDeploymentId(deploymentId);
        if (cascade) {
            for (ProcessDefinition processDefinition : processDefinitions) {
                processDefinitionId = processDefinition.getId();
                this.getProcessInstanceManager().deleteProcessInstancesByProcessDefinition(processDefinitionId, "deleted deployment", true, skipCustomListeners, skipIoMappings);
            }
            this.getHistoricJobLogManager().deleteHistoricJobLogsByDeploymentId(deploymentId);
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionId = processDefinition.getId();
            this.getProcessDefinitionManager().deleteProcessDefinition(processDefinition, processDefinitionId, cascade, false, skipCustomListeners);
        }
        this.deleteCaseDeployment(deploymentId, cascade);
        this.deleteDecisionDeployment(deploymentId, cascade);
        this.deleteDecisionRequirementDeployment(deploymentId);
        this.getResourceManager().deleteResourcesByDeploymentId(deploymentId);
        this.deleteAuthorizations(Resources.DEPLOYMENT, deploymentId);
        this.getDbEntityManager().delete(DeploymentEntity.class, "deleteDeployment", deploymentId);
    }

    protected void deleteCaseDeployment(String deploymentId, boolean cascade) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isCmmnEnabled()) {
            List<CaseDefinition> caseDefinitions = this.getCaseDefinitionManager().findCaseDefinitionByDeploymentId(deploymentId);
            if (cascade) {
                for (CaseDefinition caseDefinition : caseDefinitions) {
                    String caseDefinitionId = caseDefinition.getId();
                    this.getCaseInstanceManager().deleteCaseInstancesByCaseDefinition(caseDefinitionId, "deleted deployment", true);
                }
            }
            this.getCaseDefinitionManager().deleteCaseDefinitionsByDeploymentId(deploymentId);
            for (CaseDefinition caseDefinition : caseDefinitions) {
                String processDefinitionId = caseDefinition.getId();
                Context.getProcessEngineConfiguration().getDeploymentCache().removeCaseDefinition(processDefinitionId);
            }
        }
    }

    protected void deleteDecisionDeployment(String deploymentId, boolean cascade) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isDmnEnabled()) {
            DecisionDefinitionManager decisionDefinitionManager = this.getDecisionDefinitionManager();
            List<DecisionDefinition> decisionDefinitions = decisionDefinitionManager.findDecisionDefinitionByDeploymentId(deploymentId);
            if (cascade) {
                for (DecisionDefinition decisionDefinition : decisionDefinitions) {
                    this.getHistoricDecisionInstanceManager().deleteHistoricDecisionInstancesByDecisionDefinitionId(decisionDefinition.getId());
                }
            }
            decisionDefinitionManager.deleteDecisionDefinitionsByDeploymentId(deploymentId);
            DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
            for (DecisionDefinition decisionDefinition : decisionDefinitions) {
                String decisionDefinitionId = decisionDefinition.getId();
                deploymentCache.removeDecisionDefinition(decisionDefinitionId);
            }
        }
    }

    protected void deleteDecisionRequirementDeployment(String deploymentId) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isDmnEnabled()) {
            DecisionRequirementsDefinitionManager manager = this.getDecisionRequirementsDefinitionManager();
            List<DecisionRequirementsDefinition> decisionRequirementsDefinitions = manager.findDecisionRequirementsDefinitionByDeploymentId(deploymentId);
            manager.deleteDecisionRequirementsDefinitionsByDeploymentId(deploymentId);
            DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
            for (DecisionRequirementsDefinition decisionRequirementsDefinition : decisionRequirementsDefinitions) {
                String decisionDefinitionId = decisionRequirementsDefinition.getId();
                deploymentCache.removeDecisionRequirementsDefinition(decisionDefinitionId);
            }
        }
    }

    public DeploymentEntity findLatestDeploymentByName(String deploymentName) {
        List list = this.getDbEntityManager().selectList("selectDeploymentsByName", deploymentName, 0, 1);
        if (list != null && !list.isEmpty()) {
            return (DeploymentEntity)list.get(0);
        }
        return null;
    }

    public DeploymentEntity findDeploymentById(String deploymentId) {
        return this.getDbEntityManager().selectById(DeploymentEntity.class, deploymentId);
    }

    public List<DeploymentEntity> findDeploymentsByIds(String ... deploymentsIds) {
        return this.getDbEntityManager().selectList("selectDeploymentsByIds", deploymentsIds);
    }

    public long findDeploymentCountByQueryCriteria(DeploymentQueryImpl deploymentQuery) {
        this.configureQuery(deploymentQuery);
        return (Long)this.getDbEntityManager().selectOne("selectDeploymentCountByQueryCriteria", deploymentQuery);
    }

    public List<Deployment> findDeploymentsByQueryCriteria(DeploymentQueryImpl deploymentQuery, Page page) {
        this.configureQuery(deploymentQuery);
        return this.getDbEntityManager().selectList("selectDeploymentsByQueryCriteria", deploymentQuery, page);
    }

    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.getDbEntityManager().selectList("selectResourceNamesByDeploymentId", deploymentId);
    }

    public List<String> findDeploymentIdsByProcessInstances(List<String> processInstanceIds) {
        return this.getDbEntityManager().selectList("selectDeploymentIdsByProcessInstances", processInstanceIds);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    protected void createDefaultAuthorizations(DeploymentEntity deployment) {
        if (this.isAuthorizationEnabled()) {
            ResourceAuthorizationProvider provider = this.getResourceAuthorizationProvider();
            AuthorizationEntity[] authorizations = provider.newDeployment(deployment);
            this.saveDefaultAuthorizations(authorizations);
        }
    }

    protected void configureQuery(DeploymentQueryImpl query) {
        this.getAuthorizationManager().configureDeploymentQuery(query);
        this.getTenantManager().configureQuery(query);
    }
}

