/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.dmn.engine.DmnDecisionRuleResult;
import org.camunda.bpm.dmn.engine.impl.DmnEngineLogger;
import org.camunda.bpm.dmn.engine.impl.DmnLogger;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class DmnDecisionRuleResultImpl
implements DmnDecisionRuleResult {
    private static final long serialVersionUID = 1L;
    public static final DmnEngineLogger LOG = DmnLogger.ENGINE_LOGGER;
    protected final Map<String, TypedValue> outputValues = new LinkedHashMap<String, TypedValue>();

    public void putValue(String name, TypedValue value) {
        this.outputValues.put(name, value);
    }

    public void putAllValues(Map<String, TypedValue> values) {
        this.outputValues.putAll(values);
    }

    @Override
    public <T> T getEntry(String name) {
        return (T)this.outputValues.get(name).getValue();
    }

    @Override
    public <T extends TypedValue> T getEntryTyped(String name) {
        return (T)this.outputValues.get(name);
    }

    @Override
    public <T extends TypedValue> T getFirstEntryTyped() {
        if (!this.outputValues.isEmpty()) {
            return (T)this.outputValues.values().iterator().next();
        }
        return null;
    }

    @Override
    public <T extends TypedValue> T getSingleEntryTyped() {
        if (this.outputValues.size() > 1) {
            throw LOG.decisionOutputHasMoreThanOneValue(this);
        }
        return this.getFirstEntryTyped();
    }

    @Override
    public <T> T getFirstEntry() {
        if (!this.outputValues.isEmpty()) {
            return (T)this.getFirstEntryTyped().getValue();
        }
        return null;
    }

    @Override
    public <T> T getSingleEntry() {
        if (!this.outputValues.isEmpty()) {
            return (T)this.getSingleEntryTyped().getValue();
        }
        return null;
    }

    @Override
    public Map<String, Object> getEntryMap() {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        for (String key : this.outputValues.keySet()) {
            valueMap.put(key, this.get(key));
        }
        return valueMap;
    }

    @Override
    public Map<String, TypedValue> getEntryMapTyped() {
        return this.outputValues;
    }

    @Override
    public int size() {
        return this.outputValues.size();
    }

    @Override
    public boolean isEmpty() {
        return this.outputValues.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.outputValues.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.outputValues.keySet();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (TypedValue typedValue : this.outputValues.values()) {
            values.add(typedValue.getValue());
        }
        return values;
    }

    public String toString() {
        return this.outputValues.toString();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Object get(Object key) {
        TypedValue typedValue = this.outputValues.get(key);
        if (typedValue != null) {
            return typedValue.getValue();
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("decision output is immutable");
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("decision output is immutable");
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException("decision output is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("decision output is immutable");
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entrySet = new HashSet<Map.Entry<String, Object>>();
        for (Map.Entry<String, TypedValue> typedEntry : this.outputValues.entrySet()) {
            DmnDecisionRuleOutputEntry entry = new DmnDecisionRuleOutputEntry(typedEntry.getKey(), typedEntry.getValue());
            entrySet.add(entry);
        }
        return entrySet;
    }

    protected class DmnDecisionRuleOutputEntry
    implements Map.Entry<String, Object> {
        protected final String key;
        protected final TypedValue typedValue;

        public DmnDecisionRuleOutputEntry(String key, TypedValue typedValue) {
            this.key = key;
            this.typedValue = typedValue;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            if (this.typedValue != null) {
                return this.typedValue.getValue();
            }
            return null;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException("decision output entry is immutable");
        }
    }
}

