/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.assertions.cmmn;

import java.util.Map;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.camunda.bpm.engine.test.assertions.bpmn.BpmnAwareTests;
import org.camunda.bpm.engine.test.assertions.cmmn.CaseDefinitionAssert;
import org.camunda.bpm.engine.test.assertions.cmmn.CaseExecutionAssert;
import org.camunda.bpm.engine.test.assertions.cmmn.CaseInstanceAssert;
import org.camunda.bpm.engine.test.assertions.cmmn.CmmnAwareAssertions;

public class CmmnAwareTests
extends BpmnAwareTests {
    public static CaseInstanceAssert assertThat(CaseInstance actual) {
        return CmmnAwareAssertions.assertThat(actual);
    }

    public static CaseExecutionAssert assertThat(CaseExecution actual) {
        return CmmnAwareAssertions.assertThat(actual);
    }

    public static CaseDefinitionAssert assertThat(CaseDefinition actual) {
        return CmmnAwareAssertions.assertThat(actual);
    }

    public static CaseService caseService() {
        return CmmnAwareTests.processEngine().getCaseService();
    }

    public static CaseInstanceQuery caseInstanceQuery() {
        return CmmnAwareTests.caseService().createCaseInstanceQuery();
    }

    public static CaseExecutionQuery caseExecutionQuery() {
        return CmmnAwareTests.caseService().createCaseExecutionQuery();
    }

    public static CaseDefinitionQuery caseDefinitionQuery() {
        return CmmnAwareTests.repositoryService().createCaseDefinitionQuery();
    }

    public static void complete(CaseExecution caseExecution) {
        if (caseExecution == null) {
            throw new IllegalArgumentException("Illegal call of complete(caseExecution) - must not be null!");
        }
        CmmnAwareTests.caseService().completeCaseExecution(caseExecution.getId());
    }

    public static void disable(CaseExecution caseExecution) {
        if (caseExecution == null) {
            throw new IllegalArgumentException("Illegal call of disable(caseExecution) - must not be null!");
        }
        CmmnAwareTests.caseService().disableCaseExecution(caseExecution.getId());
    }

    public static void manuallyStart(CaseExecution caseExecution) {
        if (caseExecution == null) {
            throw new IllegalArgumentException("Illegal call of manuallyStart(caseExecution) - must not be null!");
        }
        CmmnAwareTests.caseService().manuallyStartCaseExecution(caseExecution.getId());
    }

    public static CaseExecution caseExecution(String activityId, CaseInstance caseInstance) {
        CmmnAwareTests.assertThat((String)activityId).isNotNull();
        return CmmnAwareTests.caseExecution(CmmnAwareTests.caseExecutionQuery().activityId(activityId), caseInstance);
    }

    public static CaseExecution caseExecution(CaseExecutionQuery caseExecutionQuery, CaseInstance caseInstance) {
        return ((CaseInstanceAssert)CmmnAwareTests.assertThat(caseInstance).isNotNull()).descendantCaseExecution(caseExecutionQuery).getActual();
    }

    public static void complete(CaseExecution caseExecution, Map<String, Object> variables) {
        if (caseExecution == null || variables == null) {
            throw new IllegalArgumentException(String.format("Illegal call of complete(caseExecution = '%s', variables = '%s') - both must not be null!", caseExecution, variables));
        }
        CmmnAwareTests.caseService().withCaseExecution(caseExecution.getId()).setVariables(variables).complete();
    }

    public static Map<String, Object> withVariables(String key, Object value, Object ... furtherKeyValuePairs) {
        return BpmnAwareTests.withVariables(key, value, furtherKeyValuePairs);
    }
}

