/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito;

import com.google.common.io.Resources;
import java.net.URL;
import javax.annotation.Nonnull;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.extension.mockito.Expressions;
import org.camunda.bpm.extension.mockito.function.ParseDelegateExpressions;
import org.camunda.bpm.extension.mockito.mock.FluentExecutionListenerMock;
import org.camunda.bpm.extension.mockito.mock.FluentJavaDelegateMock;
import org.camunda.bpm.extension.mockito.mock.FluentTaskListenerMock;
import org.camunda.bpm.extension.mockito.verify.ExecutionListenerVerification;
import org.camunda.bpm.extension.mockito.verify.JavaDelegateVerification;
import org.camunda.bpm.extension.mockito.verify.MockitoVerification;
import org.camunda.bpm.extension.mockito.verify.TaskListenerVerification;

public final class DelegateExpressions {
    private DelegateExpressions() {
    }

    public static void autoMock(@Nonnull String bpmnFileResource) {
        DelegateExpressions.autoMock(Resources.getResource((String)bpmnFileResource));
    }

    public static void autoMock(@Nonnull URL bpmnFile) {
        for (String name : ParseDelegateExpressions.EXECUTION_LISTENER.apply(bpmnFile)) {
            DelegateExpressions.registerExecutionListenerMock(name);
        }
        for (String name : ParseDelegateExpressions.TASK_LISTENER.apply(bpmnFile)) {
            DelegateExpressions.registerTaskListenerMock(name);
        }
        for (String name : ParseDelegateExpressions.JAVA_DELEGATE.apply(bpmnFile)) {
            DelegateExpressions.registerJavaDelegateMock(name);
        }
    }

    public static FluentJavaDelegateMock registerJavaDelegateMock(String name) {
        return Expressions.registerInstance(name, new FluentJavaDelegateMock());
    }

    public static FluentExecutionListenerMock registerExecutionListenerMock(String name) {
        return Expressions.registerInstance(name, new FluentExecutionListenerMock());
    }

    public static FluentTaskListenerMock registerTaskListenerMock(String name) {
        return Expressions.registerInstance(name, new FluentTaskListenerMock());
    }

    public static FluentJavaDelegateMock getJavaDelegateMock(String name) {
        return (FluentJavaDelegateMock)Expressions.getRegistered(name);
    }

    public static FluentExecutionListenerMock getExecutionListenerMock(String name) {
        return (FluentExecutionListenerMock)Expressions.getRegistered(name);
    }

    public static FluentTaskListenerMock getTaskListenerMock(String name) {
        return (FluentTaskListenerMock)Expressions.getRegistered(name);
    }

    public static MockitoVerification<DelegateExecution> verifyJavaDelegateMock(String name) {
        return DelegateExpressions.verifyJavaDelegateMock(DelegateExpressions.getJavaDelegateMock(name));
    }

    public static MockitoVerification<DelegateExecution> verifyJavaDelegateMock(FluentJavaDelegateMock fluentJavaDelegateMock) {
        return new JavaDelegateVerification((JavaDelegate)fluentJavaDelegateMock.getMock());
    }

    public static MockitoVerification<DelegateExecution> verifyExecutionListenerMock(String name) {
        return DelegateExpressions.verifyExecutionListenerMock(DelegateExpressions.getExecutionListenerMock(name));
    }

    public static MockitoVerification<DelegateExecution> verifyExecutionListenerMock(FluentExecutionListenerMock fluentExecutionListenerMock) {
        return new ExecutionListenerVerification((ExecutionListener)fluentExecutionListenerMock.getMock());
    }

    public static MockitoVerification<DelegateTask> verifyTaskListenerMock(String name) {
        return DelegateExpressions.verifyTaskListenerMock(DelegateExpressions.getTaskListenerMock(name));
    }

    public static MockitoVerification<DelegateTask> verifyTaskListenerMock(FluentTaskListenerMock fluentTaskListenerMock) {
        return new TaskListenerVerification((TaskListener)fluentTaskListenerMock.getMock());
    }
}

