/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.test.mock.Mocks;
import org.camunda.bpm.extension.mockito.function.CreateInstance;
import org.camunda.bpm.extension.mockito.function.NameForType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Expressions {
    private static final Logger LOG = LoggerFactory.getLogger(Expressions.class);

    private Expressions() {
    }

    public static void registerMockInstancesForNestedTypes(Class<?> parentClass) {
        Collection<Class<?>> nestedClasses = Expressions.findNestedClasses(parentClass);
        for (Class<?> type : nestedClasses) {
            Expressions.registerMockInstance(type);
        }
    }

    private static Collection<Class<?>> findNestedClasses(Class<?> parentClass) {
        ArrayList result = Lists.newArrayList();
        for (Class<?> nestedClass : parentClass.getDeclaredClasses()) {
            int modifiers = nestedClass.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
            result.add(nestedClass);
        }
        return result;
    }

    public static void registerInstancesForFields(Object instance) {
        Preconditions.checkArgument((instance != null ? 1 : 0) != 0, (Object)"instance must not be null!");
        for (Field field : instance.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object value = field.get(instance);
                if (value == null) continue;
                Expressions.registerInstance(NameForType.juelNameFor(field.getType()), value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void registerNewInstancesForNestedTypes(Class<?> parentClass) {
        for (Class<?> type : Expressions.findNestedClasses(parentClass)) {
            Expressions.registerNewInstance(type);
        }
    }

    public static void registerMockInstances(Class<?> ... types) {
        Preconditions.checkArgument((types != null ? 1 : 0) != 0, (Object)"types must not be null!");
        Expressions.registerMockInstances(Lists.newArrayList((Object[])types));
    }

    public static void registerMockInstances(Collection<Class<?>> types) {
        for (Class<?> type : types) {
            Expressions.registerMockInstance(type);
        }
    }

    public static <T> T registerMockInstance(String name, Class<T> type) {
        return Expressions.registerInstance(name, CreateInstance.mockInstance(type));
    }

    public static <T> T registerMockInstance(Class<T> type) {
        return Expressions.registerMockInstance(NameForType.juelNameFor(type), type);
    }

    public static <T> T registerNewInstance(String name, Class<T> type) {
        return Expressions.registerInstance(name, CreateInstance.newInstanceByDefaultConstructor(type));
    }

    public static <T> T registerNewInstance(Class<T> type) {
        return Expressions.registerNewInstance(NameForType.juelNameFor(type), type);
    }

    public static <T> T registerInstance(T instance) {
        return Expressions.registerInstance(NameForType.juelNameFor(instance), instance);
    }

    public static <T> T registerInstance(String name, T instance) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"name must not be blank!");
        Preconditions.checkArgument((instance != null ? 1 : 0) != 0, (Object)"instance must not be null!");
        LOG.debug(String.format("registered instance: name=%s, value=%s", name, instance));
        Mocks.register((String)name, instance);
        return instance;
    }

    public static <T> T getRegistered(String name) {
        Object mock = Mocks.get((Object)name);
        Preconditions.checkState((mock != null ? 1 : 0) != 0, (Object)("no instance registered for name=" + name));
        return (T)mock;
    }

    public static <T> T getRegistered(Class<?> type) {
        return Expressions.getRegistered(NameForType.juelNameFor(type));
    }

    public static void reset() {
        Mocks.reset();
    }
}

