/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito.answer;

import javax.annotation.Nonnull;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public final class FluentAnswer<T>
implements Answer<T> {
    private final Class<T> type;

    public static <T> T createMock(Class<T> type) {
        return (T)Mockito.mock(type, FluentAnswer.createAnswer(type));
    }

    public static <T> FluentAnswer<T> createAnswer(Class<T> type) {
        return new FluentAnswer<T>(type);
    }

    private FluentAnswer(Class<T> type) {
        this.type = type;
    }

    public T answer(@Nonnull InvocationOnMock invocation) throws Throwable {
        if (this.type.equals(invocation.getMethod().getReturnType())) {
            return (T)invocation.getMock();
        }
        return null;
    }
}

