/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito.function;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

class NodeToString
implements Function<Node, String> {
    public static final NodeToString INSTANCE = new NodeToString();
    private final Transformer transformer;

    private NodeToString() {
        try {
            this.transformer = TransformerFactory.newInstance().newTransformer();
            this.transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (TransformerConfigurationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String apply(Node document) {
        StringWriter writer = new StringWriter();
        try {
            this.transformer.transform(new DOMSource(document), new StreamResult(writer));
            return writer.toString();
        }
        catch (TransformerException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

